/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.DjbHashFunction;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.HashFunction;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;

public class OperationRouting
extends AbstractComponent {
    private final AwarenessAllocationDecider awarenessAllocationDecider;
    private static final Map<String, Set<String>> EMPTY_ROUTING = Collections.emptyMap();

    @Inject
    public OperationRouting(Settings settings, AwarenessAllocationDecider awarenessAllocationDecider) {
        super(settings);
        this.awarenessAllocationDecider = awarenessAllocationDecider;
    }

    public ShardIterator indexShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing) {
        return this.shards(clusterState, index, type, id, routing).shardsIt();
    }

    public ShardIterator getShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing, @Nullable String preference) {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index, type, id, routing), clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
    }

    public ShardIterator getShards(ClusterState clusterState, String index, int shardId, @Nullable String preference) {
        IndexShardRoutingTable indexShard = clusterState.getRoutingTable().shardRoutingTable(index, shardId);
        return this.preferenceActiveShardIterator(indexShard, clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
    }

    public int searchShardsCount(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing) {
        Set<IndexShardRoutingTable> shards = this.computeTargetedShards(clusterState, concreteIndices, routing);
        return shards.size();
    }

    public GroupShardsIterator searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference) {
        Set<IndexShardRoutingTable> shards = this.computeTargetedShards(clusterState, concreteIndices, routing);
        HashSet<ShardIterator> set = new HashSet<ShardIterator>(shards.size());
        for (IndexShardRoutingTable shard : shards) {
            ShardIterator iterator = this.preferenceActiveShardIterator(shard, clusterState.nodes().localNodeId(), clusterState.nodes(), preference);
            if (iterator == null) continue;
            set.add(iterator);
        }
        return new GroupShardsIterator(new ArrayList<ShardIterator>(set));
    }

    private Set<IndexShardRoutingTable> computeTargetedShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing) {
        routing = routing == null ? EMPTY_ROUTING : routing;
        HashSet<IndexShardRoutingTable> set = new HashSet<IndexShardRoutingTable>();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
            Set<String> effectiveRouting = routing.get(index);
            if (effectiveRouting != null) {
                for (String r : effectiveRouting) {
                    int shardId = this.generateShardId(clusterState, index, null, null, r);
                    IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
                    if (indexShard == null) {
                        throw new ShardNotFoundException(new ShardId(index, shardId));
                    }
                    set.add(indexShard);
                }
                continue;
            }
            for (IndexShardRoutingTable indexShard : indexRouting) {
                set.add(indexShard);
            }
        }
        return set;
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String localNodeId, DiscoveryNodes nodes, @Nullable String preference) {
        if (preference == null || preference.isEmpty()) {
            String[] awarenessAttributes = this.awarenessAllocationDecider.awarenessAttributes();
            if (awarenessAttributes.length == 0) {
                return indexShard.activeInitializingShardsRandomIt();
            }
            return indexShard.preferAttributesActiveInitializingShardsIt(awarenessAttributes, nodes);
        }
        if (preference.charAt(0) == '_') {
            Preference preferenceType = Preference.parse(preference);
            if (preferenceType == Preference.SHARDS) {
                int index = preference.indexOf(59);
                String shards = index == -1 ? preference.substring(Preference.SHARDS.type().length() + 1) : preference.substring(Preference.SHARDS.type().length() + 1, index);
                String[] ids = Strings.splitStringByCommaToArray(shards);
                boolean found = false;
                for (String id : ids) {
                    if (Integer.parseInt(id) != indexShard.shardId().id()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                if (index == -1 || index == preference.length() - 1) {
                    String[] awarenessAttributes = this.awarenessAllocationDecider.awarenessAttributes();
                    if (awarenessAttributes.length == 0) {
                        return indexShard.activeInitializingShardsRandomIt();
                    }
                    return indexShard.preferAttributesActiveInitializingShardsIt(awarenessAttributes, nodes);
                }
                preference = preference.substring(index + 1);
            }
            preferenceType = Preference.parse(preference);
            switch (preferenceType) {
                case PREFER_NODE: {
                    return indexShard.preferNodeActiveInitializingShardsIt(preference.substring(Preference.PREFER_NODE.type().length() + 1));
                }
                case LOCAL: {
                    return indexShard.preferNodeActiveInitializingShardsIt(localNodeId);
                }
                case PRIMARY: {
                    return indexShard.primaryActiveInitializingShardIt();
                }
                case REPLICA: {
                    return indexShard.replicaActiveInitializingShardIt();
                }
                case PRIMARY_FIRST: {
                    return indexShard.primaryFirstActiveInitializingShardsIt();
                }
                case REPLICA_FIRST: {
                    return indexShard.replicaFirstActiveInitializingShardsIt();
                }
                case ONLY_LOCAL: {
                    return indexShard.onlyNodeActiveInitializingShardsIt(localNodeId);
                }
                case ONLY_NODE: {
                    String nodeId = preference.substring(Preference.ONLY_NODE.type().length() + 1);
                    this.ensureNodeIdExists(nodes, nodeId);
                    return indexShard.onlyNodeActiveInitializingShardsIt(nodeId);
                }
                case ONLY_NODES: {
                    String nodeAttribute = preference.substring(Preference.ONLY_NODES.type().length() + 1);
                    return indexShard.onlyNodeSelectorActiveInitializingShardsIt(nodeAttribute, nodes);
                }
            }
            throw new IllegalArgumentException("unknown preference [" + (Object)((Object)preferenceType) + "]");
        }
        String[] awarenessAttributes = this.awarenessAllocationDecider.awarenessAttributes();
        if (awarenessAttributes.length == 0) {
            return indexShard.activeInitializingShardsIt(DjbHashFunction.DJB_HASH(preference));
        }
        return indexShard.preferAttributesActiveInitializingShardsIt(awarenessAttributes, nodes, DjbHashFunction.DJB_HASH(preference));
    }

    protected IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return indexRouting;
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, String type, String id, String routing) {
        int shardId = this.generateShardId(clusterState, index, type, id, routing);
        return clusterState.getRoutingTable().shardRoutingTable(index, shardId);
    }

    public ShardId shardId(ClusterState clusterState, String index, String type, String id, @Nullable String routing) {
        return new ShardId(index, this.generateShardId(clusterState, index, type, id, routing));
    }

    @SuppressForbidden(reason="Math#abs is trappy")
    private int generateShardId(ClusterState clusterState, String index, String type, String id, @Nullable String routing) {
        IndexMetaData indexMetaData = clusterState.metaData().index(index);
        if (indexMetaData == null) {
            throw new IndexNotFoundException(index);
        }
        Version createdVersion = indexMetaData.getCreationVersion();
        HashFunction hashFunction = indexMetaData.getRoutingHashFunction();
        boolean useType = indexMetaData.getRoutingUseType();
        int hash = routing == null ? (!useType ? this.hash(hashFunction, id) : this.hash(hashFunction, type, id)) : this.hash(hashFunction, routing);
        if (createdVersion.onOrAfter(Version.V_2_0_0_beta1)) {
            return MathUtils.mod(hash, indexMetaData.getNumberOfShards());
        }
        return Math.abs(hash % indexMetaData.getNumberOfShards());
    }

    protected int hash(HashFunction hashFunction, String routing) {
        return hashFunction.hash(routing);
    }

    @Deprecated
    protected int hash(HashFunction hashFunction, String type, String id) {
        if (type == null || "_all".equals(type)) {
            throw new IllegalArgumentException("Can't route an operation with no type and having type part of the routing (for backward comp)");
        }
        return hashFunction.hash(type, id);
    }

    private void ensureNodeIdExists(DiscoveryNodes nodes, String nodeId) {
        if (!nodes.dataNodes().keys().contains((Object)nodeId)) {
            throw new IllegalArgumentException("No data node with id[" + nodeId + "] found");
        }
    }
}

