/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class BytesRestResponse
extends RestResponse {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private final RestStatus status;
    private final BytesReference content;
    private final String contentType;
    private static final ESLogger SUPPRESSED_ERROR_LOGGER = ESLoggerFactory.getLogger("rest.suppressed");

    public BytesRestResponse(RestStatus status) {
        this(status, TEXT_CONTENT_TYPE, BytesArray.EMPTY);
    }

    public BytesRestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.contentType().restContentType(), builder.bytes());
    }

    public BytesRestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, String content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, byte[] content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, BytesReference content) {
        this.status = status;
        this.content = content;
        this.contentType = contentType;
    }

    public BytesRestResponse(RestChannel channel, Throwable t) throws IOException {
        this(channel, ExceptionsHelper.status(t), t);
    }

    public BytesRestResponse(RestChannel channel, RestStatus status, Throwable t) throws IOException {
        this.status = status;
        if (channel.request().method() == RestRequest.Method.HEAD) {
            this.content = BytesArray.EMPTY;
            this.contentType = TEXT_CONTENT_TYPE;
        } else {
            XContentBuilder builder = BytesRestResponse.convert(channel, status, t);
            this.content = builder.bytes();
            this.contentType = builder.contentType().restContentType();
        }
        if (t instanceof ElasticsearchException) {
            this.copyHeaders((ElasticsearchException)t);
        }
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    private static XContentBuilder convert(RestChannel channel, RestStatus status, Throwable t) throws IOException {
        XContentBuilder builder = channel.newErrorBuilder().startObject();
        if (t == null) {
            builder.field("error", "unknown");
        } else if (channel.detailedErrorsEnabled()) {
            ToXContent.Params params;
            if (channel.request().paramAsBoolean("error_trace", false)) {
                params = new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"), channel.request());
            } else {
                if (status.getStatus() < 500) {
                    SUPPRESSED_ERROR_LOGGER.debug("{} Params: {}", t, channel.request().path(), channel.request().params());
                } else {
                    SUPPRESSED_ERROR_LOGGER.warn("{} Params: {}", t, channel.request().path(), channel.request().params());
                }
                params = channel.request();
            }
            builder.field("error");
            builder.startObject();
            ElasticsearchException[] rootCauses = ElasticsearchException.guessRootCauses(t);
            builder.field("root_cause");
            builder.startArray();
            for (ElasticsearchException rootCause : rootCauses) {
                builder.startObject();
                rootCause.toXContent(builder, new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.cause.skip", "true"), params));
                builder.endObject();
            }
            builder.endArray();
            ElasticsearchException.toXContent(builder, params, t);
            builder.endObject();
        } else {
            builder.field("error", BytesRestResponse.simpleMessage(t));
        }
        builder.field("status", status.getStatus());
        builder.endObject();
        return builder;
    }

    private static String simpleMessage(Throwable t) throws IOException {
        int counter = 0;
        for (Throwable next = t; next != null && counter++ < 10; next = next.getCause()) {
            if (!(t instanceof ElasticsearchException)) continue;
            return next.getClass().getSimpleName() + "[" + next.getMessage() + "]";
        }
        return "No ElasticsearchException found";
    }
}

