"use strict";

var _classCallCheck = require("babel-runtime/helpers/class-call-check")["default"];

var _Object$keys = require("babel-runtime/core-js/object/keys")["default"];

var _interopRequireDefault = require("babel-runtime/helpers/interop-require-default")["default"];

exports.__esModule = true;

var _sourceMap = require("source-map");

var _sourceMap2 = _interopRequireDefault(_sourceMap);

/**
 * Build a sourcemap.
 */

var SourceMap = (function () {
  function SourceMap(position, opts, code) {
    // istanbul ignore next

    var _this = this;

    _classCallCheck(this, SourceMap);

    this.position = position;
    this.opts = opts;
    this.last = { generated: {}, original: {} };

    if (opts.sourceMaps) {
      this.map = new _sourceMap2["default"].SourceMapGenerator({
        file: opts.sourceMapTarget,
        sourceRoot: opts.sourceRoot
      });

      if (typeof code === "string") {
        this.map.setSourceContent(opts.sourceFileName, code);
      } else if (typeof code === "object") {
        _Object$keys(code).forEach(function (sourceFileName) {
          _this.map.setSourceContent(sourceFileName, code[sourceFileName]);
        });
      }
    } else {
      this.map = null;
    }
  }

  /**
   * Get the sourcemap.
   */

  SourceMap.prototype.get = function get() {
    var map = this.map;
    if (map) {
      return map.toJSON();
    } else {
      return map;
    }
  };

  /**
   * Mark the current generated position with a source position. May also be passed null line/column
   * values to insert a mapping to nothing.
   */

  SourceMap.prototype.mark = function mark(sourcePos) {
    var map = this.map;
    if (!map) return; // no source map

    var position = this.position;

    // Adding an empty mapping at the start of a generated line just clutters the map.
    if (this._lastGenLine !== position.line && sourcePos.line === null) return;

    // If this mapping points to the same source location as the last one, we can ignore it since
    // the previous one covers it.
    if (this._lastGenLine === position.line && this._lastSourceLine === sourcePos.line && this._lastSourceColumn === sourcePos.column) {
      return;
    }

    this._lastGenLine = position.line;
    this._lastSourceLine = sourcePos.line;
    this._lastSourceColumn = sourcePos.column;

    map.addMapping({
      generated: {
        line: position.line,
        column: position.column
      },
      source: sourcePos.line == null ? null : sourcePos.filename || this.opts.sourceFileName,
      original: sourcePos.line == null ? null : {
        line: sourcePos.line,
        column: sourcePos.column
      }
    });
  };

  return SourceMap;
})();

exports["default"] = SourceMap;
module.exports = exports["default"];