/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.Logging;
import com.sun.javafx.Utils;
import com.sun.javafx.css.CascadingStyle;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Property;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.css.parser.CSSParser;
import com.sun.javafx.logging.PlatformLogger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class StyleHelper {
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private static final CalculatedValue SKIP = new CalculatedValue(new int[0], null, false);
    private final long key;
    private final Reference<StyleCacheBucket> sharedStyleCacheRef;
    private final StyleCacheBucket localStyleCache;
    private final Reference<Map<String, List<CascadingStyle>>> smapRef;
    private final long pseudoclassStateMask;
    private final WritableValue fontProp;
    private static final Map<StyleableProperty, Style> stylesFromDefaults = new HashMap<StyleableProperty, Style>();
    private static final List<Declaration> declarationsFromDefaults;
    private static final Stylesheet defaultsStylesheet;
    private static final Map<String, Map<String, CascadingStyle>> authorStylesCache;
    private long[] pseudoClassStates;
    static final Map<Node, Long> pseudoclassMasksByNode;
    private static final StyleableProperty dummyFontProperty;

    public static StyleHelper create(Node node, Map<String, List<CascadingStyle>> map, Map<StyleCacheKey, StyleCacheBucket> map2, long l, long l2) {
        Object object;
        long[] lArray = StyleHelper.getKeys(node.getParent(), 1);
        lArray[0] = l2;
        long[] lArray2 = new long[lArray.length];
        lArray2[0] = l;
        int n = 1;
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            object = parent.impl_getStyleHelper();
            lArray2[n++] = object != null ? ((StyleHelper)object).pseudoclassStateMask : 0L;
        }
        object = new StyleCacheBucket(lArray2);
        StyleCacheKey styleCacheKey = new StyleCacheKey(lArray);
        StyleCacheBucket styleCacheBucket = map2.get(styleCacheKey);
        if (styleCacheBucket == null) {
            styleCacheBucket = new StyleCacheBucket(lArray2);
            map2.put(styleCacheKey, styleCacheBucket);
        }
        WritableValue writableValue = null;
        List<StyleableProperty> list = node.impl_getStyleableProperties();
        int n2 = list != null ? list.size() : 0;
        for (int i = 0; i < n2; ++i) {
            StyleableProperty styleableProperty = list.get(i);
            if (!"-fx-font".equals(styleableProperty.getProperty())) continue;
            writableValue = styleableProperty.getWritableValue(node);
            break;
        }
        StyleHelper styleHelper = new StyleHelper(map, writableValue, (StyleCacheBucket)object, styleCacheBucket, l, l2);
        if (LOGGER.isLoggable(500)) {
            LOGGER.fine(node + " " + l2);
        }
        return styleHelper;
    }

    private StyleCacheBucket getSharedStyleCache() {
        StyleCacheBucket styleCacheBucket = this.sharedStyleCacheRef.get();
        return styleCacheBucket;
    }

    private static long[] getKeys(Node node, int n) {
        if (node == null) {
            return new long[n];
        }
        long[] lArray = StyleHelper.getKeys(node.getParent(), ++n);
        StyleHelper styleHelper = node.impl_getStyleHelper();
        lArray[n - 1] = styleHelper != null ? styleHelper.key : 0L;
        return lArray;
    }

    private CacheEntry getCacheEntry(Node node, long[] lArray) {
        long[] lArray2 = new long[this.localStyleCache.pclassMask.length];
        assert (lArray2.length == lArray.length) : lArray2.length + " != " + lArray.length;
        for (int i = 0; i < lArray2.length; ++i) {
            lArray2[i] = this.localStyleCache.pclassMask[i] & lArray[i];
        }
        CacheEntry cacheEntry = null;
        int n = this.localStyleCache.entries.size();
        for (int i = 0; i < n; ++i) {
            CacheEntry cacheEntry2 = (CacheEntry)this.localStyleCache.entries.get(i);
            long[] lArray3 = cacheEntry2.states;
            if (!Arrays.equals(lArray2, lArray3)) continue;
            cacheEntry = cacheEntry2;
            break;
        }
        if (cacheEntry != null) {
            return cacheEntry;
        }
        StyleCacheBucket styleCacheBucket = this.getSharedStyleCache();
        if (styleCacheBucket == null) {
            return null;
        }
        CacheEntry cacheEntry3 = null;
        int n2 = styleCacheBucket.entries.size();
        for (int i = 0; i < n2; ++i) {
            CacheEntry cacheEntry4 = (CacheEntry)styleCacheBucket.entries.get(i);
            long[] lArray4 = cacheEntry4.states;
            if (!Arrays.equals(lArray2, lArray4)) continue;
            cacheEntry3 = cacheEntry4;
            break;
        }
        if (cacheEntry3 == null) {
            cacheEntry3 = new CacheEntry(lArray2);
            styleCacheBucket.entries.add(cacheEntry3);
        }
        cacheEntry = new CacheEntry(lArray2, cacheEntry3);
        this.localStyleCache.entries.add(cacheEntry);
        return cacheEntry;
    }

    public void clearLocalCache() {
        List list = this.localStyleCache.entries;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CacheEntry cacheEntry = (CacheEntry)list.get(i);
            assert (cacheEntry.sharedCacheRef != null);
            cacheEntry.values.clear();
            cacheEntry.font = null;
        }
    }

    private Map<String, List<CascadingStyle>> getStyleMap() {
        Map<String, List<CascadingStyle>> map = this.smapRef.get();
        return map;
    }

    private StyleHelper(Map<String, List<CascadingStyle>> map, WritableValue writableValue, StyleCacheBucket styleCacheBucket, StyleCacheBucket styleCacheBucket2, long l, long l2) {
        this.key = l2;
        this.smapRef = new WeakReference<Map<String, List<CascadingStyle>>>(map);
        this.sharedStyleCacheRef = new WeakReference<StyleCacheBucket>(styleCacheBucket2);
        this.localStyleCache = styleCacheBucket;
        this.pseudoclassStateMask = l;
        this.fontProp = writableValue;
    }

    public boolean isPseudoclassUsed(String string) {
        long l = StyleManager.getInstance().getPseudoclassMask(string);
        return (this.pseudoclassStateMask & l) == l;
    }

    private Map<String, CascadingStyle> getStyles(Stylesheet stylesheet) {
        HashMap<String, CascadingStyle> hashMap = new HashMap<String, CascadingStyle>();
        if (stylesheet != null) {
            int n = 0;
            List<Rule> list = stylesheet.getRules();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                Rule rule = list.get(i);
                List<Declaration> list2 = rule.getDeclarations();
                int n3 = list2.size();
                for (int j = 0; j < n3; ++j) {
                    Declaration declaration = list2.get(j);
                    CascadingStyle cascadingStyle = new CascadingStyle(new Style(Selector.getUniversalSelector(), declaration), null, 0, n++);
                    hashMap.put(declaration.property, cascadingStyle);
                }
            }
        }
        return hashMap;
    }

    private Map<String, CascadingStyle> getInlineStyleMap(Node node) {
        return this.getInlineStyleMap(node.impl_getStyleable());
    }

    private Map<String, CascadingStyle> getInlineStyleMap(Styleable styleable) {
        String string = styleable.getStyle();
        if (string == null || string.isEmpty()) {
            return null;
        }
        Map<String, CascadingStyle> map = authorStylesCache.get(string);
        if (map == null) {
            Stylesheet stylesheet = CSSParser.getInstance().parseInlineStyle(styleable);
            if (stylesheet != null) {
                stylesheet.setOrigin(Stylesheet.Origin.INLINE);
            }
            map = this.getStyles(stylesheet);
            authorStylesCache.put(string, map);
        }
        return map;
    }

    long getPseudoClassState() {
        return this.pseudoClassStates != null && this.pseudoClassStates.length > 0 ? this.pseudoClassStates[0] : 0L;
    }

    private long[] getPseudoClassStates() {
        return this.pseudoClassStates;
    }

    private static void setPseudoClassStatesForTransition(Node node, StyleHelper styleHelper) {
        int n;
        long[] lArray = null;
        int n2 = 0;
        Parent parent = node.getParent();
        while (parent != null && lArray == null) {
            StyleHelper styleHelper2 = parent.impl_getStyleHelper();
            if (styleHelper2 != null) {
                lArray = styleHelper2.pseudoClassStates;
                continue;
            }
            parent = parent.getParent();
            ++n2;
        }
        long l = node.impl_getPseudoClassState();
        int n3 = n = lArray != null ? lArray.length + n2 : n2;
        if (styleHelper.pseudoClassStates == null || styleHelper.pseudoClassStates.length < n) {
            styleHelper.pseudoClassStates = new long[n + 1];
        }
        Arrays.fill(styleHelper.pseudoClassStates, 0L);
        styleHelper.pseudoClassStates[0] = l;
        if (lArray != null) {
            System.arraycopy(lArray, 0, styleHelper.pseudoClassStates, n2 + 1, lArray.length);
        }
    }

    public void transitionToState(Node node) {
        Object object;
        boolean bl;
        if (this.smapRef.get() == null) {
            return;
        }
        StyleHelper.setPseudoClassStatesForTransition(node, this);
        long l = this.pseudoClassStates[0];
        Map<String, CascadingStyle> map = this.getInlineStyleMap(node);
        CacheEntry cacheEntry = this.getCacheEntry(node, this.pseudoClassStates);
        if (cacheEntry == null || cacheEntry.sharedCacheRef != null && cacheEntry.sharedCacheRef.get() == null) {
            node.impl_reapplyCSS();
            return;
        }
        ObservableMap<WritableValue, List<Style>> observableMap = node.impl_getStyleMap();
        boolean bl2 = bl = observableMap == null && map == null;
        if (cacheEntry.font == null) {
            object = this.getFontForUseInConvertingRelativeSize(node, cacheEntry, l, map);
            cacheEntry.font = (CalculatedValue)object;
            assert (cacheEntry.font != null);
            bl = bl && ((CacheEntry)cacheEntry).font.origin != Stylesheet.Origin.USER && ((CacheEntry)cacheEntry).font.origin != Stylesheet.Origin.INLINE && map == null;
        }
        object = StyleableProperty.getStyleables(node);
        int n = object.size();
        CssError.setCurrentScene(node.getScene());
        for (int i = 0; i < n; ++i) {
            Object object2;
            StyleableProperty styleableProperty = (StyleableProperty)object.get(i);
            if (observableMap != null && (object2 = styleableProperty.getWritableValue(node)) != null && observableMap.containsKey(object2)) {
                observableMap.remove(object2);
            }
            if (!styleableProperty.isSettable(node)) continue;
            object2 = styleableProperty.getProperty();
            ArrayList<Style> arrayList = observableMap != null ? new ArrayList<Style>() : null;
            CalculatedValue calculatedValue = null;
            if (bl) {
                calculatedValue = cacheEntry.get((String)object2);
            }
            if (calculatedValue == null) {
                boolean bl3 = this.isUserSetProperty(node, styleableProperty);
                calculatedValue = this.lookup(node, styleableProperty, bl3, l, map, node, cacheEntry, arrayList);
                cacheEntry.put((String)object2, calculatedValue);
            }
            if (calculatedValue == SKIP || calculatedValue != null && (calculatedValue.origin == Stylesheet.Origin.USER_AGENT || calculatedValue.origin == null) && this.isUserSetProperty(node, styleableProperty)) continue;
            Object object3 = calculatedValue.value;
            if (LOGGER.isLoggable(400)) {
                LOGGER.finer("call " + node + ".impl_cssSet(" + (String)object2 + ", " + object3 + ")");
            }
            try {
                styleableProperty.set(node, object3, calculatedValue.origin);
                if (observableMap == null) continue;
                WritableValue writableValue = styleableProperty.getWritableValue(node);
                observableMap.put(writableValue, arrayList);
                continue;
            }
            catch (Exception exception) {
                Object object4;
                ObservableList<CssError> observableList = null;
                observableList = StyleManager.getInstance().getErrors();
                if (observableList != null) {
                    object4 = String.format("Failed to set css [%s] due to %s\n", styleableProperty, exception.getMessage());
                    CssError.PropertySetError propertySetError = new CssError.PropertySetError(styleableProperty, node, (String)object4);
                    observableList.add(propertySetError);
                }
                if (!((PlatformLogger)(object4 = Logging.getCSSLogger())).isLoggable(900)) continue;
                ((PlatformLogger)object4).warning(String.format("Failed to set css [%s]\n", styleableProperty), exception);
            }
        }
        CssError.setCurrentScene(null);
    }

    public void transitionToState(Scene scene, List<String> list) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private CascadingStyle getStyle(Node node, String string, long l, Map<String, CascadingStyle> map) {
        assert (node != null && string != null) : String.valueOf(node) + ", " + String.valueOf(string);
        CascadingStyle cascadingStyle = map != null ? map.get(string) : null;
        Map<String, List<CascadingStyle>> map2 = this.getStyleMap();
        if (map2 == null) {
            return null;
        }
        List<CascadingStyle> list = map2.get(string);
        if ((list == null || list.isEmpty()) && cascadingStyle == null) {
            return null;
        }
        CascadingStyle cascadingStyle2 = null;
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            Selector selector;
            CascadingStyle cascadingStyle3 = list.get(i);
            Selector selector2 = selector = cascadingStyle3 == null ? null : cascadingStyle3.getSelector();
            if (selector == null || !selector.stateMatches(node, l)) continue;
            cascadingStyle2 = cascadingStyle3;
            break;
        }
        if (cascadingStyle != null && (cascadingStyle2 == null || cascadingStyle.compareTo(cascadingStyle2) < 0)) {
            cascadingStyle2 = cascadingStyle;
        }
        return cascadingStyle2;
    }

    private CalculatedValue lookup(Node node, StyleableProperty styleableProperty, boolean bl, long l, Map<String, CascadingStyle> map, Node node2, CacheEntry cacheEntry, List<Style> list) {
        if (styleableProperty.getConverter() == FontConverter.getInstance()) {
            return this.lookupFont(node, styleableProperty, bl, node2, cacheEntry, list);
        }
        String string = styleableProperty.getProperty();
        CascadingStyle cascadingStyle = this.getStyle(node, string, l, map);
        List<StyleableProperty> list2 = styleableProperty.getSubProperties();
        int n = list2 != null ? list2.size() : 0;
        StyleConverter styleConverter = styleableProperty.getConverter();
        if (cascadingStyle == null) {
            Object object;
            Object object2;
            if (n == 0) {
                return this.handleNoStyleFound(node, styleableProperty, bl, map, node2, cacheEntry, list);
            }
            HashMap<Object, Object> hashMap = null;
            Stylesheet.Origin origin = null;
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                object2 = list2.get(i);
                object = this.lookup(node, (StyleableProperty)object2, bl, l, map, node2, cacheEntry, list);
                if (object == SKIP) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<Object, Object>();
                }
                hashMap.put(object2, ((CalculatedValue)object).value);
                if (origin != null && ((CalculatedValue)object).origin != null ? origin.compareTo(((CalculatedValue)object).origin) < 0 : ((CalculatedValue)object).origin != null) {
                    origin = ((CalculatedValue)object).origin;
                }
                bl2 = bl2 || ((CalculatedValue)object).isRelative;
            }
            if (hashMap == null || hashMap.isEmpty()) {
                return this.handleNoStyleFound(node, styleableProperty, bl, map, node2, cacheEntry, list);
            }
            try {
                Object t = styleConverter.convert((Map<StyleableProperty, Object>)hashMap);
                return new CalculatedValue(t, origin, bl2);
            }
            catch (ClassCastException classCastException) {
                object2 = this.formatExceptionMessage(node, styleableProperty, cascadingStyle.getStyle(), classCastException);
                object = null;
                object = StyleManager.getInstance().getErrors();
                if (object != null) {
                    CssError.PropertySetError propertySetError = new CssError.PropertySetError(styleableProperty, node, (String)object2);
                    object.add(propertySetError);
                }
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning("caught: ", classCastException);
                    LOGGER.warning("styleable = " + styleableProperty);
                    LOGGER.warning("node = " + node.toString());
                }
                return SKIP;
            }
        }
        if (bl && cascadingStyle.getOrigin() == Stylesheet.Origin.USER_AGENT) {
            return SKIP;
        }
        ParsedValue parsedValue = cascadingStyle.getParsedValue();
        if (parsedValue != null && "inherit".equals(parsedValue.getValue())) {
            if (list != null) {
                list.add(cascadingStyle.getStyle());
            }
            return this.inherit(node, styleableProperty, map, node2, cacheEntry, list);
        }
        if (list != null) {
            list.add(cascadingStyle.getStyle());
        }
        return this.calculateValue(cascadingStyle, node, styleableProperty, l, map, node2, cacheEntry, list);
    }

    private CalculatedValue handleNoStyleFound(Node node, StyleableProperty styleableProperty, boolean bl, Map<String, CascadingStyle> map, Node node2, CacheEntry cacheEntry, List<Style> list) {
        if (styleableProperty.isInherits()) {
            if (bl) {
                return SKIP;
            }
            CalculatedValue calculatedValue = this.inherit(node, styleableProperty, map, node2, cacheEntry, list);
            return calculatedValue;
        }
        if (bl) {
            return SKIP;
        }
        Map<String, List<CascadingStyle>> map2 = this.getStyleMap();
        if (map2 == null) {
            return SKIP;
        }
        if (map2.containsKey(styleableProperty.getProperty())) {
            Object v = styleableProperty.getInitialValue(node);
            if (list != null) {
                Style style = stylesFromDefaults.get(styleableProperty);
                if (style != null) {
                    if (!declarationsFromDefaults.contains(style.getDeclaration())) {
                        declarationsFromDefaults.add(style.getDeclaration());
                    }
                } else {
                    style = new Style(Selector.getUniversalSelector(), new Declaration(styleableProperty.getProperty(), new ParsedValue(v, null), false));
                    stylesFromDefaults.put(styleableProperty, style);
                    declarationsFromDefaults.add(style.getDeclaration());
                }
                list.add(style);
            }
            return new CalculatedValue(v, null, false);
        }
        return SKIP;
    }

    private CalculatedValue inherit(Node node, StyleableProperty styleableProperty, Map<String, CascadingStyle> map, Node node2, CacheEntry cacheEntry, List<Style> list) {
        StyleHelper styleHelper;
        Parent parent = node.getParent();
        StyleHelper styleHelper2 = styleHelper = parent == null ? null : parent.impl_getStyleHelper();
        while (parent != null && styleHelper == null) {
            if ((parent = parent.getParent()) == null) continue;
            styleHelper = parent.impl_getStyleHelper();
        }
        if (parent == null) {
            return SKIP;
        }
        return styleHelper.lookup(parent, styleableProperty, false, styleHelper.getPseudoClassState(), this.getInlineStyleMap(parent), node2, cacheEntry, list);
    }

    private CascadingStyle resolveRef(Node node, String string, long l, Map<String, CascadingStyle> map) {
        StyleHelper styleHelper;
        CascadingStyle cascadingStyle = this.getStyle(node, string, l, map);
        if (cascadingStyle != null) {
            return cascadingStyle;
        }
        if (l > 0L) {
            return this.resolveRef(node, string, 0L, map);
        }
        Parent parent = node.getParent();
        StyleHelper styleHelper2 = styleHelper = parent == null ? null : parent.impl_getStyleHelper();
        while (parent != null && styleHelper == null) {
            if ((parent = parent.getParent()) == null) continue;
            styleHelper = parent.impl_getStyleHelper();
        }
        if (parent == null || styleHelper == null) {
            return null;
        }
        return styleHelper.resolveRef(parent, string, styleHelper.getPseudoClassState(), this.getInlineStyleMap(parent));
    }

    private ParsedValue resolveLookups(Node node, ParsedValue parsedValue, long l, Map<String, CascadingStyle> map, ObjectProperty<Stylesheet.Origin> objectProperty, List<Style> list) {
        block8: {
            ParsedValue[][] parsedValueArray;
            Object v;
            block7: {
                CascadingStyle cascadingStyle;
                if (parsedValue.isLookup() && (v = parsedValue.getValue()) instanceof String && (cascadingStyle = this.resolveRef(node, (String)(parsedValueArray = (ParsedValue[][])v), l, map)) != null) {
                    Object object;
                    if (list != null && (object = cascadingStyle.getStyle()) != null && !list.contains(object)) {
                        list.add((Style)object);
                    }
                    object = (Stylesheet.Origin)((Object)objectProperty.get());
                    Stylesheet.Origin origin = cascadingStyle.getOrigin();
                    if (origin != null && (object == null || ((Enum)object).compareTo(origin) < 0)) {
                        objectProperty.set(origin);
                    }
                    return this.resolveLookups(node, cascadingStyle.getParsedValue(), l, map, objectProperty, list);
                }
                if (!parsedValue.isContainsLookups()) {
                    return parsedValue;
                }
                v = parsedValue.getValue();
                if (!(v instanceof ParsedValue[][])) break block7;
                parsedValueArray = (ParsedValue[][])v;
                for (int i = 0; i < parsedValueArray.length; ++i) {
                    for (int j = 0; j < parsedValueArray[i].length; ++j) {
                        if (parsedValueArray[i][j] == null) continue;
                        parsedValueArray[i][j].resolved = this.resolveLookups(node, parsedValueArray[i][j], l, map, objectProperty, list);
                    }
                }
                break block8;
            }
            if (!(v instanceof ParsedValue[])) break block8;
            parsedValueArray = (ParsedValue[])v;
            for (int i = 0; i < parsedValueArray.length; ++i) {
                if (parsedValueArray[i] == null) continue;
                parsedValueArray[i].resolved = this.resolveLookups(node, (ParsedValue)parsedValueArray[i], l, map, objectProperty, list);
            }
        }
        return parsedValue;
    }

    private String getUnresolvedLookup(ParsedValue parsedValue) {
        block5: {
            Object v;
            block4: {
                v = parsedValue.getValue();
                if (parsedValue.isLookup() && v instanceof String) {
                    return (String)v;
                }
                if (!(v instanceof ParsedValue[][])) break block4;
                ParsedValue[][] parsedValueArray = (ParsedValue[][])v;
                for (int i = 0; i < parsedValueArray.length; ++i) {
                    for (int j = 0; j < parsedValueArray[i].length; ++j) {
                        String string;
                        if (parsedValueArray[i][j] == null || (string = this.getUnresolvedLookup(parsedValueArray[i][j])) == null) continue;
                        return string;
                    }
                }
                break block5;
            }
            if (!(v instanceof ParsedValue[])) break block5;
            ParsedValue[] parsedValueArray = (ParsedValue[])v;
            for (int i = 0; i < parsedValueArray.length; ++i) {
                String string;
                if (parsedValueArray[i] == null || (string = this.getUnresolvedLookup(parsedValueArray[i])) == null) continue;
                return string;
            }
        }
        return null;
    }

    private String formatUnresolvedLookupMessage(Node node, StyleableProperty styleableProperty, Style style, ParsedValue parsedValue) {
        URL uRL;
        String string;
        String string2 = string = parsedValue != null ? this.getUnresolvedLookup(parsedValue) : null;
        if (string == null) {
            string = "a lookup value";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Could not resolve '").append(string).append("'").append(" while resolving lookups for '").append(styleableProperty.getProperty()).append("'");
        Rule rule = style != null ? style.getDeclaration().getRule() : null;
        Stylesheet stylesheet = rule != null ? rule.getStylesheet() : null;
        URL uRL2 = uRL = stylesheet != null ? stylesheet.getUrl() : null;
        if (uRL != null) {
            stringBuilder.append(" from rule '").append(style.getSelector()).append("' in stylesheet ").append(uRL.toExternalForm());
        } else if (stylesheet != null && Stylesheet.Origin.INLINE == stylesheet.getOrigin()) {
            stringBuilder.append(" from inline style on ").append(node.toString());
        }
        return stringBuilder.toString();
    }

    private String formatExceptionMessage(Node node, StyleableProperty styleableProperty, Style style, Exception exception) {
        URL uRL;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Caught ").append(exception.toString()).append("'").append(" while calculating value for '").append(styleableProperty.getProperty()).append("'");
        Rule rule = style != null ? style.getDeclaration().getRule() : null;
        Stylesheet stylesheet = rule != null ? rule.getStylesheet() : null;
        URL uRL2 = uRL = stylesheet != null ? stylesheet.getUrl() : null;
        if (uRL != null) {
            stringBuilder.append(" from rule '").append(style.getSelector()).append("' in stylesheet ").append(uRL.toExternalForm());
        } else if (stylesheet != null && Stylesheet.Origin.INLINE == stylesheet.getOrigin()) {
            stringBuilder.append(" from inline style on ").append(node.toString());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CalculatedValue calculateValue(CascadingStyle cascadingStyle, Node node, StyleableProperty styleableProperty, long l, Map<String, CascadingStyle> map, Node node2, CacheEntry cacheEntry, List<Style> list) {
        ParsedValue parsedValue = cascadingStyle.getParsedValue();
        if (parsedValue != null && !"null".equals(parsedValue.getValue())) {
            SimpleObjectProperty<Stylesheet.Origin> simpleObjectProperty = new SimpleObjectProperty<Stylesheet.Origin>(cascadingStyle.getOrigin());
            ParsedValue parsedValue2 = this.resolveLookups(node, parsedValue, l, map, simpleObjectProperty, list);
            try {
                Object object;
                Object object2;
                Object object3;
                Object var13_12 = null;
                CalculatedValue calculatedValue = null;
                String string = styleableProperty.getProperty();
                if (parsedValue2.isNeedsFont() && (cacheEntry.font == null || ((CacheEntry)cacheEntry).font.isRelative) && ("-fx-font".equals(string) || "-fx-font-size".equals(string))) {
                    object3 = cacheEntry.font;
                    for (object2 = node; object2 != null; object2 = ((Node)object2).getParent()) {
                        object = this.getParentCacheEntry((Node)object2);
                        if (object == null) continue;
                        calculatedValue = ((CacheEntry)object).font;
                        if (calculatedValue != null && calculatedValue.isRelative) {
                            if (object3 != null) {
                                Font font = (Font)object3.value;
                                Font font2 = (Font)calculatedValue.value;
                                if (font.getSize() != font2.getSize()) break;
                            }
                            object3 = calculatedValue;
                            continue;
                        }
                        if (calculatedValue != null) break;
                    }
                }
                if (calculatedValue == null && cacheEntry != null) {
                    calculatedValue = cacheEntry != null ? cacheEntry.font : null;
                }
                object2 = calculatedValue != null ? (Font)calculatedValue.value : Font.getDefault();
                var13_12 = parsedValue2.getConverter() != null ? parsedValue2.convert((Font)object2) : styleableProperty.getConverter().convert(parsedValue2, (Font)object2);
                object3 = (Stylesheet.Origin)((Object)simpleObjectProperty.get());
                object = new CalculatedValue(var13_12, (Stylesheet.Origin)((Object)object3), parsedValue2.isNeedsFont());
                return object;
            }
            catch (ClassCastException classCastException) {
                Object object;
                String string = this.formatUnresolvedLookupMessage(node, styleableProperty, cascadingStyle.getStyle(), parsedValue2);
                ObservableList<CssError> observableList = null;
                observableList = StyleManager.getInstance().getErrors();
                if (observableList != null) {
                    object = new CssError.PropertySetError(styleableProperty, node, string);
                    observableList.add((CssError)object);
                }
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning(string);
                    LOGGER.fine("node = " + node.toString());
                    LOGGER.fine("styleable = " + styleableProperty);
                    LOGGER.fine("styles = " + styleableProperty.getMatchingStyles(node));
                }
                object = SKIP;
                return object;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object object;
                String string = this.formatExceptionMessage(node, styleableProperty, cascadingStyle.getStyle(), illegalArgumentException);
                ObservableList<CssError> observableList = null;
                observableList = StyleManager.getInstance().getErrors();
                if (observableList != null) {
                    object = new CssError.PropertySetError(styleableProperty, node, string);
                    observableList.add((CssError)object);
                }
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning("caught: ", illegalArgumentException);
                    LOGGER.fine("styleable = " + styleableProperty);
                    LOGGER.fine("node = " + node.toString());
                }
                object = SKIP;
                return object;
            }
            catch (NullPointerException nullPointerException) {
                Object object;
                String string = this.formatExceptionMessage(node, styleableProperty, cascadingStyle.getStyle(), nullPointerException);
                ObservableList<CssError> observableList = null;
                observableList = StyleManager.getInstance().getErrors();
                if (observableList != null) {
                    object = new CssError.PropertySetError(styleableProperty, node, string);
                    observableList.add((CssError)object);
                }
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning("caught: ", nullPointerException);
                    LOGGER.fine("styleable = " + styleableProperty);
                    LOGGER.fine("node = " + node.toString());
                }
                object = SKIP;
                return object;
            }
            finally {
                parsedValue2.nullResolved();
            }
        }
        return new CalculatedValue(null, cascadingStyle.getOrigin(), false);
    }

    private boolean isUserSetProperty(Node node, StyleableProperty styleableProperty) {
        WritableValue writableValue = node != null ? styleableProperty.getWritableValue(node) : null;
        Stylesheet.Origin origin = writableValue != null ? ((Property)((Object)writableValue)).getOrigin() : null;
        return origin == Stylesheet.Origin.USER;
    }

    private CacheEntry getParentCacheEntry(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node;
        StyleHelper styleHelper = null;
        while ((node2 = node2.getParent()) != null && (styleHelper = node2.impl_getStyleHelper()) == null) {
        }
        CacheEntry cacheEntry = null;
        if (node2 != null && styleHelper != null) {
            long[] lArray = styleHelper.getPseudoClassStates();
            cacheEntry = styleHelper.getCacheEntry(node2, lArray);
        }
        return cacheEntry;
    }

    private CalculatedValue getFontForUseInConvertingRelativeSize(Node node, CacheEntry cacheEntry, long l, Map<String, CascadingStyle> map) {
        Object object;
        boolean bl;
        CascadingStyle cascadingStyle;
        Object object2;
        Object object3 = null;
        Font font = null;
        Object object4 = null;
        CalculatedValue calculatedValue = null;
        boolean bl2 = false;
        if (this.fontProp != null && (object2 = StyleableProperty.getOrigin(this.fontProp)) == Stylesheet.Origin.USER) {
            object3 = object2;
            font = (Font)this.fontProp.getValue();
        }
        if ((object2 = this.getStyle(node, "-fx-font", l, map)) != null) {
            CalculatedValue calculatedValue2 = this.calculateValue((CascadingStyle)object2, node, dummyFontProperty, l, map, node, cacheEntry, null);
            if ((object3 == null || ((Enum)object3).compareTo(calculatedValue2.origin) <= 0) && calculatedValue2.value instanceof Font) {
                object3 = calculatedValue2.origin;
                calculatedValue = calculatedValue2;
                font = null;
            }
        }
        if ((cascadingStyle = this.lookupFontSubPropertyStyle(node, "-fx-font-size", bl = object3 == Stylesheet.Origin.USER || object3 == Stylesheet.Origin.INLINE, (CascadingStyle)object2, 0)) != null && (object2 == null || ((CascadingStyle)object2).compareTo(cascadingStyle) < 0)) {
            object = this.calculateValue(cascadingStyle, node, dummyFontProperty, l, map, node, cacheEntry, null);
            if (((CalculatedValue)object).value instanceof Double && (object3 == null || ((Enum)object3).compareTo(((CalculatedValue)object).origin) <= 0)) {
                object3 = ((CalculatedValue)object).origin;
                object4 = object;
                calculatedValue = null;
                font = null;
            }
        }
        if (calculatedValue != null) {
            return calculatedValue;
        }
        if (object4 != null) {
            object = Font.font("system", (Double)((CalculatedValue)object4).value);
            return new CalculatedValue(object, ((CalculatedValue)object4).origin, ((CalculatedValue)object4).isRelative);
        }
        if (font != null) {
            if (object3 != null && object3 != Stylesheet.Origin.USER && (object = this.getParentCacheEntry(node)) != null && ((CacheEntry)object).font != null) {
                bl2 = ((CacheEntry)object).font.isRelative;
            }
            return new CalculatedValue(font, (Stylesheet.Origin)((Object)object3), bl2);
        }
        object = this.getParentCacheEntry(node);
        if (object != null && ((CacheEntry)object).font != null) {
            return ((CacheEntry)object).font;
        }
        return new CalculatedValue(Font.getDefault(), null, false);
    }

    private CascadingStyle lookupFontSubPropertyStyle(Node node, String string, boolean bl, CascadingStyle cascadingStyle, int n) {
        int n2;
        Node node2 = node;
        StyleHelper styleHelper = this;
        CascadingStyle cascadingStyle2 = null;
        for (n2 = 0; node2 != null && n2 <= n; node2 = node2.getParent(), ++n2) {
            long l = styleHelper.getPseudoClassState();
            Map<String, CascadingStyle> map = styleHelper.getInlineStyleMap(node2);
            cascadingStyle2 = styleHelper.getStyle(node2, string, l, map);
            if (bl) {
                Stylesheet.Origin origin;
                if (cascadingStyle2 == null || (origin = cascadingStyle2.getOrigin()) != Stylesheet.Origin.USER_AGENT) break;
                cascadingStyle2 = null;
                break;
            }
            if (cascadingStyle2 != null) break;
            do {
                StyleHelper styleHelper2 = styleHelper = node2 != null ? node2.impl_getStyleHelper() : null;
            } while (node2 != null && styleHelper == null);
        }
        if (cascadingStyle != null && cascadingStyle2 != null) {
            boolean bl2 = cascadingStyle.getStyle().getDeclaration().isImportant();
            Style style = cascadingStyle2.getStyle();
            boolean bl3 = style.getDeclaration().isImportant();
            if (n2 < n) {
                if (bl2 && !bl3) {
                    cascadingStyle2 = null;
                }
            } else if (cascadingStyle2.compareTo(cascadingStyle) < 0) {
                cascadingStyle2 = null;
            }
        }
        return cascadingStyle2;
    }

    private CalculatedValue lookupFont(Node node, StyleableProperty styleableProperty, boolean bl, Node node2, CacheEntry cacheEntry, List<Style> list) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Map<String, CascadingStyle> map;
        long l;
        Stylesheet.Origin origin = null;
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = false;
        Node node3 = node;
        StyleHelper styleHelper = this;
        String string = styleableProperty.getProperty();
        CascadingStyle cascadingStyle = null;
        while (node3 != null) {
            l = styleHelper.getPseudoClassState();
            map = styleHelper.getInlineStyleMap(node3);
            object6 = styleHelper.getStyle(node3, string, l, map);
            if (bl) {
                if (object6 == null || (origin = ((CascadingStyle)object6).getOrigin()) == Stylesheet.Origin.USER_AGENT) break;
                cascadingStyle = object6;
                break;
            }
            if (object6 != null) {
                origin = ((CascadingStyle)object6).getOrigin();
                cascadingStyle = object6;
                break;
            }
            do {
                node3 = node3.getParent();
                ++n;
                StyleHelper styleHelper2 = styleHelper = node3 != null ? node3.impl_getStyleHelper() : null;
            } while (node3 != null && styleHelper == null);
        }
        l = this.pseudoClassStates[0];
        map = this.getInlineStyleMap(node);
        object6 = null;
        double d = -1.0;
        FontWeight fontWeight = null;
        FontPosture fontPosture = null;
        if (cascadingStyle != null) {
            if (list != null) {
                list.add(cascadingStyle.getStyle());
            }
            if ((object5 = this.calculateValue(cascadingStyle, node, styleableProperty, l, map, node2, cacheEntry, list)) != SKIP && (origin == null || origin.compareTo(((CalculatedValue)object5).origin) <= 0) && ((CalculatedValue)object5).value instanceof Font) {
                object4 = (Font)((CalculatedValue)object5).value;
                bl2 = ((CalculatedValue)object5).isRelative;
                origin = ((CalculatedValue)object5).origin;
                object3 = (ParsedValue[])cascadingStyle.getParsedValue().getValue();
                if (object3[0] != null) {
                    object6 = ((Font)object4).getFamily();
                }
                if (object3[1] != null) {
                    d = ((Font)object4).getSize();
                }
                if (object3[2] != null) {
                    fontWeight = (FontWeight)((Object)object3[2].convert(null));
                }
                if (object3[3] != null) {
                    fontPosture = (FontPosture)((Object)object3[3].convert(null));
                }
            }
        }
        object5 = null;
        object5 = this.lookupFontSubPropertyStyle(node, string + "-family", bl, cascadingStyle, n);
        if (object5 != null && (cascadingStyle == null || cascadingStyle.compareTo(object5) < 0)) {
            if (list != null) {
                list.add(((CascadingStyle)object5).getStyle());
            }
            object4 = this.calculateValue((CascadingStyle)object5, node, styleableProperty, l, map, node2, cacheEntry, list);
            if ((origin == null || origin.compareTo(((CalculatedValue)object4).origin) <= 0) && ((CalculatedValue)object4).value instanceof String) {
                object6 = Utils.stripQuotes((String)((CalculatedValue)object4).value);
                origin = ((CalculatedValue)object4).origin;
            }
        }
        object4 = null;
        object4 = this.lookupFontSubPropertyStyle(node, string + "-size", bl, cascadingStyle, n);
        if (object4 != null && (cascadingStyle == null || cascadingStyle.compareTo(object4) < 0)) {
            if (list != null) {
                list.add(((CascadingStyle)object4).getStyle());
            }
            object3 = this.calculateValue((CascadingStyle)object4, node, styleableProperty, l, map, node2, cacheEntry, list);
            if ((origin == null || origin.compareTo(((CalculatedValue)object3).origin) <= 0) && ((CalculatedValue)object3).value instanceof Double) {
                d = (Double)((CalculatedValue)object3).value;
                bl2 = ((CalculatedValue)object3).isRelative;
                origin = ((CalculatedValue)object3).origin;
            }
        }
        object3 = null;
        object3 = this.lookupFontSubPropertyStyle(node, string + "-weight", bl, cascadingStyle, n);
        if (object3 != null && (cascadingStyle == null || cascadingStyle.compareTo(object3) < 0)) {
            if (list != null) {
                list.add(((CascadingStyle)object3).getStyle());
            }
            object2 = this.calculateValue((CascadingStyle)object3, node, styleableProperty, l, map, node2, cacheEntry, list);
            if ((origin == null || origin.compareTo(((CalculatedValue)object2).origin) <= 0) && ((CalculatedValue)object2).value instanceof FontWeight) {
                fontWeight = (FontWeight)((Object)((CalculatedValue)object2).value);
                origin = ((CalculatedValue)object2).origin;
            }
        }
        object2 = null;
        object2 = this.lookupFontSubPropertyStyle(node, string + "-style", bl, cascadingStyle, n);
        if (object2 != null && (cascadingStyle == null || cascadingStyle.compareTo(object2) < 0)) {
            if (list != null) {
                list.add(((CascadingStyle)object2).getStyle());
            }
            object = this.calculateValue((CascadingStyle)object2, node, styleableProperty, l, map, node2, cacheEntry, list);
            if ((origin == null || origin.compareTo(((CalculatedValue)object).origin) <= 0) && ((CalculatedValue)object).value instanceof FontPosture) {
                fontPosture = (FontPosture)((Object)((CalculatedValue)object).value);
                origin = ((CalculatedValue)object).origin;
            }
        }
        if (object6 == null && d == -1.0 && fontWeight == null && fontPosture == null) {
            return SKIP;
        }
        object = styleableProperty != null ? styleableProperty.getWritableValue(node) : null;
        Font font = null;
        if (object != null) {
            font = (Font)object.getValue();
        }
        if (font == null) {
            font = Font.getDefault();
        }
        if (object6 == null) {
            object6 = font.getFamily();
        }
        if (d == -1.0) {
            d = font.getSize();
        }
        Font font2 = null;
        font2 = fontWeight != null && fontPosture != null ? Font.font((String)object6, fontWeight, fontPosture, d) : (fontWeight != null ? Font.font((String)object6, fontWeight, d) : (fontPosture != null ? Font.font((String)object6, fontPosture, d) : Font.font((String)object6, d)));
        return new CalculatedValue(font2, origin, bl2);
    }

    List<Style> getMatchingStyles(Styleable styleable, StyleableProperty styleableProperty) {
        int n;
        ArrayList<CascadingStyle> arrayList = new ArrayList<CascadingStyle>();
        this.getMatchingStyles(styleable, styleableProperty, arrayList);
        List<StyleableProperty> list = styleableProperty.getSubProperties();
        if (list != null) {
            n = list.size();
            for (int i = 0; i < n; ++i) {
                StyleableProperty styleableProperty2 = list.get(i);
                this.getMatchingStyles(styleable, styleableProperty2, arrayList);
            }
        }
        Collections.sort(arrayList);
        ArrayList<Style> arrayList2 = new ArrayList<Style>(arrayList.size());
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            Style style = ((CascadingStyle)arrayList.get(n)).getStyle();
            if (arrayList2.contains(style)) continue;
            arrayList2.add(style);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private void getMatchingStyles(Styleable styleable, StyleableProperty styleableProperty, List<CascadingStyle> list) {
        if (styleable != null) {
            List<Object> list2;
            Map<String, Object> map;
            String string;
            Styleable styleable2;
            HashMap<String, List<CascadingStyle>> hashMap = null;
            for (styleable2 = styleable; styleable2 != null; styleable2 = styleable2.getStyleableParent()) {
                String string2 = string = styleable2.getNode() != null ? styleable2.getNode().impl_getStyleHelper() : null;
                if (string == null || (map = super.getInlineStyleMap(styleable2)) == null) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, List<CascadingStyle>>();
                }
                for (Map.Entry entry : map.entrySet()) {
                    String n = (String)entry.getKey();
                    list2 = (List)hashMap.get(n);
                    if (list2 == null) {
                        list2 = new ArrayList();
                        hashMap.put(n, list2);
                    }
                    list2.add(entry.getValue());
                }
            }
            string = styleableProperty.getProperty();
            map = this.getStyleMap();
            if (map == null) {
                return;
            }
            List<CascadingStyle> list3 = map.get(string);
            if (list3 != null) {
                void styleHelper;
                list.addAll(list3);
                boolean i = false;
                int n = list3.size();
                while (styleHelper < n) {
                    list2 = (CascadingStyle)list3.get((int)styleHelper);
                    ParsedValue parsedValue = ((CascadingStyle)((Object)list2)).getParsedValue();
                    this.getMatchingLookupStyles(styleable, parsedValue, hashMap, list);
                    ++styleHelper;
                }
            }
            if (styleableProperty.isInherits()) {
                for (styleable2 = styleable.getStyleableParent(); styleable2 != null; styleable2 = styleable2.getStyleableParent()) {
                    StyleHelper styleHelper;
                    StyleHelper styleHelper2 = styleHelper = styleable2.getNode() != null ? styleable2.getNode().impl_getStyleHelper() : null;
                    if (styleHelper == null) continue;
                    styleHelper.getMatchingStyles(styleable2, styleableProperty, list);
                }
            }
        }
    }

    private void getMatchingLookupStyles(Styleable styleable, ParsedValue parsedValue, Map<String, List<CascadingStyle>> map, List<CascadingStyle> list) {
        block10: {
            ParsedValue[][] parsedValueArray;
            Object v;
            block9: {
                if (parsedValue.isLookup() && (v = parsedValue.getValue()) instanceof String) {
                    parsedValueArray = (ParsedValue[][])v;
                    Styleable styleable2 = styleable;
                    do {
                        List<CascadingStyle> list2;
                        StyleHelper styleHelper;
                        StyleHelper styleHelper2 = styleHelper = styleable2.getNode() != null ? styleable2.getNode().impl_getStyleHelper() : null;
                        if (styleHelper == null) continue;
                        int n = list.size();
                        Map<String, List<CascadingStyle>> map2 = styleHelper.getStyleMap();
                        if (map2 != null && (list2 = map2.get(parsedValueArray)) != null) {
                            list.addAll(list2);
                        }
                        List<CascadingStyle> list3 = list2 = map != null ? map.get(parsedValueArray) : null;
                        if (list2 != null) {
                            list.addAll(list2);
                        }
                        int n2 = list.size();
                        for (int i = n; i < n2; ++i) {
                            CascadingStyle cascadingStyle = list.get(i);
                            this.getMatchingLookupStyles(styleable2, cascadingStyle.getParsedValue(), map, list);
                        }
                    } while ((styleable2 = styleable2.getStyleableParent()) != null);
                }
                if (!parsedValue.isContainsLookups()) {
                    return;
                }
                v = parsedValue.getValue();
                if (!(v instanceof ParsedValue[][])) break block9;
                parsedValueArray = (ParsedValue[][])v;
                for (int i = 0; i < parsedValueArray.length; ++i) {
                    for (int j = 0; j < parsedValueArray[i].length; ++j) {
                        if (parsedValueArray[i][j] == null) continue;
                        this.getMatchingLookupStyles(styleable, parsedValueArray[i][j], map, list);
                    }
                }
                break block10;
            }
            if (!(v instanceof ParsedValue[])) break block10;
            parsedValueArray = (ParsedValue[])v;
            for (int i = 0; i < parsedValueArray.length; ++i) {
                if (parsedValueArray[i] == null) continue;
                this.getMatchingLookupStyles(styleable, (ParsedValue)parsedValueArray[i], map, list);
            }
        }
    }

    static {
        Rule rule = new Rule(new ArrayList<Selector>(), Collections.EMPTY_LIST);
        rule.getSelectors().add(Selector.getUniversalSelector());
        declarationsFromDefaults = rule.getDeclarations();
        defaultsStylesheet = new Stylesheet();
        defaultsStylesheet.setOrigin(null);
        defaultsStylesheet.getRules().add(rule);
        authorStylesCache = new HashMap<String, Map<String, CascadingStyle>>();
        pseudoclassMasksByNode = new HashMap<Node, Long>();
        dummyFontProperty = new StyleableProperty.FONT<Node>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(Node node) {
                return true;
            }

            @Override
            public WritableValue<Font> getWritableValue(Node node) {
                return null;
            }
        };
    }

    static class CacheEntry {
        private final long[] states;
        private final Map<String, CalculatedValue> values;
        private CalculatedValue font;
        private final Reference<CacheEntry> sharedCacheRef;

        private CacheEntry(long[] lArray) {
            this(lArray, (CacheEntry)null);
        }

        private CacheEntry(long[] lArray, CacheEntry cacheEntry) {
            this.states = lArray;
            this.values = new HashMap<String, CalculatedValue>();
            this.sharedCacheRef = new WeakReference<CacheEntry>(cacheEntry);
        }

        private CalculatedValue get(String string) {
            CalculatedValue calculatedValue = null;
            if (!this.values.isEmpty()) {
                calculatedValue = this.values.get(string);
            }
            if (calculatedValue == null && this.sharedCacheRef != null) {
                CacheEntry cacheEntry = this.sharedCacheRef.get();
                calculatedValue = cacheEntry != null ? cacheEntry.values.get(string) : SKIP;
            }
            return calculatedValue;
        }

        private void put(String string, CalculatedValue calculatedValue) {
            boolean bl;
            boolean bl2 = bl = this.sharedCacheRef == null || calculatedValue.origin == Stylesheet.Origin.INLINE || calculatedValue.origin == Stylesheet.Origin.USER || calculatedValue.isRelative && (this.font.origin == Stylesheet.Origin.INLINE || this.font.origin == Stylesheet.Origin.USER);
            if (bl) {
                this.values.put(string, calculatedValue);
            } else {
                CacheEntry cacheEntry = this.sharedCacheRef.get();
                if (cacheEntry != null && !cacheEntry.values.containsKey(string)) {
                    cacheEntry.values.put(string, calculatedValue);
                }
            }
        }
    }

    private static class CalculatedValue {
        final Object value;
        final Stylesheet.Origin origin;
        final boolean isRelative;

        CalculatedValue(Object object, Stylesheet.Origin origin, boolean bl) {
            this.value = object;
            this.origin = origin;
            this.isRelative = bl;
        }
    }

    static final class StyleCacheBucket {
        private final long[] pclassMask;
        private final List<CacheEntry> entries;

        private StyleCacheBucket(long[] lArray) {
            this.pclassMask = lArray;
            this.entries = new ArrayList<CacheEntry>();
        }
    }

    public static class StyleCacheKey {
        private final long[] keys;

        private StyleCacheKey(long[] lArray) {
            this.keys = lArray;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StyleCacheKey styleCacheKey = (StyleCacheKey)object;
            return Arrays.equals(this.keys, styleCacheKey.keys);
        }

        public int hashCode() {
            int n = 5;
            n = 67 * n + Arrays.hashCode(this.keys);
            return n;
        }
    }
}

