/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CellUtils;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class TextFieldTreeCell<T>
extends TreeCell<T> {
    private TextField textField;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");

    public static Callback<TreeView<String>, TreeCell<String>> forTreeView() {
        return TextFieldTreeCell.forTreeView(new DefaultStringConverter());
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(final StringConverter<T> stringConverter) {
        return new Callback<TreeView<T>, TreeCell<T>>(){

            @Override
            public TreeCell<T> call(TreeView<T> treeView) {
                return new TextFieldTreeCell(stringConverter);
            }
        };
    }

    public TextFieldTreeCell() {
        this((StringConverter<T>)null);
    }

    public TextFieldTreeCell(StringConverter<T> stringConverter) {
        this.getStyleClass().add("text-field-tree-cell");
        this.setConverter(stringConverter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> stringConverter) {
        this.converterProperty().set(stringConverter);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    @Override
    public void startEdit() {
        if (!this.isEditable() || !this.getTreeView().isEditable()) {
            return;
        }
        super.startEdit();
        CellUtils.startEdit(this, this.textField, this.getConverter());
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        CellUtils.cancelEdit(this, this.getConverter());
    }

    @Override
    public void updateItem(T t, boolean bl) {
        super.updateItem(t, bl);
        CellUtils.updateItem(this, this.textField, this.getConverter());
    }
}

