/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.mac;

import com.sun.jna.Memory;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxyResolver;
import org.netbeans.core.network.proxy.NetworkProxySettings;
import org.netbeans.core.network.proxy.mac.MacCoreFoundationLibrary;
import org.netbeans.core.network.proxy.mac.MacNetworkProxyLibrary;

public class MacNetworkProxy
implements NetworkProxyResolver {
    private static final Logger LOGGER = Logger.getLogger(MacNetworkProxy.class.getName());
    private static final MacNetworkProxyLibrary cfNetworkLibrary = MacNetworkProxyLibrary.LIBRARY;
    private static final MacCoreFoundationLibrary cfLibrary = MacCoreFoundationLibrary.LIBRARY;
    private static final String COMMA = ",";
    private static final NativeLibrary NETWORK_LIBRARY = NativeLibrary.getInstance((String)"CoreServices");
    private static final String KEY_AUTO_DISCOVERY_ENABLE = "kCFNetworkProxiesProxyAutoDiscoveryEnable";
    private static final String KEY_PAC_ENABLE = "kCFNetworkProxiesProxyAutoConfigEnable";
    private static final String KEY_PAC_URL = "kCFNetworkProxiesProxyAutoConfigURLString";
    private static final String KEY_HTTP_ENABLE = "kCFNetworkProxiesHTTPEnable";
    private static final String KEY_HTTP_HOST = "kCFNetworkProxiesHTTPProxy";
    private static final String KEY_HTTP_PORT = "kCFNetworkProxiesHTTPPort";
    private static final String KEY_HTTPS_ENABLE = "kCFNetworkProxiesHTTPSEnable";
    private static final String KEY_HTTPS_HOST = "kCFNetworkProxiesHTTPSProxy";
    private static final String KEY_HTTPS_PORT = "kCFNetworkProxiesHTTPSPort";
    private static final String KEY_SOCKS_ENABLE = "kCFNetworkProxiesSOCKSEnable";
    private static final String KEY_SOCKS_HOST = "kCFNetworkProxiesSOCKSProxy";
    private static final String KEY_SOCKS_PORT = "kCFNetworkProxiesSOCKSPort";
    private static final String KEY_EXCEPTIONS_LIST = "kCFNetworkProxiesExceptionsList";

    @Override
    public NetworkProxySettings getNetworkProxySettings() {
        Pointer pointer;
        Pointer pointer2;
        boolean bl = false;
        LOGGER.log(Level.FINE, "Mac system proxy resolver started.");
        Pointer pointer3 = cfNetworkLibrary.CFNetworkCopySystemProxySettings();
        Pointer pointer4 = cfLibrary.CFDictionaryGetValue(pointer3, this.getKeyCFStringRef(KEY_AUTO_DISCOVERY_ENABLE));
        if (this.getIntFromCFNumberRef(pointer4) != 0) {
            LOGGER.log(Level.INFO, "Mac system proxy resolver: auto detect");
            bl = true;
        }
        if (this.getIntFromCFNumberRef(pointer2 = cfLibrary.CFDictionaryGetValue(pointer3, this.getKeyCFStringRef(KEY_PAC_ENABLE))) != 0) {
            pointer = new Pointer[1];
            if (cfLibrary.CFDictionaryGetValueIfPresent(pointer3, this.getKeyCFStringRef(KEY_PAC_URL), (Pointer[])pointer)) {
                String string = this.getStringFromCFStringRef(pointer[0]);
                LOGGER.log(Level.INFO, "Mac system proxy resolver: auto - PAC ({0})", string);
                return new NetworkProxySettings(string);
            }
        }
        pointer = cfLibrary.CFDictionaryGetValue(pointer3, this.getKeyCFStringRef(KEY_HTTP_ENABLE));
        Pointer pointer5 = cfLibrary.CFDictionaryGetValue(pointer3, this.getKeyCFStringRef(KEY_HTTPS_ENABLE));
        Pointer pointer6 = cfLibrary.CFDictionaryGetValue(pointer3, this.getKeyCFStringRef(KEY_SOCKS_ENABLE));
        if (this.getIntFromCFNumberRef(pointer) != 0 || this.getIntFromCFNumberRef(pointer5) != 0 || this.getIntFromCFNumberRef(pointer6) != 0) {
            String string = this.getStringFromCFStringRef(this.getValueIfExists(pointer3, KEY_HTTP_HOST));
            String string2 = this.getStringFromCFNumberRef(this.getValueIfExists(pointer3, KEY_HTTP_PORT));
            String string3 = this.getStringFromCFStringRef(this.getValueIfExists(pointer3, KEY_HTTPS_HOST));
            String string4 = this.getStringFromCFNumberRef(this.getValueIfExists(pointer3, KEY_HTTPS_PORT));
            String string5 = this.getStringFromCFStringRef(this.getValueIfExists(pointer3, KEY_SOCKS_HOST));
            String string6 = this.getStringFromCFNumberRef(this.getValueIfExists(pointer3, KEY_SOCKS_PORT));
            String[] stringArray = this.getNoProxyHosts(this.getValueIfExists(pointer3, KEY_EXCEPTIONS_LIST));
            LOGGER.log(Level.INFO, "Mac system proxy resolver: manual - http host ({0})", string);
            LOGGER.log(Level.INFO, "Mac system proxy resolver: manual - http port ({0})", string2);
            LOGGER.log(Level.INFO, "Mac system proxy resolver: manual - https host ({0})", string3);
            LOGGER.log(Level.INFO, "Mac system proxy resolver: manual - https port ({0})", string4);
            LOGGER.log(Level.INFO, "Mac system proxy resolver: manual - socks host ({0})", string5);
            LOGGER.log(Level.INFO, "Mac system proxy resolver: manual - socks port ({0})", string6);
            LOGGER.log(Level.INFO, "Mac system proxy resolver: manual - no proxy hosts ({0})", MacNetworkProxy.getStringFromArray(stringArray));
            return new NetworkProxySettings(string, string2, string3, string4, string5, string6, stringArray);
        }
        return new NetworkProxySettings(bl);
    }

    private Pointer getKeyCFStringRef(String string) {
        return NETWORK_LIBRARY.getGlobalVariableAddress(string).getPointer(0L);
    }

    private String getStringFromCFStringRef(Pointer pointer) {
        long l;
        long l2;
        Memory memory;
        if (pointer != null && cfLibrary.CFStringGetCString(pointer, (Pointer)(memory = new Memory(l2 = cfLibrary.CFStringGetMaximumSizeForEncoding(l = cfLibrary.CFStringGetLength(pointer), 0x8000100))), l2, 0x8000100)) {
            return memory.getString(0L);
        }
        return null;
    }

    private int getIntFromCFNumberRef(Pointer pointer) {
        long l;
        Memory memory;
        Pointer pointer2;
        if (pointer != null && cfLibrary.CFNumberGetValue(pointer, pointer2 = cfLibrary.CFNumberGetType(pointer), (Pointer)(memory = new Memory(l = cfLibrary.CFNumberGetByteSize(pointer))))) {
            return memory.getInt(0L);
        }
        return 0;
    }

    private String getStringFromCFNumberRef(Pointer pointer) {
        long l;
        Memory memory;
        Pointer pointer2;
        if (pointer != null && cfLibrary.CFNumberGetValue(pointer, pointer2 = cfLibrary.CFNumberGetType(pointer), (Pointer)(memory = new Memory(l = cfLibrary.CFNumberGetByteSize(pointer))))) {
            return String.valueOf(memory.getInt(0L));
        }
        return null;
    }

    private String[] getNoProxyHosts(Pointer pointer) {
        if (pointer != null) {
            long l = cfLibrary.CFArrayGetCount(pointer);
            String[] stringArray = new String[(int)l];
            for (long i = 0L; i < l; ++i) {
                String string;
                Pointer pointer2 = cfLibrary.CFArrayGetValueAtIndex(pointer, new Pointer(i));
                stringArray[(int)i] = string = this.getStringFromCFStringRef(pointer2);
            }
            return stringArray;
        }
        return new String[0];
    }

    private Pointer getValueIfExists(Pointer pointer, String string) {
        Pointer[] pointerArray = new Pointer[1];
        if (cfLibrary.CFDictionaryGetValueIfPresent(pointer, this.getKeyCFStringRef(string), pointerArray)) {
            return pointerArray[0];
        }
        return null;
    }

    private static String getStringFromArray(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i != stringArray.length - 1) continue;
            stringBuilder.append(COMMA);
        }
        return stringBuilder.toString();
    }
}

