/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.border;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BackgroundRepeat;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.BackgroundSpecification;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class BackgroundRepeatResolveHandler
implements ResolveHandler {
    private static final CSSValuePair EMPTY_BACKGROUND_REPEAT = new CSSValuePair(BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT);

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        CSSValue cSSValue = layoutElement.getLayoutContext().getValue(styleKey);
        if (cSSValue == null) {
            return;
        }
        if (!(cSSValue instanceof CSSValueList)) {
            return;
        }
        CSSValueList cSSValueList = (CSSValueList)cSSValue;
        int n = cSSValueList.getLength();
        if (n == 0) {
            return;
        }
        BackgroundSpecification backgroundSpecification = layoutElement.getLayoutContext().getBackgroundSpecification();
        for (int i = 0; i < n; ++i) {
            CSSValue cSSValue2 = cSSValueList.getItem(i);
            if (!(cSSValue2 instanceof CSSValuePair)) {
                backgroundSpecification.setBackgroundRepeat(i, EMPTY_BACKGROUND_REPEAT);
                continue;
            }
            CSSValuePair cSSValuePair = (CSSValuePair)cSSValue2;
            backgroundSpecification.setBackgroundRepeat(i, cSSValuePair);
        }
    }
}

