/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.displaymodel;

import java.io.IOException;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayModel;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.displaymodel.FlowContext;
import org.jfree.layouting.normalizer.displaymodel.ModelBuilder;
import org.jfree.layouting.normalizer.generator.ContentGenerator;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.IntList;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class FastDisplayModelBuilder
implements ModelBuilder {
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_INLINE = 2;
    public static final int TYPE_MARKER = 3;
    public static final int TYPE_RUBY = 4;
    public static final int TYPE_TABLE = 5;
    public static final int TYPE_TABLE_CELL = 6;
    public static final int TYPE_TABLE_ROW = 7;
    public static final int TYPE_TABLE_SECTION = 8;
    public static final int TYPE_TABLE_COLGROUP = 9;
    public static final int TYPE_TABLE_COL = 10;
    public static final int TYPE_TABLE_CAPTION = 11;
    public static final int TYPE_IGNORED = 12;
    public static final int TYPE_PARAGRAPH = 13;
    public static final int TYPE_FLOW = 14;
    public static final int FLAG_AUTOGENERATED = 0x1000000;
    public static final int MODEL_BLOCK_INSIDE = 1;
    public static final int MODEL_INLINE_INSIDE = 2;
    public static final int MODEL_TABLE = 3;
    public static final int MODEL_TABLE_SECTION = 4;
    public static final int MODEL_TABLE_ROW = 5;
    public static final int MODEL_TABLE_COLGROUP = 6;
    public static final int MODEL_TABLE_COL = 7;
    private LayoutProcess layoutProcess;
    private FastStack flowContexts;
    private ContentGenerator contentGenerator;
    private int suspendCounter;

    public FastDisplayModelBuilder() {
    }

    public FastDisplayModelBuilder(ContentGenerator contentGenerator, LayoutProcess layoutProcess) {
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        if (contentGenerator == null) {
            throw new NullPointerException();
        }
        this.contentGenerator = contentGenerator;
        this.layoutProcess = layoutProcess;
        this.flowContexts = new FastStack();
    }

    public void startDocument(PageContext pageContext) throws NormalizationException {
        this.contentGenerator.startedDocument(pageContext);
    }

    public void startElement(LayoutContext layoutContext) throws NormalizationException, IOException {
        Object object;
        if (this.flowContexts.isEmpty()) {
            object = new FlowContext();
            this.flowContexts.push(object);
            ((FlowContext)object).addElement(1, 0x100000E, layoutContext);
            this.contentGenerator.startedFlow(layoutContext);
        }
        if ((object = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE)) == DisplayRole.NONE || this.suspendCounter > 0) {
            ++this.suspendCounter;
            this.contentGenerator.startedPassThrough(layoutContext);
            return;
        }
        if (object == DisplayRole.TABLE_CAPTION) {
            this.addTableCaption(layoutContext);
            return;
        }
        if (object == DisplayRole.TABLE_COLUMN) {
            this.addTableColumn(layoutContext);
            return;
        }
        if (object == DisplayRole.TABLE_COLUMN_GROUP) {
            this.addTableColumnGroup(layoutContext);
            return;
        }
        if (object == DisplayRole.TABLE_FOOTER_GROUP || object == DisplayRole.TABLE_HEADER_GROUP || object == DisplayRole.TABLE_ROW_GROUP) {
            this.addTableSection(layoutContext);
            return;
        }
        if (object == DisplayRole.TABLE_ROW) {
            this.addTableRow(layoutContext);
            return;
        }
        if (object == DisplayRole.TABLE_CELL) {
            this.addTableCell(layoutContext);
            return;
        }
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        int n = flowContext.getActiveDisplayModel();
        switch (n) {
            case 1: {
                this.addToBlockLevelBox(layoutContext);
                return;
            }
            case 2: {
                this.addToInlineLevelBox(layoutContext);
                return;
            }
            case 3: {
                this.addToTableLevelBox(layoutContext);
                return;
            }
            case 4: {
                StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
                ContextId contextId = new ContextId(2, -1L, 0L);
                LayoutContext layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
                flowContext.addElement(5, 0x1000007, layoutContext2);
                this.contentGenerator.startedTableRow(layoutContext2);
                LayoutContext layoutContext3 = styleResolver.createAnonymousContext(contextId, layoutContext2);
                flowContext.addElement(1, 0x1000006, layoutContext3);
                this.contentGenerator.startedTableCell(layoutContext3);
                this.addToBlockLevelBox(layoutContext);
                return;
            }
            case 5: {
                StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
                ContextId contextId = new ContextId(2, -1L, 0L);
                LayoutContext layoutContext4 = styleResolver.createAnonymousContext(contextId, layoutContext);
                flowContext.addElement(1, 0x1000006, layoutContext4);
                this.contentGenerator.startedTableCell(layoutContext4);
                this.addToBlockLevelBox(layoutContext);
                return;
            }
            case 6: 
            case 7: {
                ++this.suspendCounter;
                this.contentGenerator.startedPassThrough(layoutContext);
                return;
            }
        }
        throw new NormalizationException("Unexpected type: " + n + " for display-role " + object);
    }

    private void addTableCaption(LayoutContext layoutContext) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        int n = flowContext.getCurrentDisplayModel();
        if (n != 3) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId contextId = new ContextId(2, -1L, 0L);
            LayoutContext layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
            flowContext.addElement(3, 0x1000005, layoutContext2);
            this.contentGenerator.startedTable(layoutContext2);
        }
        flowContext.addElement(1, 11, layoutContext);
        this.contentGenerator.startedTableCaption(layoutContext);
    }

    private void addTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        int n = flowContext.getCurrentDisplayModel();
        if (n != 3) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId contextId = new ContextId(2, -1L, 0L);
            LayoutContext layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
            flowContext.addElement(3, 0x1000005, layoutContext2);
            this.contentGenerator.startedTable(layoutContext2);
        }
        flowContext.addElement(6, 9, layoutContext);
        this.contentGenerator.startedTableColumnGroup(layoutContext);
    }

    private void addTableColumn(LayoutContext layoutContext) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        int n = flowContext.getCurrentDisplayModel();
        if (n != 3 && n != 6) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId contextId = new ContextId(2, -1L, 0L);
            this.suspendNonBlockElements();
            LayoutContext layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
            flowContext.addElement(3, 0x1000005, layoutContext2);
            this.contentGenerator.startedTable(layoutContext2);
        }
        flowContext.addElement(7, 10, layoutContext);
        this.contentGenerator.startedTableColumn(layoutContext);
    }

    private void addTableSection(LayoutContext layoutContext) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        int n = flowContext.getCurrentDisplayModel();
        if (n != 3) {
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId contextId = new ContextId(2, -1L, 0L);
            this.suspendNonBlockElements();
            LayoutContext layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
            flowContext.addElement(3, 0x1000005, layoutContext2);
            this.contentGenerator.startedTable(layoutContext2);
        }
        flowContext.addElement(4, 8, layoutContext);
        this.contentGenerator.startedTableSection(layoutContext);
    }

    private void addTableRow(LayoutContext layoutContext) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        int n = flowContext.getCurrentDisplayModel();
        if (n != 4) {
            LayoutContext layoutContext2;
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId contextId = new ContextId(2, -1L, 0L);
            if (n != 3) {
                layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
                this.suspendNonBlockElements();
                flowContext.addElement(3, 0x1000005, layoutContext2);
                this.contentGenerator.startedTable(layoutContext2);
            }
            layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
            flowContext.addElement(4, 0x1000008, layoutContext2);
            this.contentGenerator.startedTableSection(layoutContext2);
        }
        flowContext.addElement(5, 7, layoutContext);
        this.contentGenerator.startedTableRow(layoutContext);
    }

    private void addTableCell(LayoutContext layoutContext) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        int n = flowContext.getCurrentDisplayModel();
        if (n != 5) {
            LayoutContext layoutContext2;
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId contextId = new ContextId(2, -1L, 0L);
            if (n != 3 && n != 4) {
                this.suspendNonBlockElements();
                layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
                flowContext.addElement(3, 0x1000005, layoutContext2);
                this.contentGenerator.startedTable(layoutContext2);
                n = 3;
            }
            if (n != 4) {
                layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
                flowContext.addElement(4, 0x1000008, layoutContext2);
                this.contentGenerator.startedTableSection(layoutContext2);
            }
            layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
            flowContext.addElement(5, 0x1000007, layoutContext2);
            this.contentGenerator.startedTableRow(layoutContext2);
        }
        flowContext.addElement(1, 6, layoutContext);
        this.contentGenerator.startedTableCell(layoutContext);
    }

    private void addToBlockLevelBox(LayoutContext layoutContext) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.INLINE.equals(cSSValue)) {
            Object object;
            if (!this.reactivateSuspendedInlines(flowContext)) {
                object = this.layoutProcess.getStyleResolver();
                ContextId contextId = new ContextId(2, -1L, 0L);
                LayoutContext layoutContext2 = object.createAnonymousContext(contextId, layoutContext);
                flowContext.addElement(2, 0x100000D, layoutContext2);
                this.contentGenerator.startedRootInline(layoutContext2);
            }
            if (DisplayModel.TABLE.equals(object = layoutContext.getValue(BoxStyleKeys.DISPLAY_MODEL))) {
                flowContext.addElement(3, 2, layoutContext);
                this.contentGenerator.startedTable(layoutContext);
            } else if (DisplayModel.INLINE_INSIDE.equals(object)) {
                flowContext.addElement(2, 2, layoutContext);
                this.contentGenerator.startedInline(layoutContext);
            } else {
                flowContext.addElement(1, 1, layoutContext);
                this.contentGenerator.startedBlock(layoutContext);
            }
            return;
        }
        CSSValue cSSValue2 = layoutContext.getValue(BoxStyleKeys.DISPLAY_MODEL);
        if (DisplayModel.TABLE.equals(cSSValue2)) {
            flowContext.addElement(3, 5, layoutContext);
            this.contentGenerator.startedTable(layoutContext);
        } else if (DisplayModel.INLINE_INSIDE.equals(cSSValue2)) {
            flowContext.addElement(2, 1, layoutContext);
            this.contentGenerator.startedBlock(layoutContext);
            StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
            ContextId contextId = new ContextId(2, -1L, 0L);
            LayoutContext layoutContext3 = styleResolver.createAnonymousContext(contextId, layoutContext);
            flowContext.addElement(2, 0x100000D, layoutContext3);
            this.contentGenerator.startedRootInline(layoutContext3);
        } else {
            flowContext.addElement(1, 1, layoutContext);
            this.contentGenerator.startedBlock(layoutContext);
        }
    }

    private void addToInlineLevelBox(LayoutContext layoutContext) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        if (DisplayRole.INLINE.equals(cSSValue)) {
            CSSValue cSSValue2 = layoutContext.getValue(BoxStyleKeys.DISPLAY_MODEL);
            if (DisplayModel.TABLE.equals(cSSValue2)) {
                flowContext.addElement(3, 5, layoutContext);
                this.contentGenerator.startedTable(layoutContext);
            } else if (DisplayModel.INLINE_INSIDE.equals(cSSValue2)) {
                flowContext.addElement(2, 2, layoutContext);
                this.contentGenerator.startedInline(layoutContext);
            } else {
                flowContext.addElement(1, 1, layoutContext);
                this.contentGenerator.startedBlock(layoutContext);
            }
            return;
        }
        this.suspendNonBlockElements();
        this.addToBlockLevelBox(layoutContext);
    }

    private void suspendNonBlockElements() throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        int n = flowContext.getCurrentDisplayModel();
        while (n != 1) {
            int n2 = flowContext.getCurrentDisplayRole();
            this.callFinish(n2);
            flowContext.suspend();
            n = flowContext.getCurrentDisplayModel();
        }
    }

    private void addToTableLevelBox(LayoutContext layoutContext) throws NormalizationException {
        StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
        ContextId contextId = new ContextId(2, -1L, 0L);
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        LayoutContext layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
        flowContext.addElement(4, 0x1000008, layoutContext2);
        this.contentGenerator.startedTableSection(layoutContext2);
        LayoutContext layoutContext3 = styleResolver.createAnonymousContext(contextId, layoutContext2);
        flowContext.addElement(5, 0x1000007, layoutContext3);
        this.contentGenerator.startedTableRow(layoutContext3);
        LayoutContext layoutContext4 = styleResolver.createAnonymousContext(contextId, layoutContext3);
        flowContext.addElement(1, 0x1000006, layoutContext4);
        this.contentGenerator.startedTableCell(layoutContext4);
        this.addToBlockLevelBox(layoutContext);
    }

    public void addContent(ContentToken contentToken) throws NormalizationException {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        LayoutContext layoutContext = flowContext.getCurrentLayoutContext();
        if (this.suspendCounter > 0) {
            this.contentGenerator.addPassThroughContent(layoutContext, contentToken);
            return;
        }
        int n = flowContext.getActiveDisplayModel();
        if (n == 1) {
            if (!this.reactivateSuspendedInlines(flowContext)) {
                StyleResolver styleResolver = this.layoutProcess.getStyleResolver();
                ContextId contextId = new ContextId(2, -1L, 0L);
                LayoutContext layoutContext2 = styleResolver.createAnonymousContext(contextId, layoutContext);
                flowContext.addElement(2, 0x100000D, layoutContext2);
                this.contentGenerator.startedRootInline(layoutContext2);
                this.contentGenerator.addContent(layoutContext2, contentToken);
            } else {
                this.contentGenerator.addContent(layoutContext, contentToken);
            }
            return;
        }
        if (n == 2) {
            this.reactivateSuspendedInlines(flowContext);
            this.contentGenerator.addContent(layoutContext, contentToken);
        } else {
            this.contentGenerator.addContent(layoutContext, contentToken);
        }
    }

    private boolean reactivateSuspendedInlines(FlowContext flowContext) throws NormalizationException {
        if (flowContext.getCurrentState() != 1) {
            return false;
        }
        IntList intList = new IntList(5);
        IntList intList2 = new IntList(5);
        FastStack fastStack = new FastStack();
        while (flowContext.getCurrentState() == 1) {
            fastStack.push((Object)flowContext.getCurrentLayoutContext());
            intList.push(flowContext.getCurrentDisplayRole());
            intList2.push(flowContext.getCurrentDisplayModel());
            flowContext.close();
        }
        while (!fastStack.isEmpty()) {
            LayoutContext layoutContext = (LayoutContext)fastStack.pop();
            int n = intList.pop();
            int n2 = intList2.pop();
            int n3 = n & 0xFFFFFF;
            if (n3 == 2) {
                this.contentGenerator.startedInline(layoutContext);
                flowContext.addElement(n2, n, layoutContext);
                continue;
            }
            if (n3 == 13) {
                this.contentGenerator.startedRootInline(layoutContext);
                flowContext.addElement(n2, n, layoutContext);
                continue;
            }
            throw new IllegalStateException("Unexpected role: " + n3);
        }
        return true;
    }

    public void endElement() throws NormalizationException {
        int n;
        if (this.suspendCounter > 0) {
            this.contentGenerator.finishedPassThrough();
            --this.suspendCounter;
            return;
        }
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        do {
            n = flowContext.getCurrentDisplayRole();
            if (flowContext.getCurrentState() == 0) {
                this.callFinish(n);
            } else {
                LayoutContext layoutContext = flowContext.getCurrentLayoutContext();
            }
            flowContext.close();
            if (n != 14) continue;
            flowContext = (FlowContext)this.flowContexts.peek();
        } while ((n & 0x1000000) == 0x1000000 && !flowContext.isEmpty());
    }

    public void endDocument() throws NormalizationException {
        this.endElement();
        FlowContext flowContext = (FlowContext)this.flowContexts.pop();
        this.contentGenerator.finishedDocument();
    }

    private void callFinish(int n) throws NormalizationException {
        switch (n & 0xFFFFFF) {
            case 1: {
                this.contentGenerator.finishedBlock();
                break;
            }
            case 14: {
                this.contentGenerator.finishedFlow();
                break;
            }
            case 5: {
                this.contentGenerator.finishedTable();
                break;
            }
            case 11: {
                this.contentGenerator.finishedTableCaption();
                break;
            }
            case 6: {
                this.contentGenerator.finishedTableCell();
                break;
            }
            case 10: {
                this.contentGenerator.finishedTableColumn();
                break;
            }
            case 9: {
                this.contentGenerator.finishedTableColumnGroup();
                break;
            }
            case 7: {
                this.contentGenerator.finishedTableRow();
                break;
            }
            case 8: {
                this.contentGenerator.finishedTableSection();
                break;
            }
            case 2: {
                this.contentGenerator.finishedInline();
                break;
            }
            case 3: {
                this.contentGenerator.finishedMarker();
                break;
            }
            case 13: {
                this.contentGenerator.finishedRootInline();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void handlePageBreak(PageContext pageContext) throws NormalizationException {
        this.contentGenerator.handlePageBreak(pageContext);
    }

    public Renderer getRenderer() {
        return this.contentGenerator.getRenderer();
    }

    public State saveState() throws StateException {
        return new FastDisplayModelBuilderState(this);
    }

    private static class FastDisplayModelBuilderState
    implements State {
        private FlowContext[] contexts;
        private int suspendCounter;
        private State contentGeneratorState;

        private FastDisplayModelBuilderState(FastDisplayModelBuilder fastDisplayModelBuilder) throws StateException {
            this.contentGeneratorState = fastDisplayModelBuilder.contentGenerator.saveState();
            this.suspendCounter = fastDisplayModelBuilder.suspendCounter;
            this.contexts = new FlowContext[fastDisplayModelBuilder.flowContexts.size()];
            try {
                for (int i = 0; i < this.contexts.length; ++i) {
                    FlowContext flowContext = (FlowContext)fastDisplayModelBuilder.flowContexts.get(i);
                    this.contexts[i] = (FlowContext)flowContext.clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new StateException("Cloning failed.", cloneNotSupportedException);
            }
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            try {
                FastDisplayModelBuilder fastDisplayModelBuilder = new FastDisplayModelBuilder();
                fastDisplayModelBuilder.layoutProcess = layoutProcess;
                fastDisplayModelBuilder.flowContexts = new FastStack();
                fastDisplayModelBuilder.suspendCounter = this.suspendCounter;
                for (int i = 0; i < this.contexts.length; ++i) {
                    FlowContext flowContext = this.contexts[i];
                    fastDisplayModelBuilder.flowContexts.push(flowContext.clone());
                }
                fastDisplayModelBuilder.contentGenerator = (ContentGenerator)this.contentGeneratorState.restore(layoutProcess);
                return fastDisplayModelBuilder;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new StateException("Clone failed", cloneNotSupportedException);
            }
        }
    }
}

