/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import java.io.Serializable;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.text.RenderableTextFactory;

public final class FlowContext {
    private RenderableTextFactory textFactory;
    private NormalFlowRenderBox currentFlow;

    public FlowContext(RenderableTextFactory renderableTextFactory, NormalFlowRenderBox normalFlowRenderBox) {
        if (renderableTextFactory == null) {
            throw new NullPointerException();
        }
        if (normalFlowRenderBox == null) {
            throw new NullPointerException();
        }
        this.textFactory = renderableTextFactory;
        this.currentFlow = normalFlowRenderBox;
    }

    public RenderableTextFactory getTextFactory() {
        return this.textFactory;
    }

    public NormalFlowRenderBox getCurrentFlow() {
        return this.currentFlow;
    }

    public FlowContextState saveState() throws StateException {
        FlowContextState flowContextState = new FlowContextState(this.textFactory.saveState(), this.currentFlow.getInstanceId());
        return flowContextState;
    }

    public static class FlowContextState
    implements Serializable {
        private State textFactoryState;
        private Object currentFlowId;

        public FlowContextState(State state, Object object) {
            if (state == null) {
                throw new NullPointerException();
            }
            if (object == null) {
                throw new NullPointerException();
            }
            this.textFactoryState = state;
            this.currentFlowId = object;
        }

        public State getTextFactoryState() {
            return this.textFactoryState;
        }

        public Object getCurrentFlowId() {
            return this.currentFlowId;
        }
    }
}

