/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.border;

import org.jfree.layouting.renderer.border.BorderCorner;
import org.jfree.layouting.renderer.border.BorderEdge;
import org.jfree.layouting.renderer.border.EmptyBorderCorner;
import org.jfree.layouting.renderer.border.EmptyBorderEdge;

public class Border
implements Cloneable {
    private static Border emptyBorder;
    private BorderEdge top;
    private BorderEdge left;
    private BorderEdge bottom;
    private BorderEdge right;
    private BorderEdge splittingEdge;
    private BorderCorner topLeft;
    private BorderCorner topRight;
    private BorderCorner bottomLeft;
    private BorderCorner bottomRight;
    private Boolean empty;

    public Border(BorderEdge borderEdge, BorderEdge borderEdge2, BorderEdge borderEdge3, BorderEdge borderEdge4, BorderEdge borderEdge5, BorderCorner borderCorner, BorderCorner borderCorner2, BorderCorner borderCorner3, BorderCorner borderCorner4) {
        this.top = borderEdge;
        this.left = borderEdge2;
        this.bottom = borderEdge3;
        this.right = borderEdge4;
        this.splittingEdge = borderEdge5;
        this.topLeft = borderCorner;
        this.topRight = borderCorner2;
        this.bottomLeft = borderCorner3;
        this.bottomRight = borderCorner4;
    }

    public BorderEdge getTop() {
        return this.top;
    }

    public BorderEdge getLeft() {
        return this.left;
    }

    public BorderEdge getBottom() {
        return this.bottom;
    }

    public BorderEdge getRight() {
        return this.right;
    }

    public BorderEdge getSplittingEdge() {
        return this.splittingEdge;
    }

    public BorderCorner getTopLeft() {
        return this.topLeft;
    }

    public BorderCorner getTopRight() {
        return this.topRight;
    }

    public BorderCorner getBottomLeft() {
        return this.bottomLeft;
    }

    public BorderCorner getBottomRight() {
        return this.bottomRight;
    }

    public Border[] splitVertically(Border[] borderArray) {
        if (borderArray == null || borderArray.length < 2) {
            borderArray = new Border[2];
        }
        borderArray[0] = (Border)this.clone();
        borderArray[0].empty = null;
        borderArray[0].right = borderArray[0].splittingEdge;
        borderArray[1] = (Border)this.clone();
        borderArray[1].empty = null;
        borderArray[1].left = borderArray[1].splittingEdge;
        return borderArray;
    }

    public Border[] splitHorizontally(Border[] borderArray) {
        if (borderArray == null || borderArray.length < 2) {
            borderArray = new Border[2];
        }
        borderArray[0] = (Border)this.clone();
        borderArray[0].empty = null;
        borderArray[0].bottom = borderArray[0].splittingEdge;
        borderArray[1] = (Border)this.clone();
        borderArray[1].empty = null;
        borderArray[1].top = borderArray[1].splittingEdge;
        return borderArray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Borders not supporting clone is evil!");
        }
    }

    public static synchronized Border createEmptyBorder() {
        if (emptyBorder == null) {
            BorderEdge borderEdge = EmptyBorderEdge.getInstance();
            EmptyBorderCorner emptyBorderCorner = EmptyBorderCorner.getInstance();
            emptyBorder = new Border(borderEdge, borderEdge, borderEdge, borderEdge, borderEdge, emptyBorderCorner, emptyBorderCorner, emptyBorderCorner, emptyBorderCorner);
        }
        return emptyBorder;
    }

    public boolean isEmpty() {
        if (this.empty != null) {
            return this.empty;
        }
        if (this.top.getWidth().getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.left.getWidth().getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.bottom.getWidth().getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.right.getWidth().getValue() != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        this.empty = Boolean.TRUE;
        return true;
    }
}

