/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.paginating;

import java.util.ArrayList;
import org.jfree.layouting.StateException;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.paginating.PageState;
import org.jfree.report.flow.paginating.PaginatingReportProcessor;
import org.jfree.report.util.WeakReferenceList;

public class PageStateList {
    private static final int MASTERPOSITIONS_MAX = 10;
    private static final int MASTERPOSITIONS_MED = 4;
    private static final int PRIMARY_MAX = 20;
    private static final int MASTER4_MAX = 120;
    private ArrayList masterStates10;
    private ArrayList masterStates4;
    private ArrayList primaryStates;
    private int size;
    private PaginatingReportProcessor pageProcess;

    public PageStateList(PaginatingReportProcessor paginatingReportProcessor) {
        if (paginatingReportProcessor == null) {
            throw new NullPointerException("ReportProcessor null");
        }
        this.pageProcess = paginatingReportProcessor;
        this.primaryStates = new ArrayList();
        this.masterStates4 = new ArrayList();
        this.masterStates10 = new ArrayList();
    }

    private int getMasterPos(int n, int n2) {
        return n / n2;
    }

    protected PaginatingReportProcessor getPageProcess() {
        return this.pageProcess;
    }

    public int size() {
        return this.size;
    }

    public void add(PageState pageState) {
        if (pageState == null) {
            throw new NullPointerException();
        }
        if (this.size() < 20) {
            this.primaryStates.add(pageState);
            ++this.size;
        } else if (this.size() < 120) {
            int n = this.size() - 20;
            int n2 = this.getMasterPos(n, 4);
            if (n2 >= this.masterStates4.size()) {
                MasterList masterList = new MasterList(this, 4);
                this.masterStates4.add(masterList);
                masterList.add(pageState);
            } else {
                MasterList masterList = (MasterList)this.masterStates4.get(n2);
                masterList.add(pageState);
            }
            ++this.size;
        } else {
            int n = this.size() - 120;
            int n3 = this.getMasterPos(n, 10);
            if (n3 >= this.masterStates10.size()) {
                MasterList masterList = new MasterList(this, 10);
                this.masterStates10.add(masterList);
                masterList.add(pageState);
            } else {
                MasterList masterList = (MasterList)this.masterStates10.get(n3);
                masterList.add(pageState);
            }
            ++this.size;
        }
    }

    public void clear() {
        this.masterStates10.clear();
        this.masterStates4.clear();
        this.primaryStates.clear();
        this.size = 0;
    }

    public PageState get(int n) {
        if (n >= this.size() || n < 0) {
            throw new IndexOutOfBoundsException("Index is invalid. Index was " + n + "; size was " + this.size());
        }
        if (n < 20) {
            return (PageState)this.primaryStates.get(n);
        }
        if (n < 120) {
            MasterList masterList = (MasterList)this.masterStates4.get(this.getMasterPos(n -= 20, 4));
            return (PageState)masterList.get(n);
        }
        MasterList masterList = (MasterList)this.masterStates10.get(this.getMasterPos(n -= 120, 10));
        return (PageState)masterList.get(n);
    }

    private static final class MasterList
    extends WeakReferenceList {
        private final PageStateList master;

        private MasterList(PageStateList pageStateList, int n) {
            super(n);
            this.master = pageStateList;
        }

        protected Object restoreChild(int n) {
            PageState pageState = (PageState)this.getMaster();
            if (pageState == null) {
                return null;
            }
            int n2 = this.getChildPos(n);
            try {
                return this.restoreState(n2, pageState);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private PageState restoreState(int n, PageState pageState) throws ReportProcessingException, StateException, ReportDataFactoryException, DataSourceException {
            if (pageState == null) {
                throw new NullPointerException("Master is null");
            }
            PageState pageState2 = pageState;
            for (int i = 0; i <= n; ++i) {
                PaginatingReportProcessor paginatingReportProcessor = this.master.getPageProcess();
                pageState2 = paginatingReportProcessor.processPage(pageState2);
                this.set(pageState2, i + 1);
            }
            return pageState2;
        }
    }
}

