/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class StackableException
extends Exception {
    private static final long serialVersionUID = -8649054607849486694L;
    private Throwable parent;
    private String message;

    protected StackableException() {
    }

    protected StackableException(String message, Throwable ex) {
        this.message = message;
        this.parent = ex;
    }

    protected StackableException(String message, Exception ex) {
        super(message);
        this.parent = ex;
        this.message = message;
    }

    protected StackableException(String message) {
        this.message = message;
    }

    public Exception getParent() {
        if (this.parent instanceof Exception) {
            return (Exception)this.parent;
        }
        return null;
    }

    protected void update(String message, Throwable parent) {
        this.message = message;
        this.parent = parent;
    }

    public Throwable getParentThrowable() {
        return this.parent;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.getParentThrowable() != null) {
            stream.println("ParentException: ");
            this.getParentThrowable().printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.getParentThrowable() != null) {
            writer.println("ParentException: ");
            this.getParentThrowable().printStackTrace(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            this.printStackTrace(System.err);
        }
    }
}

