/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.stream;

import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.stream.StreamContentLocation;
import org.pentaho.reporting.libraries.repository.stream.WrappedInputStream;
import org.pentaho.reporting.libraries.repository.stream.WrappedOutputStream;

public class StreamRepository
implements Repository {
    private MimeRegistry mimeRegistry;
    private WrappedOutputStream outputStream;
    private WrappedInputStream inputStream;
    private StreamContentLocation rootLocation;
    private String contentName;

    public StreamRepository(InputStream inputStream, OutputStream outputStream, String contentName) {
        if (contentName == null) {
            throw new NullPointerException();
        }
        if (inputStream != null) {
            this.inputStream = new WrappedInputStream(inputStream);
        }
        if (outputStream != null) {
            this.outputStream = new WrappedOutputStream(outputStream);
        }
        this.contentName = contentName;
        this.mimeRegistry = new DefaultMimeRegistry();
        this.rootLocation = new StreamContentLocation(this);
    }

    public StreamRepository(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, "content.data");
    }

    public StreamRepository(InputStream inputStream, String contentName) {
        this(inputStream, null, contentName);
    }

    public StreamRepository(OutputStream outputStream) {
        this(null, outputStream, "content.data");
    }

    public String getContentName() {
        return this.contentName;
    }

    public WrappedOutputStream getOutputStream() {
        return this.outputStream;
    }

    public WrappedInputStream getInputStream() {
        return this.inputStream;
    }

    public ContentLocation getRoot() {
        return this.rootLocation;
    }

    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }
}

