/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.xslt;

import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.MergeException;
import org.openoffice.xmerge.converter.xml.xslt.GenericOfficeDocument;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.diff.IteratorLCSAlgorithm;
import org.openoffice.xmerge.merger.diff.ParaNodeIterator;
import org.openoffice.xmerge.merger.merge.CharacterBaseParagraphMerge;
import org.openoffice.xmerge.merger.merge.DocumentMerge;
import org.openoffice.xmerge.util.Debug;

public class DocumentMergerImpl
implements DocumentMerger {
    private final ConverterCapabilities cc_;
    private final Document orig;

    public DocumentMergerImpl(Document doc, ConverterCapabilities cc) {
        this.cc_ = cc;
        this.orig = doc;
    }

    public void merge(Document modifiedDoc) throws MergeException {
        GenericOfficeDocument wdoc1 = (GenericOfficeDocument)this.orig;
        GenericOfficeDocument wdoc2 = (GenericOfficeDocument)modifiedDoc;
        org.w3c.dom.Document doc1 = wdoc1.getContentDOM();
        org.w3c.dom.Document doc2 = wdoc2.getContentDOM();
        ParaNodeIterator i1 = new ParaNodeIterator(this.cc_, doc1.getDocumentElement());
        ParaNodeIterator i2 = new ParaNodeIterator(this.cc_, doc2.getDocumentElement());
        IteratorLCSAlgorithm diffAlgo = new IteratorLCSAlgorithm();
        Difference[] diffTable = diffAlgo.computeDiffs(i1, i2);
        if (Debug.isFlagSet(1)) {
            Debug.log(1, "Diff Result: ");
            for (int i = 0; i < diffTable.length; ++i) {
                Debug.log(1, diffTable[i].debug());
            }
        }
        CharacterBaseParagraphMerge charMerge = new CharacterBaseParagraphMerge();
        DocumentMerge docMerge = new DocumentMerge(this.cc_, charMerge);
        docMerge.applyDifference(i1, i2, diffTable);
    }
}

