/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openoffice.xmerge.Convert;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.ConverterFactory;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.util.registry.ConverterInfoMgr;
import org.openoffice.xmerge.util.registry.ConverterInfoReader;

public class ActiveSyncDriver {
    public static void main(String[] args) {
        if (args.length != 4) {
            return;
        }
        ActiveSyncDriver asd = new ActiveSyncDriver();
        try {
            asd.Convert(args[0], args[1], args[2], args[3]);
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean Convert(String srcMime, String dstMime, String srcFile, String dstFile) throws Exception {
        File pluginJar;
        String ooClassDir = null;
        String strClassPath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(strClassPath, ";");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!s.endsWith("xmerge.jar")) continue;
            ooClassDir = s.substring(0, s.indexOf("xmerge.jar"));
        }
        if (ooClassDir == null) {
            return true;
        }
        if (srcMime.equals("staroffice/sxw") || srcMime.equals("application/x-pocket-word")) {
            pluginJar = new File(ooClassDir + "pocketWord.jar");
        } else if (srcMime.equals("staroffice/sxc") || srcMime.equals("application/x-pocket-excel")) {
            pluginJar = new File(ooClassDir + "pexcel.jar");
        } else {
            return false;
        }
        ConverterInfoReader cirPlugin = new ConverterInfoReader(pluginJar.toURI().toURL().toString(), false);
        ConverterInfoMgr.addPlugIn(cirPlugin.getConverterInfoEnumeration());
        ConverterFactory cf = new ConverterFactory();
        Convert conv = cf.getConverter(srcMime, dstMime);
        if (conv == null) {
            return false;
        }
        boolean bOK = true;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(srcFile);
            conv.addInputStream(srcFile, fis);
            try {
                fos = new FileOutputStream(dstFile);
                ConvertData dataOut = conv.convert();
                Document doc = (Document)dataOut.getDocumentEnumeration().next();
                doc.write(fos);
                fos.flush();
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        catch (IOException e) {
            bOK = false;
        }
        catch (NullPointerException e) {
            bOK = false;
        }
        catch (ConvertException e) {
            bOK = false;
        }
        catch (NoSuchElementException e) {
            bOK = false;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return bOK;
    }
}

