/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XLayoutConstrains;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.Date;
import com.sun.star.util.Time;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.Shape;

public class Control
extends Shape {
    XControlModel xControlModel;
    private XControl xControl;
    public XPropertySet xPropertySet;
    XWindowPeer xWindowPeer;
    private static final int SOMAXTEXTSIZE = 50;
    private int icontroltype;
    private XNameContainer xFormName;
    private static final int IIMGFIELDWIDTH = 3000;

    public Control() {
    }

    public Control(FormHandler _oFormHandler, String _sServiceName, Point _aPoint) {
        super(_oFormHandler, _sServiceName, _aPoint, null);
    }

    public Control(FormHandler _oFormHandler, XNameContainer _xFormName, int _icontroltype, String _FieldName, Point _aPoint, Size _aSize) {
        super(_oFormHandler, _aPoint, _aSize);
        this.xFormName = _xFormName;
        this.createControl(_icontroltype, null, _FieldName);
    }

    public Control(FormHandler _oFormHandler, int _icontroltype, Point _aPoint, Size _aSize) {
        super(_oFormHandler, _aPoint, _aSize);
        this.createControl(_icontroltype, null, null);
    }

    private void createControl(int _icontroltype, XShapes _xGroupShapes, String _FieldName) {
        try {
            this.icontroltype = _icontroltype;
            String sServiceName = this.oFormHandler.sModelServices[this.getControlType()];
            Object oControlModel = this.oFormHandler.xMSFDoc.createInstance(sServiceName);
            this.xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)oControlModel);
            this.xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oControlModel);
            XPropertySetInfo xPSI = this.xPropertySet.getPropertySetInfo();
            if (xPSI.hasPropertyByName("MouseWheelBehavior")) {
                this.xPropertySet.setPropertyValue("MouseWheelBehavior", (Object)0);
            }
            this.insertControlInContainer(_FieldName);
            this.xControlShape.setControl(this.xControlModel);
            if (_xGroupShapes == null) {
                this.oFormHandler.xDrawPage.add(this.xShape);
            } else {
                _xGroupShapes.add(this.xShape);
            }
            this.xControl = this.oFormHandler.xControlAccess.getControl(this.xControlModel);
            UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xControl);
            this.xWindowPeer = this.xControl.getPeer();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void insertControlInContainer(String _fieldname) {
        try {
            if (this.xFormName != null) {
                XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.xFormName);
                String sControlName = Desktop.getUniqueName(xNameAccess, this.getControlName(_fieldname));
                this.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sControlName);
                this.xFormName.insertByName(sControlName, (Object)this.xControlModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private String getControlName(String _fieldname) {
        String controlname = PropertyNames.EMPTY_STRING;
        switch (this.getControlType()) {
            case 0: {
                controlname = "lbl" + _fieldname;
                break;
            }
            case 1: {
                controlname = "txt" + _fieldname;
                break;
            }
            case 2: {
                controlname = "chk" + _fieldname;
                break;
            }
            case 3: {
                controlname = "dat" + _fieldname;
                break;
            }
            case 4: {
                controlname = "tim" + _fieldname;
                break;
            }
            case 5: {
                controlname = "fmt" + _fieldname;
                break;
            }
            case 6: {
                controlname = "grd" + _fieldname;
                break;
            }
            case 7: {
                controlname = "img" + _fieldname;
                break;
            }
            default: {
                controlname = "ctrl" + _fieldname;
            }
        }
        return controlname;
    }

    public int getPreferredWidth(String sText) {
        Size aPeerSize = this.getPreferredSize(sText);
        return (aPeerSize.Width + 10) * this.oFormHandler.getXPixelFactor();
    }

    public int getPreferredHeight(String sText) {
        Size aPeerSize = this.getPreferredSize(sText);
        if (this.getControlType() == 2) {
            return aPeerSize.Height * this.oFormHandler.getXPixelFactor();
        }
        return (aPeerSize.Height + 2) * this.oFormHandler.getXPixelFactor();
    }

    public int getPreferredWidth() {
        if (this.getControlType() == 7) {
            return 3000;
        }
        Size aPeerSize = this.getPeerSize();
        if (this.getControlType() == 2) {
            return aPeerSize.Width * this.oFormHandler.getXPixelFactor();
        }
        return aPeerSize.Width * this.oFormHandler.getXPixelFactor() + 200;
    }

    public int getPreferredHeight() {
        if (this.getControlType() == 7) {
            return 2000;
        }
        Size aPeerSize = this.getPeerSize();
        int nHeight = aPeerSize.Height;
        return (nHeight + 1) * this.oFormHandler.getYPixelFactor();
    }

    private Size getPreferredSize(String sText) {
        block4: {
            try {
                if (this.xPropertySet.getPropertySetInfo().hasPropertyByName("Text")) {
                    this.xPropertySet.setPropertyValue("Text", (Object)sText);
                    break block4;
                }
                if (this.xPropertySet.getPropertySetInfo().hasPropertyByName(PropertyNames.PROPERTY_LABEL)) {
                    this.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_LABEL, (Object)sText);
                    break block4;
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return this.getPeer().getPreferredSize();
    }

    public void setPropertyValue(String _sPropertyName, Object _aPropertyValue) throws Exception {
        if (this.xPropertySet.getPropertySetInfo().hasPropertyByName(_sPropertyName)) {
            this.xPropertySet.setPropertyValue(_sPropertyName, _aPropertyValue);
        }
    }

    private XLayoutConstrains getPeer() {
        return (XLayoutConstrains)UnoRuntime.queryInterface(XLayoutConstrains.class, (Object)this.xControl.getPeer());
    }

    private Size getPeerSize() {
        try {
            Size aPreferredSize = null;
            double dblEffMax = 0.0;
            if (this.xPropertySet.getPropertySetInfo().hasPropertyByName("EffectiveMax")) {
                if (this.xPropertySet.getPropertyValue("EffectiveMax") != Any.VOID) {
                    dblEffMax = AnyConverter.toDouble((Object)this.xPropertySet.getPropertyValue("EffectiveMax"));
                }
                if (dblEffMax == 0.0) {
                    this.xPropertySet.setPropertyValue("EffectiveValue", (Object)new Double(99999.0));
                } else {
                    this.xPropertySet.setPropertyValue("EffectiveValue", (Object)new Double(dblEffMax));
                }
                aPreferredSize = this.getPeer().getPreferredSize();
                this.xPropertySet.setPropertyValue("EffectiveValue", (Object)Any.VOID);
            } else if (this.getControlType() == 2) {
                aPreferredSize = this.getPeer().getPreferredSize();
            } else if (this.getControlType() == 3) {
                Date d = new Date();
                d.Day = (short)30;
                d.Month = (short)12;
                d.Year = (short)9999;
                this.xPropertySet.setPropertyValue("Date", (Object)d);
                aPreferredSize = this.getPeer().getPreferredSize();
                this.xPropertySet.setPropertyValue("Date", (Object)Any.VOID);
            } else if (this.getControlType() == 4) {
                Time t = new Time();
                t.NanoSeconds = 999999999;
                t.Seconds = (short)59;
                t.Minutes = (short)59;
                t.Hours = (short)22;
                this.xPropertySet.setPropertyValue("Time", (Object)t);
                aPreferredSize = this.getPeer().getPreferredSize();
                this.xPropertySet.setPropertyValue("Time", (Object)Any.VOID);
            } else {
                short iTextLength = AnyConverter.toShort((Object)this.xPropertySet.getPropertyValue("MaxTextLen"));
                String stext = iTextLength < 50 ? FormHandler.SOSIZETEXT.substring(0, 50) : FormHandler.SOSIZETEXT.substring(0, iTextLength);
                this.xPropertySet.setPropertyValue("Text", (Object)stext);
                aPreferredSize = this.getPeer().getPreferredSize();
                this.xPropertySet.setPropertyValue("Text", (Object)PropertyNames.EMPTY_STRING);
            }
            return aPreferredSize;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public int getControlType() {
        return this.icontroltype;
    }
}

