/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.UintMap;

public class NativeFunction
extends BaseFunction {
    String[] argNames;
    int argCount;
    int version;

    public final void initScriptFunction(int version, String functionName, String[] argNames, int argCount) {
        if (argNames == null || 0 > argCount || argCount > argNames.length) {
            throw new IllegalArgumentException();
        }
        if (this.argNames != null) {
            throw new IllegalStateException();
        }
        this.functionName = functionName;
        this.argNames = argNames;
        this.argCount = argCount;
        this.version = version;
    }

    final String decompile(int indent, int flags) {
        String encodedSource = this.getEncodedSource();
        if (encodedSource == null) {
            return super.decompile(indent, flags);
        }
        UintMap properties = new UintMap(1);
        properties.put(1, indent);
        return Decompiler.decompile(encodedSource, flags, properties);
    }

    public int getLength() {
        if (this.version != 120) {
            return this.argCount;
        }
        NativeCall activation = this.getActivation(Context.getContext());
        if (activation == null) {
            return this.argCount;
        }
        return activation.getOriginalArguments().length;
    }

    public int getArity() {
        return this.argCount;
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }
}

