/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import java.util.concurrent.Callable;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class HandleMethod
extends DynamicMethod
implements MethodArgs2,
Cloneable {
    private Callable<MethodHandle> maker0;
    private Callable<MethodHandle> maker1;
    private Callable<MethodHandle> maker2;
    private Callable<MethodHandle> maker3;
    private Callable<MethodHandle> maker4;
    private MethodHandle target0;
    private MethodHandle target1;
    private MethodHandle target2;
    private MethodHandle target3;
    private MethodHandle target4;
    private volatile boolean initialized0;
    private volatile boolean initialized1;
    private volatile boolean initialized2;
    private volatile boolean initialized3;
    private volatile boolean initialized4;
    private final int min;
    private final int max;
    private final String parameterDesc;
    private final Signature signature;
    private final boolean builtin;
    private final boolean notImplemented;

    public HandleMethod(RubyModule implementationClass, Visibility visibility, long encodedSignature, boolean builtin, boolean notImplemented, String parameterDesc, int min2, int max2, Callable<MethodHandle> ... makers) {
        super(implementationClass, visibility);
        this.signature = Signature.decode(encodedSignature);
        this.builtin = builtin;
        this.notImplemented = notImplemented;
        this.parameterDesc = parameterDesc;
        this.min = min2;
        this.max = max2;
        this.maker0 = makers[0];
        this.maker1 = makers[1];
        this.maker2 = makers[2];
        this.maker3 = makers[3];
        this.maker4 = makers[4];
    }

    public HandleMethod(RubyModule implementationClass, Visibility visibility, long encodedSignature, boolean builtin, boolean notImplemented, String parameterDesc, int min2, int max2, Callable<MethodHandle> maker0, Callable<MethodHandle> maker1, Callable<MethodHandle> maker2, Callable<MethodHandle> maker3, Callable<MethodHandle> maker4) {
        super(implementationClass, visibility);
        this.signature = Signature.decode(encodedSignature);
        this.builtin = builtin;
        this.notImplemented = notImplemented;
        this.parameterDesc = parameterDesc;
        this.min = min2;
        this.max = max2;
        this.maker0 = maker0;
        this.maker1 = maker1;
        this.maker2 = maker2;
        this.maker3 = maker3;
        this.maker4 = maker4;
    }

    @Override
    public Arity getArity() {
        return this.signature.arity();
    }

    @Override
    public boolean isBuiltin() {
        return this.builtin;
    }

    @Override
    public boolean isNotImplemented() {
        return this.notImplemented;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    private MethodHandle ensureTarget0() {
        if (!this.initialized0) {
            this.target0 = HandleMethod.safeCall(this.maker0);
            this.initialized0 = true;
            this.maker0 = null;
        }
        return this.target0;
    }

    private MethodHandle ensureTarget1() {
        if (!this.initialized1) {
            this.target1 = HandleMethod.safeCall(this.maker1);
            this.initialized1 = true;
            this.maker1 = null;
        }
        return this.target1;
    }

    private MethodHandle ensureTarget2() {
        if (!this.initialized2) {
            this.target2 = HandleMethod.safeCall(this.maker2);
            this.initialized2 = true;
            this.maker2 = null;
        }
        return this.target2;
    }

    private MethodHandle ensureTarget3() {
        if (!this.initialized3) {
            this.target3 = HandleMethod.safeCall(this.maker3);
            this.initialized3 = true;
            this.maker3 = null;
        }
        return this.target3;
    }

    private MethodHandle ensureTarget4() {
        if (!this.initialized4) {
            this.target4 = HandleMethod.safeCall(this.maker4);
            this.initialized4 = true;
            this.maker4 = null;
        }
        return this.target4;
    }

    private static MethodHandle safeCall(Callable<MethodHandle> maker) {
        try {
            if (maker == null) {
                return null;
            }
            return maker.call();
        }
        catch (Exception e) {
            Helpers.throwException(e);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        try {
            MethodHandle target4 = this.ensureTarget4();
            if (target4 != null) {
                Arity.checkArgumentCount(context, args2.length, this.min, this.max);
                return target4.invokeExact(context, self2, clazz, name2, args2, block);
            }
            int arity2 = Arity.checkArgumentCount(context, args2.length, this.min, this.max);
            switch (args2.length) {
                case 0: {
                    return this.ensureTarget0().invokeExact(context, self2, clazz, name2, block);
                }
                case 1: {
                    return this.ensureTarget1().invokeExact(context, self2, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.ensureTarget2().invokeExact(context, self2, clazz, name2, args2[0], args2[1], block);
                }
                case 3: {
                    return this.ensureTarget3().invokeExact(context, self2, clazz, name2, args2[0], args2[1], args2[2], block);
                }
            }
            throw new RuntimeException("invalid arity for call: " + arity2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        MethodHandle target0 = this.ensureTarget0();
        if (target0 == null) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        try {
            return target0.invokeExact(context, self2, clazz, name2, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        MethodHandle target1 = this.ensureTarget1();
        if (target1 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, block);
        }
        try {
            return target1.invokeExact(context, self2, clazz, name2, arg0, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        MethodHandle target2 = this.ensureTarget2();
        if (target2 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
        }
        try {
            return target2.invokeExact(context, self2, clazz, name2, arg0, arg1, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        MethodHandle target3 = this.ensureTarget3();
        if (target3 == null) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
        try {
            return target3.invokeExact(context, self2, clazz, name2, arg0, arg1, arg2, block);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public DynamicMethod dup() {
        return new HandleMethod(this.implementationClass, this.getVisibility(), this.signature.encode(), this.builtin, this.notImplemented, this.parameterDesc, this.min, this.max, this.maker0, this.maker1, this.maker2, this.maker3, this.maker4);
    }

    @Override
    public String[] getParameterList() {
        if (this.parameterDesc != null && this.parameterDesc.length() > 0) {
            return this.parameterDesc.split(";");
        }
        return new String[0];
    }

    public MethodHandle getHandle(int arity2) {
        switch (arity2) {
            case -1: {
                return this.ensureTarget4();
            }
            case 0: {
                return this.ensureTarget0();
            }
            case 1: {
                return this.ensureTarget1();
            }
            case 2: {
                return this.ensureTarget2();
            }
            case 3: {
                return this.ensureTarget3();
            }
        }
        return null;
    }
}

