/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.animation.Animation;
import javafx.animation.Timeline;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.banner.BannerButton;
import org.pdfsam.ui.commons.Animations;
import org.pdfsam.ui.commons.ShowStageRequest;
import org.pdfsam.ui.log.ErrorLoggedEvent;
import org.pdfsam.ui.log.LogAreaVisiblityChangedEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

@Named
class LogButton
extends BannerButton {
    static final String HAS_ERRORS_CSS_CLASS = "log-has-errors";
    private Timeline anim;

    LogButton() {
        super(MaterialDesignIcon.COMMENT_ALERT_OUTLINE);
        this.setOnAction(e -> {
            this.hasUnseenErrors(false);
            StaticStudio.eventStudio().broadcast(new ShowStageRequest(), "LogStage");
        });
        this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Application messages")));
        this.anim = Animations.shake((Node)this);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onLogMessage(ErrorLoggedEvent event) {
        this.hasUnseenErrors(true);
    }

    @EventListener
    public void onViewedLogArea(LogAreaVisiblityChangedEvent event) {
        this.hasUnseenErrors(false);
    }

    void hasUnseenErrors(boolean value) {
        if (value) {
            if (this.anim.getStatus() != Animation.Status.RUNNING) {
                this.anim.play();
            }
            if (!this.getStyleClass().contains((Object)HAS_ERRORS_CSS_CLASS)) {
                this.getStyleClass().add((Object)HAS_ERRORS_CSS_CLASS);
            }
        } else {
            this.getStyleClass().remove((Object)HAS_ERRORS_CSS_CLASS);
            this.anim.stop();
            this.setRotate(0.0);
            this.setScaleY(1.0);
        }
    }
}

