/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.commons;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import java.util.Objects;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.commons.OpenUrlRequest;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;

public class UrlButton
extends Button {
    private UrlButton(String text) {
        super(text);
    }

    public static final UrlButton styledUrlButton(String text, String url, GlyphIcons icon) {
        return UrlButton.urlButton(text, url, icon, Style.BUTTON.css());
    }

    public static final UrlButton urlButton(String text, String url, GlyphIcons icon, String ... style) {
        RequireUtils.require(StringUtils.isNotBlank(url), "URL cannot be blank");
        UrlButton button = new UrlButton(text);
        button.setOnAction(e -> StaticStudio.eventStudio().broadcast(new OpenUrlRequest(url)));
        if (Objects.nonNull(icon)) {
            GlyphsDude.setIcon((Labeled)button, icon);
        }
        if (Objects.nonNull(style) && style.length > 0) {
            button.getStyleClass().addAll((Object[])style);
        }
        return button;
    }
}

