/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.util.Comparator;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;

public enum LongColumn implements SelectionTableColumn<Number>
{
    SIZE{

        @Override
        public String getColumnTitle() {
            return DefaultI18nContext.getInstance().i18n("Size");
        }

        @Override
        public ObservableValue<Number> getObservableValue(SelectionTableRowData data) {
            return new SimpleLongProperty(data.descriptor().getFile().length());
        }

        @Override
        public String getTextValue(Number item) {
            return item != null ? FileUtils.byteCountToDisplaySize(item.longValue()) : "";
        }

        @Override
        public Comparator<Number> comparator() {
            return Comparator.comparingLong(Number::longValue);
        }
    }
    ,
    LAST_MODIFIED{

        @Override
        public String getColumnTitle() {
            return DefaultI18nContext.getInstance().i18n("Modified");
        }

        @Override
        public ObservableValue<Number> getObservableValue(SelectionTableRowData data) {
            return new SimpleLongProperty(data.descriptor().getFile().lastModified());
        }

        @Override
        public String getTextValue(Number item) {
            return item != null ? FORMATTER.format(item) : "";
        }

        @Override
        public Comparator<Number> comparator() {
            return Comparator.comparingLong(Number::longValue);
        }
    };

    private static final FastDateFormat FORMATTER;

    static {
        FORMATTER = FastDateFormat.getDateTimeInstance(1, 2);
    }
}

