/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.TransferMode;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.support.io.FileType;
import org.pdfsam.ui.commons.OpenFileRequest;
import org.pdfsam.ui.commons.RemoveSelectedEvent;
import org.pdfsam.ui.commons.SetDestinationRequest;
import org.pdfsam.ui.commons.ShowPdfDescriptorRequest;
import org.pdfsam.ui.selection.PasswordFieldPopup;
import org.pdfsam.ui.selection.ShowPasswordFieldPopupRequest;
import org.pdfsam.ui.selection.multiple.ClearSelectionTableEvent;
import org.pdfsam.ui.selection.multiple.DuplicateSelectedEvent;
import org.pdfsam.ui.selection.multiple.SelectionChangedEvent;
import org.pdfsam.ui.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.selection.multiple.move.MoveSelectedEvent;
import org.pdfsam.ui.selection.multiple.move.MoveType;
import org.pdfsam.ui.selection.multiple.move.SelectionAndFocus;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionTable
extends TableView<SelectionTableRowData>
implements ModuleOwned,
RestorableView {
    private static final Logger LOG = LoggerFactory.getLogger(SelectionTable.class);
    private String ownerModule = "";
    private Label placeHolder = new Label(DefaultI18nContext.getInstance().i18n("Drag and drop PDF files here"));
    private PasswordFieldPopup passwordPopup;
    private Consumer<SelectionChangedEvent> selectionChangedConsumer;

    public SelectionTable(String ownerModule, boolean canDuplicateItems, boolean canMove, SelectionTableColumn<?> ... columns) {
        this.ownerModule = StringUtils.defaultString(ownerModule);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Arrays.stream(columns).forEach(c -> this.getColumns().add(c.getTableColumn()));
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY);
        this.getSelectionModel().getSelectedIndices().addListener(c -> {
            ObservableList selected = c.getList();
            if (selected.isEmpty()) {
                StaticStudio.eventStudio().broadcast(SelectionChangedEvent.clearSelectionEvent(), ownerModule);
                LOG.trace("Selection cleared for {}", (Object)ownerModule);
            } else {
                SelectionChangedEvent newSelectionEvent = SelectionChangedEvent.select((Collection<? extends Integer>)selected).ofTotalRows(this.getItems().size());
                StaticStudio.eventStudio().broadcast(newSelectionEvent, ownerModule);
                LOG.trace("{} for {}", (Object)newSelectionEvent, (Object)ownerModule);
            }
        });
        this.placeHolder.getStyleClass().add((Object)"drag-drop-placeholder");
        this.placeHolder.setDisable(true);
        this.setPlaceholder((Node)this.placeHolder);
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragEntered(e -> this.dragConsume((DragEvent)e, this.onDragEnteredConsumer()));
        this.setOnDragExited(this::onDragExited);
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped()));
        this.passwordPopup = new PasswordFieldPopup(this.ownerModule);
        MenuItem setDestinationItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Set destination"), MaterialIcon.FLIGHT_LAND);
        setDestinationItem.setOnAction(e -> StaticStudio.eventStudio().broadcast(SetDestinationRequest.requestDestination(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile(), this.getOwnerModule()), this.getOwnerModule()));
        setDestinationItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        this.selectionChangedConsumer = e -> setDestinationItem.setDisable(!e.isSingleSelection());
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{setDestinationItem, new SeparatorMenuItem()});
        this.initItemsSectionContextMenu(contextMenu, canDuplicateItems, canMove);
        this.initBottomSectionContextMenu(contextMenu);
        this.setContextMenu(contextMenu);
        StaticStudio.eventStudio().addAnnotatedListeners(this);
        StaticStudio.eventStudio().add(SelectionChangedEvent.class, e -> this.selectionChangedConsumer.accept((SelectionChangedEvent)e), ownerModule);
    }

    private void initItemsSectionContextMenu(ContextMenu contextMenu, boolean canDuplicate, boolean canMove) {
        MenuItem removeSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Remove"), MaterialDesignIcon.MINUS);
        removeSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast(new RemoveSelectedEvent(), this.getOwnerModule()));
        removeSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]));
        contextMenu.getItems().add((Object)removeSelected);
        this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> removeSelected.setDisable(e.isClearSelection()));
        if (canMove) {
            MenuItem moveTopSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Move to Top"), MaterialDesignIcon.CHEVRON_DOUBLE_UP);
            moveTopSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast(new MoveSelectedEvent(MoveType.TOP), this.getOwnerModule()));
            MenuItem moveUpSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Move Up"), MaterialDesignIcon.CHEVRON_UP);
            moveUpSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast(new MoveSelectedEvent(MoveType.UP), this.getOwnerModule()));
            MenuItem moveDownSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Move Down"), MaterialDesignIcon.CHEVRON_DOWN);
            moveDownSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast(new MoveSelectedEvent(MoveType.DOWN), this.getOwnerModule()));
            MenuItem moveBottomSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Move to Bottom"), MaterialDesignIcon.CHEVRON_DOUBLE_DOWN);
            moveBottomSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast(new MoveSelectedEvent(MoveType.BOTTOM), this.getOwnerModule()));
            contextMenu.getItems().addAll((Object[])new MenuItem[]{moveTopSelected, moveUpSelected, moveDownSelected, moveBottomSelected});
            moveBottomSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveDownSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveUpSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            moveTopSelected.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> {
                moveTopSelected.setDisable(!e.canMove(MoveType.TOP));
                moveUpSelected.setDisable(!e.canMove(MoveType.UP));
                moveDownSelected.setDisable(!e.canMove(MoveType.DOWN));
                moveBottomSelected.setDisable(!e.canMove(MoveType.BOTTOM));
            });
        }
        if (canDuplicate) {
            MenuItem duplicateItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Duplicate"), MaterialDesignIcon.CONTENT_COPY);
            duplicateItem.setOnAction(e -> StaticStudio.eventStudio().broadcast(new DuplicateSelectedEvent(), this.getOwnerModule()));
            duplicateItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
            contextMenu.getItems().add((Object)duplicateItem);
            this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> duplicateItem.setDisable(e.isClearSelection()));
        }
    }

    private void initBottomSectionContextMenu(ContextMenu contextMenu) {
        MenuItem infoItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Document properties"), MaterialDesignIcon.INFORMATION_OUTLINE);
        infoItem.setOnAction(e -> Platform.runLater(() -> StaticStudio.eventStudio().broadcast(new ShowPdfDescriptorRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor()))));
        MenuItem openFileItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Open"), MaterialDesignIcon.FILE_PDF_BOX);
        openFileItem.setOnAction(e -> StaticStudio.eventStudio().broadcast(new OpenFileRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile())));
        MenuItem openFolderItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Open Folder"), MaterialDesignIcon.FOLDER_OUTLINE);
        openFolderItem.setOnAction(e -> StaticStudio.eventStudio().broadcast(new OpenFileRequest(((SelectionTableRowData)this.getSelectionModel().getSelectedItem()).descriptor().getFile().getParentFile())));
        infoItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        openFileItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        openFolderItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.ALT_DOWN}));
        contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), infoItem, openFileItem, openFolderItem});
        this.selectionChangedConsumer = this.selectionChangedConsumer.andThen(e -> {
            infoItem.setDisable(!e.isSingleSelection());
            openFileItem.setDisable(!e.isSingleSelection());
            openFolderItem.setDisable(!e.isSingleSelection());
        });
    }

    private MenuItem createMenuItem(String text, GlyphIcons icon) {
        MenuItem item = new MenuItem(text);
        GlyphsDude.setIcon(item, icon, "1.1em");
        item.setDisable(true);
        return item;
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        if (e.getDragboard().hasFiles()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragEnteredConsumer() {
        return e -> this.placeHolder.setDisable(false);
    }

    private void onDragExited(DragEvent e) {
        this.placeHolder.setDisable(true);
        e.consume();
    }

    private Consumer<DragEvent> onDragDropped() {
        return e -> {
            PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(this.getOwnerModule());
            this.getFilesFromDragboard(e.getDragboard()).filter(f -> FileType.PDF.matches(f.getName())).map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(loadEvent::add);
            if (!loadEvent.getDocuments().isEmpty()) {
                StaticStudio.eventStudio().broadcast(loadEvent, this.getOwnerModule());
            }
            e.setDropCompleted(true);
        };
    }

    private Stream<File> getFilesFromDragboard(Dragboard board) {
        List files = board.getFiles();
        if (files.size() == 1 && ((File)files.get(0)).isDirectory()) {
            return Arrays.stream(((File)files.get(0)).listFiles()).sorted();
        }
        return files.stream();
    }

    @Override
    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    @EventListener(priority=-2147483648)
    public void onLoadDocumentsRequest(PdfLoadRequestEvent loadEvent) {
        this.getItems().addAll((Collection)loadEvent.getDocuments().stream().map(SelectionTableRowData::new).collect(Collectors.toList()));
        loadEvent.getDocuments().stream().findFirst().ifPresent(f -> StaticStudio.eventStudio().broadcast(SetDestinationRequest.requestFallbackDestination(f.getFile(), this.getOwnerModule()), this.getOwnerModule()));
        StaticStudio.eventStudio().broadcast(loadEvent);
    }

    @EventListener
    public void onDuplicate(DuplicateSelectedEvent event) {
        LOG.trace("Duplicating selected items");
        this.getSelectionModel().getSelectedItems().forEach(i -> this.getItems().add((Object)i.duplicate()));
    }

    @EventListener
    public void onClear(ClearSelectionTableEvent event) {
        this.getItems().forEach(d -> d.descriptor().releaseAll());
        this.getSelectionModel().clearSelection();
        this.getItems().clear();
    }

    @EventListener
    public void onRemoveSelected(RemoveSelectedEvent event) {
        TreeSet<Integer> indices = new TreeSet<Integer>(Collections.reverseOrder());
        indices.addAll((Collection<Integer>)this.getSelectionModel().getSelectedIndices());
        LOG.trace("Removing {} items", (Object)indices.size());
        indices.forEach(i -> ((SelectionTableRowData)this.getItems().remove(i.intValue())).invalidate());
        this.requestFocus();
    }

    @EventListener
    public void onMoveSelected(MoveSelectedEvent event) {
        this.getSortOrder().clear();
        ObservableList selectedIndices = this.getSelectionModel().getSelectedIndices();
        Integer[] selected = (Integer[])selectedIndices.toArray((Object[])new Integer[selectedIndices.size()]);
        int focus = this.getFocusModel().getFocusedIndex();
        this.getSelectionModel().clearSelection();
        SelectionAndFocus newSelection = event.getType().move(selected, this.getItems(), focus);
        if (!SelectionAndFocus.NULL.equals(newSelection)) {
            LOG.trace("Changing selection to {}", (Object)newSelection);
            this.getSelectionModel().selectIndices(newSelection.getRow(), newSelection.getRows());
            this.getFocusModel().focus(newSelection.getFocus());
            this.scrollTo(newSelection.getFocus());
        }
    }

    @EventListener
    public void showPasswordFieldPopup(ShowPasswordFieldPopupRequest request) {
        Window owner;
        Scene scene = this.getScene();
        if (scene != null && (owner = scene.getWindow()) != null && owner.isShowing()) {
            Point2D nodeCoord = request.getRequestingNode().localToScene(request.getRequestingNode().getWidth() / 2.0, request.getRequestingNode().getHeight() / 1.5);
            double anchorX = Math.round(owner.getX() + scene.getX() + nodeCoord.getX() + 2.0);
            double anchorY = Math.round(owner.getY() + scene.getY() + nodeCoord.getY() + 2.0);
            this.passwordPopup.showFor((Node)this, request.getPdfDescriptor(), anchorX, anchorY);
        }
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put(StringUtils.defaultString(this.getId()) + "input.size", Integer.toString(this.getItems().size()));
        IntStream.range(0, this.getItems().size()).forEach(i -> {
            SelectionTableRowData current = (SelectionTableRowData)this.getItems().get(i);
            data.put(StringUtils.defaultString(this.getId()) + "input." + i, current.descriptor().getFile().getAbsolutePath());
            data.put(StringUtils.defaultString(this.getId()) + "input.password." + i, current.descriptor().getPassword());
            data.put(StringUtils.defaultString(this.getId()) + "input.range." + i, current.getPageSelection());
        });
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        this.onClear(null);
        int size = Optional.ofNullable(data.get(StringUtils.defaultString(this.getId()) + "input.size")).map(Integer::valueOf).orElse(0);
        if (size > 0) {
            PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(this.getOwnerModule());
            ArrayList items = new ArrayList();
            IntStream.range(0, size).forEach(i -> {
                String id = StringUtils.defaultString(this.getId());
                Optional.ofNullable(data.get(id + "input." + i)).ifPresent(f -> {
                    PdfDocumentDescriptor descriptor = PdfDocumentDescriptor.newDescriptor(new File((String)f), (String)data.get(id + "input.password." + i));
                    loadEvent.add(descriptor);
                    items.add(new SelectionTableRowData(descriptor, (String)data.get(id + "input.range." + i)));
                });
            });
            this.getItems().addAll(items);
            StaticStudio.eventStudio().broadcast(loadEvent);
        }
    }
}

