/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.sejda.core.context.GlobalConfiguration;
import org.sejda.core.context.SejdaContext;
import org.sejda.core.notification.strategy.NotificationStrategy;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskNotFoundException;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.Task;

public class DefaultSejdaContext
implements SejdaContext {
    private static final String ERROR_INSTANTIATING_THE_TASK = "Error instantiating the task";

    @Override
    public final Class<? extends NotificationStrategy> getNotificationStrategy() {
        return GlobalConfiguration.getInstance().getNotificationStrategy();
    }

    @Override
    public boolean isValidation() {
        return GlobalConfiguration.getInstance().isValidation();
    }

    public boolean isIgnoreXmlConfiguration() {
        return GlobalConfiguration.getInstance().isIgnoreXmlConfiguration();
    }

    @Override
    public Task<? extends TaskParameters> getTask(TaskParameters parameters) throws TaskException {
        Class<?> parametersClass = parameters.getClass();
        Class<? extends Task> taskClass = GlobalConfiguration.getInstance().getTasksRegistry().getTask(parametersClass);
        if (taskClass == null) {
            throw new TaskNotFoundException(String.format("Unable to find a Task class able to execute %s", parametersClass));
        }
        try {
            Constructor<? extends Task> constructor = taskClass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new TaskException(ERROR_INSTANTIATING_THE_TASK, e);
        }
        catch (NoSuchMethodException e) {
            throw new TaskException(String.format("The task %s doesn't define a public no-args contructor.", taskClass), e);
        }
    }
}

