/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.processor;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.processor.AppendExtensionPrefixProcessor;
import org.sejda.core.support.prefix.processor.LoggingPrefixProcessorDecorator;
import org.sejda.core.support.prefix.processor.PrefixProcessor;
import org.sejda.core.support.prefix.processor.PrefixType;
import org.sejda.core.support.prefix.processor.PrependPrefixProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixTypesChain {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixTypesChain.class);
    private Set<PrefixType> firstLevelPrefixChain = new HashSet<PrefixType>();
    private Set<PrefixType> secondLevelPrefixChain = new HashSet<PrefixType>();
    private PrefixProcessor fallBackProcessor = new LoggingPrefixProcessorDecorator(new PrependPrefixProcessor());
    private PrefixProcessor extensionProcessor = new LoggingPrefixProcessorDecorator(new AppendExtensionPrefixProcessor());

    public PrefixTypesChain(String prefix) {
        if (StringUtils.isNotBlank(prefix)) {
            for (PrefixType type : PrefixType.values()) {
                if (!type.isFoundIn(prefix)) continue;
                if (type.isEnsureUniqueNames()) {
                    this.firstLevelPrefixChain.add(type);
                    continue;
                }
                this.secondLevelPrefixChain.add(type);
            }
        }
    }

    public String process(String prefix, NameGenerationRequest request) {
        LOG.trace("Performing prefix processing with first level prefix chain");
        String retVal = this.processChain(prefix, request, this.firstLevelPrefixChain);
        if (!prefix.equals(retVal)) {
            LOG.trace("Performing prefix processing with second level prefix chain");
            retVal = this.processChain(retVal, request, this.secondLevelPrefixChain);
        } else {
            retVal = this.fallBackProcessor.process(retVal, request);
        }
        return this.extensionProcessor.process(retVal, request);
    }

    private String processChain(String prefix, NameGenerationRequest request, Set<PrefixType> chain) {
        String retVal = prefix;
        for (PrefixType type : chain) {
            retVal = new LoggingPrefixProcessorDecorator(type.getProcessor()).process(retVal, request);
        }
        return retVal;
    }
}

