/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter.image;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.image.ImageColorType;
import org.sejda.model.image.ImageType;
import org.sejda.model.input.PdfSource;
import org.sejda.model.parameter.base.AbstractParameters;
import org.sejda.model.parameter.base.SinglePdfSourceTaskParameters;
import org.sejda.model.validation.constraint.Positive;

public abstract class AbstractPdfToImageParameters
extends AbstractParameters
implements SinglePdfSourceTaskParameters {
    public static final int DEFAULT_DPI = 72;
    @Min(value=1L)
    private int resolutionInDpi = 72;
    @NotNull
    private ImageColorType outputImageColorType;
    @Valid
    @NotNull
    private PdfSource<?> source;
    @Positive
    private float userZoom = 1.0f;

    @Override
    public PdfSource<?> getSource() {
        return this.source;
    }

    @Override
    public void setSource(PdfSource<?> source) {
        this.source = source;
    }

    AbstractPdfToImageParameters(ImageColorType outputImageColorType) {
        this.outputImageColorType = outputImageColorType;
    }

    public ImageColorType getOutputImageColorType() {
        return this.outputImageColorType;
    }

    public float getUserZoom() {
        return this.userZoom;
    }

    public void setUserZoom(float userZoom) {
        this.userZoom = userZoom;
    }

    @NotNull
    public abstract ImageType getOutputImageType();

    public int getResolutionInDpi() {
        return this.resolutionInDpi;
    }

    public void setResolutionInDpi(int resolutionInDpi) {
        this.resolutionInDpi = resolutionInDpi;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.resolutionInDpi).append(this.outputImageColorType).append((Object)this.getOutputImageType()).append(this.source).append(this.userZoom).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractPdfToImageParameters)) {
            return false;
        }
        AbstractPdfToImageParameters parameter = (AbstractPdfToImageParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.resolutionInDpi, parameter.getResolutionInDpi()).append(this.outputImageColorType, parameter.getOutputImageColorType()).append(this.userZoom, parameter.getUserZoom()).append((Object)this.getOutputImageType(), (Object)parameter.getOutputImageType()).append(this.source, parameter.getSource()).isEquals();
    }
}

