/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.common;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.common.PDNumberTreeNode;
import org.sejda.sambox.pdmodel.common.PDPageLabelRange;
import org.sejda.util.RequireUtils;

public class PDPageLabels
implements COSObjectable {
    private Map<Integer, PDPageLabelRange> labels = new TreeMap<Integer, PDPageLabelRange>();

    public PDPageLabels() {
        PDPageLabelRange defaultRange = new PDPageLabelRange();
        defaultRange.setStyle("D");
        this.labels.put(0, defaultRange);
    }

    public PDPageLabels(COSDictionary dict) throws IOException {
        if (Objects.nonNull(dict)) {
            this.findLabels(new PDNumberTreeNode(dict, COSDictionary.class));
        }
    }

    private void findLabels(PDNumberTreeNode node) throws IOException {
        block3: {
            block2: {
                if (node.getKids() == null) break block2;
                List<PDNumberTreeNode> kids = node.getKids();
                for (PDNumberTreeNode kid : kids) {
                    this.findLabels(kid);
                }
                break block3;
            }
            if (node.getNumbers() == null) break block3;
            Map<Integer, COSObjectable> numbers = node.getNumbers();
            for (Map.Entry<Integer, COSObjectable> i : numbers.entrySet()) {
                if (i.getKey() < 0) continue;
                this.labels.put(i.getKey(), new PDPageLabelRange((COSDictionary)i.getValue()));
            }
        }
    }

    public int getPageRangeCount() {
        return this.labels.size();
    }

    public PDPageLabelRange getPageLabelRange(int startPage) {
        return this.labels.get(startPage);
    }

    public void setLabelItem(int startPage, PDPageLabelRange item) {
        RequireUtils.requireArg(startPage >= 0, "Cannot set a label starting from a negative page number");
        this.labels.put(startPage, item);
    }

    @Override
    public COSBase getCOSObject() {
        COSDictionary dict = new COSDictionary();
        COSArray arr = new COSArray();
        for (Map.Entry<Integer, PDPageLabelRange> i : this.labels.entrySet()) {
            arr.add(COSInteger.get(i.getKey().intValue()));
            arr.add(i.getValue());
        }
        dict.setItem(COSName.NUMS, (COSBase)arr);
        return dict;
    }
}

