/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.font;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.util.BoundingBox;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.font.CMapManager;
import org.sejda.sambox.pdmodel.font.PDFontDescriptor;
import org.sejda.sambox.pdmodel.font.PDFontLike;
import org.sejda.sambox.pdmodel.font.PDType1FontEmbedder;
import org.sejda.sambox.pdmodel.font.Standard14Fonts;
import org.sejda.sambox.pdmodel.font.encoding.GlyphList;
import org.sejda.sambox.util.Matrix;
import org.sejda.sambox.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDFont
implements COSObjectable,
PDFontLike {
    private static final Logger LOG = LoggerFactory.getLogger(PDFont.class);
    protected static final Matrix DEFAULT_FONT_MATRIX = new Matrix(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
    protected final COSDictionary dict;
    private final CMap toUnicodeCMap;
    private final FontMetrics afmStandard14;
    private PDFontDescriptor fontDescriptor;
    private List<Float> widths;
    private float avgFontWidth;
    private float fontWidthOfSpace = -1.0f;

    PDFont() {
        this.dict = new COSDictionary();
        this.dict.setItem(COSName.TYPE, (COSBase)COSName.FONT);
        this.toUnicodeCMap = null;
        this.fontDescriptor = null;
        this.afmStandard14 = null;
    }

    PDFont(String baseFont) {
        this.dict = new COSDictionary();
        this.dict.setItem(COSName.TYPE, (COSBase)COSName.FONT);
        this.toUnicodeCMap = null;
        this.afmStandard14 = Standard14Fonts.getAFM(baseFont);
        if (this.afmStandard14 == null) {
            throw new IllegalArgumentException("No AFM for font " + baseFont);
        }
        this.fontDescriptor = PDType1FontEmbedder.buildFontDescriptor(this.afmStandard14);
    }

    protected PDFont(COSDictionary fontDictionary) throws IOException {
        this.dict = fontDictionary;
        this.afmStandard14 = Standard14Fonts.getAFM(this.getName());
        COSDictionary fd = (COSDictionary)this.dict.getDictionaryObject(COSName.FONT_DESC);
        this.fontDescriptor = fd != null ? new PDFontDescriptor(fd) : (this.afmStandard14 != null ? PDType1FontEmbedder.buildFontDescriptor(this.afmStandard14) : null);
        COSBase toUnicode = this.dict.getDictionaryObject(COSName.TO_UNICODE);
        if (toUnicode != null) {
            this.toUnicodeCMap = this.readCMap(toUnicode);
            if (this.toUnicodeCMap != null && !this.toUnicodeCMap.hasUnicodeMappings()) {
                LOG.warn("Invalid ToUnicode CMap in font " + this.getName());
            }
        } else {
            this.toUnicodeCMap = null;
        }
    }

    protected final FontMetrics getStandard14AFM() {
        return this.afmStandard14;
    }

    @Override
    public PDFontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    protected final void setFontDescriptor(PDFontDescriptor fontDescriptor) {
        this.fontDescriptor = fontDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CMap readCMap(COSBase base) throws IOException {
        if (base instanceof COSName) {
            String name = ((COSName)base).getName();
            return CMapManager.getPredefinedCMap(name);
        }
        if (base instanceof COSStream) {
            InputStream input = null;
            try {
                input = ((COSStream)base).getUnfilteredStream();
                CMap cMap = CMapManager.parseCMap(input);
                return cMap;
            }
            finally {
                IOUtils.closeQuietly(input);
            }
        }
        throw new IOException("Expected Name or Stream");
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dict;
    }

    @Override
    public Vector getPositionVector(int code) {
        throw new UnsupportedOperationException("Horizontal fonts have no position vector");
    }

    public Vector getDisplacement(int code) throws IOException {
        return new Vector(this.getWidth(code) / 1000.0f, 0.0f);
    }

    @Override
    public float getWidth(int code) throws IOException {
        if (this.dict.containsKey(COSName.WIDTHS) || this.dict.containsKey(COSName.MISSING_WIDTH)) {
            int firstChar = this.dict.getInt(COSName.FIRST_CHAR, -1);
            int lastChar = this.dict.getInt(COSName.LAST_CHAR, -1);
            int siz = this.getWidths().size();
            int idx = code - firstChar;
            if (siz > 0 && code >= firstChar && code <= lastChar && idx < siz) {
                return this.getWidths().get(idx).floatValue();
            }
            PDFontDescriptor fd = this.getFontDescriptor();
            if (fd != null && fd.hasMissingWidth()) {
                return fd.getMissingWidth();
            }
        }
        if (this.isStandard14()) {
            return this.getStandard14Width(code);
        }
        return this.getWidthFromFont(code);
    }

    protected abstract float getStandard14Width(int var1);

    @Override
    public abstract float getWidthFromFont(int var1) throws IOException;

    @Override
    public abstract boolean isEmbedded();

    @Override
    public abstract float getHeight(int var1) throws IOException;

    public final byte[] encode(String text) throws IOException {
        int codePoint;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(offset);
            byte[] bytes = this.encode(codePoint);
            out.write(bytes);
        }
        return out.toByteArray();
    }

    protected abstract byte[] encode(int var1) throws IOException;

    public float getStringWidth(String text) throws IOException {
        byte[] bytes = this.encode(text);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        float width = 0.0f;
        while (in.available() > 0) {
            int code = this.readCode(in);
            width += this.getWidth(code);
        }
        return width;
    }

    @Override
    public float getAverageFontWidth() {
        float average;
        if (this.avgFontWidth != 0.0f) {
            average = this.avgFontWidth;
        } else {
            float totalWidth = 0.0f;
            float characterCount = 0.0f;
            COSArray widths = (COSArray)this.dict.getDictionaryObject(COSName.WIDTHS);
            if (widths != null) {
                for (int i = 0; i < widths.size(); ++i) {
                    COSNumber fontWidth = (COSNumber)widths.getObject(i);
                    if (!(fontWidth.floatValue() > 0.0f)) continue;
                    totalWidth += fontWidth.floatValue();
                    characterCount += 1.0f;
                }
            }
            average = totalWidth > 0.0f ? totalWidth / characterCount : 0.0f;
            this.avgFontWidth = average;
        }
        return average;
    }

    public abstract int readCode(InputStream var1) throws IOException;

    public String toUnicode(int code, GlyphList customGlyphList) throws IOException {
        return this.toUnicode(code);
    }

    public String toUnicode(int code) throws IOException {
        if (this.toUnicodeCMap != null) {
            if (this.toUnicodeCMap.getName() != null && this.toUnicodeCMap.getName().startsWith("Identity-") && this.dict.getDictionaryObject(COSName.TO_UNICODE) instanceof COSName) {
                return new String(new char[]{(char)code});
            }
            return this.toUnicodeCMap.toUnicode(code);
        }
        return null;
    }

    public String getType() {
        return this.dict.getNameAsString(COSName.TYPE);
    }

    public String getSubType() {
        return this.dict.getNameAsString(COSName.SUBTYPE);
    }

    @Override
    public abstract String getName();

    @Override
    public abstract BoundingBox getBoundingBox() throws IOException;

    protected final List<Float> getWidths() {
        if (this.widths == null) {
            COSArray array = (COSArray)this.dict.getDictionaryObject(COSName.WIDTHS);
            this.widths = array != null ? COSArrayList.convertFloatCOSArrayToList(array) : Collections.emptyList();
        }
        return this.widths;
    }

    @Override
    public Matrix getFontMatrix() {
        return DEFAULT_FONT_MATRIX;
    }

    public float getSpaceWidth() {
        if (this.fontWidthOfSpace == -1.0f) {
            COSBase toUnicode = this.dict.getDictionaryObject(COSName.TO_UNICODE);
            try {
                if (toUnicode != null) {
                    int spaceMapping = this.toUnicodeCMap.getSpaceMapping();
                    if (spaceMapping > -1) {
                        this.fontWidthOfSpace = this.getWidth(spaceMapping);
                    }
                } else {
                    this.fontWidthOfSpace = this.getWidth(32);
                }
                if (this.fontWidthOfSpace <= 0.0f) {
                    this.fontWidthOfSpace = this.getAverageFontWidth();
                }
            }
            catch (Exception e) {
                LOG.error("Can't determine the width of the space character, assuming 250", e);
                this.fontWidthOfSpace = 250.0f;
            }
        }
        return this.fontWidthOfSpace;
    }

    public abstract boolean isVertical();

    public boolean isStandard14() {
        if (this.isEmbedded()) {
            return false;
        }
        return Standard14Fonts.containsName(this.getName());
    }

    public abstract void addToSubset(int var1);

    public abstract void subset() throws IOException;

    public abstract boolean willBeSubset();

    @Override
    public abstract boolean isDamaged();

    public boolean equals(Object other) {
        return other instanceof PDFont && ((PDFont)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.getCOSObject().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getName();
    }
}

