/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.inspect.AbstractMethodRuleAction;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelMapBasedRule<T, C>
extends AbstractMethodRuleAction<C> {
    private final List<ModelReference<?>> inputs;
    protected final int baseTypeParameterIndex;

    public ModelMapBasedRule(ModelReference<C> subject, final ModelType<? extends T> baseType, MethodRuleDefinition<?, ?> ruleDefinition, ModelReference<?> ... additionalInputs) {
        super(subject, ruleDefinition.getDescriptor());
        this.inputs = ModelMapBasedRule.calculateInputs(baseType, ruleDefinition.getReferences().subList(1, ruleDefinition.getReferences().size()), Arrays.asList(additionalInputs));
        this.baseTypeParameterIndex = 1 + Iterables.indexOf(ruleDefinition.getReferences().subList(1, ruleDefinition.getReferences().size()), (Predicate)new Predicate<ModelReference<?>>(){

            public boolean apply(ModelReference<?> element) {
                return element.getType().equals((Object)baseType);
            }
        });
    }

    private static ImmutableList<ModelReference<?>> calculateInputs(final ModelType<?> baseType, List<ModelReference<?>> references, List<ModelReference<?>> modelReferences) {
        Iterable filteredReferences = Iterables.filter(references, (Predicate)new Predicate<ModelReference<?>>(){

            public boolean apply(ModelReference<?> element) {
                return !element.getType().equals((Object)baseType);
            }
        });
        ImmutableList.Builder allInputs = ImmutableList.builder();
        allInputs.addAll(modelReferences);
        allInputs.addAll(filteredReferences);
        return allInputs.build();
    }

    public List<? extends ModelReference<?>> getInputs() {
        return this.inputs;
    }

    protected void invoke(ModelRuleInvoker<?> ruleInvoker, List<ModelView<?>> inputs, ModelMap<?> modelMap, T baseTypeParameter, Object ... ignoredInputs) {
        List<Object> ignoredInputsList = Arrays.asList(ignoredInputs);
        Object[] args = new Object[inputs.size() + 2 - ignoredInputs.length];
        args[0] = modelMap;
        args[this.baseTypeParameterIndex] = baseTypeParameter;
        block0: for (ModelView<?> view : inputs) {
            Object instance = view.getInstance();
            if (ignoredInputsList.contains(instance)) continue;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = instance;
                continue block0;
            }
        }
        ruleInvoker.invoke(args);
    }
}

