/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jcodings.Encoding;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=SourceNode.class)})
public abstract class ReadBitStringNode
extends PackNode {
    private final ByteOrder byteOrder;
    private final boolean star;
    private final int length;

    public ReadBitStringNode(RubyContext context, ByteOrder byteOrder, boolean star, int length) {
        super(context);
        this.byteOrder = byteOrder;
        this.star = star;
        this.length = length;
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int lCurByte;
        byte[] lElem;
        int bits;
        ByteBuffer encode = ByteBuffer.wrap(source, this.getSourcePosition(frame), this.getSourceLength(frame) - this.getSourcePosition(frame));
        int occurrences = this.length;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            if (this.star || occurrences > encode.remaining() * 8) {
                occurrences = encode.remaining() * 8;
            }
            bits = 0;
            lElem = new byte[occurrences];
            for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                bits = (lCurByte & 7) != 0 ? (bits <<= 1) : (int)encode.get();
                lElem[lCurByte] = (bits & 0x80) != 0 ? 49 : 48;
            }
        } else {
            if (this.star || occurrences > encode.remaining() * 8) {
                occurrences = encode.remaining() * 8;
            }
            bits = 0;
            lElem = new byte[occurrences];
            for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                bits = (lCurByte & 7) != 0 ? (bits >>>= 1) : (int)encode.get();
                lElem[lCurByte] = (bits & 1) != 0 ? 49 : 48;
            }
        }
        Encoding encoding = Encoding.load((String)"ASCII");
        ByteList result = new ByteList(lElem, encoding, false);
        this.setSourcePosition(frame, encode.position());
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), result, 0, null);
    }
}

