/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.languagetool.synthesis.ManualSynthesizer;

public class ManualSynthesizerTest
extends TestCase {
    private ManualSynthesizer synthesizer;

    protected void setUp() throws Exception {
        super.setUp();
        String data = "# some test data\nInflectedForm11\tLemma1\tPOS1\nInflectedForm121\tLemma1\tPOS2\nInflectedForm122\tLemma1\tPOS2\nInflectedForm2\tLemma2\tPOS1\n";
        this.synthesizer = new ManualSynthesizer((InputStream)new ByteArrayInputStream("# some test data\nInflectedForm11\tLemma1\tPOS1\nInflectedForm121\tLemma1\tPOS2\nInflectedForm122\tLemma1\tPOS2\nInflectedForm2\tLemma2\tPOS1\n".getBytes("UTF-8")));
    }

    public void testLookupNonExisting() throws IOException {
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup("", ""));
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup("", null));
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup(null, ""));
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup(null, null));
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup("NONE", "UNKNOWN"));
    }

    public void testInvalidLookup() throws IOException {
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup("NONE", "POS1"));
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup("Lemma1", "UNKNOWN"));
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup("Lemma1", "POS."));
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup("Lemma2", "POS2"));
    }

    public void testValidLookup() throws IOException {
        ManualSynthesizerTest.assertEquals((String)"[InflectedForm11]", (String)String.valueOf(this.synthesizer.lookup("Lemma1", "POS1")));
        ManualSynthesizerTest.assertEquals((String)"[InflectedForm121, InflectedForm122]", (String)String.valueOf(this.synthesizer.lookup("Lemma1", "POS2")));
        ManualSynthesizerTest.assertEquals((String)"[InflectedForm2]", (String)String.valueOf(this.synthesizer.lookup("Lemma2", "POS1")));
    }

    public void testCaseSensitive() throws IOException {
        ManualSynthesizerTest.assertNull((Object)this.synthesizer.lookup("LEmma1", "POS1"));
    }
}

