/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.PrimitiveIterator;
import java.util.stream.LongStream;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.xref.CompressedXrefEntry;
import org.sejda.sambox.xref.XrefEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractXrefStreamParser {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXrefStreamParser.class);
    private COSParser parser;

    AbstractXrefStreamParser(COSParser parser) {
        this.parser = parser;
    }

    abstract void onTrailerFound(COSDictionary var1);

    abstract void onEntryFound(XrefEntry var1);

    COSDictionary parse(long streamObjectOffset) throws IOException {
        LOG.debug("Parsing xref stream at offset " + streamObjectOffset);
        this.parser.position(streamObjectOffset);
        this.parser.skipIndirectObjectDefinition();
        this.parser.skipSpaces();
        COSDictionary dictionary = this.parser.nextDictionary();
        try (COSStream xrefStream = this.parser.nextStream(dictionary);){
            this.onTrailerFound(dictionary);
            this.parseStream(xrefStream);
        }
        LOG.debug("Done parsing xref stream");
        return dictionary;
    }

    void parseStream(COSStream xrefStream) throws IOException {
        LongStream objectNumbers = LongStream.empty();
        COSArray index = (COSArray)xrefStream.getDictionaryObject(COSName.INDEX);
        if (index == null) {
            LOG.debug("No index found for xref stream, using default values");
            objectNumbers = LongStream.rangeClosed(0L, xrefStream.getInt(COSName.SIZE));
        } else {
            LOG.debug("Index found, now retrieving expected object numbers");
            LongStream.Builder builder = LongStream.builder();
            for (int i = 0; i < index.size(); i += 2) {
                long start = ((COSNumber)index.get(i)).longValue();
                long end = start + Math.max(((COSNumber)index.get(i + 1)).longValue() - 1L, 0L);
                LOG.trace(String.format("Adding expected range from %d to %d", start, end));
                LongStream.rangeClosed(start, end).forEach(builder::add);
            }
            objectNumbers = builder.build();
        }
        COSArray xrefFormat = (COSArray)xrefStream.getDictionaryObject(COSName.W);
        int w0 = xrefFormat.getInt(0);
        int w1 = xrefFormat.getInt(1);
        int w2 = xrefFormat.getInt(2);
        int lineSize = w0 + w1 + w2;
        try (InputStream stream = xrefStream.getUnfilteredStream();){
            PrimitiveIterator.OfLong objectIds = objectNumbers.iterator();
            block15: while (stream.available() > 0 && objectIds.hasNext()) {
                Long objectId = objectIds.next();
                byte[] currLine = new byte[lineSize];
                stream.read(currLine);
                int type = w0 == 0 ? 1 : 0;
                int i = 0;
                for (i = 0; i < w0; ++i) {
                    type += (currLine[i] & 0xFF) << (w0 - i - 1) * 8;
                }
                int field1 = 0;
                for (i = 0; i < w1; ++i) {
                    field1 += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                }
                int field2 = 0;
                for (i = 0; i < w2; ++i) {
                    field2 += (currLine[i + w0 + w1] & 0xFF) << (w2 - i - 1) * 8;
                }
                switch (type) {
                    case 0: {
                        this.onEntryFound(XrefEntry.freeEntry(objectId, field2));
                        continue block15;
                    }
                    case 1: {
                        this.onEntryFound(XrefEntry.inUseEntry(objectId, field1, field2));
                        continue block15;
                    }
                    case 2: {
                        this.onEntryFound(CompressedXrefEntry.compressedEntry(objectId, field1, field2));
                        continue block15;
                    }
                }
                LOG.warn("Unknown xref entry type " + type);
            }
        }
    }

    COSParser parser() {
        return this.parser;
    }
}

