;;;
;;; Copyright (c) 2010-2013 uim Project http://code.google.com/p/uim/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;;; TUT-Codeεϻε桦
;;; ɴ기סؤ٤Ʊ͡2ǸǹԤΥɽ
;;; Ūˤʸɽ硣
;;;
;;; ġŷϵפ˴ޤޤ롢
;;; ɴ기סؤѤե(ki.js)ηѴΡ
;;; http://www.sirius.spline.tv/
;;;
;;; ѹ:
;;;  - _ -> \
;;;  - Shift + _ -> _
;;;  - Shift + Space -> Space
;;;  - Shift + 0 -> |

;;; ΰ֤ǤϤʤƤ˴ŤruleѴ롣
;;; (dvorakܡɤǤ⡢Ʊ֤ΥƱϤ褦ˡ
;;;  ruleѴtutcode-kigou-rule-translateǹԤ
;;;  ȥƤ˴ŤruleȹʤʤΤǡ
;;;  (: ((("q" " "))(""))  ((("'" " "))("")))
;;;  Ƥ˴Ťruletutcode-kigou-rule-translateѴƤ
;;;  (: ((("q" " "))(""))  ((("q" " "))(""))  ((("'" " "))(""))))
;;; @param translate-alist Ѵɽ
;;; @return Ѵɽ
;;; XXX:kigou-ruleƤ˱ѴɬפʤΤǡ
;;;     δؿtutcode-kigou-rule.scmե˵ҡ
(define (tutcode-kigou-rule-pre-translate translate-alist)
  (require "japanese.scm") ; for ja-wide
  (map
    (lambda (elem)
      (let*
        ((seq (caar elem))
         (key1 (car seq))
         (key2 (cadr seq))
         (tr (and (string=? key2 " ") (assoc key1 translate-alist)))
         (tr-key (and tr (cadr tr)))
         (tr-char (and tr-key (ja-wide tr-key))))
        (if tr-char
          (list (list seq) (list tr-char))
          elem)))
    tutcode-kigou-rule))

;;; stroke-helpǡ2ȥ⡼ɻˡ
;;; ⥭Ϥ̵ɽƤalist
(define tutcode-kigou-rule-stroke-help-top-page-alist
  '(
    ("1" "*")
    ("2" "*")
    ("3" "*")
    ("4" "*")
    ("5" "*")
    ("6" "*")
    ("7" "*")
    ("8" "*")
    ("9" "*")
    ("0" "*")
    ("-" "*")
    ("^" "*")
    ("q" "*")
    ("w" "*")
    ("e" "*")
    ("r" "*")
    ("t" "*")
    ("y" "*")
    ("u" "*")
    ("i" "*")
    ("o" "*")
    ("p" "*")
    ("@" "*")
    ("[" "*")
    ("a" "*")
    ("s" "*")
    ("d" "*")
    ("f" "*")
    ("g" "*")
    ("h" "*")
    ("j" "*¡")
    ("k" "*á")
    ("l" "*ġ")
    (";" "*š")
    (":" "*ơ")
    ("]" "*")
    ("z" "*ǡ")
    ("x" "*ȡ")
    ("c" "*")
    ("v" "*ɡ")
    ("b" "*ʡ")
    ("n" "*ˡ")
    ("m" "*̡")
    ("," "*͡")
    ("." "*Ρ")
    ("/" "*ϡ")
    ("\\" "*")
    (" " "*")
    ("!" "*С")
    ("\"" "*ѡ")
    ("#" "*ҡ")
    ("$" "*ӡ")
    ("%" "*ԡ")
    ("&" "*ա")
    ("'" "*֡")
    ("(" "*ס")
    (")" "*ء")
    ("|" "*١")
    ("=" "*ڡ")
    ("~" "*ۡ")
    ("Q" "*ܡ")
    ("W" "*ݡ")
    ("E" "*ޡ")
    ("R" "*ߡ")
    ("T" "*")
    ("Y" "*")
    ("U" "*")
    ("I" "*")
    ("O" "*")
    ("P" "*")
    ("`" "*")
    ("{" "*")
    ("A" "*")
    ("S" "*")
    ("D" "*")
    ("F" "*")
    ("G" "*")
    ("H" "*")
    ("J" "*")
    ("K" "*")
    ("L" "*")
    ("+" "*")
    ("*" "*")
    ("}" "*")
    ("Z" "*")
    ("N" "*")
    ("M" "*")
    ("<" "*")
    (">" "*")))

(define tutcode-kigou-rule
  '(
    ;((("1" "1"))("")) ;դ
    ;((("1" "2"))("")) ;
    ;((("1" "3"))("")) ;
    ((("1" "4"))(tutcode-bushu-start))
    ((("1" "5"))(tutcode-interactive-bushu-start))
    ((("1" "6"))(tutcode-postfix-bushu-start))
    ((("1" "7"))(tutcode-mazegaki-start))
    ((("1" "8"))(tutcode-latin-conv-start))
    ((("1" "9"))(tutcode-auto-help-redisplay))
    ((("1" "q"))(""))
    ((("1" "w"))(""))
    ((("1" "e"))(""))
    ((("1" "r"))(""))
    ((("1" "t"))(""))
    ((("1" "y"))(""))
    ((("1" "u"))(""))
    ((("1" "i"))(""))
    ((("1" "o"))(""))
    ((("1" "p"))(""))
    ((("1" "@"))(""))
    ((("1" "["))(""))
    ((("1" "a"))(""))
    ((("1" "s"))(""))
    ((("1" "d"))(""))
    ((("1" "g"))(""))
    ((("1" "h"))(""))
    ((("1" "j"))(""))
    ((("1" "k"))(""))
    ((("1" "l"))(""))
    ((("1" ";"))(""))
    ((("1" ":"))(""))
    ((("1" "z"))(""))
    ((("1" "x"))(""))
    ((("1" " "))(""))
    ((("1" "E"))(""))
    ((("1" "R"))(""))
    ((("1" "T"))(""))
    ((("1" "U"))(""))
    ((("1" "P"))(""))
    ((("1" "`"))(""))
    ((("1" "{"))(""))
    ((("1" "A"))(""))
    ((("1" "S"))(""))
    ((("1" "D"))(""))
    ((("1" "F"))(""))
    ((("1" "G"))(""))
    ((("1" "H"))(""))
    ((("1" "J"))(""))
    ((("1" "K"))(""))
    ((("1" "L"))(""))
    ((("1" "+"))(""))
    ((("1" "*"))(""))
    ((("1" "V"))(""))
    ((("1" "N"))(""))
    ((("1" "M"))(""))
    ((("1" "<"))(""))
    ((("1" ">"))(""))
    ((("1" "?"))(""))
    ((("1" "_"))(""))
    ((("2" "1"))(""))
    ((("2" "2"))(""))
    ((("2" "3"))(""))
    ((("2" "4"))(""))
    ((("2" "5"))(""))
    ((("2" "6"))(""))
    ((("2" "7"))(""))
    ((("2" "8"))(""))
    ((("2" "9"))(""))
    ((("2" "0"))(""))
    ((("2" "["))(""))
    ((("2" "s"))(""))
    ((("2" "d"))(""))
    ((("2" "f"))(""))
    ((("2" "g"))(""))
    ((("2" "h"))(""))
    ((("2" "j"))(""))
    ((("2" "k"))(""))
    ((("2" "l"))(""))
    ((("2" ":"))(""))
    ((("2" "]"))(""))
    ((("2" "x"))(""))
    ((("2" "c"))(""))
    ((("2" "v"))(""))
    ((("2" "b"))(""))
    ((("2" "n"))(""))
    ((("2" "m"))(""))
    ((("2" ","))(""))
    ((("2" "\\"))(""))
    ((("2" " "))(""))
    ((("2" "Q"))(""))
    ((("2" "W"))(""))
    ((("2" "E"))(""))
    ((("2" "R"))(""))
    ((("2" "T"))(""))
    ((("2" "Y"))(""))
    ((("2" "U"))(""))
    ((("2" "I"))(""))
    ((("2" "O"))(""))
    ((("2" "P"))(""))
    ((("2" "`"))(""))
    ((("2" "{"))(""))
    ((("2" "A"))(""))
    ((("2" "S"))(""))
    ((("2" "D"))(""))
    ((("2" "*"))(""))
    ((("2" "}"))(""))
    ((("2" "Z"))(""))
    ((("2" "X"))(""))
    ((("2" "C"))(""))
    ((("2" "V"))(""))
    ((("2" "B"))(""))
    ((("2" "N"))(""))
    ((("2" "_"))(""))
    ((("3" "1"))(""))
    ((("3" "2"))(""))
    ((("3" "3"))(""))
    ((("3" "4"))(""))
    ((("3" "5"))(""))
    ((("3" "6"))(""))
    ((("3" "7"))(""))
    ((("3" "8"))(""))
    ((("3" "9"))(""))
    ((("3" "0"))(""))
    ((("3" "-"))(""))
    ((("3" "^"))(""))
    ((("3" "q"))(""))
    ((("3" "w"))(""))
    ((("3" "e"))(""))
    ((("3" "r"))(""))
    ((("3" "t"))(""))
    ((("3" "y"))(""))
    ((("3" "u"))(""))
    ((("3" "i"))(""))
    ((("3" "o"))(""))
    ((("3" "p"))(""))
    ((("3" "@"))(""))
    ((("3" "["))(""))
    ((("3" "a"))(""))
    ((("3" "s"))(""))
    ((("3" "d"))(""))
    ((("3" "f"))(""))
    ((("3" "g"))(""))
    ((("3" "h"))(""))
    ((("3" "j"))(""))
    ((("3" "k"))(""))
    ((("3" "l"))(""))
    ((("3" ";"))(""))
    ((("3" ":"))(""))
    ((("3" "]"))(""))
    ((("3" "z"))(""))
    ((("3" "x"))(""))
    ((("3" "c"))(""))
    ((("3" "v"))(""))
    ((("3" "b"))(""))
    ((("3" "n"))(""))
    ((("3" "m"))(""))
    ((("3" ","))(""))
    ((("3" "."))(""))
    ((("3" "/"))(""))
    ((("3" "\\"))(""))
    ((("3" " "))(""))
    ((("3" "!"))(""))
    ((("3" "\""))(""))
    ((("3" "#"))(""))
    ((("3" "$"))(""))
    ((("3" "%"))(""))
    ((("3" "&"))(""))
    ((("3" "'"))(""))
    ((("3" "("))(""))
    ((("3" ")"))(""))
    ((("3" "|"))(""))
    ((("3" "="))(""))
    ((("3" "~"))(""))
    ((("3" "Q"))(""))
    ((("3" "W"))(""))
    ((("3" "E"))(""))
    ((("3" "R"))(""))
    ((("3" "T"))(""))
    ((("3" "Y"))(""))
    ((("3" "U"))(""))
    ((("3" "I"))(""))
    ((("3" "O"))(""))
    ((("3" "P"))(""))
    ((("3" "`"))(""))
    ((("3" "{"))(""))
    ((("3" "A"))(""))
    ((("3" "S"))(""))
    ((("3" "D"))(""))
    ((("3" "F"))(""))
    ((("3" "G"))(""))
    ((("3" "H"))(""))
    ((("3" "J"))(""))
    ((("3" "K"))(""))
    ((("3" "L"))(""))
    ((("3" "+"))(""))
    ((("3" "*"))(""))
    ((("3" "}"))(""))
    ((("3" "Z"))(""))
    ((("3" "X"))(""))
    ((("3" "C"))(""))
    ((("3" "V"))(""))
    ((("3" "B"))(""))
    ((("3" "N"))(""))
    ((("3" "M"))(""))
    ((("3" "<"))(""))
    ((("3" ">"))(""))
    ((("3" "?"))(""))
    ((("3" "_"))(""))
    ((("4" "1"))(""))
    ((("4" "2"))(""))
    ((("4" "3"))(""))
    ((("4" "4"))(""))
    ((("4" "5"))(""))
    ((("4" "6"))(""))
    ((("4" "7"))(""))
    ((("4" "8"))(""))
    ((("4" "9"))(""))
    ((("4" "0"))(""))
    ((("4" "-"))(""))
    ((("4" "^"))(""))
    ((("4" "q"))(""))
    ((("4" "w"))(""))
    ((("4" "e"))(""))
    ((("4" "r"))(""))
    ((("4" "t"))(""))
    ((("4" "y"))(""))
    ((("4" "u"))(""))
    ((("4" "i"))(""))
    ((("4" "o"))(""))
    ((("4" "p"))(""))
    ((("4" "@"))(""))
    ((("4" "["))(""))
    ((("4" "a"))(""))
    ((("4" "s"))(""))
    ((("4" "d"))(""))
    ((("4" "f"))(""))
    ((("4" "g"))(""))
    ((("4" "h"))(""))
    ((("4" "j"))(""))
    ((("4" "k"))(""))
    ((("4" "l"))(""))
    ((("4" ";"))(""))
    ((("4" ":"))(""))
    ((("4" "]"))(""))
    ((("4" "z"))(""))
    ((("4" "x"))(""))
    ((("4" "c"))(""))
    ((("4" "v"))(""))
    ((("4" "b"))(""))
    ((("4" "n"))(""))
    ((("4" "m"))(""))
    ((("4" ","))(""))
    ((("4" "."))(""))
    ((("4" "/"))(""))
    ((("4" "\\"))(""))
    ((("4" " "))(""))
    ((("4" "!"))(""))
    ((("4" "\""))(""))
    ((("4" "#"))(""))
    ((("4" "$"))(""))
    ((("4" "%"))(""))
    ((("4" "&"))(""))
    ((("4" "'"))(""))
    ((("4" "("))(""))
    ((("4" ")"))(""))
    ((("4" "|"))(""))
    ((("4" "="))(""))
    ((("4" "~"))(""))
    ((("4" "Q"))(""))
    ((("4" "W"))(""))
    ((("4" "E"))(""))
    ((("4" "R"))(""))
    ((("4" "T"))(""))
    ((("4" "Y"))(""))
    ((("4" "U"))(""))
    ((("4" "I"))(""))
    ((("4" "O"))(""))
    ((("4" "P"))(""))
    ((("4" "`"))(""))
    ((("4" "{"))(""))
    ((("4" "A"))(""))
    ((("4" "S"))(""))
    ((("4" "D"))(""))
    ((("4" "F"))(""))
    ((("4" "G"))(""))
    ((("4" "H"))(""))
    ((("4" "J"))(""))
    ((("4" "K"))(""))
    ((("4" "L"))(""))
    ((("4" "+"))(""))
    ((("4" "*"))(""))
    ((("4" "}"))(""))
    ((("4" "Z"))(""))
    ((("4" "X"))(""))
    ((("4" "C"))(""))
    ((("4" "V"))(""))
    ((("4" "B"))(""))
    ((("4" "N"))(""))
    ((("4" "M"))(""))
    ((("4" "<"))(""))
    ((("4" ">"))(""))
    ((("4" "?"))(""))
    ((("4" "_"))(""))
    ((("5" "1"))(""))
    ((("5" "2"))(""))
    ((("5" "3"))(""))
    ((("5" "4"))(""))
    ((("5" "5"))(""))
    ((("5" "6"))(""))
    ((("5" "7"))(""))
    ((("5" "8"))(""))
    ((("5" "9"))(""))
    ((("5" "0"))(""))
    ((("5" "-"))(""))
    ((("5" "^"))(""))
    ((("5" "q"))(""))
    ((("5" "w"))(""))
    ((("5" "e"))(""))
    ((("5" "r"))(""))
    ((("5" "t"))(""))
    ((("5" "y"))(""))
    ((("5" "u"))(""))
    ((("5" "i"))(""))
    ((("5" "o"))(""))
    ((("5" "p"))(""))
    ((("5" "@"))(""))
    ((("5" "["))(""))
    ((("5" "a"))(""))
    ((("5" "s"))(""))
    ((("5" "d"))(""))
    ((("5" "f"))(""))
    ((("5" "g"))(""))
    ((("5" "h"))(""))
    ((("5" "j"))(""))
    ((("5" "k"))(""))
    ((("5" "l"))(""))
    ((("5" ";"))(""))
    ((("5" ":"))(""))
    ((("5" "]"))(""))
    ((("5" "z"))(""))
    ((("5" "x"))(""))
    ((("5" "c"))(""))
    ((("5" "v"))(""))
    ((("5" "b"))(""))
    ((("5" "n"))(""))
    ((("5" "m"))(""))
    ((("5" ","))(""))
    ((("5" "."))(""))
    ((("5" "/"))(""))
    ((("5" "\\"))(""))
    ((("5" " "))(""))
    ((("5" "!"))(""))
    ((("5" "\""))(""))
    ((("5" "#"))(""))
    ((("5" "$"))(""))
    ((("5" "%"))(""))
    ((("5" "&"))(""))
    ((("5" "'"))(""))
    ((("5" "("))(""))
    ((("5" ")"))(""))
    ((("5" "|"))(""))
    ((("5" "="))(""))
    ((("5" "~"))(""))
    ((("5" "Q"))(""))
    ((("5" "W"))(""))
    ((("5" "E"))(""))
    ((("5" "R"))(""))
    ((("5" "T"))(""))
    ((("5" "Y"))(""))
    ((("5" "U"))(""))
    ((("5" "I"))(""))
    ((("5" "O"))(""))
    ((("5" "P"))(""))
    ((("5" "`"))(""))
    ((("5" "{"))(""))
    ((("5" "A"))(""))
    ((("5" "S"))(""))
    ((("5" "D"))(""))
    ((("5" "F"))(""))
    ((("5" "G"))(""))
    ((("5" "H"))(""))
    ((("5" "J"))(""))
    ((("5" "K"))(""))
    ((("5" "L"))(""))
    ((("5" "+"))(""))
    ((("5" "*"))(""))
    ((("5" "}"))(""))
    ((("5" "Z"))(""))
    ((("5" "X"))(""))
    ((("5" "C"))(""))
    ((("5" "V"))(""))
    ((("5" "B"))(""))
    ((("5" "N"))(""))
    ((("5" "M"))(""))
    ((("5" "<"))(""))
    ((("5" ">"))(""))
    ((("5" "?"))(""))
    ((("5" "_"))(""))
    ((("6" "1"))(""))
    ((("6" "2"))(""))
    ((("6" "3"))(""))
    ((("6" "4"))(""))
    ((("6" "5"))(""))
    ((("6" "6"))(""))
    ((("6" "7"))(""))
    ((("6" "8"))(""))
    ((("6" "9"))(""))
    ((("6" "0"))(""))
    ((("6" "-"))(""))
    ((("6" "^"))(""))
    ((("6" "q"))(""))
    ((("6" "w"))(""))
    ((("6" "e"))(""))
    ((("6" "r"))(""))
    ((("6" "t"))(""))
    ((("6" "y"))(""))
    ((("6" "u"))(""))
    ((("6" "i"))(""))
    ((("6" "o"))(""))
    ((("6" "p"))(""))
    ((("6" "@"))(""))
    ((("6" "["))(""))
    ((("6" "a"))(""))
    ((("6" "s"))(""))
    ((("6" "d"))(""))
    ((("6" "f"))(""))
    ((("6" "g"))(""))
    ((("6" "h"))(""))
    ((("6" "j"))(""))
    ((("6" "k"))(""))
    ((("6" "l"))(""))
    ((("6" ";"))(""))
    ((("6" ":"))(""))
    ((("6" "]"))(""))
    ((("6" "z"))(""))
    ((("6" "x"))(""))
    ((("6" "c"))(""))
    ((("6" "v"))(""))
    ((("6" "b"))(""))
    ((("6" "n"))(""))
    ((("6" "m"))(""))
    ((("6" ","))(""))
    ((("6" "."))(""))
    ((("6" "/"))(""))
    ((("6" "\\"))(""))
    ((("6" " "))(""))
    ((("6" "!"))(""))
    ((("6" "\""))(""))
    ((("6" "#"))(""))
    ((("6" "$"))(""))
    ((("6" "%"))(""))
    ((("6" "&"))(""))
    ((("6" "'"))(""))
    ((("6" "("))(""))
    ((("6" ")"))(""))
    ((("6" "|"))(""))
    ((("6" "="))(""))
    ((("6" "~"))(""))
    ((("6" "Q"))(""))
    ((("6" "W"))(""))
    ((("6" "E"))(""))
    ((("6" "R"))(""))
    ((("6" "T"))(""))
    ((("6" "Y"))(""))
    ((("6" "U"))(""))
    ((("6" "I"))(""))
    ((("6" "O"))(""))
    ((("6" "P"))(""))
    ((("6" "`"))(""))
    ((("6" "{"))(""))
    ((("6" "A"))(""))
    ((("6" "S"))(""))
    ((("6" "D"))(""))
    ((("6" "F"))(""))
    ((("6" "G"))(""))
    ((("6" "H"))(""))
    ((("6" "J"))(""))
    ((("6" "K"))(""))
    ((("6" "L"))(""))
    ((("6" "+"))(""))
    ((("6" "*"))(""))
    ((("6" "}"))(""))
    ((("6" "Z"))(""))
    ((("6" "X"))(""))
    ((("6" "C"))(""))
    ((("6" "V"))(""))
    ((("6" "B"))(""))
    ((("6" "N"))(""))
    ((("6" "M"))(""))
    ((("6" "<"))(""))
    ((("6" ">"))(""))
    ((("6" "?"))(""))
    ((("6" "_"))(""))
    ((("7" "1"))(""))
    ((("7" "2"))(""))
    ((("7" "3"))(""))
    ((("7" "4"))(""))
    ((("7" "5"))(""))
    ((("7" "6"))(""))
    ((("7" "7"))(""))
    ((("7" "8"))(""))
    ((("7" "9"))(""))
    ((("7" "0"))(""))
    ((("7" "-"))(""))
    ((("7" "^"))(""))
    ((("7" "q"))(""))
    ((("7" "w"))(""))
    ((("7" "e"))(""))
    ((("7" "r"))(""))
    ((("7" "t"))(""))
    ((("7" "y"))(""))
    ((("7" "u"))(""))
    ((("7" "i"))(""))
    ((("7" "o"))(""))
    ((("7" "p"))(""))
    ((("7" "@"))(""))
    ((("7" "["))(""))
    ((("7" "a"))(""))
    ((("7" "s"))(""))
    ((("7" "d"))(""))
    ((("7" "f"))(""))
    ((("7" "g"))(""))
    ((("7" "h"))(""))
    ((("7" "j"))(""))
    ((("7" "k"))(""))
    ((("7" "l"))(""))
    ((("7" ";"))(""))
    ((("7" ":"))(""))
    ((("7" "]"))(""))
    ((("7" "z"))(""))
    ((("7" "x"))(""))
    ((("7" "c"))(""))
    ((("7" "v"))(""))
    ((("7" "b"))(""))
    ((("7" "n"))(""))
    ((("7" "m"))(""))
    ((("7" ","))(""))
    ((("7" "."))(""))
    ((("7" "/"))(""))
    ((("7" "\\"))(""))
    ((("7" " "))(""))
    ((("7" "!"))(""))
    ((("7" "\""))(""))
    ((("7" "#"))(""))
    ((("7" "$"))(""))
    ((("7" "%"))(""))
    ((("7" "&"))(""))
    ((("7" "'"))(""))
    ((("7" "("))(""))
    ((("7" ")"))(""))
    ((("7" "|"))(""))
    ((("7" "="))(""))
    ((("7" "~"))(""))
    ((("7" "Q"))(""))
    ((("7" "W"))(""))
    ((("7" "E"))(""))
    ((("7" "R"))(""))
    ((("7" "T"))(""))
    ((("7" "Y"))(""))
    ((("7" "U"))(""))
    ((("7" "I"))(""))
    ((("7" "O"))(""))
    ((("7" "P"))(""))
    ((("7" "`"))(""))
    ((("7" "{"))(""))
    ((("7" "A"))(""))
    ((("7" "S"))(""))
    ((("7" "D"))(""))
    ((("7" "F"))(""))
    ((("7" "G"))(""))
    ((("7" "H"))(""))
    ((("7" "J"))(""))
    ((("7" "K"))(""))
    ((("7" "L"))(""))
    ((("7" "+"))(""))
    ((("7" "*"))(""))
    ((("7" "}"))(""))
    ((("7" "Z"))(""))
    ((("7" "X"))(""))
    ((("7" "C"))(""))
    ((("7" "V"))(""))
    ((("7" "B"))(""))
    ((("7" "N"))(""))
    ((("7" "M"))(""))
    ((("7" "<"))(""))
    ((("7" ">"))(""))
    ((("7" "?"))(""))
    ((("7" "_"))(""))
    ((("8" "1"))(""))
    ((("8" "2"))(""))
    ((("8" "3"))(""))
    ((("8" "4"))(""))
    ((("8" "5"))(""))
    ((("8" "6"))(""))
    ((("8" "7"))(""))
    ((("8" "8"))(""))
    ((("8" "9"))(""))
    ((("8" "0"))(""))
    ((("8" "-"))(""))
    ((("8" "^"))(""))
    ((("8" "q"))(""))
    ((("8" "w"))(""))
    ((("8" "e"))(""))
    ((("8" "r"))(""))
    ((("8" "t"))(""))
    ((("8" "y"))(""))
    ((("8" "u"))(""))
    ((("8" "i"))(""))
    ((("8" "o"))(""))
    ((("8" "p"))(""))
    ((("8" "@"))(""))
    ((("8" "["))(""))
    ((("8" "a"))(""))
    ((("8" "s"))(""))
    ((("8" "d"))(""))
    ((("8" "f"))(""))
    ((("8" "g"))(""))
    ((("8" "h"))(""))
    ((("8" "j"))(""))
    ((("8" "k"))(""))
    ((("8" "l"))(""))
    ((("8" ";"))(""))
    ((("8" ":"))(""))
    ((("8" "]"))(""))
    ((("8" "z"))(""))
    ((("8" "x"))(""))
    ((("8" "c"))(""))
    ((("8" "v"))(""))
    ((("8" "b"))(""))
    ((("8" "n"))(""))
    ((("8" "m"))(""))
    ((("8" ","))(""))
    ((("8" "."))(""))
    ((("8" "/"))(""))
    ((("8" "\\"))(""))
    ((("8" " "))(""))
    ((("8" "!"))(""))
    ((("8" "\""))(""))
    ((("8" "#"))(""))
    ((("8" "$"))(""))
    ((("8" "%"))(""))
    ((("8" "&"))(""))
    ((("8" "'"))(""))
    ((("8" "("))(""))
    ((("8" ")"))(""))
    ((("8" "|"))(""))
    ((("8" "="))(""))
    ((("8" "~"))(""))
    ((("8" "Q"))(""))
    ((("8" "W"))(""))
    ((("8" "E"))(""))
    ((("8" "R"))(""))
    ((("8" "T"))(""))
    ((("8" "Y"))(""))
    ((("8" "U"))(""))
    ((("8" "I"))(""))
    ((("8" "O"))(""))
    ((("8" "P"))(""))
    ((("8" "`"))(""))
    ((("8" "{"))(""))
    ((("8" "A"))(""))
    ((("8" "S"))(""))
    ((("8" "D"))(""))
    ((("8" "F"))(""))
    ((("8" "G"))(""))
    ((("8" "H"))(""))
    ((("8" "J"))(""))
    ((("8" "K"))(""))
    ((("8" "L"))(""))
    ((("8" "+"))(""))
    ((("8" "*"))(""))
    ((("8" "}"))(""))
    ((("8" "Z"))(""))
    ((("8" "X"))(""))
    ((("8" "C"))(""))
    ((("8" "V"))(""))
    ((("8" "B"))(""))
    ((("8" "N"))(""))
    ((("8" "M"))(""))
    ((("8" "<"))(""))
    ((("8" ">"))(""))
    ((("8" "?"))(""))
    ((("8" "_"))(""))
    ((("9" "1"))(""))
    ((("9" "2"))(""))
    ((("9" "3"))(""))
    ((("9" "4"))(""))
    ((("9" "5"))(""))
    ((("9" "6"))(""))
    ((("9" "7"))(""))
    ((("9" "8"))(""))
    ((("9" "9"))(""))
    ((("9" "0"))(""))
    ((("9" "-"))(""))
    ((("9" "^"))(""))
    ((("9" "q"))(""))
    ((("9" "w"))(""))
    ((("9" "e"))(""))
    ((("9" "r"))(""))
    ((("9" "t"))(""))
    ((("9" "y"))(""))
    ((("9" "u"))(""))
    ((("9" "i"))(""))
    ((("9" "o"))(""))
    ((("9" "p"))(""))
    ((("9" "@"))(""))
    ((("9" "["))(""))
    ((("9" "a"))(""))
    ((("9" "s"))(""))
    ((("9" "d"))(""))
    ((("9" "f"))(""))
    ((("9" "g"))(""))
    ((("9" "h"))(""))
    ((("9" "j"))(""))
    ((("9" "k"))(""))
    ((("9" "l"))(""))
    ((("9" ";"))(""))
    ((("9" ":"))(""))
    ((("9" "]"))(""))
    ((("9" "z"))(""))
    ((("9" "x"))(""))
    ((("9" "c"))(""))
    ((("9" "v"))(""))
    ((("9" "b"))(""))
    ((("9" "n"))(""))
    ((("9" "m"))(""))
    ((("9" ","))(""))
    ((("9" "."))(""))
    ((("9" "/"))(""))
    ((("9" "\\"))(""))
    ((("9" " "))(""))
    ((("9" "!"))(""))
    ((("9" "\""))(""))
    ((("9" "#"))(""))
    ((("9" "$"))(""))
    ((("9" "%"))(""))
    ((("9" "&"))(""))
    ((("9" "'"))(""))
    ((("9" "("))(""))
    ((("9" ")"))(""))
    ((("9" "|"))(""))
    ((("9" "="))(""))
    ((("9" "~"))(""))
    ((("9" "Q"))(""))
    ((("9" "W"))(""))
    ((("9" "E"))(""))
    ((("9" "R"))(""))
    ((("9" "T"))(""))
    ((("9" "Y"))(""))
    ((("9" "U"))(""))
    ((("9" "I"))(""))
    ((("9" "O"))(""))
    ((("9" "P"))(""))
    ((("9" "`"))(""))
    ((("9" "{"))(""))
    ((("9" "A"))(""))
    ((("9" "S"))(""))
    ((("9" "D"))(""))
    ((("9" "F"))(""))
    ((("9" "G"))(""))
    ((("9" "H"))(""))
    ((("9" "J"))(""))
    ((("9" "K"))(""))
    ((("9" "L"))(""))
    ((("9" "+"))(""))
    ((("9" "*"))(""))
    ((("9" "}"))(""))
    ((("9" "Z"))(""))
    ((("9" "X"))(""))
    ((("9" "C"))(""))
    ((("9" "V"))(""))
    ((("9" "B"))(""))
    ((("9" "N"))(""))
    ((("9" "M"))(""))
    ((("9" "<"))(""))
    ((("9" ">"))(""))
    ((("9" "?"))(""))
    ((("9" "_"))(""))
    ((("0" "1"))(""))
    ((("0" "2"))(""))
    ((("0" "3"))(""))
    ((("0" "4"))(""))
    ((("0" "5"))(""))
    ((("0" "6"))(""))
    ((("0" "7"))(""))
    ((("0" "8"))(""))
    ((("0" "9"))(""))
    ((("0" "0"))(""))
    ((("0" "-"))(""))
    ((("0" "^"))(""))
    ((("0" "q"))(""))
    ((("0" "w"))(""))
    ((("0" "e"))(""))
    ((("0" "r"))(""))
    ((("0" "t"))(""))
    ((("0" "y"))(""))
    ((("0" "u"))(""))
    ((("0" "i"))(""))
    ((("0" "o"))(""))
    ((("0" "p"))(""))
    ((("0" "@"))(""))
    ((("0" "["))(""))
    ((("0" "a"))(""))
    ((("0" "s"))(""))
    ((("0" "d"))(""))
    ((("0" "f"))(""))
    ((("0" "g"))(""))
    ((("0" "h"))(""))
    ((("0" "j"))(""))
    ((("0" "k"))(""))
    ((("0" "l"))(""))
    ((("0" ";"))(""))
    ((("0" ":"))(""))
    ((("0" "]"))(""))
    ((("0" "z"))(""))
    ((("0" "x"))(""))
    ((("0" "c"))(""))
    ((("0" "v"))(""))
    ((("0" "b"))(""))
    ((("0" "n"))(""))
    ((("0" "m"))(""))
    ((("0" ","))(""))
    ((("0" "."))(""))
    ((("0" "/"))(""))
    ((("0" "\\"))(""))
    ((("0" " "))(""))
    ((("0" "!"))(""))
    ((("0" "\""))(""))
    ((("0" "#"))(""))
    ((("0" "$"))(""))
    ((("0" "%"))(""))
    ((("0" "&"))(""))
    ((("0" "'"))(""))
    ((("0" "("))(""))
    ((("0" ")"))(""))
    ((("0" "|"))(""))
    ((("0" "="))(""))
    ((("0" "~"))(""))
    ((("0" "Q"))(""))
    ((("0" "W"))(""))
    ((("0" "E"))(""))
    ((("0" "R"))(""))
    ((("0" "T"))(""))
    ((("0" "Y"))(""))
    ((("0" "U"))(""))
    ((("0" "I"))(""))
    ((("0" "O"))(""))
    ((("0" "P"))(""))
    ((("0" "`"))(""))
    ((("0" "{"))(""))
    ((("0" "A"))(""))
    ((("0" "S"))(""))
    ((("0" "D"))(""))
    ((("0" "F"))(""))
    ((("0" "G"))(""))
    ((("0" "H"))(""))
    ((("0" "J"))(""))
    ((("0" "K"))(""))
    ((("0" "L"))(""))
    ((("0" "+"))(""))
    ((("0" "*"))(""))
    ((("0" "}"))(""))
    ((("0" "Z"))(""))
    ((("0" "X"))(""))
    ((("0" "C"))(""))
    ((("0" "V"))(""))
    ((("0" "B"))(""))
    ((("0" "N"))(""))
    ((("0" "M"))(""))
    ((("0" "<"))(""))
    ((("0" ">"))(""))
    ((("0" "?"))(""))
    ((("0" "_"))(""))
    ((("-" "1"))(""))
    ((("-" "2"))(""))
    ((("-" "3"))(""))
    ((("-" "4"))(""))
    ((("-" "5"))(""))
    ((("-" "6"))(""))
    ((("-" "7"))(""))
    ((("-" "8"))(""))
    ((("-" "9"))(""))
    ((("-" "0"))(""))
    ((("-" "-"))(""))
    ((("-" "^"))(""))
    ((("-" "q"))(""))
    ((("-" "w"))(""))
    ((("-" "e"))(""))
    ((("-" "r"))(""))
    ((("-" "t"))(""))
    ((("-" "y"))(""))
    ((("-" "u"))(""))
    ((("-" "i"))(""))
    ((("-" "o"))(""))
    ((("-" "p"))(""))
    ((("-" "@"))(""))
    ((("-" "["))(""))
    ((("-" "a"))(""))
    ((("-" "s"))(""))
    ((("-" "d"))(""))
    ((("-" "f"))(""))
    ((("-" "g"))(""))
    ((("-" "h"))(""))
    ((("-" "j"))(""))
    ((("-" "k"))(""))
    ((("-" "l"))(""))
    ((("-" ";"))(""))
    ((("-" ":"))(""))
    ((("-" "]"))(""))
    ((("-" "z"))(""))
    ((("-" "x"))(""))
    ((("-" "c"))(""))
    ((("-" "v"))(""))
    ((("-" "b"))(""))
    ((("-" "n"))(""))
    ((("-" "m"))(""))
    ((("-" ","))(""))
    ((("-" "."))(""))
    ((("-" "/"))(""))
    ((("-" "\\"))(""))
    ((("-" " "))(""))
    ((("-" "!"))(""))
    ((("-" "\""))(""))
    ((("-" "#"))(""))
    ((("-" "$"))(""))
    ((("-" "%"))(""))
    ((("-" "&"))(""))
    ((("-" "'"))(""))
    ((("-" "("))(""))
    ((("-" ")"))(""))
    ((("-" "|"))(""))
    ((("-" "="))(""))
    ((("-" "~"))(""))
    ((("-" "Q"))(""))
    ((("-" "W"))(""))
    ((("-" "E"))(""))
    ((("-" "R"))(""))
    ((("-" "T"))(""))
    ((("-" "Y"))(""))
    ((("-" "U"))(""))
    ((("-" "I"))(""))
    ((("-" "O"))(""))
    ((("-" "P"))(""))
    ((("-" "`"))(""))
    ((("-" "{"))(""))
    ((("-" "A"))(""))
    ((("-" "S"))(""))
    ((("-" "D"))(""))
    ((("-" "F"))(""))
    ((("-" "G"))(""))
    ((("-" "H"))(""))
    ((("-" "J"))(""))
    ((("-" "K"))(""))
    ((("-" "L"))(""))
    ((("-" "+"))(""))
    ((("-" "*"))(""))
    ((("-" "}"))(""))
    ((("-" "Z"))(""))
    ((("-" "X"))(""))
    ((("-" "C"))(""))
    ((("-" "V"))(""))
    ((("-" "B"))(""))
    ((("-" "N"))(""))
    ((("-" "M"))(""))
    ((("-" "<"))(""))
    ((("-" ">"))(""))
    ((("-" "?"))(""))
    ((("-" "_"))(""))
    ((("^" "1"))(""))
    ((("^" "2"))(""))
    ((("^" "4"))(""))
    ((("^" "5"))(""))
    ((("^" "q"))(""))
    ((("^" "w"))(""))
    ((("^" "e"))(""))
    ((("^" "r"))(""))
    ((("^" "t"))(""))
    ((("^" "y"))(""))
    ((("^" "i"))(""))
    ((("^" "@"))(""))
    ((("^" "a"))(""))
    ((("^" "s"))(""))
    ((("^" "d"))(""))
    ((("^" "f"))(""))
    ((("^" "g"))(""))
    ((("^" "h"))(""))
    ((("^" "j"))(""))
    ((("^" "k"))(""))
    ((("^" "l"))(""))
    ((("^" ";"))(""))
    ((("^" ":"))(""))
    ((("^" "]"))(""))
    ((("^" "z"))(""))
    ((("^" "x"))(""))
    ((("^" "c"))(""))
    ((("^" "v"))(""))
    ((("^" "b"))(""))
    ((("^" "n"))(""))
    ((("^" ","))(""))
    ((("^" "\\"))(""))
    ((("^" " "))(""))
    ((("q" "6"))(""))
    ((("q" "0"))(""))
    ((("q" "y"))(""))
    ((("q" "u"))(""))
    ((("q" "o"))(""))
    ((("q" "p"))(""))
    ((("q" "h"))(""))
    ((("q" "j"))(""))
    ((("q" "l"))(""))
    ((("q" ";"))(""))
    ((("q" " "))(""))
    ((("q" "Y"))(""))
    ((("q" "I"))(""))
    ((("q" "H"))(""))
    ((("w" "6"))(""))
    ((("w" "7"))(""))
    ((("w" "8"))(""))
    ((("w" "9"))(""))
    ((("w" "0"))(""))
    ((("w" "y"))(""))
    ((("w" "u"))(""))
    ((("w" "i"))(""))
    ((("w" "o"))(""))
    ((("w" "p"))(""))
    ((("w" "h"))(""))
    ((("w" "j"))(""))
    ((("w" "k"))(""))
    ((("w" "l"))(""))
    ((("w" ";"))(""))
    ((("w" " "))(""))
    ((("e" "6"))(""))
    ((("e" "8"))(""))
    ((("e" "0"))(""))
    ((("e" "y"))(""))
    ((("e" "i"))(""))
    ((("e" "p"))(""))
    ((("e" "h"))(""))
    ((("e" "k"))(""))
    ((("e" ";"))(""))
    ((("e" " "))(""))
    ((("e" "&"))(""))
    ((("e" "("))(""))
    ((("e" "|"))(""))
    ((("e" "Y"))(""))
    ((("e" "I"))(""))
    ((("e" "P"))(""))
    ((("e" "H"))(""))
    ((("e" "K"))(""))
    ((("e" "+"))(""))
    ((("r" "6"))(""))
    ((("r" "7"))(""))
    ((("r" "8"))(""))
    ((("r" "9"))(""))
    ((("r" "0"))(""))
    ((("r" "y"))(""))
    ((("r" "u"))(""))
    ((("r" "i"))(""))
    ((("r" "o"))(""))
    ((("r" "p"))(""))
    ((("r" "h"))(""))
    ((("r" "j"))(""))
    ((("r" "k"))(""))
    ((("r" "l"))(""))
    ((("r" ";"))(""))
    ((("r" " "))(""))
    ((("r" "Y"))(""))
    ((("r" "U"))(""))
    ((("r" "I"))(""))
    ((("r" "O"))(""))
    ((("r" "P"))(""))
    ((("r" "H"))(""))
    ((("r" "J"))(""))
    ((("r" "K"))(""))
    ((("r" "L"))(""))
    ((("r" "+"))(""))
    ((("t" "1"))(""))
    ((("t" "2"))(""))
    ((("t" "3"))(""))
    ((("t" "4"))(""))
    ((("t" "5"))(""))
    ((("t" "6"))(""))
    ((("t" "7"))(""))
    ((("t" "8"))(""))
    ((("t" "9"))(""))
    ((("t" "0"))(""))
    ((("t" "-"))(""))
    ((("t" "^"))(""))
    ((("t" "q"))(""))
    ((("t" "w"))(""))
    ((("t" "e"))(""))
    ((("t" "r"))(""))
    ((("t" "t"))(""))
    ((("t" "y"))(""))
    ((("t" "u"))(""))
    ((("t" "i"))(""))
    ((("t" "o"))(""))
    ((("t" "p"))(""))
    ((("t" "@"))(""))
    ((("t" "["))(""))
    ((("t" "a"))(""))
    ((("t" "s"))(""))
    ((("t" "d"))(""))
    ((("t" "f"))(""))
    ((("t" "g"))(""))
    ((("t" "h"))(""))
    ((("t" "j"))(""))
    ((("t" "k"))(""))
    ((("t" "l"))(""))
    ((("t" ";"))(""))
    ((("t" ":"))(""))
    ((("t" "]"))(""))
    ((("t" "z"))(""))
    ((("t" "x"))(""))
    ((("t" "c"))(""))
    ((("t" "v"))(""))
    ((("t" "b"))(""))
    ((("t" "n"))(""))
    ((("t" "m"))(""))
    ((("t" ","))(""))
    ((("t" "."))(""))
    ((("t" "/"))(""))
    ((("t" "\\"))(""))
    ((("t" " "))(""))
    ((("t" "!"))(""))
    ((("t" "\""))(""))
    ((("t" "#"))(""))
    ((("t" "$"))(""))
    ((("t" "%"))(""))
    ((("t" "&"))(""))
    ((("t" "'"))(""))
    ((("t" "("))(""))
    ((("t" ")"))(""))
    ((("t" "|"))(""))
    ((("t" "="))(""))
    ((("t" "~"))(""))
    ((("t" "Q"))(""))
    ((("t" "W"))(""))
    ((("t" "E"))(""))
    ((("t" "R"))(""))
    ((("t" "T"))(""))
    ((("t" "Y"))(""))
    ((("t" "U"))(""))
    ((("t" "I"))(""))
    ((("t" "O"))(""))
    ((("t" "P"))(""))
    ((("t" "`"))(""))
    ((("t" "{"))(""))
    ((("t" "A"))(""))
    ((("t" "S"))(""))
    ((("t" "D"))(""))
    ((("t" "F"))(""))
    ((("t" "G"))(""))
    ((("t" "H"))(""))
    ((("t" "J"))(""))
    ((("t" "K"))(""))
    ((("t" "L"))(""))
    ((("t" "+"))(""))
    ((("t" "*"))(""))
    ((("t" "}"))(""))
    ((("t" "Z"))(""))
    ((("t" "X"))(""))
    ((("t" "C"))(""))
    ((("t" "V"))(""))
    ((("t" "B"))(""))
    ((("t" "N"))(""))
    ((("t" "M"))(""))
    ((("t" "<"))(""))
    ((("t" ">"))(""))
    ((("t" "?"))(""))
    ((("t" "_"))(""))
    ((("y" "1"))(""))
    ((("y" "2"))(""))
    ((("y" "3"))(""))
    ((("y" "4"))(""))
    ((("y" "5"))(""))
    ((("y" "6"))(""))
    ((("y" "7"))(""))
    ((("y" "8"))(""))
    ((("y" "9"))(""))
    ((("y" "0"))(""))
    ((("y" "-"))(""))
    ((("y" "^"))(""))
    ((("y" "q"))(""))
    ((("y" "w"))(""))
    ((("y" "e"))(""))
    ((("y" "r"))(""))
    ((("y" "t"))(""))
    ((("y" "y"))(""))
    ((("y" "u"))(""))
    ((("y" "i"))(""))
    ((("y" "o"))(""))
    ((("y" "p"))(""))
    ((("y" "@"))(""))
    ((("y" "["))(""))
    ((("y" "a"))(""))
    ((("y" "s"))(""))
    ((("y" "d"))(""))
    ((("y" "f"))(""))
    ((("y" "g"))(""))
    ((("y" "h"))(""))
    ((("y" "j"))(""))
    ((("y" "k"))(""))
    ((("y" "l"))(""))
    ((("y" ";"))(""))
    ((("y" ":"))(""))
    ((("y" "]"))(""))
    ((("y" "z"))(""))
    ((("y" "x"))(""))
    ((("y" "c"))(""))
    ((("y" "v"))(""))
    ((("y" "b"))(""))
    ((("y" "n"))(""))
    ((("y" "m"))(""))
    ((("y" ","))(""))
    ((("y" "."))(""))
    ((("y" "/"))(""))
    ((("y" "\\"))(""))
    ((("y" " "))(""))
    ((("y" "!"))(""))
    ((("y" "\""))(""))
    ((("y" "#"))(""))
    ((("y" "$"))(""))
    ((("y" "%"))(""))
    ((("y" "&"))(""))
    ((("y" "'"))(""))
    ((("y" "("))(""))
    ((("y" ")"))(""))
    ((("y" "|"))(""))
    ((("y" "="))(""))
    ((("y" "~"))(""))
    ((("y" "Q"))(""))
    ((("y" "W"))(""))
    ((("y" "E"))(""))
    ((("y" "R"))(""))
    ((("y" "T"))(""))
    ((("y" "Y"))(""))
    ((("y" "U"))(""))
    ((("y" "I"))(""))
    ((("y" "O"))(""))
    ((("y" "P"))(""))
    ((("y" "`"))(""))
    ((("y" "{"))(""))
    ((("y" "A"))(""))
    ((("y" "S"))(""))
    ((("y" "D"))(""))
    ((("y" "F"))(""))
    ((("y" "G"))(""))
    ((("y" "H"))(""))
    ((("y" "J"))(""))
    ((("y" "K"))(""))
    ((("y" "L"))(""))
    ((("y" "+"))(""))
    ((("y" "*"))(""))
    ((("y" "}"))(""))
    ((("y" "Z"))(""))
    ((("y" "X"))(""))
    ((("y" "C"))(""))
    ((("y" "V"))(""))
    ((("y" "B"))(""))
    ((("y" "N"))(""))
    ((("y" "M"))(""))
    ((("y" "<"))(""))
    ((("y" ">"))(""))
    ((("y" "?"))(""))
    ((("y" "_"))(""))
    ((("u" "1"))(""))
    ((("u" "2"))(""))
    ((("u" "3"))(""))
    ((("u" "4"))(""))
    ((("u" "5"))(""))
    ((("u" "6"))(""))
    ((("u" "7"))(""))
    ((("u" "8"))(""))
    ((("u" "9"))(""))
    ((("u" "0"))(""))
    ((("u" "-"))(""))
    ((("u" "^"))(""))
    ((("u" "q"))(""))
    ((("u" "w"))(""))
    ((("u" "e"))(""))
    ((("u" "r"))(""))
    ((("u" "t"))(""))
    ((("u" "y"))(""))
    ((("u" "u"))(""))
    ((("u" "i"))(""))
    ((("u" "o"))(""))
    ((("u" "p"))(""))
    ((("u" "@"))(""))
    ((("u" "["))(""))
    ((("u" "a"))(""))
    ((("u" "s"))(""))
    ((("u" "d"))(""))
    ((("u" "f"))(""))
    ((("u" "g"))(""))
    ((("u" "h"))(""))
    ((("u" "j"))(""))
    ((("u" "k"))(""))
    ((("u" "l"))(""))
    ((("u" ";"))(""))
    ((("u" ":"))(""))
    ((("u" "]"))(""))
    ((("u" "z"))(""))
    ((("u" "x"))(""))
    ((("u" "c"))(""))
    ((("u" "v"))(""))
    ((("u" "b"))(""))
    ((("u" "n"))(""))
    ((("u" "m"))(""))
    ((("u" ","))(""))
    ((("u" "."))(""))
    ((("u" "/"))(""))
    ((("u" "\\"))(""))
    ((("u" " "))(""))
    ((("u" "!"))(""))
    ((("u" "\""))(""))
    ((("u" "#"))(""))
    ((("u" "$"))(""))
    ((("u" "%"))(""))
    ((("u" "&"))(""))
    ((("u" "'"))(""))
    ((("u" "("))(""))
    ((("u" ")"))(""))
    ((("u" "|"))(""))
    ((("u" "="))(""))
    ((("u" "~"))(""))
    ((("u" "Q"))(""))
    ((("u" "W"))(""))
    ((("u" "E"))(""))
    ((("u" "R"))(""))
    ((("u" "T"))(""))
    ((("u" "Y"))(""))
    ((("u" "U"))(""))
    ((("u" "I"))(""))
    ((("u" "O"))(""))
    ((("u" "P"))(""))
    ((("u" "`"))(""))
    ((("u" "{"))(""))
    ((("u" "A"))(""))
    ((("u" "S"))(""))
    ((("u" "D"))(""))
    ((("u" "F"))(""))
    ((("u" "G"))(""))
    ((("u" "H"))(""))
    ((("u" "J"))(""))
    ((("u" "K"))(""))
    ((("u" "L"))(""))
    ((("u" "+"))(""))
    ((("u" "*"))(""))
    ((("u" "}"))(""))
    ((("u" "Z"))(""))
    ((("u" "X"))(""))
    ((("u" "C"))(""))
    ((("u" "V"))(""))
    ((("u" "B"))(""))
    ((("u" "N"))(""))
    ((("u" "M"))(""))
    ((("u" "<"))(""))
    ((("u" ">"))(""))
    ((("u" "?"))(""))
    ((("u" "_"))(""))
    ((("i" "1"))(""))
    ((("i" "2"))(""))
    ((("i" "3"))(""))
    ((("i" "4"))(""))
    ((("i" "5"))(""))
    ((("i" "6"))(""))
    ((("i" "7"))(""))
    ((("i" "8"))(""))
    ((("i" "9"))(""))
    ((("i" "0"))(""))
    ((("i" "-"))(""))
    ((("i" "^"))(""))
    ((("i" "q"))(""))
    ((("i" "w"))(""))
    ((("i" "e"))(""))
    ((("i" "r"))(""))
    ((("i" "t"))(""))
    ((("i" "y"))(""))
    ((("i" "u"))(""))
    ((("i" "i"))(""))
    ((("i" "o"))(""))
    ((("i" "p"))(""))
    ((("i" "@"))(""))
    ((("i" "["))(""))
    ((("i" "a"))(""))
    ((("i" "s"))(""))
    ((("i" "d"))(""))
    ((("i" "f"))(""))
    ((("i" "g"))(""))
    ((("i" "h"))(""))
    ((("i" "j"))(""))
    ((("i" "k"))(""))
    ((("i" "l"))(""))
    ((("i" ";"))(""))
    ((("i" ":"))(""))
    ((("i" "]"))(""))
    ((("i" "z"))(""))
    ((("i" "x"))(""))
    ((("i" "c"))(""))
    ((("i" "v"))(""))
    ((("i" "b"))(""))
    ((("i" "n"))(""))
    ((("i" "m"))(""))
    ((("i" ","))(""))
    ((("i" "."))(""))
    ((("i" "/"))(""))
    ((("i" "\\"))(""))
    ((("i" " "))(""))
    ((("i" "!"))(""))
    ((("i" "\""))(""))
    ((("i" "#"))(""))
    ((("i" "$"))(""))
    ((("i" "%"))(""))
    ((("i" "&"))(""))
    ((("i" "'"))(""))
    ((("i" "("))(""))
    ((("i" ")"))(""))
    ((("i" "|"))(""))
    ((("i" "="))(""))
    ((("i" "~"))(""))
    ((("i" "Q"))(""))
    ((("i" "W"))(""))
    ((("i" "E"))(""))
    ((("i" "R"))(""))
    ((("i" "T"))(""))
    ((("i" "Y"))(""))
    ((("i" "U"))(""))
    ((("i" "I"))(""))
    ((("i" "O"))(""))
    ((("i" "P"))(""))
    ((("i" "`"))(""))
    ((("i" "{"))(""))
    ((("i" "A"))(""))
    ((("i" "S"))(""))
    ((("i" "D"))(""))
    ((("i" "F"))(""))
    ((("i" "G"))(""))
    ((("i" "H"))(""))
    ((("i" "J"))(""))
    ((("i" "K"))(""))
    ((("i" "L"))(""))
    ((("i" "+"))(""))
    ((("i" "*"))(""))
    ((("i" "}"))(""))
    ((("i" "Z"))(""))
    ((("i" "X"))(""))
    ((("i" "C"))(""))
    ((("i" "V"))(""))
    ((("i" "B"))(""))
    ((("i" "N"))(""))
    ((("i" "M"))(""))
    ((("i" "<"))(""))
    ((("i" ">"))(""))
    ((("i" "?"))(""))
    ((("i" "_"))(""))
    ((("o" "1"))(""))
    ((("o" "2"))(""))
    ((("o" "3"))(""))
    ((("o" "4"))(""))
    ((("o" "5"))(""))
    ((("o" "6"))(""))
    ((("o" "7"))(""))
    ((("o" "8"))(""))
    ((("o" "9"))(""))
    ((("o" "0"))(""))
    ((("o" "-"))(""))
    ((("o" "^"))(""))
    ((("o" "q"))(""))
    ((("o" "w"))(""))
    ((("o" "e"))(""))
    ((("o" "r"))(""))
    ((("o" "t"))(""))
    ((("o" "y"))(""))
    ((("o" "u"))(""))
    ((("o" "i"))(""))
    ((("o" "o"))(""))
    ((("o" "p"))(""))
    ((("o" "@"))(""))
    ((("o" "["))(""))
    ((("o" "a"))(""))
    ((("o" "s"))(""))
    ((("o" "d"))(""))
    ((("o" "f"))(""))
    ((("o" "g"))(""))
    ((("o" "h"))(""))
    ((("o" "j"))(""))
    ((("o" "k"))(""))
    ((("o" "l"))(""))
    ((("o" ";"))(""))
    ((("o" ":"))(""))
    ((("o" "]"))(""))
    ((("o" "z"))(""))
    ((("o" "x"))(""))
    ((("o" "c"))(""))
    ((("o" "v"))(""))
    ((("o" "b"))(""))
    ((("o" "n"))(""))
    ((("o" "m"))(""))
    ((("o" ","))(""))
    ((("o" "."))(""))
    ((("o" "/"))(""))
    ((("o" "\\"))(""))
    ((("o" " "))(""))
    ((("o" "!"))(""))
    ((("o" "\""))(""))
    ((("o" "#"))(""))
    ((("o" "$"))(""))
    ((("o" "%"))(""))
    ((("o" "&"))(""))
    ((("o" "'"))(""))
    ((("o" "("))(""))
    ((("o" ")"))(""))
    ((("o" "|"))(""))
    ((("o" "="))(""))
    ((("o" "~"))(""))
    ((("o" "Q"))(""))
    ((("o" "W"))(""))
    ((("o" "E"))(""))
    ((("o" "R"))(""))
    ((("o" "T"))(""))
    ((("o" "Y"))(""))
    ((("o" "U"))(""))
    ((("o" "I"))(""))
    ((("o" "O"))(""))
    ((("o" "P"))(""))
    ((("o" "`"))(""))
    ((("o" "{"))(""))
    ((("o" "A"))(""))
    ((("o" "S"))(""))
    ((("o" "D"))(""))
    ((("o" "F"))(""))
    ((("o" "G"))(""))
    ((("o" "H"))(""))
    ((("o" "J"))(""))
    ((("o" "K"))(""))
    ((("o" "L"))(""))
    ((("o" "+"))(""))
    ((("o" "*"))(""))
    ((("o" "}"))(""))
    ((("o" "Z"))(""))
    ((("o" "X"))(""))
    ((("o" "C"))(""))
    ((("o" "V"))(""))
    ((("o" "B"))(""))
    ((("o" "N"))(""))
    ((("o" "M"))(""))
    ((("o" "<"))(""))
    ((("o" ">"))(""))
    ((("o" "?"))(""))
    ((("o" "_"))(""))
    ((("p" "1"))(""))
    ((("p" "2"))(""))
    ((("p" "3"))(""))
    ((("p" "4"))(""))
    ((("p" "5"))(""))
    ((("p" "6"))(""))
    ((("p" "7"))(""))
    ((("p" "8"))(""))
    ((("p" "9"))(""))
    ((("p" "0"))(""))
    ((("p" "-"))(""))
    ((("p" "^"))(""))
    ((("p" "q"))(""))
    ((("p" "w"))(""))
    ((("p" "e"))(""))
    ((("p" "r"))(""))
    ((("p" "t"))(""))
    ((("p" "y"))(""))
    ((("p" "u"))(""))
    ((("p" "i"))(""))
    ((("p" "o"))(""))
    ((("p" "p"))(""))
    ((("p" "@"))(""))
    ((("p" "["))(""))
    ((("p" "a"))(""))
    ((("p" "s"))(""))
    ((("p" "d"))(""))
    ((("p" "f"))(""))
    ((("p" "g"))(""))
    ((("p" "h"))(""))
    ((("p" "j"))(""))
    ((("p" "k"))(""))
    ((("p" "l"))(""))
    ((("p" ";"))(""))
    ((("p" ":"))(""))
    ((("p" "]"))(""))
    ((("p" "z"))(""))
    ((("p" "x"))(""))
    ((("p" "c"))(""))
    ((("p" "v"))(""))
    ((("p" "b"))(""))
    ((("p" "n"))(""))
    ((("p" "m"))(""))
    ((("p" ","))(""))
    ((("p" "."))(""))
    ((("p" "/"))(""))
    ((("p" "\\"))(""))
    ((("p" " "))(""))
    ((("p" "!"))(""))
    ((("p" "\""))(""))
    ((("p" "#"))(""))
    ((("p" "$"))(""))
    ((("p" "%"))(""))
    ((("p" "&"))(""))
    ((("p" "'"))(""))
    ((("p" "("))(""))
    ((("p" ")"))(""))
    ((("p" "|"))(""))
    ((("p" "="))(""))
    ((("p" "~"))(""))
    ((("p" "Q"))(""))
    ((("p" "W"))(""))
    ((("p" "E"))(""))
    ((("p" "R"))(""))
    ((("p" "T"))(""))
    ((("p" "Y"))(""))
    ((("p" "U"))(""))
    ((("p" "I"))(""))
    ((("p" "O"))(""))
    ((("p" "P"))(""))
    ((("p" "`"))(""))
    ((("p" "{"))(""))
    ((("p" "A"))(""))
    ((("p" "S"))(""))
    ((("p" "D"))(""))
    ((("p" "F"))(""))
    ((("p" "G"))(""))
    ((("p" "H"))(""))
    ((("p" "J"))(""))
    ((("p" "K"))(""))
    ((("p" "L"))(""))
    ((("p" "+"))(""))
    ((("p" "*"))(""))
    ((("p" "}"))(""))
    ((("p" "Z"))(""))
    ((("p" "X"))(""))
    ((("p" "C"))(""))
    ((("p" "V"))(""))
    ((("p" "B"))(""))
    ((("p" "N"))(""))
    ((("p" "M"))(""))
    ((("p" "<"))(""))
    ((("p" ">"))(""))
    ((("p" "?"))(""))
    ((("p" "_"))(""))
    ((("@" "1"))(""))
    ((("@" "2"))(""))
    ((("@" "3"))(""))
    ((("@" "4"))(""))
    ((("@" "5"))(""))
    ((("@" "6"))(""))
    ((("@" "7"))(""))
    ((("@" "8"))(""))
    ((("@" "9"))(""))
    ((("@" "0"))(""))
    ((("@" "-"))(""))
    ((("@" "^"))(""))
    ((("@" "q"))(""))
    ((("@" "w"))(""))
    ((("@" "e"))(""))
    ((("@" "r"))(""))
    ((("@" "t"))(""))
    ((("@" "y"))(""))
    ((("@" "u"))(""))
    ((("@" "i"))(""))
    ((("@" "o"))(""))
    ((("@" "p"))(""))
    ((("@" "@"))(""))
    ((("@" "["))(""))
    ((("@" "a"))(""))
    ((("@" "s"))(""))
    ((("@" "d"))(""))
    ((("@" "f"))(""))
    ((("@" "g"))(""))
    ((("@" "h"))(""))
    ((("@" "j"))(""))
    ((("@" "k"))(""))
    ((("@" "l"))(""))
    ((("@" ";"))(""))
    ((("@" ":"))(""))
    ((("@" "]"))(""))
    ((("@" "z"))(""))
    ((("@" "x"))(""))
    ((("@" "c"))(""))
    ((("@" "v"))(""))
    ((("@" "b"))(""))
    ((("@" "n"))(""))
    ((("@" "m"))(""))
    ((("@" ","))(""))
    ((("@" "."))(""))
    ((("@" "/"))(""))
    ((("@" "\\"))(""))
    ((("@" " "))(""))
    ((("@" "!"))(""))
    ((("@" "\""))(""))
    ((("@" "#"))(""))
    ((("@" "$"))(""))
    ((("@" "%"))(""))
    ((("@" "&"))(""))
    ((("@" "'"))(""))
    ((("@" "("))(""))
    ((("@" ")"))(""))
    ((("@" "|"))(""))
    ((("@" "="))(""))
    ((("@" "~"))(""))
    ((("@" "Q"))(""))
    ((("@" "W"))(""))
    ((("@" "E"))(""))
    ((("@" "R"))(""))
    ((("@" "T"))(""))
    ((("@" "Y"))(""))
    ((("@" "U"))(""))
    ((("@" "I"))(""))
    ((("@" "O"))(""))
    ((("@" "P"))(""))
    ((("@" "`"))(""))
    ((("@" "{"))(""))
    ((("@" "A"))(""))
    ((("@" "S"))(""))
    ((("@" "D"))(""))
    ((("@" "F"))(""))
    ((("@" "G"))(""))
    ((("@" "H"))(""))
    ((("@" "J"))(""))
    ((("@" "K"))(""))
    ((("@" "L"))(""))
    ((("@" "+"))(""))
    ((("@" "*"))(""))
    ((("@" "}"))(""))
    ((("@" "Z"))(""))
    ((("@" "X"))(""))
    ((("@" "C"))(""))
    ((("@" "V"))(""))
    ((("@" "B"))(""))
    ((("@" "N"))(""))
    ((("@" "M"))(""))
    ((("@" "<"))(""))
    ((("@" ">"))(""))
    ((("@" "?"))(""))
    ((("@" "_"))(""))
    ((("[" "1"))(""))
    ((("[" "2"))(""))
    ((("[" "3"))(""))
    ((("[" "4"))(""))
    ((("[" "5"))(""))
    ((("[" "6"))(""))
    ((("[" "7"))(""))
    ((("[" "8"))(""))
    ((("[" "9"))(""))
    ((("[" "0"))(""))
    ((("[" "-"))(""))
    ((("[" "^"))(""))
    ((("[" "q"))(""))
    ((("[" "w"))(""))
    ((("[" "e"))(""))
    ((("[" "r"))(""))
    ((("[" "t"))(""))
    ((("[" "y"))(""))
    ((("[" "u"))(""))
    ((("[" "i"))(""))
    ((("[" "o"))(""))
    ((("[" "p"))(""))
    ((("[" "@"))(""))
    ((("[" "["))(""))
    ((("[" "a"))(""))
    ((("[" "s"))(""))
    ((("[" "d"))(""))
    ((("[" "f"))(""))
    ((("[" "g"))(""))
    ((("[" "h"))(""))
    ((("[" "k"))(""))
    ((("[" "l"))(""))
    ((("[" ";"))(""))
    ((("[" ":"))(""))
    ((("[" "]"))(""))
    ((("[" "z"))(""))
    ((("[" "x"))(""))
    ((("[" "c"))(""))
    ((("[" "v"))(""))
    ((("[" "b"))(""))
    ((("[" "n"))(""))
    ((("[" "m"))(""))
    ((("[" ","))(""))
    ((("[" "."))(""))
    ((("[" "/"))(""))
    ((("[" "\\"))(""))
    ((("[" " "))(""))
    ((("[" "!"))(""))
    ((("[" "\""))(""))
    ((("[" "#"))(""))
    ((("[" "$"))(""))
    ((("[" "%"))(""))
    ((("[" "&"))(""))
    ((("[" "'"))(""))
    ((("[" "R"))(""))
    ((("[" "T"))(""))
    ((("[" "Y"))(""))
    ((("[" "U"))(""))
    ((("[" "I"))(""))
    ((("[" "O"))(""))
    ((("[" "P"))(""))
    ((("[" "`"))(""))
    ((("[" "{"))(""))
    ((("[" "A"))(""))
    ((("[" "S"))(""))
    ((("[" "D"))(""))
    ((("[" "F"))(""))
    ((("[" "G"))(""))
    ((("[" "H"))(""))
    ((("[" "J"))(""))
    ((("[" "K"))(""))
    ((("[" "L"))(""))
    ((("[" "+"))(""))
    ((("[" "*"))(""))
    ((("[" "}"))(""))
    ((("[" "Z"))(""))
    ((("[" "X"))(""))
    ((("[" "C"))(""))
    ((("[" "V"))(""))
    ((("[" "B"))(""))
    ((("[" "N"))(""))
    ((("[" "M"))(""))
    ((("[" "<"))(""))
    ((("[" ">"))(""))
    ((("a" "6"))(""))
    ((("a" "7"))(""))
    ((("a" "8"))(""))
    ((("a" "9"))(""))
    ((("a" "0"))(""))
    ((("a" "y"))(""))
    ((("a" "u"))(""))
    ((("a" "i"))(""))
    ((("a" "o"))(""))
    ((("a" "p"))(""))
    ((("a" "h"))(""))
    ((("a" "j"))(""))
    ((("a" "k"))(""))
    ((("a" "l"))(""))
    ((("a" ";"))(""))
    ((("a" " "))(""))
    ((("s" "6"))(""))
    ((("s" "7"))(""))
    ((("s" "8"))(""))
    ((("s" "9"))(""))
    ((("s" "0"))(""))
    ((("s" "y"))(""))
    ((("s" "u"))(""))
    ((("s" "i"))(""))
    ((("s" "o"))(""))
    ((("s" "p"))(""))
    ((("s" "h"))(""))
    ((("s" "j"))(""))
    ((("s" "k"))(""))
    ((("s" "l"))(""))
    ((("s" ";"))(""))
    ((("s" " "))(""))
    ((("s" "Y"))(""))
    ((("s" "U"))(""))
    ((("s" "I"))(""))
    ((("s" "O"))(""))
    ((("s" "P"))(""))
    ((("s" "H"))(""))
    ((("s" "J"))(""))
    ((("s" "K"))(""))
    ((("s" "L"))(""))
    ((("s" "+"))(""))
    ((("d" "6"))(""))
    ((("d" "7"))(""))
    ((("d" "8"))(""))
    ((("d" "9"))(""))
    ((("d" "0"))(""))
    ((("d" "y"))(""))
    ((("d" "u"))(""))
    ((("d" "i"))(""))
    ((("d" "o"))(""))
    ((("d" "p"))(""))
    ((("d" "h"))(""))
    ((("d" "j"))(""))
    ((("d" "k"))(""))
    ((("d" "l"))(""))
    ((("d" ";"))(""))
    ((("d" " "))(""))
    ((("d" "Y"))(""))
    ((("d" "U"))(""))
    ((("d" "I"))(""))
    ((("d" "O"))(""))
    ((("d" "P"))(""))
    ((("d" "H"))(""))
    ((("d" "J"))(""))
    ((("d" "K"))(""))
    ((("d" "L"))(""))
    ((("d" "+"))(""))
    ((("f" "6"))(""))
    ((("f" "7"))(""))
    ((("f" "8"))(""))
    ((("f" "9"))(""))
    ((("f" "0"))(""))
    ((("f" "y"))(""))
    ((("f" "u"))(""))
    ((("f" "i"))(""))
    ((("f" "o"))(""))
    ((("f" "p"))(""))
    ((("f" "h"))(""))
    ((("f" "j"))(""))
    ((("f" "k"))(""))
    ((("f" "l"))(""))
    ((("f" ";"))(""))
    ((("f" " "))(""))
    ((("f" "Y"))(""))
    ((("f" "U"))(""))
    ((("f" "I"))(""))
    ((("f" "O"))(""))
    ((("f" "P"))(""))
    ((("f" "H"))(""))
    ((("f" "J"))(""))
    ((("f" "K"))(""))
    ((("f" "L"))(""))
    ((("f" "+"))(""))
    ((("g" "1"))(""))
    ((("g" "2"))(""))
    ((("g" "3"))(""))
    ((("g" "4"))(""))
    ((("g" "5"))(""))
    ((("g" "6"))(""))
    ((("g" "7"))(""))
    ((("g" "8"))(""))
    ((("g" "9"))(""))
    ((("g" "0"))(""))
    ((("g" "-"))(""))
    ((("g" "^"))(""))
    ((("g" "q"))(""))
    ((("g" "w"))(""))
    ((("g" "e"))(""))
    ((("g" "r"))(""))
    ((("g" "t"))(""))
    ((("g" "y"))(""))
    ((("g" "u"))(""))
    ((("g" "i"))(""))
    ((("g" "o"))(""))
    ((("g" "p"))(""))
    ((("g" "@"))(""))
    ((("g" "["))(""))
    ((("g" "a"))(""))
    ((("g" "s"))(""))
    ((("g" "d"))(""))
    ((("g" "f"))(""))
    ((("g" "g"))(""))
    ((("g" "h"))(""))
    ((("g" "j"))(""))
    ((("g" "k"))(""))
    ((("g" "l"))(""))
    ((("g" ";"))(""))
    ((("g" ":"))(""))
    ((("g" "]"))(""))
    ((("g" "z"))(""))
    ((("g" "x"))(""))
    ((("g" "c"))(""))
    ((("g" "v"))(""))
    ((("g" "b"))(""))
    ((("g" "n"))(""))
    ((("g" "m"))(""))
    ((("g" ","))(""))
    ((("g" "."))(""))
    ((("g" "/"))(""))
    ((("g" "\\"))(""))
    ((("g" " "))(""))
    ((("g" "!"))(""))
    ((("g" "\""))(""))
    ((("g" "#"))(""))
    ((("g" "$"))(""))
    ((("g" "%"))(""))
    ((("g" "&"))(""))
    ((("g" "'"))(""))
    ((("g" "("))(""))
    ((("g" ")"))(""))
    ((("g" "|"))(""))
    ((("g" "="))(""))
    ((("g" "~"))(""))
    ((("g" "Q"))(""))
    ((("g" "W"))(""))
    ((("g" "E"))(""))
    ((("g" "R"))(""))
    ((("g" "T"))(""))
    ((("g" "Y"))(""))
    ((("g" "U"))(""))
    ((("g" "I"))(""))
    ((("g" "O"))(""))
    ((("g" "P"))(""))
    ((("g" "`"))(""))
    ((("g" "{"))(""))
    ((("g" "A"))(""))
    ((("g" "S"))(""))
    ((("g" "D"))(""))
    ((("g" "F"))(""))
    ((("g" "G"))(""))
    ((("g" "H"))(""))
    ((("g" "J"))(""))
    ((("g" "K"))(""))
    ((("g" "L"))(""))
    ((("g" "+"))(""))
    ((("g" "*"))(""))
    ((("g" "}"))(""))
    ((("g" "Z"))(""))
    ((("g" "X"))(""))
    ((("g" "C"))(""))
    ((("g" "V"))(""))
    ((("g" "B"))(""))
    ((("g" "N"))(""))
    ((("g" "M"))(""))
    ((("g" "<"))(""))
    ((("g" ">"))(""))
    ((("g" "?"))(""))
    ((("g" "_"))(""))
    ((("h" "1"))(""))
    ((("h" "2"))(""))
    ((("h" "3"))(""))
    ((("h" "4"))(""))
    ((("h" "5"))(""))
    ((("h" "6"))(""))
    ((("h" "7"))(""))
    ((("h" "8"))(""))
    ((("h" "9"))(""))
    ((("h" "0"))(""))
    ((("h" "-"))(""))
    ((("h" "^"))(""))
    ((("h" "q"))(""))
    ((("h" "w"))(""))
    ((("h" "e"))(""))
    ((("h" "r"))(""))
    ((("h" "t"))(""))
    ((("h" "y"))(""))
    ((("h" "u"))(""))
    ((("h" "i"))(""))
    ((("h" "o"))(""))
    ((("h" "p"))(""))
    ((("h" "@"))(""))
    ((("h" "["))(""))
    ((("h" "a"))(""))
    ((("h" "s"))(""))
    ((("h" "d"))(""))
    ((("h" "f"))(""))
    ((("h" "g"))(""))
    ((("h" "h"))(""))
    ((("h" "j"))(""))
    ((("h" "k"))(""))
    ((("h" "l"))(""))
    ((("h" ";"))(""))
    ((("h" ":"))(""))
    ((("h" "]"))(""))
    ((("h" "z"))(""))
    ((("h" "x"))(""))
    ((("h" "c"))(""))
    ((("h" "v"))(""))
    ((("h" "b"))(""))
    ((("h" "n"))(""))
    ((("h" "m"))(""))
    ((("h" ","))(""))
    ((("h" "."))(""))
    ((("h" "/"))(""))
    ((("h" "\\"))(""))
    ((("h" " "))(""))
    ((("h" "!"))(""))
    ((("h" "\""))(""))
    ((("h" "#"))(""))
    ((("h" "$"))(""))
    ((("h" "%"))(""))
    ((("h" "&"))(""))
    ((("h" "'"))(""))
    ((("h" "("))(""))
    ((("h" ")"))(""))
    ((("h" "|"))(""))
    ((("h" "="))(""))
    ((("h" "~"))(""))
    ((("h" "Q"))(""))
    ((("h" "W"))(""))
    ((("h" "E"))(""))
    ((("h" "R"))(""))
    ((("h" "T"))(""))
    ((("h" "Y"))(""))
    ((("h" "U"))(""))
    ((("h" "I"))(""))
    ((("h" "O"))(""))
    ((("h" "P"))(""))
    ((("h" "`"))(""))
    ((("h" "{"))(""))
    ((("h" "A"))(""))
    ((("h" "S"))(""))
    ((("h" "D"))(""))
    ((("h" "F"))(""))
    ((("h" "G"))(""))
    ((("h" "H"))(""))
    ((("h" "J"))(""))
    ((("h" "K"))(""))
    ((("h" "L"))(""))
    ((("h" "+"))(""))
    ((("h" "*"))(""))
    ((("h" "}"))(""))
    ((("h" "Z"))(""))
    ((("h" "X"))(""))
    ((("h" "C"))(""))
    ((("h" "V"))(""))
    ((("h" "B"))(""))
    ((("h" "N"))(""))
    ((("h" "M"))(""))
    ((("h" "<"))(""))
    ((("h" ">"))(""))
    ((("h" "?"))(""))
    ((("h" "_"))(""))
    ((("j" "1"))("¡"))
    ((("j" "2"))("¢"))
    ((("j" "3"))("£"))
    ((("j" "4"))("¤"))
    ((("j" "5"))("¥"))
    ((("j" "6"))("¦"))
    ((("j" "7"))("§"))
    ((("j" "8"))("¨"))
    ((("j" "9"))("©"))
    ((("j" "0"))("ª"))
    ((("j" "-"))("«"))
    ((("j" "^"))("¬"))
    ((("j" "q"))("­"))
    ((("j" "w"))("®"))
    ((("j" "e"))("¯"))
    ((("j" "r"))("°"))
    ((("j" "t"))("±"))
    ((("j" "y"))("²"))
    ((("j" "u"))("³"))
    ((("j" "i"))("´"))
    ((("j" "o"))("µ"))
    ((("j" "p"))("¶"))
    ((("j" "@"))("·"))
    ((("j" "["))("¸"))
    ((("j" "a"))("¹"))
    ((("j" "s"))("º"))
    ((("j" "d"))("»"))
    ((("j" "f"))("¼"))
    ((("j" "g"))("½"))
    ((("j" "h"))("¾"))
    ((("j" "j"))("¿"))
    ((("j" "k"))(""))
    ((("j" "l"))(""))
    ((("j" ";"))(""))
    ((("j" ":"))(""))
    ((("j" "]"))(""))
    ((("j" "z"))(""))
    ((("j" "x"))(""))
    ((("j" "c"))(""))
    ((("j" "v"))(""))
    ((("j" "b"))(""))
    ((("j" "n"))(""))
    ((("j" "m"))(""))
    ((("j" ","))(""))
    ((("j" "."))(""))
    ((("j" "/"))(""))
    ((("j" "\\"))(""))
    ((("j" " "))(""))
    ((("j" "!"))(""))
    ((("j" "\""))(""))
    ((("j" "#"))(""))
    ((("j" "$"))(""))
    ((("j" "%"))(""))
    ((("j" "&"))(""))
    ((("j" "'"))(""))
    ((("j" "("))(""))
    ((("j" ")"))(""))
    ((("j" "|"))(""))
    ((("j" "="))(""))
    ((("j" "~"))(""))
    ((("j" "Q"))(""))
    ((("j" "W"))(""))
    ((("j" "E"))(""))
    ((("j" "R"))(""))
    ((("j" "T"))(""))
    ((("j" "Y"))(""))
    ((("j" "U"))(""))
    ((("j" "I"))(""))
    ((("j" "O"))(""))
    ((("j" "P"))(""))
    ((("j" "`"))(""))
    ((("j" "{"))(""))
    ((("j" "A"))(""))
    ((("j" "S"))(""))
    ((("j" "D"))(""))
    ((("j" "F"))(""))
    ((("j" "G"))(""))
    ((("j" "H"))(""))
    ((("j" "J"))(""))
    ((("j" "K"))(""))
    ((("j" "L"))(""))
    ((("j" "+"))(""))
    ((("j" "*"))(""))
    ((("j" "}"))(""))
    ((("j" "Z"))(""))
    ((("j" "X"))(""))
    ((("j" "C"))(""))
    ((("j" "V"))(""))
    ((("j" "B"))(""))
    ((("j" "N"))(""))
    ((("j" "M"))(""))
    ((("j" "<"))(""))
    ((("j" ">"))(""))
    ((("j" "?"))(""))
    ((("j" "_"))(""))
    ((("k" "1"))("á"))
    ((("k" "2"))("â"))
    ((("k" "3"))("ã"))
    ((("k" "4"))("ä"))
    ((("k" "5"))("å"))
    ((("k" "6"))("æ"))
    ((("k" "7"))("ç"))
    ((("k" "8"))("è"))
    ((("k" "9"))("é"))
    ((("k" "0"))("ê"))
    ((("k" "-"))("ë"))
    ((("k" "^"))("ì"))
    ((("k" "q"))("í"))
    ((("k" "w"))("î"))
    ((("k" "e"))("ï"))
    ((("k" "r"))("ð"))
    ((("k" "t"))("ñ"))
    ((("k" "y"))("ò"))
    ((("k" "u"))("ó"))
    ((("k" "i"))("ô"))
    ((("k" "o"))("õ"))
    ((("k" "p"))("ö"))
    ((("k" "@"))("÷"))
    ((("k" "["))("ø"))
    ((("k" "a"))("ù"))
    ((("k" "s"))("ú"))
    ((("k" "d"))("û"))
    ((("k" "f"))("ü"))
    ((("k" "g"))("ý"))
    ((("k" "h"))("þ"))
    ((("k" "j"))("ÿ"))
    ((("k" "k"))(""))
    ((("k" "l"))(""))
    ((("k" ";"))(""))
    ((("k" ":"))(""))
    ((("k" "]"))(""))
    ((("k" "z"))(""))
    ((("k" "x"))(""))
    ((("k" "c"))(""))
    ((("k" "v"))(""))
    ((("k" "b"))(""))
    ((("k" "n"))(""))
    ((("k" "m"))(""))
    ((("k" ","))(""))
    ((("k" "."))(""))
    ((("k" "/"))(""))
    ((("k" "\\"))(""))
    ((("k" " "))(""))
    ((("k" "!"))(""))
    ((("k" "\""))(""))
    ((("k" "#"))(""))
    ((("k" "$"))(""))
    ((("k" "%"))(""))
    ((("k" "&"))(""))
    ((("k" "'"))(""))
    ((("k" "("))(""))
    ((("k" ")"))(""))
    ((("k" "|"))(""))
    ((("k" "="))(""))
    ((("k" "~"))(""))
    ((("k" "Q"))(""))
    ((("k" "W"))(""))
    ((("k" "E"))(""))
    ((("k" "R"))(""))
    ((("k" "T"))(""))
    ((("k" "Y"))(""))
    ((("k" "U"))(""))
    ((("k" "I"))(""))
    ((("k" "O"))(""))
    ((("k" "P"))(""))
    ((("k" "`"))(""))
    ((("k" "{"))(""))
    ((("k" "A"))(""))
    ((("k" "S"))(""))
    ((("k" "D"))(""))
    ((("k" "F"))(""))
    ((("k" "G"))(""))
    ((("k" "H"))(""))
    ((("k" "J"))(""))
    ((("k" "K"))(""))
    ((("k" "L"))(""))
    ((("k" "+"))(""))
    ((("k" "*"))(""))
    ((("k" "}"))(""))
    ((("k" "Z"))(""))
    ((("k" "X"))(""))
    ((("k" "C"))(""))
    ((("k" "V"))(""))
    ((("k" "B"))(""))
    ((("k" "N"))(""))
    ((("k" "M"))(""))
    ((("k" "<"))(""))
    ((("k" ">"))(""))
    ((("k" "?"))(""))
    ((("k" "_"))(""))
    ((("l" "1"))("ġ"))
    ((("l" "2"))("Ģ"))
    ((("l" "3"))("ģ"))
    ((("l" "4"))("Ĥ"))
    ((("l" "5"))("ĥ"))
    ((("l" "6"))("Ħ"))
    ((("l" "7"))("ħ"))
    ((("l" "8"))("Ĩ"))
    ((("l" "9"))("ĩ"))
    ((("l" "0"))("Ī"))
    ((("l" "-"))("ī"))
    ((("l" "^"))("Ĭ"))
    ((("l" "q"))("ĭ"))
    ((("l" "w"))("Į"))
    ((("l" "e"))("į"))
    ((("l" "r"))("İ"))
    ((("l" "t"))("ı"))
    ((("l" "y"))("Ĳ"))
    ((("l" "u"))("ĳ"))
    ((("l" "i"))("Ĵ"))
    ((("l" "o"))("ĵ"))
    ((("l" "p"))("Ķ"))
    ((("l" "@"))("ķ"))
    ((("l" "["))("ĸ"))
    ((("l" "a"))("Ĺ"))
    ((("l" "s"))("ĺ"))
    ((("l" "d"))("Ļ"))
    ((("l" "f"))("ļ"))
    ((("l" "g"))("Ľ"))
    ((("l" "h"))("ľ"))
    ((("l" "j"))("Ŀ"))
    ((("l" "k"))(""))
    ((("l" "l"))(""))
    ((("l" ";"))(""))
    ((("l" ":"))(""))
    ((("l" "]"))(""))
    ((("l" "z"))(""))
    ((("l" "x"))(""))
    ((("l" "c"))(""))
    ((("l" "v"))(""))
    ((("l" "b"))(""))
    ((("l" "n"))(""))
    ((("l" "m"))(""))
    ((("l" ","))(""))
    ((("l" "."))(""))
    ((("l" "/"))(""))
    ((("l" "\\"))(""))
    ((("l" " "))(""))
    ((("l" "!"))(""))
    ((("l" "\""))(""))
    ((("l" "#"))(""))
    ((("l" "$"))(""))
    ((("l" "%"))(""))
    ((("l" "&"))(""))
    ((("l" "'"))(""))
    ((("l" "("))(""))
    ((("l" ")"))(""))
    ((("l" "|"))(""))
    ((("l" "="))(""))
    ((("l" "~"))(""))
    ((("l" "Q"))(""))
    ((("l" "W"))(""))
    ((("l" "E"))(""))
    ((("l" "R"))(""))
    ((("l" "T"))(""))
    ((("l" "Y"))(""))
    ((("l" "U"))(""))
    ((("l" "I"))(""))
    ((("l" "O"))(""))
    ((("l" "P"))(""))
    ((("l" "`"))(""))
    ((("l" "{"))(""))
    ((("l" "A"))(""))
    ((("l" "S"))(""))
    ((("l" "D"))(""))
    ((("l" "F"))(""))
    ((("l" "G"))(""))
    ((("l" "H"))(""))
    ((("l" "J"))(""))
    ((("l" "K"))(""))
    ((("l" "L"))(""))
    ((("l" "+"))(""))
    ((("l" "*"))(""))
    ((("l" "}"))(""))
    ((("l" "Z"))(""))
    ((("l" "X"))(""))
    ((("l" "C"))(""))
    ((("l" "V"))(""))
    ((("l" "B"))(""))
    ((("l" "N"))(""))
    ((("l" "M"))(""))
    ((("l" "<"))(""))
    ((("l" ">"))(""))
    ((("l" "?"))(""))
    ((("l" "_"))(""))
    (((";" "1"))("š"))
    (((";" "2"))("Ţ"))
    (((";" "3"))("ţ"))
    (((";" "4"))("Ť"))
    (((";" "5"))("ť"))
    (((";" "6"))("Ŧ"))
    (((";" "7"))("ŧ"))
    (((";" "8"))("Ũ"))
    (((";" "9"))("ũ"))
    (((";" "0"))("Ū"))
    (((";" "-"))("ū"))
    (((";" "^"))("Ŭ"))
    (((";" "q"))("ŭ"))
    (((";" "w"))("Ů"))
    (((";" "e"))("ů"))
    (((";" "r"))("Ű"))
    (((";" "t"))("ű"))
    (((";" "y"))("Ų"))
    (((";" "u"))("ų"))
    (((";" "i"))("Ŵ"))
    (((";" "o"))("ŵ"))
    (((";" "p"))("Ŷ"))
    (((";" "@"))("ŷ"))
    (((";" "["))("Ÿ"))
    (((";" "a"))("Ź"))
    (((";" "s"))("ź"))
    (((";" "d"))("Ż"))
    (((";" "f"))("ż"))
    (((";" "g"))("Ž"))
    (((";" "h"))("ž"))
    (((";" "j"))("ſ"))
    (((";" "k"))(""))
    (((";" "l"))(""))
    (((";" ";"))(""))
    (((";" ":"))(""))
    (((";" "]"))(""))
    (((";" "z"))(""))
    (((";" "x"))(""))
    (((";" "c"))(""))
    (((";" "v"))(""))
    (((";" "b"))(""))
    (((";" "n"))(""))
    (((";" "m"))(""))
    (((";" ","))(""))
    (((";" "."))(""))
    (((";" "/"))(""))
    (((";" "\\"))(""))
    (((";" " "))(""))
    (((";" "!"))(""))
    (((";" "\""))(""))
    (((";" "#"))(""))
    (((";" "$"))(""))
    (((";" "%"))(""))
    (((";" "&"))(""))
    (((";" "'"))(""))
    (((";" "("))(""))
    (((";" ")"))(""))
    (((";" "|"))(""))
    (((";" "="))(""))
    (((";" "~"))(""))
    (((";" "Q"))(""))
    (((";" "W"))(""))
    (((";" "E"))(""))
    (((";" "R"))(""))
    (((";" "T"))(""))
    (((";" "Y"))(""))
    (((";" "U"))(""))
    (((";" "I"))(""))
    (((";" "O"))(""))
    (((";" "P"))(""))
    (((";" "`"))(""))
    (((";" "{"))(""))
    (((";" "A"))(""))
    (((";" "S"))(""))
    (((";" "D"))(""))
    (((";" "F"))(""))
    (((";" "G"))(""))
    (((";" "H"))(""))
    (((";" "J"))(""))
    (((";" "K"))(""))
    (((";" "L"))(""))
    (((";" "+"))(""))
    (((";" "*"))(""))
    (((";" "}"))(""))
    (((";" "Z"))(""))
    (((";" "X"))(""))
    (((";" "C"))(""))
    (((";" "V"))(""))
    (((";" "B"))(""))
    (((";" "N"))(""))
    (((";" "M"))(""))
    (((";" "<"))(""))
    (((";" ">"))(""))
    (((";" "?"))(""))
    (((";" "_"))(""))
    (((":" "1"))("ơ"))
    (((":" "2"))("Ƣ"))
    (((":" "3"))("ƣ"))
    (((":" "4"))("Ƥ"))
    (((":" "5"))("ƥ"))
    (((":" "6"))("Ʀ"))
    (((":" "7"))("Ƨ"))
    (((":" "8"))("ƨ"))
    (((":" "9"))("Ʃ"))
    (((":" "0"))("ƪ"))
    (((":" "-"))("ƫ"))
    (((":" "^"))("Ƭ"))
    (((":" "q"))("ƭ"))
    (((":" "w"))("Ʈ"))
    (((":" "e"))("Ư"))
    (((":" "r"))("ư"))
    (((":" "t"))("Ʊ"))
    (((":" "y"))("Ʋ"))
    (((":" "u"))("Ƴ"))
    (((":" "i"))("ƴ"))
    (((":" "o"))("Ƶ"))
    (((":" "p"))("ƶ"))
    (((":" "@"))("Ʒ"))
    (((":" "["))("Ƹ"))
    (((":" "a"))("ƹ"))
    (((":" "s"))("ƺ"))
    (((":" "d"))("ƻ"))
    (((":" "f"))("Ƽ"))
    (((":" "g"))("ƽ"))
    (((":" "h"))("ƾ"))
    (((":" "j"))("ƿ"))
    (((":" "k"))(""))
    (((":" "l"))(""))
    (((":" ";"))(""))
    (((":" ":"))(""))
    (((":" "]"))(""))
    (((":" "z"))(""))
    (((":" "x"))(""))
    (((":" "c"))(""))
    (((":" "v"))(""))
    (((":" "b"))(""))
    (((":" "n"))(""))
    (((":" "m"))(""))
    (((":" ","))(""))
    (((":" "."))(""))
    (((":" "/"))(""))
    (((":" "\\"))(""))
    (((":" " "))(""))
    (((":" "!"))(""))
    (((":" "\""))(""))
    (((":" "#"))(""))
    (((":" "$"))(""))
    (((":" "%"))(""))
    (((":" "&"))(""))
    (((":" "'"))(""))
    (((":" "("))(""))
    (((":" ")"))(""))
    (((":" "|"))(""))
    (((":" "="))(""))
    (((":" "~"))(""))
    (((":" "Q"))(""))
    (((":" "W"))(""))
    (((":" "E"))(""))
    (((":" "R"))(""))
    (((":" "T"))(""))
    (((":" "Y"))(""))
    (((":" "U"))(""))
    (((":" "I"))(""))
    (((":" "O"))(""))
    (((":" "P"))(""))
    (((":" "`"))(""))
    (((":" "{"))(""))
    (((":" "A"))(""))
    (((":" "S"))(""))
    (((":" "D"))(""))
    (((":" "F"))(""))
    (((":" "G"))(""))
    (((":" "H"))(""))
    (((":" "J"))(""))
    (((":" "K"))(""))
    (((":" "L"))(""))
    (((":" "+"))(""))
    (((":" "*"))(""))
    (((":" "}"))(""))
    (((":" "Z"))(""))
    (((":" "X"))(""))
    (((":" "C"))(""))
    (((":" "V"))(""))
    (((":" "B"))(""))
    (((":" "N"))(""))
    (((":" "M"))(""))
    (((":" "<"))(""))
    (((":" ">"))(""))
    (((":" "?"))(""))
    (((":" "_"))(""))
    ((("]" "1"))(""))
    ((("]" "2"))(""))
    ((("]" "3"))(""))
    ((("]" "4"))(""))
    ((("]" "5"))(""))
    ((("]" "6"))(""))
    ((("]" "7"))(""))
    ((("]" "8"))(""))
    ((("]" "9"))(""))
    ((("]" "0"))(""))
    ((("]" "-"))(""))
    ((("]" "^"))(""))
    ((("]" "q"))(""))
    ((("]" "w"))(""))
    ((("]" "e"))(""))
    ((("]" "r"))(""))
    ((("]" "t"))(""))
    ((("]" "y"))(""))
    ((("]" "u"))(""))
    ((("]" "i"))(""))
    ((("]" "o"))(""))
    ((("]" "p"))(""))
    ((("]" "@"))(""))
    ((("]" "["))(""))
    ((("]" " "))(""))
    ((("]" "!"))(""))
    ((("]" "\""))(""))
    ((("]" "#"))(""))
    ((("]" "$"))(""))
    ((("]" "%"))(""))
    ((("]" "&"))(""))
    ((("]" "'"))(""))
    ((("]" "("))(""))
    ((("]" ")"))(""))
    ((("]" "|"))(""))
    ((("]" "="))(""))
    ((("]" "~"))(""))
    ((("]" "Q"))(""))
    ((("]" "W"))(""))
    ((("]" "E"))(""))
    ((("]" "R"))(""))
    ((("]" "T"))(""))
    ((("]" "Y"))(""))
    ((("]" "U"))(""))
    ((("]" "I"))(""))
    ((("]" "O"))(""))
    ((("]" "P"))(""))
    ((("]" "`"))(""))
    ((("]" "{"))(""))
    ((("z" "1"))("ǡ"))
    ((("z" "2"))("Ǣ"))
    ((("z" "3"))("ǣ"))
    ((("z" "4"))("Ǥ"))
    ((("z" "5"))("ǥ"))
    ((("z" "6"))("Ǧ"))
    ((("z" "7"))("ǧ"))
    ((("z" "8"))("Ǩ"))
    ((("z" "9"))("ǩ"))
    ((("z" "0"))("Ǫ"))
    ((("z" "-"))("ǫ"))
    ((("z" "^"))("Ǭ"))
    ((("z" "q"))("ǭ"))
    ((("z" "w"))("Ǯ"))
    ((("z" "e"))("ǯ"))
    ((("z" "r"))("ǰ"))
    ((("z" "t"))("Ǳ"))
    ((("z" "y"))("ǲ"))
    ((("z" "u"))("ǳ"))
    ((("z" "i"))("Ǵ"))
    ((("z" "o"))("ǵ"))
    ((("z" "p"))("Ƕ"))
    ((("z" "@"))("Ƿ"))
    ((("z" "["))("Ǹ"))
    ((("z" "a"))("ǹ"))
    ((("z" "s"))("Ǻ"))
    ((("z" "d"))("ǻ"))
    ((("z" "f"))("Ǽ"))
    ((("z" "g"))("ǽ"))
    ((("z" "h"))("Ǿ"))
    ((("z" "j"))("ǿ"))
    ((("z" "k"))(""))
    ((("z" "l"))(""))
    ((("z" ";"))(""))
    ((("z" ":"))(""))
    ((("z" "]"))(""))
    ((("z" "z"))(""))
    ((("z" "x"))(""))
    ((("z" "c"))(""))
    ((("z" "v"))(""))
    ((("z" "b"))(""))
    ((("z" "n"))(""))
    ((("z" "m"))(""))
    ((("z" ","))(""))
    ((("z" "."))(""))
    ((("z" "/"))(""))
    ((("z" "\\"))(""))
    ((("z" " "))(""))
    ((("z" "!"))(""))
    ((("z" "\""))(""))
    ((("z" "#"))(""))
    ((("z" "$"))(""))
    ((("z" "%"))(""))
    ((("z" "&"))(""))
    ((("z" "'"))(""))
    ((("z" "("))(""))
    ((("z" ")"))(""))
    ((("z" "|"))(""))
    ((("z" "="))(""))
    ((("z" "~"))(""))
    ((("z" "Q"))(""))
    ((("z" "W"))(""))
    ((("z" "E"))(""))
    ((("z" "R"))(""))
    ((("z" "T"))(""))
    ((("z" "Y"))(""))
    ((("z" "U"))(""))
    ((("z" "I"))(""))
    ((("z" "O"))(""))
    ((("z" "P"))(""))
    ((("z" "`"))(""))
    ((("z" "{"))(""))
    ((("z" "A"))(""))
    ((("z" "S"))(""))
    ((("z" "D"))(""))
    ((("z" "F"))(""))
    ((("z" "G"))(""))
    ((("z" "H"))(""))
    ((("z" "J"))(""))
    ((("z" "K"))(""))
    ((("z" "L"))(""))
    ((("z" "+"))(""))
    ((("z" "*"))(""))
    ((("z" "}"))(""))
    ((("z" "Z"))(""))
    ((("z" "X"))(""))
    ((("z" "C"))(""))
    ((("z" "V"))(""))
    ((("z" "B"))(""))
    ((("z" "N"))(""))
    ((("z" "M"))(""))
    ((("z" "<"))(""))
    ((("z" ">"))(""))
    ((("z" "?"))(""))
    ((("z" "_"))(""))
    ((("x" "1"))("ȡ"))
    ((("x" "2"))("Ȣ"))
    ((("x" "3"))("ȣ"))
    ((("x" "4"))("Ȥ"))
    ((("x" "5"))("ȥ"))
    ((("x" "6"))("Ȧ"))
    ((("x" "7"))("ȧ"))
    ((("x" "8"))("Ȩ"))
    ((("x" "9"))("ȩ"))
    ((("x" "0"))("Ȫ"))
    ((("x" "-"))("ȫ"))
    ((("x" "^"))("Ȭ"))
    ((("x" "q"))("ȭ"))
    ((("x" "w"))("Ȯ"))
    ((("x" "e"))("ȯ"))
    ((("x" "r"))("Ȱ"))
    ((("x" "t"))("ȱ"))
    ((("x" "y"))("Ȳ"))
    ((("x" "u"))("ȳ"))
    ((("x" "i"))("ȴ"))
    ((("x" "o"))("ȵ"))
    ((("x" "p"))("ȶ"))
    ((("x" "@"))("ȷ"))
    ((("x" "["))("ȸ"))
    ((("x" "a"))("ȹ"))
    ((("x" "s"))("Ⱥ"))
    ((("x" "d"))("Ȼ"))
    ((("x" "f"))("ȼ"))
    ((("x" "g"))("Ƚ"))
    ((("x" "h"))("Ⱦ"))
    ((("x" "j"))("ȿ"))
    ((("x" "k"))(""))
    ((("x" "l"))(""))
    ((("x" ";"))(""))
    ((("x" ":"))(""))
    ((("x" "]"))(""))
    ((("x" "z"))(""))
    ((("x" "x"))(""))
    ((("x" "c"))(""))
    ((("x" "v"))(""))
    ((("x" "b"))(""))
    ((("x" "n"))(""))
    ((("x" "m"))(""))
    ((("x" ","))(""))
    ((("x" "."))(""))
    ((("x" "/"))(""))
    ((("x" "\\"))(""))
    ((("x" " "))(""))
    ((("x" "!"))(""))
    ((("x" "\""))(""))
    ((("x" "#"))(""))
    ((("x" "$"))(""))
    ((("x" "%"))(""))
    ((("x" "&"))(""))
    ((("x" "'"))(""))
    ((("x" "("))(""))
    ((("x" ")"))(""))
    ((("x" "|"))(""))
    ((("x" "="))(""))
    ((("x" "~"))(""))
    ((("x" "Q"))(""))
    ((("x" "W"))(""))
    ((("x" "E"))(""))
    ((("x" "R"))(""))
    ((("x" "T"))(""))
    ((("x" "Y"))(""))
    ((("x" "U"))(""))
    ((("x" "I"))(""))
    ((("x" "O"))(""))
    ((("x" "P"))(""))
    ((("x" "`"))(""))
    ((("x" "{"))(""))
    ((("x" "A"))(""))
    ((("x" "S"))(""))
    ((("x" "D"))(""))
    ((("x" "F"))(""))
    ((("x" "G"))(""))
    ((("x" "H"))(""))
    ((("x" "J"))(""))
    ((("x" "K"))(""))
    ((("x" "L"))(""))
    ((("x" "+"))(""))
    ((("x" "*"))(""))
    ((("x" "}"))(""))
    ((("x" "Z"))(""))
    ((("x" "X"))(""))
    ((("x" "C"))(""))
    ((("x" "V"))(""))
    ((("x" "B"))(""))
    ((("x" "N"))(""))
    ((("x" "M"))(""))
    ((("x" "<"))(""))
    ((("x" ">"))(""))
    ((("x" "?"))(""))
    ((("x" "_"))(""))
    ((("c" "6"))(""))
    ((("c" "7"))(""))
    ((("c" "8"))(""))
    ((("c" "9"))(""))
    ((("c" "0"))(""))
    ((("c" "y"))(""))
    ((("c" "u"))(""))
    ((("c" "i"))(""))
    ((("c" "o"))(""))
    ((("c" "p"))(""))
    ((("c" "h"))(""))
    ((("c" "j"))(""))
    ((("c" "k"))(""))
    ((("c" "l"))(""))
    ((("c" ";"))(""))
    ((("c" " "))(""))
    ((("c" "Y"))(""))
    ((("c" "U"))(""))
    ((("c" "I"))(""))
    ((("c" "O"))(""))
    ((("c" "P"))(""))
    ((("c" "H"))(""))
    ((("c" "J"))(""))
    ((("c" "K"))(""))
    ((("c" "L"))(""))
    ((("c" "+"))(""))
    ((("v" "1"))("ɡ"))
    ((("v" "2"))("ɢ"))
    ((("v" "3"))("ɣ"))
    ((("v" "4"))("ɤ"))
    ((("v" "5"))("ɥ"))
    ((("v" "6"))("ɦ"))
    ((("v" "7"))("ɧ"))
    ((("v" "8"))("ɨ"))
    ((("v" "9"))("ɩ"))
    ((("v" "0"))("ɪ"))
    ((("v" "-"))("ɫ"))
    ((("v" "^"))("ɬ"))
    ((("v" "q"))("ɭ"))
    ((("v" "w"))("ɮ"))
    ((("v" "e"))("ɯ"))
    ((("v" "r"))("ɰ"))
    ((("v" "t"))("ɱ"))
    ((("v" "y"))("ɲ"))
    ((("v" "u"))("ɳ"))
    ((("v" "i"))("ɴ"))
    ((("v" "o"))("ɵ"))
    ((("v" "p"))("ɶ"))
    ((("v" "@"))("ɷ"))
    ((("v" "["))("ɸ"))
    ((("v" "a"))("ɹ"))
    ((("v" "s"))("ɺ"))
    ((("v" "d"))("ɻ"))
    ((("v" "f"))("ɼ"))
    ((("v" "g"))("ɽ"))
    ((("v" "h"))("ɾ"))
    ((("v" "j"))("ɿ"))
    ((("v" "k"))(""))
    ((("v" "l"))(""))
    ((("v" ";"))(""))
    ((("v" ":"))(""))
    ((("v" "]"))(""))
    ((("v" "z"))(""))
    ((("v" "x"))(""))
    ((("v" "c"))(""))
    ((("v" "v"))(""))
    ((("v" "b"))(""))
    ((("v" "n"))(""))
    ((("v" "m"))(""))
    ((("v" ","))(""))
    ((("v" "."))(""))
    ((("v" "/"))(""))
    ((("v" "\\"))(""))
    ((("v" " "))(""))
    ((("v" "!"))(""))
    ((("v" "\""))(""))
    ((("v" "#"))(""))
    ((("v" "$"))(""))
    ((("v" "%"))(""))
    ((("v" "&"))(""))
    ((("v" "'"))(""))
    ((("v" "("))(""))
    ((("v" ")"))(""))
    ((("v" "|"))(""))
    ((("v" "="))(""))
    ((("v" "~"))(""))
    ((("v" "Q"))(""))
    ((("v" "W"))(""))
    ((("v" "E"))(""))
    ((("v" "R"))(""))
    ((("v" "T"))(""))
    ((("v" "Y"))(""))
    ((("v" "U"))(""))
    ((("v" "I"))(""))
    ((("v" "O"))(""))
    ((("v" "P"))(""))
    ((("v" "`"))(""))
    ((("v" "{"))(""))
    ((("v" "A"))(""))
    ((("v" "S"))(""))
    ((("v" "D"))(""))
    ((("v" "F"))(""))
    ((("v" "G"))(""))
    ((("v" "H"))(""))
    ((("v" "J"))(""))
    ((("v" "K"))(""))
    ((("v" "L"))(""))
    ((("v" "+"))(""))
    ((("v" "*"))(""))
    ((("v" "}"))(""))
    ((("v" "Z"))(""))
    ((("v" "X"))(""))
    ((("v" "C"))(""))
    ((("v" "V"))(""))
    ((("v" "B"))(""))
    ((("v" "N"))(""))
    ((("v" "M"))(""))
    ((("v" "<"))(""))
    ((("v" ">"))(""))
    ((("v" "?"))(""))
    ((("v" "_"))(""))
    ((("b" "1"))("ʡ"))
    ((("b" "2"))("ʢ"))
    ((("b" "3"))("ʣ"))
    ((("b" "4"))("ʤ"))
    ((("b" "5"))("ʥ"))
    ((("b" "6"))("ʦ"))
    ((("b" "7"))("ʧ"))
    ((("b" "8"))("ʨ"))
    ((("b" "9"))("ʩ"))
    ((("b" "0"))("ʪ"))
    ((("b" "-"))("ʫ"))
    ((("b" "^"))("ʬ"))
    ((("b" "q"))("ʭ"))
    ((("b" "w"))("ʮ"))
    ((("b" "e"))("ʯ"))
    ((("b" "r"))("ʰ"))
    ((("b" "t"))("ʱ"))
    ((("b" "y"))("ʲ"))
    ((("b" "u"))("ʳ"))
    ((("b" "i"))("ʴ"))
    ((("b" "o"))("ʵ"))
    ((("b" "p"))("ʶ"))
    ((("b" "@"))("ʷ"))
    ((("b" "["))("ʸ"))
    ((("b" "a"))("ʹ"))
    ((("b" "s"))("ʺ"))
    ((("b" "d"))("ʻ"))
    ((("b" "f"))("ʼ"))
    ((("b" "g"))("ʽ"))
    ((("b" "h"))("ʾ"))
    ((("b" "j"))("ʿ"))
    ((("b" "k"))(""))
    ((("b" "l"))(""))
    ((("b" ";"))(""))
    ((("b" ":"))(""))
    ((("b" "]"))(""))
    ((("b" "z"))(""))
    ((("b" "x"))(""))
    ((("b" "c"))(""))
    ((("b" "v"))(""))
    ((("b" "b"))(""))
    ((("b" "n"))(""))
    ((("b" "m"))(""))
    ((("b" ","))(""))
    ((("b" "."))(""))
    ((("b" "/"))(""))
    ((("b" "\\"))(""))
    ((("b" " "))(""))
    ((("b" "!"))(""))
    ((("b" "\""))(""))
    ((("b" "#"))(""))
    ((("b" "$"))(""))
    ((("b" "%"))(""))
    ((("b" "&"))(""))
    ((("b" "'"))(""))
    ((("b" "("))(""))
    ((("b" ")"))(""))
    ((("b" "|"))(""))
    ((("b" "="))(""))
    ((("b" "~"))(""))
    ((("b" "Q"))(""))
    ((("b" "W"))(""))
    ((("b" "E"))(""))
    ((("b" "R"))(""))
    ((("b" "T"))(""))
    ((("b" "Y"))(""))
    ((("b" "U"))(""))
    ((("b" "I"))(""))
    ((("b" "O"))(""))
    ((("b" "P"))(""))
    ((("b" "`"))(""))
    ((("b" "{"))(""))
    ((("b" "A"))(""))
    ((("b" "S"))(""))
    ((("b" "D"))(""))
    ((("b" "F"))(""))
    ((("b" "G"))(""))
    ((("b" "H"))(""))
    ((("b" "J"))(""))
    ((("b" "K"))(""))
    ((("b" "L"))(""))
    ((("b" "+"))(""))
    ((("b" "*"))(""))
    ((("b" "}"))(""))
    ((("b" "Z"))(""))
    ((("b" "X"))(""))
    ((("b" "C"))(""))
    ((("b" "V"))(""))
    ((("b" "B"))(""))
    ((("b" "N"))(""))
    ((("b" "M"))(""))
    ((("b" "<"))(""))
    ((("b" ">"))(""))
    ((("b" "?"))(""))
    ((("b" "_"))(""))
    ((("n" "1"))("ˡ"))
    ((("n" "2"))("ˢ"))
    ((("n" "3"))("ˣ"))
    ((("n" "4"))("ˤ"))
    ((("n" "5"))("˥"))
    ((("n" "6"))("˦"))
    ((("n" "7"))("˧"))
    ((("n" "8"))("˨"))
    ((("n" "9"))("˩"))
    ((("n" "0"))("˪"))
    ((("n" "-"))("˫"))
    ((("n" "^"))("ˬ"))
    ((("n" "q"))("˭"))
    ((("n" "w"))("ˮ"))
    ((("n" "e"))("˯"))
    ((("n" "r"))("˰"))
    ((("n" "t"))("˱"))
    ((("n" "y"))("˲"))
    ((("n" "u"))("˳"))
    ((("n" "i"))("˴"))
    ((("n" "o"))("˵"))
    ((("n" "p"))("˶"))
    ((("n" "@"))("˷"))
    ((("n" "["))("˸"))
    ((("n" "a"))("˹"))
    ((("n" "s"))("˺"))
    ((("n" "d"))("˻"))
    ((("n" "f"))("˼"))
    ((("n" "g"))("˽"))
    ((("n" "h"))("˾"))
    ((("n" "j"))("˿"))
    ((("n" "k"))(""))
    ((("n" "l"))(""))
    ((("n" ";"))(""))
    ((("n" ":"))(""))
    ((("n" "]"))(""))
    ((("n" "z"))(""))
    ((("n" "x"))(""))
    ((("n" "c"))(""))
    ((("n" "v"))(""))
    ((("n" "b"))(""))
    ((("n" "n"))(""))
    ((("n" "m"))(""))
    ((("n" ","))(""))
    ((("n" "."))(""))
    ((("n" "/"))(""))
    ((("n" "\\"))(""))
    ((("n" " "))(""))
    ((("n" "!"))(""))
    ((("n" "\""))(""))
    ((("n" "#"))(""))
    ((("n" "$"))(""))
    ((("n" "%"))(""))
    ((("n" "&"))(""))
    ((("n" "'"))(""))
    ((("n" "("))(""))
    ((("n" ")"))(""))
    ((("n" "|"))(""))
    ((("n" "="))(""))
    ((("n" "~"))(""))
    ((("n" "Q"))(""))
    ((("n" "W"))(""))
    ((("n" "E"))(""))
    ((("n" "R"))(""))
    ((("n" "T"))(""))
    ((("n" "Y"))(""))
    ((("n" "U"))(""))
    ((("n" "I"))(""))
    ((("n" "O"))(""))
    ((("n" "P"))(""))
    ((("n" "`"))(""))
    ((("n" "{"))(""))
    ((("n" "A"))(""))
    ((("n" "S"))(""))
    ((("n" "D"))(""))
    ((("n" "F"))(""))
    ((("n" "G"))(""))
    ((("n" "H"))(""))
    ((("n" "J"))(""))
    ((("n" "K"))(""))
    ((("n" "L"))(""))
    ((("n" "+"))(""))
    ((("n" "*"))(""))
    ((("n" "}"))(""))
    ((("n" "Z"))(""))
    ((("n" "X"))(""))
    ((("n" "C"))(""))
    ((("n" "V"))(""))
    ((("n" "B"))(""))
    ((("n" "N"))(""))
    ((("n" "M"))(""))
    ((("n" "<"))(""))
    ((("n" ">"))(""))
    ((("n" "?"))(""))
    ((("n" "_"))(""))
    ((("m" "1"))("̡"))
    ((("m" "2"))("̢"))
    ((("m" "3"))("̣"))
    ((("m" "4"))("̤"))
    ((("m" "5"))("̥"))
    ((("m" "6"))("̦"))
    ((("m" "7"))("̧"))
    ((("m" "8"))("̨"))
    ((("m" "9"))("̩"))
    ((("m" "0"))("̪"))
    ((("m" "-"))("̫"))
    ((("m" "^"))("̬"))
    ((("m" "q"))("̭"))
    ((("m" "w"))("̮"))
    ((("m" "e"))("̯"))
    ((("m" "r"))("̰"))
    ((("m" "t"))("̱"))
    ((("m" "y"))("̲"))
    ((("m" "u"))("̳"))
    ((("m" "i"))("̴"))
    ((("m" "o"))("̵"))
    ((("m" "p"))("̶"))
    ((("m" "@"))("̷"))
    ((("m" "["))("̸"))
    ((("m" "a"))("̹"))
    ((("m" "s"))("̺"))
    ((("m" "d"))("̻"))
    ((("m" "f"))("̼"))
    ((("m" "g"))("̽"))
    ((("m" "h"))("̾"))
    ((("m" "j"))("̿"))
    ((("m" "k"))(""))
    ((("m" "l"))(""))
    ((("m" ";"))(""))
    ((("m" ":"))(""))
    ((("m" "]"))(""))
    ((("m" "z"))(""))
    ((("m" "x"))(""))
    ((("m" "c"))(""))
    ((("m" "v"))(""))
    ((("m" "b"))(""))
    ((("m" "n"))(""))
    ((("m" "m"))(""))
    ((("m" ","))(""))
    ((("m" "."))(""))
    ((("m" "/"))(""))
    ((("m" "\\"))(""))
    ((("m" " "))(""))
    ((("m" "!"))(""))
    ((("m" "\""))(""))
    ((("m" "#"))(""))
    ((("m" "$"))(""))
    ((("m" "%"))(""))
    ((("m" "&"))(""))
    ((("m" "'"))(""))
    ((("m" "("))(""))
    ((("m" ")"))(""))
    ((("m" "|"))(""))
    ((("m" "="))(""))
    ((("m" "~"))(""))
    ((("m" "Q"))(""))
    ((("m" "W"))(""))
    ((("m" "E"))(""))
    ((("m" "R"))(""))
    ((("m" "T"))(""))
    ((("m" "Y"))(""))
    ((("m" "U"))(""))
    ((("m" "I"))(""))
    ((("m" "O"))(""))
    ((("m" "P"))(""))
    ((("m" "`"))(""))
    ((("m" "{"))(""))
    ((("m" "A"))(""))
    ((("m" "S"))(""))
    ((("m" "D"))(""))
    ((("m" "F"))(""))
    ((("m" "G"))(""))
    ((("m" "H"))(""))
    ((("m" "J"))(""))
    ((("m" "K"))(""))
    ((("m" "L"))(""))
    ((("m" "+"))(""))
    ((("m" "*"))(""))
    ((("m" "}"))(""))
    ((("m" "Z"))(""))
    ((("m" "X"))(""))
    ((("m" "C"))(""))
    ((("m" "V"))(""))
    ((("m" "B"))(""))
    ((("m" "N"))(""))
    ((("m" "M"))(""))
    ((("m" "<"))(""))
    ((("m" ">"))(""))
    ((("m" "?"))(""))
    ((("m" "_"))(""))
    ((("," "1"))("͡"))
    ((("," "2"))("͢"))
    ((("," "3"))("ͣ"))
    ((("," "4"))("ͤ"))
    ((("," "5"))("ͥ"))
    ((("," "6"))("ͦ"))
    ((("," "7"))("ͧ"))
    ((("," "8"))("ͨ"))
    ((("," "9"))("ͩ"))
    ((("," "0"))("ͪ"))
    ((("," "-"))("ͫ"))
    ((("," "^"))("ͬ"))
    ((("," "q"))("ͭ"))
    ((("," "w"))("ͮ"))
    ((("," "e"))("ͯ"))
    ((("," "r"))("Ͱ"))
    ((("," "t"))("ͱ"))
    ((("," "y"))("Ͳ"))
    ((("," "u"))("ͳ"))
    ((("," "i"))("ʹ"))
    ((("," "o"))("͵"))
    ((("," "p"))("Ͷ"))
    ((("," "@"))("ͷ"))
    ((("," "["))("͸"))
    ((("," "a"))("͹"))
    ((("," "s"))("ͺ"))
    ((("," "d"))("ͻ"))
    ((("," "f"))("ͼ"))
    ((("," "g"))("ͽ"))
    ((("," "h"))(";"))
    ((("," "j"))("Ϳ"))
    ((("," "k"))(""))
    ((("," "l"))(""))
    ((("," ";"))(""))
    ((("," ":"))(""))
    ((("," "]"))(""))
    ((("," "z"))(""))
    ((("," "x"))(""))
    ((("," "c"))(""))
    ((("," "v"))(""))
    ((("," "b"))(""))
    ((("," "n"))(""))
    ((("," "m"))(""))
    ((("," ","))(""))
    ((("," "."))(""))
    ((("," "/"))(""))
    ((("," "\\"))(""))
    ((("," " "))(""))
    ((("," "!"))(""))
    ((("," "\""))(""))
    ((("," "#"))(""))
    ((("," "$"))(""))
    ((("," "%"))(""))
    ((("," "&"))(""))
    ((("," "'"))(""))
    ((("," "("))(""))
    ((("," ")"))(""))
    ((("," "|"))(""))
    ((("," "="))(""))
    ((("," "~"))(""))
    ((("," "Q"))(""))
    ((("," "W"))(""))
    ((("," "E"))(""))
    ((("," "R"))(""))
    ((("," "T"))(""))
    ((("," "Y"))(""))
    ((("," "U"))(""))
    ((("," "I"))(""))
    ((("," "O"))(""))
    ((("," "P"))(""))
    ((("," "`"))(""))
    ((("," "{"))(""))
    ((("," "A"))(""))
    ((("," "S"))(""))
    ((("," "D"))(""))
    ((("," "F"))(""))
    ((("," "G"))(""))
    ((("," "H"))(""))
    ((("," "J"))(""))
    ((("," "K"))(""))
    ((("," "L"))(""))
    ((("," "+"))(""))
    ((("," "*"))(""))
    ((("," "}"))(""))
    ((("," "Z"))(""))
    ((("," "X"))(""))
    ((("," "C"))(""))
    ((("," "V"))(""))
    ((("," "B"))(""))
    ((("," "N"))(""))
    ((("," "M"))(""))
    ((("," "<"))(""))
    ((("," ">"))(""))
    ((("," "?"))(""))
    ((("," "_"))(""))
    ((("." "1"))("Ρ"))
    ((("." "2"))("΢"))
    ((("." "3"))("Σ"))
    ((("." "4"))("Τ"))
    ((("." "5"))("Υ"))
    ((("." "6"))("Φ"))
    ((("." "7"))("Χ"))
    ((("." "8"))("Ψ"))
    ((("." "9"))("Ω"))
    ((("." "0"))("Ϊ"))
    ((("." "-"))("Ϋ"))
    ((("." "^"))("ά"))
    ((("." "q"))("έ"))
    ((("." "w"))("ή"))
    ((("." "e"))("ί"))
    ((("." "r"))("ΰ"))
    ((("." "t"))("α"))
    ((("." "y"))("β"))
    ((("." "u"))("γ"))
    ((("." "i"))("δ"))
    ((("." "o"))("ε"))
    ((("." "p"))("ζ"))
    ((("." "@"))("η"))
    ((("." "["))("θ"))
    ((("." "a"))("ι"))
    ((("." "s"))("κ"))
    ((("." "d"))("λ"))
    ((("." "f"))("μ"))
    ((("." "g"))("ν"))
    ((("." "h"))("ξ"))
    ((("." "j"))("ο"))
    ((("." "k"))(""))
    ((("." "l"))(""))
    ((("." ";"))(""))
    ((("." ":"))(""))
    ((("." "]"))(""))
    ((("." "z"))(""))
    ((("." "x"))(""))
    ((("." "c"))(""))
    ((("." "v"))(""))
    ((("." "b"))(""))
    ((("." "n"))(""))
    ((("." "m"))(""))
    ((("." ","))(""))
    ((("." "."))(""))
    ((("." "/"))(""))
    ((("." "\\"))(""))
    ((("." " "))(""))
    ((("." "!"))(""))
    ((("." "\""))(""))
    ((("." "#"))(""))
    ((("." "$"))(""))
    ((("." "%"))(""))
    ((("." "&"))(""))
    ((("." "'"))(""))
    ((("." "("))(""))
    ((("." ")"))(""))
    ((("." "|"))(""))
    ((("." "="))(""))
    ((("." "~"))(""))
    ((("." "Q"))(""))
    ((("." "W"))(""))
    ((("." "E"))(""))
    ((("." "R"))(""))
    ((("." "T"))(""))
    ((("." "Y"))(""))
    ((("." "U"))(""))
    ((("." "I"))(""))
    ((("." "O"))(""))
    ((("." "P"))(""))
    ((("." "`"))(""))
    ((("." "{"))(""))
    ((("." "A"))(""))
    ((("." "S"))(""))
    ((("." "D"))(""))
    ((("." "F"))(""))
    ((("." "G"))(""))
    ((("." "H"))(""))
    ((("." "J"))(""))
    ((("." "K"))(""))
    ((("." "L"))(""))
    ((("." "+"))(""))
    ((("." "*"))(""))
    ((("." "}"))(""))
    ((("." "Z"))(""))
    ((("." "X"))(""))
    ((("." "C"))(""))
    ((("." "V"))(""))
    ((("." "B"))(""))
    ((("." "N"))(""))
    ((("." "M"))(""))
    ((("." "<"))(""))
    ((("." ">"))(""))
    ((("." "?"))(""))
    ((("." "_"))(""))
    ((("/" "1"))("ϡ"))
    ((("/" "2"))("Ϣ"))
    ((("/" "3"))("ϣ"))
    ((("/" "4"))("Ϥ"))
    ((("/" "5"))("ϥ"))
    ((("/" "6"))("Ϧ"))
    ((("/" "7"))("ϧ"))
    ((("/" "8"))("Ϩ"))
    ((("/" "9"))("ϩ"))
    ((("/" "0"))("Ϫ"))
    ((("/" "-"))("ϫ"))
    ((("/" "^"))("Ϭ"))
    ((("/" "q"))("ϭ"))
    ((("/" "w"))("Ϯ"))
    ((("/" "e"))("ϯ"))
    ((("/" "r"))("ϰ"))
    ((("/" "t"))("ϱ"))
    ((("/" "y"))("ϲ"))
    ((("/" "u"))("ϳ"))
    ((("/" "i"))("ϴ"))
    ((("/" "o"))("ϵ"))
    ((("/" "p"))("϶"))
    ((("/" "@"))("Ϸ"))
    ((("/" "["))("ϸ"))
    ((("/" "a"))("Ϲ"))
    ((("/" "s"))("Ϻ"))
    ((("/" "d"))("ϻ"))
    ((("/" "f"))("ϼ"))
    ((("/" "g"))("Ͻ"))
    ((("/" "h"))("Ͼ"))
    ((("/" "j"))("Ͽ"))
    ((("/" "k"))(""))
    ((("/" "l"))(""))
    ((("/" ";"))(""))
    ((("/" ":"))(""))
    ((("/" "]"))(""))
    ((("/" "z"))(""))
    ((("/" "x"))(""))
    ((("/" "c"))(""))
    ((("/" "v"))(""))
    ((("/" "b"))(""))
    ((("/" "n"))(""))
    ((("/" "m"))(""))
    ((("/" ","))(""))
    ((("/" "."))(""))
    ((("/" "/"))(""))
    ((("/" "\\"))(""))
    ((("/" " "))(""))
    ((("/" "!"))(""))
    ((("/" "\""))(""))
    ((("/" "#"))(""))
    ((("/" "$"))(""))
    ((("\\" "1"))(""))
    ((("\\" "2"))(""))
    ((("\\" "3"))(""))
    ((("\\" "4"))(""))
    ((("\\" "5"))(""))
    ((("\\" "6"))(""))
    ((("\\" "7"))(""))
    ((("\\" "8"))(""))
    ((("\\" "9"))(""))
    ((("\\" "0"))(""))
    ((("\\" "-"))(""))
    ((("\\" "^"))(""))
    ((("\\" "q"))(""))
    ((("\\" "w"))(""))
    ((("\\" "e"))(""))
    ((("\\" "r"))(""))
    ((("\\" "t"))(""))
    ((("\\" "y"))(""))
    ((("\\" "u"))(""))
    ((("\\" "i"))(""))
    ((("\\" "o"))(""))
    ((("\\" "p"))(""))
    ((("\\" "@"))(""))
    ((("\\" "["))(""))
    ((("\\" "a"))(""))
    ((("\\" "s"))(""))
    ((("\\" "d"))(""))
    ((("\\" "f"))(""))
    ((("\\" "g"))(""))
    ((("\\" "h"))(""))
    ((("\\" "j"))(""))
    ((("\\" "k"))(""))
    ((("\\" "l"))(""))
    ((("\\" " "))(""))
    ((("\\" "!"))(""))
    ((("\\" "\""))(""))
    ((("\\" "#"))(""))
    ((("\\" "$"))(""))
    ((("\\" "%"))(""))
    ((("\\" "&"))(""))
    ((("\\" "'"))(""))
    ((("\\" "("))(""))
    ((("\\" ")"))(""))
    ((("\\" "|"))(""))
    ((("\\" "="))(""))
    ((("\\" "~"))(""))
    ((("\\" "Q"))(""))
    ((("\\" "W"))(""))
    ((("\\" "E"))(""))
    ((("\\" "R"))(""))
    ((("\\" "T"))(""))
    ((("\\" "Y"))(""))
    ((("\\" "U"))(""))
    ((("\\" "I"))(""))
    ((("\\" "O"))(""))
    ((("\\" "P"))(""))
    ((("\\" "`"))(""))
    ((("\\" "{"))(""))
    ((("\\" "A"))(""))
    ((("\\" "S"))(""))
    ((("\\" "D"))(""))
    ((("\\" "F"))(""))
    ((("\\" "G"))(""))
    ((("\\" "H"))(""))
    ((("\\" "J"))(""))
    ((("\\" "K"))(""))
    ((("\\" "L"))(""))
    (((" " "1"))(""))
    (((" " "2"))(""))
    (((" " "6"))(""))
    (((" " "7"))(""))
    (((" " "8"))(""))
    (((" " "9"))(""))
    (((" " "0"))(""))
    (((" " "-"))(""))
    (((" " "^"))(""))
    (((" " "q"))(""))
    (((" " "w"))(""))
    (((" " "e"))(""))
    (((" " "r"))(""))
    (((" " "y"))(""))
    (((" " "u"))(""))
    (((" " "i"))(""))
    (((" " "o"))(""))
    (((" " "p"))(""))
    (((" " "@"))(""))
    (((" " "["))(""))
    (((" " "a"))(""))
    (((" " "s"))(""))
    (((" " "h"))(""))
    (((" " "j"))(""))
    (((" " "k"))(""))
    (((" " "l"))(""))
    (((" " ";"))(""))
    (((" " ":"))(""))
    (((" " "z"))(""))
    (((" " "x"))(""))
    (((" " "c"))(""))
    (((" " "v"))(""))
    (((" " "b"))(""))
    (((" " "n"))(""))
    (((" " "m"))(""))
    (((" " ","))(""))
    (((" " "."))(""))
    (((" " "/"))(""))
    (((" " " "))(""))
    (((" " "&"))(""))
    (((" " "'"))(""))
    (((" " "("))(""))
    (((" " ")"))(""))
    (((" " "|"))(""))
    (((" " "="))(""))
    (((" " "~"))(""))
    (((" " "Y"))(""))
    (((" " "U"))(""))
    (((" " "I"))(""))
    (((" " "O"))(""))
    (((" " "P"))(""))
    (((" " "`"))(""))
    (((" " "{"))(""))
    (((" " "H"))(""))
    (((" " "J"))(""))
    (((" " "K"))(""))
    (((" " "L"))(""))
    (((" " "+"))(""))
    (((" " "*"))(""))
    (((" " "Z"))(""))
    (((" " "X"))(""))
    (((" " "C"))(""))
    (((" " "V"))(""))
    (((" " "B"))(""))
    (((" " "N"))(""))
    (((" " "M"))(""))
    (((" " "<"))(""))
    (((" " ">"))(""))
    (((" " "?"))(""))
    ((("!" "1"))("С"))
    ((("!" "2"))("Т"))
    ((("!" "3"))("У"))
    ((("!" "4"))("Ф"))
    ((("!" "5"))("Х"))
    ((("!" "6"))("Ц"))
    ((("!" "7"))("Ч"))
    ((("!" "8"))("Ш"))
    ((("!" "9"))("Щ"))
    ((("!" "0"))("Ъ"))
    ((("!" "-"))("Ы"))
    ((("!" "^"))("Ь"))
    ((("!" "q"))("Э"))
    ((("!" "w"))("Ю"))
    ((("!" "e"))("Я"))
    ((("!" "r"))("а"))
    ((("!" "t"))("б"))
    ((("!" "y"))("в"))
    ((("!" "u"))("г"))
    ((("!" "i"))("д"))
    ((("!" "o"))("е"))
    ((("!" "p"))("ж"))
    ((("!" "@"))("з"))
    ((("!" "["))("и"))
    ((("!" "a"))("й"))
    ((("!" "s"))("к"))
    ((("!" "d"))("л"))
    ((("!" "f"))("м"))
    ((("!" "g"))("н"))
    ((("!" "h"))("о"))
    ((("!" "j"))("п"))
    ((("!" "k"))(""))
    ((("!" "l"))(""))
    ((("!" ";"))(""))
    ((("!" ":"))(""))
    ((("!" "]"))(""))
    ((("!" "z"))(""))
    ((("!" "x"))(""))
    ((("!" "c"))(""))
    ((("!" "v"))(""))
    ((("!" "b"))(""))
    ((("!" "n"))(""))
    ((("!" "m"))(""))
    ((("!" ","))(""))
    ((("!" "."))(""))
    ((("!" "/"))(""))
    ((("!" "\\"))(""))
    ((("!" "!"))(""))
    ((("!" "\""))(""))
    ((("!" "#"))(""))
    ((("!" "$"))(""))
    ((("!" "%"))(""))
    ((("!" "&"))(""))
    ((("!" "'"))(""))
    ((("!" "("))(""))
    ((("!" ")"))(""))
    ((("!" "|"))(""))
    ((("!" "="))(""))
    ((("!" "~"))(""))
    ((("!" "Q"))(""))
    ((("!" "W"))(""))
    ((("!" "E"))(""))
    ((("!" "R"))(""))
    ((("!" "T"))(""))
    ((("!" "Y"))(""))
    ((("!" "U"))(""))
    ((("!" "I"))(""))
    ((("!" "O"))(""))
    ((("!" "P"))(""))
    ((("!" "`"))(""))
    ((("!" "{"))(""))
    ((("!" "A"))(""))
    ((("!" "S"))(""))
    ((("!" "D"))(""))
    ((("!" "F"))(""))
    ((("!" "G"))(""))
    ((("!" "H"))(""))
    ((("!" "J"))(""))
    ((("!" "K"))(""))
    ((("!" "L"))(""))
    ((("!" "+"))(""))
    ((("!" "*"))(""))
    ((("!" "}"))(""))
    ((("!" "Z"))(""))
    ((("!" "X"))(""))
    ((("!" "C"))(""))
    ((("!" "V"))(""))
    ((("!" "B"))(""))
    ((("!" "N"))(""))
    ((("!" "M"))(""))
    ((("!" "<"))(""))
    ((("!" ">"))(""))
    ((("!" "?"))(""))
    ((("!" "_"))(""))
    ((("!" " "))(""))
    ((("\"" "1"))("ѡ"))
    ((("\"" "2"))("Ѣ"))
    ((("\"" "3"))("ѣ"))
    ((("\"" "4"))("Ѥ"))
    ((("\"" "5"))("ѥ"))
    ((("\"" "6"))("Ѧ"))
    ((("\"" "7"))("ѧ"))
    ((("\"" "8"))("Ѩ"))
    ((("\"" "9"))("ѩ"))
    ((("\"" "0"))("Ѫ"))
    ((("\"" "-"))("ѫ"))
    ((("\"" "^"))("Ѭ"))
    ((("\"" "q"))("ѭ"))
    ((("\"" "w"))("Ѯ"))
    ((("\"" "e"))("ѯ"))
    ((("\"" "r"))("Ѱ"))
    ((("\"" "t"))("ѱ"))
    ((("\"" "y"))("Ѳ"))
    ((("\"" "u"))("ѳ"))
    ((("\"" "i"))("Ѵ"))
    ((("\"" "o"))("ѵ"))
    ((("\"" "p"))("Ѷ"))
    ((("\"" "@"))("ѷ"))
    ((("\"" "["))("Ѹ"))
    ((("\"" "a"))("ѹ"))
    ((("\"" "s"))("Ѻ"))
    ((("\"" "d"))("ѻ"))
    ((("\"" "f"))("Ѽ"))
    ((("\"" "g"))("ѽ"))
    ((("\"" "h"))("Ѿ"))
    ((("\"" "j"))("ѿ"))
    ((("\"" "k"))(""))
    ((("\"" "l"))(""))
    ((("\"" ";"))(""))
    ((("\"" ":"))(""))
    ((("\"" "]"))(""))
    ((("\"" "z"))(""))
    ((("\"" "x"))(""))
    ((("\"" "c"))(""))
    ((("\"" "v"))(""))
    ((("\"" "b"))(""))
    ((("\"" "n"))(""))
    ((("\"" "m"))(""))
    ((("\"" ","))(""))
    ((("\"" "."))(""))
    ((("\"" "/"))(""))
    ((("\"" "\\"))(""))
    ((("\"" "!"))(""))
    ((("\"" "\""))(""))
    ((("\"" "#"))(""))
    ((("\"" "$"))(""))
    ((("\"" "%"))(""))
    ((("\"" "&"))(""))
    ((("\"" "'"))(""))
    ((("\"" "("))(""))
    ((("\"" ")"))(""))
    ((("\"" "|"))(""))
    ((("\"" "="))(""))
    ((("\"" "~"))(""))
    ((("\"" "Q"))(""))
    ((("\"" "W"))(""))
    ((("\"" "E"))(""))
    ((("\"" "R"))(""))
    ((("\"" "T"))(""))
    ((("\"" "Y"))(""))
    ((("\"" "U"))(""))
    ((("\"" "I"))(""))
    ((("\"" "O"))(""))
    ((("\"" "P"))(""))
    ((("\"" "`"))(""))
    ((("\"" "{"))(""))
    ((("\"" "A"))(""))
    ((("\"" "S"))(""))
    ((("\"" "D"))(""))
    ((("\"" "F"))(""))
    ((("\"" "G"))(""))
    ((("\"" "H"))(""))
    ((("\"" "J"))(""))
    ((("\"" "K"))(""))
    ((("\"" "L"))(""))
    ((("\"" "+"))(""))
    ((("\"" "*"))(""))
    ((("\"" "}"))(""))
    ((("\"" "Z"))(""))
    ((("\"" "X"))(""))
    ((("\"" "C"))(""))
    ((("\"" "V"))(""))
    ((("\"" "B"))(""))
    ((("\"" "N"))(""))
    ((("\"" "M"))(""))
    ((("\"" "<"))(""))
    ((("\"" ">"))(""))
    ((("\"" "?"))(""))
    ((("\"" "_"))(""))
    ((("\"" " "))(""))
    ((("#" "1"))("ҡ"))
    ((("#" "2"))("Ң"))
    ((("#" "3"))("ң"))
    ((("#" "4"))("Ҥ"))
    ((("#" "5"))("ҥ"))
    ((("#" "6"))("Ҧ"))
    ((("#" "7"))("ҧ"))
    ((("#" "8"))("Ҩ"))
    ((("#" "9"))("ҩ"))
    ((("#" "0"))("Ҫ"))
    ((("#" "-"))("ҫ"))
    ((("#" "^"))("Ҭ"))
    ((("#" "q"))("ҭ"))
    ((("#" "w"))("Ү"))
    ((("#" "e"))("ү"))
    ((("#" "r"))("Ұ"))
    ((("#" "t"))("ұ"))
    ((("#" "y"))("Ҳ"))
    ((("#" "u"))("ҳ"))
    ((("#" "i"))("Ҵ"))
    ((("#" "o"))("ҵ"))
    ((("#" "p"))("Ҷ"))
    ((("#" "@"))("ҷ"))
    ((("#" "["))("Ҹ"))
    ((("#" "a"))("ҹ"))
    ((("#" "s"))("Һ"))
    ((("#" "d"))("һ"))
    ((("#" "f"))("Ҽ"))
    ((("#" "g"))("ҽ"))
    ((("#" "h"))("Ҿ"))
    ((("#" "j"))("ҿ"))
    ((("#" "k"))(""))
    ((("#" "l"))(""))
    ((("#" ";"))(""))
    ((("#" ":"))(""))
    ((("#" "]"))(""))
    ((("#" "z"))(""))
    ((("#" "x"))(""))
    ((("#" "c"))(""))
    ((("#" "v"))(""))
    ((("#" "b"))(""))
    ((("#" "n"))(""))
    ((("#" "m"))(""))
    ((("#" ","))(""))
    ((("#" "."))(""))
    ((("#" "/"))(""))
    ((("#" "\\"))(""))
    ((("#" "!"))(""))
    ((("#" "\""))(""))
    ((("#" "#"))(""))
    ((("#" "$"))(""))
    ((("#" "%"))(""))
    ((("#" "&"))(""))
    ((("#" "'"))(""))
    ((("#" "("))(""))
    ((("#" ")"))(""))
    ((("#" "|"))(""))
    ((("#" "="))(""))
    ((("#" "~"))(""))
    ((("#" "Q"))(""))
    ((("#" "W"))(""))
    ((("#" "E"))(""))
    ((("#" "R"))(""))
    ((("#" "T"))(""))
    ((("#" "Y"))(""))
    ((("#" "U"))(""))
    ((("#" "I"))(""))
    ((("#" "O"))(""))
    ((("#" "P"))(""))
    ((("#" "`"))(""))
    ((("#" "{"))(""))
    ((("#" "A"))(""))
    ((("#" "S"))(""))
    ((("#" "D"))(""))
    ((("#" "F"))(""))
    ((("#" "G"))(""))
    ((("#" "H"))(""))
    ((("#" "J"))(""))
    ((("#" "K"))(""))
    ((("#" "L"))(""))
    ((("#" "+"))(""))
    ((("#" "*"))(""))
    ((("#" "}"))(""))
    ((("#" "Z"))(""))
    ((("#" "X"))(""))
    ((("#" "C"))(""))
    ((("#" "V"))(""))
    ((("#" "B"))(""))
    ((("#" "N"))(""))
    ((("#" "M"))(""))
    ((("#" "<"))(""))
    ((("#" ">"))(""))
    ((("#" "?"))(""))
    ((("#" "_"))(""))
    ((("#" " "))(""))
    ((("$" "1"))("ӡ"))
    ((("$" "2"))("Ӣ"))
    ((("$" "3"))("ӣ"))
    ((("$" "4"))("Ӥ"))
    ((("$" "5"))("ӥ"))
    ((("$" "6"))("Ӧ"))
    ((("$" "7"))("ӧ"))
    ((("$" "8"))("Ө"))
    ((("$" "9"))("ө"))
    ((("$" "0"))("Ӫ"))
    ((("$" "-"))("ӫ"))
    ((("$" "^"))("Ӭ"))
    ((("$" "q"))("ӭ"))
    ((("$" "w"))("Ӯ"))
    ((("$" "e"))("ӯ"))
    ((("$" "r"))("Ӱ"))
    ((("$" "t"))("ӱ"))
    ((("$" "y"))("Ӳ"))
    ((("$" "u"))("ӳ"))
    ((("$" "i"))("Ӵ"))
    ((("$" "o"))("ӵ"))
    ((("$" "p"))("Ӷ"))
    ((("$" "@"))("ӷ"))
    ((("$" "["))("Ӹ"))
    ((("$" "a"))("ӹ"))
    ((("$" "s"))("Ӻ"))
    ((("$" "d"))("ӻ"))
    ((("$" "f"))("Ӽ"))
    ((("$" "g"))("ӽ"))
    ((("$" "h"))("Ӿ"))
    ((("$" "j"))("ӿ"))
    ((("$" "k"))(""))
    ((("$" "l"))(""))
    ((("$" ";"))(""))
    ((("$" ":"))(""))
    ((("$" "]"))(""))
    ((("$" "z"))(""))
    ((("$" "x"))(""))
    ((("$" "c"))(""))
    ((("$" "v"))(""))
    ((("$" "b"))(""))
    ((("$" "n"))(""))
    ((("$" "m"))(""))
    ((("$" ","))(""))
    ((("$" "."))(""))
    ((("$" "/"))(""))
    ((("$" "\\"))(""))
    ((("$" "!"))(""))
    ((("$" "\""))(""))
    ((("$" "#"))(""))
    ((("$" "$"))(""))
    ((("$" "%"))(""))
    ((("$" "&"))(""))
    ((("$" "'"))(""))
    ((("$" "("))(""))
    ((("$" ")"))(""))
    ((("$" "|"))(""))
    ((("$" "="))(""))
    ((("$" "~"))(""))
    ((("$" "Q"))(""))
    ((("$" "W"))(""))
    ((("$" "E"))(""))
    ((("$" "R"))(""))
    ((("$" "T"))(""))
    ((("$" "Y"))(""))
    ((("$" "U"))(""))
    ((("$" "I"))(""))
    ((("$" "O"))(""))
    ((("$" "P"))(""))
    ((("$" "`"))(""))
    ((("$" "{"))(""))
    ((("$" "A"))(""))
    ((("$" "S"))(""))
    ((("$" "D"))(""))
    ((("$" "F"))(""))
    ((("$" "G"))(""))
    ((("$" "H"))(""))
    ((("$" "J"))(""))
    ((("$" "K"))(""))
    ((("$" "L"))(""))
    ((("$" "+"))(""))
    ((("$" "*"))(""))
    ((("$" "}"))(""))
    ((("$" "Z"))(""))
    ((("$" "X"))(""))
    ((("$" "C"))(""))
    ((("$" "V"))(""))
    ((("$" "B"))(""))
    ((("$" "N"))(""))
    ((("$" "M"))(""))
    ((("$" "<"))(""))
    ((("$" ">"))(""))
    ((("$" "?"))(""))
    ((("$" "_"))(""))
    ((("$" " "))(""))
    ((("%" "1"))("ԡ"))
    ((("%" "2"))("Ԣ"))
    ((("%" "3"))("ԣ"))
    ((("%" "4"))("Ԥ"))
    ((("%" "5"))("ԥ"))
    ((("%" "6"))("Ԧ"))
    ((("%" "7"))("ԧ"))
    ((("%" "8"))("Ԩ"))
    ((("%" "9"))("ԩ"))
    ((("%" "0"))("Ԫ"))
    ((("%" "-"))("ԫ"))
    ((("%" "^"))("Ԭ"))
    ((("%" "q"))("ԭ"))
    ((("%" "w"))("Ԯ"))
    ((("%" "e"))("ԯ"))
    ((("%" "r"))("԰"))
    ((("%" "t"))("Ա"))
    ((("%" "y"))("Բ"))
    ((("%" "u"))("Գ"))
    ((("%" "i"))("Դ"))
    ((("%" "o"))("Ե"))
    ((("%" "p"))("Զ"))
    ((("%" "@"))("Է"))
    ((("%" "["))("Ը"))
    ((("%" "a"))("Թ"))
    ((("%" "s"))("Ժ"))
    ((("%" "d"))("Ի"))
    ((("%" "f"))("Լ"))
    ((("%" "g"))("Խ"))
    ((("%" "h"))("Ծ"))
    ((("%" "j"))("Կ"))
    ((("%" "k"))(""))
    ((("%" "l"))(""))
    ((("%" ";"))(""))
    ((("%" ":"))(""))
    ((("%" "]"))(""))
    ((("%" "z"))(""))
    ((("%" "x"))(""))
    ((("%" "c"))(""))
    ((("%" "v"))(""))
    ((("%" "b"))(""))
    ((("%" "n"))(""))
    ((("%" "m"))(""))
    ((("%" ","))(""))
    ((("%" "."))(""))
    ((("%" "/"))(""))
    ((("%" "\\"))(""))
    ((("%" "!"))(""))
    ((("%" "\""))(""))
    ((("%" "#"))(""))
    ((("%" "$"))(""))
    ((("%" "%"))(""))
    ((("%" "&"))(""))
    ((("%" "'"))(""))
    ((("%" "("))(""))
    ((("%" ")"))(""))
    ((("%" "|"))(""))
    ((("%" "="))(""))
    ((("%" "~"))(""))
    ((("%" "Q"))(""))
    ((("%" "W"))(""))
    ((("%" "E"))(""))
    ((("%" "R"))(""))
    ((("%" "T"))(""))
    ((("%" "Y"))(""))
    ((("%" "U"))(""))
    ((("%" "I"))(""))
    ((("%" "O"))(""))
    ((("%" "P"))(""))
    ((("%" "`"))(""))
    ((("%" "{"))(""))
    ((("%" "A"))(""))
    ((("%" "S"))(""))
    ((("%" "D"))(""))
    ((("%" "F"))(""))
    ((("%" "G"))(""))
    ((("%" "H"))(""))
    ((("%" "J"))(""))
    ((("%" "K"))(""))
    ((("%" "L"))(""))
    ((("%" "+"))(""))
    ((("%" "*"))(""))
    ((("%" "}"))(""))
    ((("%" "Z"))(""))
    ((("%" "X"))(""))
    ((("%" "C"))(""))
    ((("%" "V"))(""))
    ((("%" "B"))(""))
    ((("%" "N"))(""))
    ((("%" "M"))(""))
    ((("%" "<"))(""))
    ((("%" ">"))(""))
    ((("%" "?"))(""))
    ((("%" "_"))(""))
    ((("%" " "))(""))
    ((("&" "1"))("ա"))
    ((("&" "2"))("բ"))
    ((("&" "3"))("գ"))
    ((("&" "4"))("դ"))
    ((("&" "5"))("ե"))
    ((("&" "6"))("զ"))
    ((("&" "7"))("է"))
    ((("&" "8"))("ը"))
    ((("&" "9"))("թ"))
    ((("&" "0"))("ժ"))
    ((("&" "-"))("ի"))
    ((("&" "^"))("լ"))
    ((("&" "q"))("խ"))
    ((("&" "w"))("ծ"))
    ((("&" "e"))("կ"))
    ((("&" "r"))("հ"))
    ((("&" "t"))("ձ"))
    ((("&" "y"))("ղ"))
    ((("&" "u"))("ճ"))
    ((("&" "i"))("մ"))
    ((("&" "o"))("յ"))
    ((("&" "p"))("ն"))
    ((("&" "@"))("շ"))
    ((("&" "["))("ո"))
    ((("&" "a"))("չ"))
    ((("&" "s"))("պ"))
    ((("&" "d"))("ջ"))
    ((("&" "f"))("ռ"))
    ((("&" "g"))("ս"))
    ((("&" "h"))("վ"))
    ((("&" "j"))("տ"))
    ((("&" "k"))(""))
    ((("&" "l"))(""))
    ((("&" ";"))(""))
    ((("&" ":"))(""))
    ((("&" "]"))(""))
    ((("&" "z"))(""))
    ((("&" "x"))(""))
    ((("&" "c"))(""))
    ((("&" "v"))(""))
    ((("&" "b"))(""))
    ((("&" "n"))(""))
    ((("&" "m"))(""))
    ((("&" ","))(""))
    ((("&" "."))(""))
    ((("&" "/"))(""))
    ((("&" "\\"))(""))
    ((("&" "!"))(""))
    ((("&" "\""))(""))
    ((("&" "#"))(""))
    ((("&" "$"))(""))
    ((("&" "%"))(""))
    ((("&" "&"))(""))
    ((("&" "'"))(""))
    ((("&" "("))(""))
    ((("&" ")"))(""))
    ((("&" "|"))(""))
    ((("&" "="))(""))
    ((("&" "~"))(""))
    ((("&" "Q"))(""))
    ((("&" "W"))(""))
    ((("&" "E"))(""))
    ((("&" "R"))(""))
    ((("&" "T"))(""))
    ((("&" "Y"))(""))
    ((("&" "U"))(""))
    ((("&" "I"))(""))
    ((("&" "O"))(""))
    ((("&" "P"))(""))
    ((("&" "`"))(""))
    ((("&" "{"))(""))
    ((("&" "A"))(""))
    ((("&" "S"))(""))
    ((("&" "D"))(""))
    ((("&" "F"))(""))
    ((("&" "G"))(""))
    ((("&" "H"))(""))
    ((("&" "J"))(""))
    ((("&" "K"))(""))
    ((("&" "L"))(""))
    ((("&" "+"))(""))
    ((("&" "*"))(""))
    ((("&" "}"))(""))
    ((("&" "Z"))(""))
    ((("&" "X"))(""))
    ((("&" "C"))(""))
    ((("&" "V"))(""))
    ((("&" "B"))(""))
    ((("&" "N"))(""))
    ((("&" "M"))(""))
    ((("&" "<"))(""))
    ((("&" ">"))(""))
    ((("&" "?"))(""))
    ((("&" "_"))(""))
    ((("&" " "))(""))
    ((("'" "1"))("֡"))
    ((("'" "2"))("֢"))
    ((("'" "3"))("֣"))
    ((("'" "4"))("֤"))
    ((("'" "5"))("֥"))
    ((("'" "6"))("֦"))
    ((("'" "7"))("֧"))
    ((("'" "8"))("֨"))
    ((("'" "9"))("֩"))
    ((("'" "0"))("֪"))
    ((("'" "-"))("֫"))
    ((("'" "^"))("֬"))
    ((("'" "q"))("֭"))
    ((("'" "w"))("֮"))
    ((("'" "e"))("֯"))
    ((("'" "r"))("ְ"))
    ((("'" "t"))("ֱ"))
    ((("'" "y"))("ֲ"))
    ((("'" "u"))("ֳ"))
    ((("'" "i"))("ִ"))
    ((("'" "o"))("ֵ"))
    ((("'" "p"))("ֶ"))
    ((("'" "@"))("ַ"))
    ((("'" "["))("ָ"))
    ((("'" "a"))("ֹ"))
    ((("'" "s"))("ֺ"))
    ((("'" "d"))("ֻ"))
    ((("'" "f"))("ּ"))
    ((("'" "g"))("ֽ"))
    ((("'" "h"))("־"))
    ((("'" "j"))("ֿ"))
    ((("'" "k"))(""))
    ((("'" "l"))(""))
    ((("'" ";"))(""))
    ((("'" ":"))(""))
    ((("'" "]"))(""))
    ((("'" "z"))(""))
    ((("'" "x"))(""))
    ((("'" "c"))(""))
    ((("'" "v"))(""))
    ((("'" "b"))(""))
    ((("'" "n"))(""))
    ((("'" "m"))(""))
    ((("'" ","))(""))
    ((("'" "."))(""))
    ((("'" "/"))(""))
    ((("'" "\\"))(""))
    ((("'" "!"))(""))
    ((("'" "\""))(""))
    ((("'" "#"))(""))
    ((("'" "$"))(""))
    ((("'" "%"))(""))
    ((("'" "&"))(""))
    ((("'" "'"))(""))
    ((("'" "("))(""))
    ((("'" ")"))(""))
    ((("'" "|"))(""))
    ((("'" "="))(""))
    ((("'" "~"))(""))
    ((("'" "Q"))(""))
    ((("'" "W"))(""))
    ((("'" "E"))(""))
    ((("'" "R"))(""))
    ((("'" "T"))(""))
    ((("'" "Y"))(""))
    ((("'" "U"))(""))
    ((("'" "I"))(""))
    ((("'" "O"))(""))
    ((("'" "P"))(""))
    ((("'" "`"))(""))
    ((("'" "{"))(""))
    ((("'" "A"))(""))
    ((("'" "S"))(""))
    ((("'" "D"))(""))
    ((("'" "F"))(""))
    ((("'" "G"))(""))
    ((("'" "H"))(""))
    ((("'" "J"))(""))
    ((("'" "K"))(""))
    ((("'" "L"))(""))
    ((("'" "+"))(""))
    ((("'" "*"))(""))
    ((("'" "}"))(""))
    ((("'" "Z"))(""))
    ((("'" "X"))(""))
    ((("'" "C"))(""))
    ((("'" "V"))(""))
    ((("'" "B"))(""))
    ((("'" "N"))(""))
    ((("'" "M"))(""))
    ((("'" "<"))(""))
    ((("'" ">"))(""))
    ((("'" "?"))(""))
    ((("'" "_"))(""))
    ((("'" " "))(""))
    ((("(" "1"))("ס"))
    ((("(" "2"))("ע"))
    ((("(" "3"))("ף"))
    ((("(" "4"))("פ"))
    ((("(" "5"))("ץ"))
    ((("(" "6"))("צ"))
    ((("(" "7"))("ק"))
    ((("(" "8"))("ר"))
    ((("(" "9"))("ש"))
    ((("(" "0"))("ת"))
    ((("(" "-"))("׫"))
    ((("(" "^"))("׬"))
    ((("(" "q"))("׭"))
    ((("(" "w"))("׮"))
    ((("(" "e"))("ׯ"))
    ((("(" "r"))("װ"))
    ((("(" "t"))("ױ"))
    ((("(" "y"))("ײ"))
    ((("(" "u"))("׳"))
    ((("(" "i"))("״"))
    ((("(" "o"))("׵"))
    ((("(" "p"))("׶"))
    ((("(" "@"))("׷"))
    ((("(" "["))("׸"))
    ((("(" "a"))("׹"))
    ((("(" "s"))("׺"))
    ((("(" "d"))("׻"))
    ((("(" "f"))("׼"))
    ((("(" "g"))("׽"))
    ((("(" "h"))("׾"))
    ((("(" "j"))("׿"))
    ((("(" "k"))(""))
    ((("(" "l"))(""))
    ((("(" ";"))(""))
    ((("(" ":"))(""))
    ((("(" "]"))(""))
    ((("(" "z"))(""))
    ((("(" "x"))(""))
    ((("(" "c"))(""))
    ((("(" "v"))(""))
    ((("(" "b"))(""))
    ((("(" "n"))(""))
    ((("(" "m"))(""))
    ((("(" ","))(""))
    ((("(" "."))(""))
    ((("(" "/"))(""))
    ((("(" "\\"))(""))
    ((("(" "!"))(""))
    ((("(" "\""))(""))
    ((("(" "#"))(""))
    ((("(" "$"))(""))
    ((("(" "%"))(""))
    ((("(" "&"))(""))
    ((("(" "'"))(""))
    ((("(" "("))(""))
    ((("(" ")"))(""))
    ((("(" "|"))(""))
    ((("(" "="))(""))
    ((("(" "~"))(""))
    ((("(" "Q"))(""))
    ((("(" "W"))(""))
    ((("(" "E"))(""))
    ((("(" "R"))(""))
    ((("(" "T"))(""))
    ((("(" "Y"))(""))
    ((("(" "U"))(""))
    ((("(" "I"))(""))
    ((("(" "O"))(""))
    ((("(" "P"))(""))
    ((("(" "`"))(""))
    ((("(" "{"))(""))
    ((("(" "A"))(""))
    ((("(" "S"))(""))
    ((("(" "D"))(""))
    ((("(" "F"))(""))
    ((("(" "G"))(""))
    ((("(" "H"))(""))
    ((("(" "J"))(""))
    ((("(" "K"))(""))
    ((("(" "L"))(""))
    ((("(" "+"))(""))
    ((("(" "*"))(""))
    ((("(" "}"))(""))
    ((("(" "Z"))(""))
    ((("(" "X"))(""))
    ((("(" "C"))(""))
    ((("(" "V"))(""))
    ((("(" "B"))(""))
    ((("(" "N"))(""))
    ((("(" "M"))(""))
    ((("(" "<"))(""))
    ((("(" ">"))(""))
    ((("(" "?"))(""))
    ((("(" "_"))(""))
    ((("(" " "))(""))
    (((")" "1"))("ء"))
    (((")" "2"))("آ"))
    (((")" "3"))("أ"))
    (((")" "4"))("ؤ"))
    (((")" "5"))("إ"))
    (((")" "6"))("ئ"))
    (((")" "7"))("ا"))
    (((")" "8"))("ب"))
    (((")" "9"))("ة"))
    (((")" "0"))("ت"))
    (((")" "-"))("ث"))
    (((")" "^"))("ج"))
    (((")" "q"))("ح"))
    (((")" "w"))("خ"))
    (((")" "e"))("د"))
    (((")" "r"))("ذ"))
    (((")" "t"))("ر"))
    (((")" "y"))("ز"))
    (((")" "u"))("س"))
    (((")" "i"))("ش"))
    (((")" "o"))("ص"))
    (((")" "p"))("ض"))
    (((")" "@"))("ط"))
    (((")" "["))("ظ"))
    (((")" "a"))("ع"))
    (((")" "s"))("غ"))
    (((")" "d"))("ػ"))
    (((")" "f"))("ؼ"))
    (((")" "g"))("ؽ"))
    (((")" "h"))("ؾ"))
    (((")" "j"))("ؿ"))
    (((")" "k"))(""))
    (((")" "l"))(""))
    (((")" ";"))(""))
    (((")" ":"))(""))
    (((")" "]"))(""))
    (((")" "z"))(""))
    (((")" "x"))(""))
    (((")" "c"))(""))
    (((")" "v"))(""))
    (((")" "b"))(""))
    (((")" "n"))(""))
    (((")" "m"))(""))
    (((")" ","))(""))
    (((")" "."))(""))
    (((")" "/"))(""))
    (((")" "\\"))(""))
    (((")" "!"))(""))
    (((")" "\""))(""))
    (((")" "#"))(""))
    (((")" "$"))(""))
    (((")" "%"))(""))
    (((")" "&"))(""))
    (((")" "'"))(""))
    (((")" "("))(""))
    (((")" ")"))(""))
    (((")" "|"))(""))
    (((")" "="))(""))
    (((")" "~"))(""))
    (((")" "Q"))(""))
    (((")" "W"))(""))
    (((")" "E"))(""))
    (((")" "R"))(""))
    (((")" "T"))(""))
    (((")" "Y"))(""))
    (((")" "U"))(""))
    (((")" "I"))(""))
    (((")" "O"))(""))
    (((")" "P"))(""))
    (((")" "`"))(""))
    (((")" "{"))(""))
    (((")" "A"))(""))
    (((")" "S"))(""))
    (((")" "D"))(""))
    (((")" "F"))(""))
    (((")" "G"))(""))
    (((")" "H"))(""))
    (((")" "J"))(""))
    (((")" "K"))(""))
    (((")" "L"))(""))
    (((")" "+"))(""))
    (((")" "*"))(""))
    (((")" "}"))(""))
    (((")" "Z"))(""))
    (((")" "X"))(""))
    (((")" "C"))(""))
    (((")" "V"))(""))
    (((")" "B"))(""))
    (((")" "N"))(""))
    (((")" "M"))(""))
    (((")" "<"))(""))
    (((")" ">"))(""))
    (((")" "?"))(""))
    (((")" "_"))(""))
    (((")" " "))(""))
    ((("|" "1"))("١"))
    ((("|" "2"))("٢"))
    ((("|" "3"))("٣"))
    ((("|" "4"))("٤"))
    ((("|" "5"))("٥"))
    ((("|" "6"))("٦"))
    ((("|" "7"))("٧"))
    ((("|" "8"))("٨"))
    ((("|" "9"))("٩"))
    ((("|" "0"))("٪"))
    ((("|" "-"))("٫"))
    ((("|" "^"))("٬"))
    ((("|" "q"))("٭"))
    ((("|" "w"))("ٮ"))
    ((("|" "e"))("ٯ"))
    ((("|" "r"))("ٰ"))
    ((("|" "t"))("ٱ"))
    ((("|" "y"))("ٲ"))
    ((("|" "u"))("ٳ"))
    ((("|" "i"))("ٴ"))
    ((("|" "o"))("ٵ"))
    ((("|" "p"))("ٶ"))
    ((("|" "@"))("ٷ"))
    ((("|" "["))("ٸ"))
    ((("|" "a"))("ٹ"))
    ((("|" "s"))("ٺ"))
    ((("|" "d"))("ٻ"))
    ((("|" "f"))("ټ"))
    ((("|" "g"))("ٽ"))
    ((("|" "h"))("پ"))
    ((("|" "j"))("ٿ"))
    ((("|" "k"))(""))
    ((("|" "l"))(""))
    ((("|" ";"))(""))
    ((("|" ":"))(""))
    ((("|" "]"))(""))
    ((("|" "z"))(""))
    ((("|" "x"))(""))
    ((("|" "c"))(""))
    ((("|" "v"))(""))
    ((("|" "b"))(""))
    ((("|" "n"))(""))
    ((("|" "m"))(""))
    ((("|" ","))(""))
    ((("|" "."))(""))
    ((("|" "/"))(""))
    ((("|" "\\"))(""))
    ((("|" "!"))(""))
    ((("|" "\""))(""))
    ((("|" "#"))(""))
    ((("|" "$"))(""))
    ((("|" "%"))(""))
    ((("|" "&"))(""))
    ((("|" "'"))(""))
    ((("|" "("))(""))
    ((("|" ")"))(""))
    ((("|" "|"))(""))
    ((("|" "="))(""))
    ((("|" "~"))(""))
    ((("|" "Q"))(""))
    ((("|" "W"))(""))
    ((("|" "E"))(""))
    ((("|" "R"))(""))
    ((("|" "T"))(""))
    ((("|" "Y"))(""))
    ((("|" "U"))(""))
    ((("|" "I"))(""))
    ((("|" "O"))(""))
    ((("|" "P"))(""))
    ((("|" "`"))(""))
    ((("|" "{"))(""))
    ((("|" "A"))(""))
    ((("|" "S"))(""))
    ((("|" "D"))(""))
    ((("|" "F"))(""))
    ((("|" "G"))(""))
    ((("|" "H"))(""))
    ((("|" "J"))(""))
    ((("|" "K"))(""))
    ((("|" "L"))(""))
    ((("|" "+"))(""))
    ((("|" "*"))(""))
    ((("|" "}"))(""))
    ((("|" "Z"))(""))
    ((("|" "X"))(""))
    ((("|" "C"))(""))
    ((("|" "V"))(""))
    ((("|" "B"))(""))
    ((("|" "N"))(""))
    ((("|" "M"))(""))
    ((("|" "<"))(""))
    ((("|" ">"))(""))
    ((("|" "?"))(""))
    ((("|" "_"))(""))
    ((("|" " "))(""))
    ((("=" "1"))("ڡ"))
    ((("=" "2"))("ڢ"))
    ((("=" "3"))("ڣ"))
    ((("=" "4"))("ڤ"))
    ((("=" "5"))("ڥ"))
    ((("=" "6"))("ڦ"))
    ((("=" "7"))("ڧ"))
    ((("=" "8"))("ڨ"))
    ((("=" "9"))("ک"))
    ((("=" "0"))("ڪ"))
    ((("=" "-"))("ګ"))
    ((("=" "^"))("ڬ"))
    ((("=" "q"))("ڭ"))
    ((("=" "w"))("ڮ"))
    ((("=" "e"))("گ"))
    ((("=" "r"))("ڰ"))
    ((("=" "t"))("ڱ"))
    ((("=" "y"))("ڲ"))
    ((("=" "u"))("ڳ"))
    ((("=" "i"))("ڴ"))
    ((("=" "o"))("ڵ"))
    ((("=" "p"))("ڶ"))
    ((("=" "@"))("ڷ"))
    ((("=" "["))("ڸ"))
    ((("=" "a"))("ڹ"))
    ((("=" "s"))("ں"))
    ((("=" "d"))("ڻ"))
    ((("=" "f"))("ڼ"))
    ((("=" "g"))("ڽ"))
    ((("=" "h"))("ھ"))
    ((("=" "j"))("ڿ"))
    ((("=" "k"))(""))
    ((("=" "l"))(""))
    ((("=" ";"))(""))
    ((("=" ":"))(""))
    ((("=" "]"))(""))
    ((("=" "z"))(""))
    ((("=" "x"))(""))
    ((("=" "c"))(""))
    ((("=" "v"))(""))
    ((("=" "b"))(""))
    ((("=" "n"))(""))
    ((("=" "m"))(""))
    ((("=" ","))(""))
    ((("=" "."))(""))
    ((("=" "/"))(""))
    ((("=" "\\"))(""))
    ((("=" "!"))(""))
    ((("=" "\""))(""))
    ((("=" "#"))(""))
    ((("=" "$"))(""))
    ((("=" "%"))(""))
    ((("=" "&"))(""))
    ((("=" "'"))(""))
    ((("=" "("))(""))
    ((("=" ")"))(""))
    ((("=" "|"))(""))
    ((("=" "="))(""))
    ((("=" "~"))(""))
    ((("=" "Q"))(""))
    ((("=" "W"))(""))
    ((("=" "E"))(""))
    ((("=" "R"))(""))
    ((("=" "T"))(""))
    ((("=" "Y"))(""))
    ((("=" "U"))(""))
    ((("=" "I"))(""))
    ((("=" "O"))(""))
    ((("=" "P"))(""))
    ((("=" "`"))(""))
    ((("=" "{"))(""))
    ((("=" "A"))(""))
    ((("=" "S"))(""))
    ((("=" "D"))(""))
    ((("=" "F"))(""))
    ((("=" "G"))(""))
    ((("=" "H"))(""))
    ((("=" "J"))(""))
    ((("=" "K"))(""))
    ((("=" "L"))(""))
    ((("=" "+"))(""))
    ((("=" "*"))(""))
    ((("=" "}"))(""))
    ((("=" "Z"))(""))
    ((("=" "X"))(""))
    ((("=" "C"))(""))
    ((("=" "V"))(""))
    ((("=" "B"))(""))
    ((("=" "N"))(""))
    ((("=" "M"))(""))
    ((("=" "<"))(""))
    ((("=" ">"))(""))
    ((("=" "?"))(""))
    ((("=" "_"))(""))
    ((("=" " "))(""))
    ((("~" "1"))("ۡ"))
    ((("~" "2"))("ۢ"))
    ((("~" "3"))("ۣ"))
    ((("~" "4"))("ۤ"))
    ((("~" "5"))("ۥ"))
    ((("~" "6"))("ۦ"))
    ((("~" "7"))("ۧ"))
    ((("~" "8"))("ۨ"))
    ((("~" "9"))("۩"))
    ((("~" "0"))("۪"))
    ((("~" "-"))("۫"))
    ((("~" "^"))("۬"))
    ((("~" "q"))("ۭ"))
    ((("~" "w"))("ۮ"))
    ((("~" "e"))("ۯ"))
    ((("~" "r"))("۰"))
    ((("~" "t"))("۱"))
    ((("~" "y"))("۲"))
    ((("~" "u"))("۳"))
    ((("~" "i"))("۴"))
    ((("~" "o"))("۵"))
    ((("~" "p"))("۶"))
    ((("~" "@"))("۷"))
    ((("~" "["))("۸"))
    ((("~" "a"))("۹"))
    ((("~" "s"))("ۺ"))
    ((("~" "d"))("ۻ"))
    ((("~" "f"))("ۼ"))
    ((("~" "g"))("۽"))
    ((("~" "h"))("۾"))
    ((("~" "j"))("ۿ"))
    ((("~" "k"))(""))
    ((("~" "l"))(""))
    ((("~" ";"))(""))
    ((("~" ":"))(""))
    ((("~" "]"))(""))
    ((("~" "z"))(""))
    ((("~" "x"))(""))
    ((("~" "c"))(""))
    ((("~" "v"))(""))
    ((("~" "b"))(""))
    ((("~" "n"))(""))
    ((("~" "m"))(""))
    ((("~" ","))(""))
    ((("~" "."))(""))
    ((("~" "/"))(""))
    ((("~" "\\"))(""))
    ((("~" "!"))(""))
    ((("~" "\""))(""))
    ((("~" "#"))(""))
    ((("~" "$"))(""))
    ((("~" "%"))(""))
    ((("~" "&"))(""))
    ((("~" "'"))(""))
    ((("~" "("))(""))
    ((("~" ")"))(""))
    ((("~" "|"))(""))
    ((("~" "="))(""))
    ((("~" "~"))(""))
    ((("~" "Q"))(""))
    ((("~" "W"))(""))
    ((("~" "E"))(""))
    ((("~" "R"))(""))
    ((("~" "T"))(""))
    ((("~" "Y"))(""))
    ((("~" "U"))(""))
    ((("~" "I"))(""))
    ((("~" "O"))(""))
    ((("~" "P"))(""))
    ((("~" "`"))(""))
    ((("~" "{"))(""))
    ((("~" "A"))(""))
    ((("~" "S"))(""))
    ((("~" "D"))(""))
    ((("~" "F"))(""))
    ((("~" "G"))(""))
    ((("~" "H"))(""))
    ((("~" "J"))(""))
    ((("~" "K"))(""))
    ((("~" "L"))(""))
    ((("~" "+"))(""))
    ((("~" "*"))(""))
    ((("~" "}"))(""))
    ((("~" "Z"))(""))
    ((("~" "X"))(""))
    ((("~" "C"))(""))
    ((("~" "V"))(""))
    ((("~" "B"))(""))
    ((("~" "N"))(""))
    ((("~" "M"))(""))
    ((("~" "<"))(""))
    ((("~" ">"))(""))
    ((("~" "?"))(""))
    ((("~" "_"))(""))
    ((("~" " "))(""))
    ((("Q" "1"))("ܡ"))
    ((("Q" "2"))("ܢ"))
    ((("Q" "3"))("ܣ"))
    ((("Q" "4"))("ܤ"))
    ((("Q" "5"))("ܥ"))
    ((("Q" "6"))("ܦ"))
    ((("Q" "7"))("ܧ"))
    ((("Q" "8"))("ܨ"))
    ((("Q" "9"))("ܩ"))
    ((("Q" "0"))("ܪ"))
    ((("Q" "-"))("ܫ"))
    ((("Q" "^"))("ܬ"))
    ((("Q" "q"))("ܭ"))
    ((("Q" "w"))("ܮ"))
    ((("Q" "e"))("ܯ"))
    ((("Q" "r"))("ܰ"))
    ((("Q" "t"))("ܱ"))
    ((("Q" "y"))("ܲ"))
    ((("Q" "u"))("ܳ"))
    ((("Q" "i"))("ܴ"))
    ((("Q" "o"))("ܵ"))
    ((("Q" "p"))("ܶ"))
    ((("Q" "@"))("ܷ"))
    ((("Q" "["))("ܸ"))
    ((("Q" "a"))("ܹ"))
    ((("Q" "s"))("ܺ"))
    ((("Q" "d"))("ܻ"))
    ((("Q" "f"))("ܼ"))
    ((("Q" "g"))("ܽ"))
    ((("Q" "h"))("ܾ"))
    ((("Q" "j"))("ܿ"))
    ((("Q" "k"))(""))
    ((("Q" "l"))(""))
    ((("Q" ";"))(""))
    ((("Q" ":"))(""))
    ((("Q" "]"))(""))
    ((("Q" "z"))(""))
    ((("Q" "x"))(""))
    ((("Q" "c"))(""))
    ((("Q" "v"))(""))
    ((("Q" "b"))(""))
    ((("Q" "n"))(""))
    ((("Q" "m"))(""))
    ((("Q" ","))(""))
    ((("Q" "."))(""))
    ((("Q" "/"))(""))
    ((("Q" "\\"))(""))
    ((("Q" "!"))(""))
    ((("Q" "\""))(""))
    ((("Q" "#"))(""))
    ((("Q" "$"))(""))
    ((("Q" "%"))(""))
    ((("Q" "&"))(""))
    ((("Q" "'"))(""))
    ((("Q" "("))(""))
    ((("Q" ")"))(""))
    ((("Q" "|"))(""))
    ((("Q" "="))(""))
    ((("Q" "~"))(""))
    ((("Q" "Q"))(""))
    ((("Q" "W"))(""))
    ((("Q" "E"))(""))
    ((("Q" "R"))(""))
    ((("Q" "T"))(""))
    ((("Q" "Y"))(""))
    ((("Q" "U"))(""))
    ((("Q" "I"))(""))
    ((("Q" "O"))(""))
    ((("Q" "P"))(""))
    ((("Q" "`"))(""))
    ((("Q" "{"))(""))
    ((("Q" "A"))(""))
    ((("Q" "S"))(""))
    ((("Q" "D"))(""))
    ((("Q" "F"))(""))
    ((("Q" "G"))(""))
    ((("Q" "H"))(""))
    ((("Q" "J"))(""))
    ((("Q" "K"))(""))
    ((("Q" "L"))(""))
    ((("Q" "+"))(""))
    ((("Q" "*"))(""))
    ((("Q" "}"))(""))
    ((("Q" "Z"))(""))
    ((("Q" "X"))(""))
    ((("Q" "C"))(""))
    ((("Q" "V"))(""))
    ((("Q" "B"))(""))
    ((("Q" "N"))(""))
    ((("Q" "M"))(""))
    ((("Q" "<"))(""))
    ((("Q" ">"))(""))
    ((("Q" "?"))(""))
    ((("Q" "_"))(""))
    ((("Q" " "))(""))
    ((("W" "1"))("ݡ"))
    ((("W" "2"))("ݢ"))
    ((("W" "3"))("ݣ"))
    ((("W" "4"))("ݤ"))
    ((("W" "5"))("ݥ"))
    ((("W" "6"))("ݦ"))
    ((("W" "7"))("ݧ"))
    ((("W" "8"))("ݨ"))
    ((("W" "9"))("ݩ"))
    ((("W" "0"))("ݪ"))
    ((("W" "-"))("ݫ"))
    ((("W" "^"))("ݬ"))
    ((("W" "q"))("ݭ"))
    ((("W" "w"))("ݮ"))
    ((("W" "e"))("ݯ"))
    ((("W" "r"))("ݰ"))
    ((("W" "t"))("ݱ"))
    ((("W" "y"))("ݲ"))
    ((("W" "u"))("ݳ"))
    ((("W" "i"))("ݴ"))
    ((("W" "o"))("ݵ"))
    ((("W" "p"))("ݶ"))
    ((("W" "@"))("ݷ"))
    ((("W" "["))("ݸ"))
    ((("W" "a"))("ݹ"))
    ((("W" "s"))("ݺ"))
    ((("W" "d"))("ݻ"))
    ((("W" "f"))("ݼ"))
    ((("W" "g"))("ݽ"))
    ((("W" "h"))("ݾ"))
    ((("W" "j"))("ݿ"))
    ((("W" "k"))(""))
    ((("W" "l"))(""))
    ((("W" ";"))(""))
    ((("W" ":"))(""))
    ((("W" "]"))(""))
    ((("W" "z"))(""))
    ((("W" "x"))(""))
    ((("W" "c"))(""))
    ((("W" "v"))(""))
    ((("W" "b"))(""))
    ((("W" "n"))(""))
    ((("W" "m"))(""))
    ((("W" ","))(""))
    ((("W" "."))(""))
    ((("W" "/"))(""))
    ((("W" "\\"))(""))
    ((("W" "!"))(""))
    ((("W" "\""))(""))
    ((("W" "#"))(""))
    ((("W" "$"))(""))
    ((("W" "%"))(""))
    ((("W" "&"))(""))
    ((("W" "'"))(""))
    ((("W" "("))(""))
    ((("W" ")"))(""))
    ((("W" "|"))(""))
    ((("W" "="))(""))
    ((("W" "~"))(""))
    ((("W" "Q"))(""))
    ((("W" "W"))(""))
    ((("W" "E"))(""))
    ((("W" "R"))(""))
    ((("W" "T"))(""))
    ((("W" "Y"))(""))
    ((("W" "U"))(""))
    ((("W" "I"))(""))
    ((("W" "O"))(""))
    ((("W" "P"))(""))
    ((("W" "`"))(""))
    ((("W" "{"))(""))
    ((("W" "A"))(""))
    ((("W" "S"))(""))
    ((("W" "D"))(""))
    ((("W" "F"))(""))
    ((("W" "G"))(""))
    ((("W" "H"))(""))
    ((("W" "J"))(""))
    ((("W" "K"))(""))
    ((("W" "L"))(""))
    ((("W" "+"))(""))
    ((("W" "*"))(""))
    ((("W" "}"))(""))
    ((("W" "Z"))(""))
    ((("W" "X"))(""))
    ((("W" "C"))(""))
    ((("W" "V"))(""))
    ((("W" "B"))(""))
    ((("W" "N"))(""))
    ((("W" "M"))(""))
    ((("W" "<"))(""))
    ((("W" ">"))(""))
    ((("W" "?"))(""))
    ((("W" "_"))(""))
    ((("W" " "))(""))
    ((("E" "1"))("ޡ"))
    ((("E" "2"))("ޢ"))
    ((("E" "3"))("ޣ"))
    ((("E" "4"))("ޤ"))
    ((("E" "5"))("ޥ"))
    ((("E" "6"))("ަ"))
    ((("E" "7"))("ާ"))
    ((("E" "8"))("ި"))
    ((("E" "9"))("ީ"))
    ((("E" "0"))("ު"))
    ((("E" "-"))("ޫ"))
    ((("E" "^"))("ެ"))
    ((("E" "q"))("ޭ"))
    ((("E" "w"))("ޮ"))
    ((("E" "e"))("ޯ"))
    ((("E" "r"))("ް"))
    ((("E" "t"))("ޱ"))
    ((("E" "y"))("޲"))
    ((("E" "u"))("޳"))
    ((("E" "i"))("޴"))
    ((("E" "o"))("޵"))
    ((("E" "p"))("޶"))
    ((("E" "@"))("޷"))
    ((("E" "["))("޸"))
    ((("E" "a"))("޹"))
    ((("E" "s"))("޺"))
    ((("E" "d"))("޻"))
    ((("E" "f"))("޼"))
    ((("E" "g"))("޽"))
    ((("E" "h"))("޾"))
    ((("E" "j"))("޿"))
    ((("E" "k"))(""))
    ((("E" "l"))(""))
    ((("E" ";"))(""))
    ((("E" ":"))(""))
    ((("E" "]"))(""))
    ((("E" "z"))(""))
    ((("E" "x"))(""))
    ((("E" "c"))(""))
    ((("E" "v"))(""))
    ((("E" "b"))(""))
    ((("E" "n"))(""))
    ((("E" "m"))(""))
    ((("E" ","))(""))
    ((("E" "."))(""))
    ((("E" "/"))(""))
    ((("E" "\\"))(""))
    ((("E" "!"))(""))
    ((("E" "\""))(""))
    ((("E" "#"))(""))
    ((("E" "$"))(""))
    ((("E" "%"))(""))
    ((("E" "&"))(""))
    ((("E" "'"))(""))
    ((("E" "("))(""))
    ((("E" ")"))(""))
    ((("E" "|"))(""))
    ((("E" "="))(""))
    ((("E" "~"))(""))
    ((("E" "Q"))(""))
    ((("E" "W"))(""))
    ((("E" "E"))(""))
    ((("E" "R"))(""))
    ((("E" "T"))(""))
    ((("E" "Y"))(""))
    ((("E" "U"))(""))
    ((("E" "I"))(""))
    ((("E" "O"))(""))
    ((("E" "P"))(""))
    ((("E" "`"))(""))
    ((("E" "{"))(""))
    ((("E" "A"))(""))
    ((("E" "S"))(""))
    ((("E" "D"))(""))
    ((("E" "F"))(""))
    ((("E" "G"))(""))
    ((("E" "H"))(""))
    ((("E" "J"))(""))
    ((("E" "K"))(""))
    ((("E" "L"))(""))
    ((("E" "+"))(""))
    ((("E" "*"))(""))
    ((("E" "}"))(""))
    ((("E" "Z"))(""))
    ((("E" "X"))(""))
    ((("E" "C"))(""))
    ((("E" "V"))(""))
    ((("E" "B"))(""))
    ((("E" "N"))(""))
    ((("E" "M"))(""))
    ((("E" "<"))(""))
    ((("E" ">"))(""))
    ((("E" "?"))(""))
    ((("E" "_"))(""))
    ((("E" " "))(""))
    ((("R" "1"))("ߡ"))
    ((("R" "2"))("ߢ"))
    ((("R" "3"))("ߣ"))
    ((("R" "4"))("ߤ"))
    ((("R" "5"))("ߥ"))
    ((("R" "6"))("ߦ"))
    ((("R" "7"))("ߧ"))
    ((("R" "8"))("ߨ"))
    ((("R" "9"))("ߩ"))
    ((("R" "0"))("ߪ"))
    ((("R" "-"))("߫"))
    ((("R" "^"))("߬"))
    ((("R" "q"))("߭"))
    ((("R" "w"))("߮"))
    ((("R" "e"))("߯"))
    ((("R" "r"))("߰"))
    ((("R" "t"))("߱"))
    ((("R" "y"))("߲"))
    ((("R" "u"))("߳"))
    ((("R" "i"))("ߴ"))
    ((("R" "o"))("ߵ"))
    ((("R" "p"))("߶"))
    ((("R" "@"))("߷"))
    ((("R" "["))("߸"))
    ((("R" "a"))("߹"))
    ((("R" "s"))("ߺ"))
    ((("R" "d"))("߻"))
    ((("R" "f"))("߼"))
    ((("R" "g"))("߽"))
    ((("R" "h"))("߾"))
    ((("R" "j"))("߿"))
    ((("R" "k"))(""))
    ((("R" "l"))(""))
    ((("R" ";"))(""))
    ((("R" ":"))(""))
    ((("R" "]"))(""))
    ((("R" "z"))(""))
    ((("R" "x"))(""))
    ((("R" "c"))(""))
    ((("R" "v"))(""))
    ((("R" "b"))(""))
    ((("R" "n"))(""))
    ((("R" "m"))(""))
    ((("R" ","))(""))
    ((("R" "."))(""))
    ((("R" "/"))(""))
    ((("R" "\\"))(""))
    ((("R" "!"))(""))
    ((("R" "\""))(""))
    ((("R" "#"))(""))
    ((("R" "$"))(""))
    ((("R" "%"))(""))
    ((("R" "&"))(""))
    ((("R" "'"))(""))
    ((("R" "("))(""))
    ((("R" ")"))(""))
    ((("R" "|"))(""))
    ((("R" "="))(""))
    ((("R" "~"))(""))
    ((("R" "Q"))(""))
    ((("R" "W"))(""))
    ((("R" "E"))(""))
    ((("R" "R"))(""))
    ((("R" "T"))(""))
    ((("R" "Y"))(""))
    ((("R" "U"))(""))
    ((("R" "I"))(""))
    ((("R" "O"))(""))
    ((("R" "P"))(""))
    ((("R" "`"))(""))
    ((("R" "{"))(""))
    ((("R" "A"))(""))
    ((("R" "S"))(""))
    ((("R" "D"))(""))
    ((("R" "F"))(""))
    ((("R" "G"))(""))
    ((("R" "H"))(""))
    ((("R" "J"))(""))
    ((("R" "K"))(""))
    ((("R" "L"))(""))
    ((("R" "+"))(""))
    ((("R" "*"))(""))
    ((("R" "}"))(""))
    ((("R" "Z"))(""))
    ((("R" "X"))(""))
    ((("R" "C"))(""))
    ((("R" "V"))(""))
    ((("R" "B"))(""))
    ((("R" "N"))(""))
    ((("R" "M"))(""))
    ((("R" "<"))(""))
    ((("R" ">"))(""))
    ((("R" "?"))(""))
    ((("R" "_"))(""))
    ((("R" " "))(""))
    ((("T" "1"))(""))
    ((("T" "2"))(""))
    ((("T" "3"))(""))
    ((("T" "4"))(""))
    ((("T" "5"))(""))
    ((("T" "6"))(""))
    ((("T" "7"))(""))
    ((("T" "8"))(""))
    ((("T" "9"))(""))
    ((("T" "0"))(""))
    ((("T" "-"))(""))
    ((("T" "^"))(""))
    ((("T" "q"))(""))
    ((("T" "w"))(""))
    ((("T" "e"))(""))
    ((("T" "r"))(""))
    ((("T" "t"))(""))
    ((("T" "y"))(""))
    ((("T" "u"))(""))
    ((("T" "i"))(""))
    ((("T" "o"))(""))
    ((("T" "p"))(""))
    ((("T" "@"))(""))
    ((("T" "["))(""))
    ((("T" "a"))(""))
    ((("T" "s"))(""))
    ((("T" "d"))(""))
    ((("T" "f"))(""))
    ((("T" "g"))(""))
    ((("T" "h"))(""))
    ((("T" "j"))(""))
    ((("T" "k"))(""))
    ((("T" "l"))(""))
    ((("T" ";"))(""))
    ((("T" ":"))(""))
    ((("T" "]"))(""))
    ((("T" "z"))(""))
    ((("T" "x"))(""))
    ((("T" "c"))(""))
    ((("T" "v"))(""))
    ((("T" "b"))(""))
    ((("T" "n"))(""))
    ((("T" "m"))(""))
    ((("T" ","))(""))
    ((("T" "."))(""))
    ((("T" "/"))(""))
    ((("T" "\\"))(""))
    ((("T" "!"))(""))
    ((("T" "\""))(""))
    ((("T" "#"))(""))
    ((("T" "$"))(""))
    ((("T" "%"))(""))
    ((("T" "&"))(""))
    ((("T" "'"))(""))
    ((("T" "("))(""))
    ((("T" ")"))(""))
    ((("T" "|"))(""))
    ((("T" "="))(""))
    ((("T" "~"))(""))
    ((("T" "Q"))(""))
    ((("T" "W"))(""))
    ((("T" "E"))(""))
    ((("T" "R"))(""))
    ((("T" "T"))(""))
    ((("T" "Y"))(""))
    ((("T" "U"))(""))
    ((("T" "I"))(""))
    ((("T" "O"))(""))
    ((("T" "P"))(""))
    ((("T" "`"))(""))
    ((("T" "{"))(""))
    ((("T" "A"))(""))
    ((("T" "S"))(""))
    ((("T" "D"))(""))
    ((("T" "F"))(""))
    ((("T" "G"))(""))
    ((("T" "H"))(""))
    ((("T" "J"))(""))
    ((("T" "K"))(""))
    ((("T" "L"))(""))
    ((("T" "+"))(""))
    ((("T" "*"))(""))
    ((("T" "}"))(""))
    ((("T" "Z"))(""))
    ((("T" "X"))(""))
    ((("T" "C"))(""))
    ((("T" "V"))(""))
    ((("T" "B"))(""))
    ((("T" "N"))(""))
    ((("T" "M"))(""))
    ((("T" "<"))(""))
    ((("T" ">"))(""))
    ((("T" "?"))(""))
    ((("T" "_"))(""))
    ((("T" " "))(""))
    ((("Y" "1"))(""))
    ((("Y" "2"))(""))
    ((("Y" "3"))(""))
    ((("Y" "4"))(""))
    ((("Y" "5"))(""))
    ((("Y" "6"))(""))
    ((("Y" "7"))(""))
    ((("Y" "8"))(""))
    ((("Y" "9"))(""))
    ((("Y" "0"))(""))
    ((("Y" "-"))(""))
    ((("Y" "^"))(""))
    ((("Y" "q"))(""))
    ((("Y" "w"))(""))
    ((("Y" "e"))(""))
    ((("Y" "r"))(""))
    ((("Y" "t"))(""))
    ((("Y" "y"))(""))
    ((("Y" "u"))(""))
    ((("Y" "i"))(""))
    ((("Y" "o"))(""))
    ((("Y" "p"))(""))
    ((("Y" "@"))(""))
    ((("Y" "["))(""))
    ((("Y" "a"))(""))
    ((("Y" "s"))(""))
    ((("Y" "d"))(""))
    ((("Y" "f"))(""))
    ((("Y" "g"))(""))
    ((("Y" "h"))(""))
    ((("Y" "j"))(""))
    ((("Y" "k"))(""))
    ((("Y" "l"))(""))
    ((("Y" ";"))(""))
    ((("Y" ":"))(""))
    ((("Y" "]"))(""))
    ((("Y" "z"))(""))
    ((("Y" "x"))(""))
    ((("Y" "c"))(""))
    ((("Y" "v"))(""))
    ((("Y" "b"))(""))
    ((("Y" "n"))(""))
    ((("Y" "m"))(""))
    ((("Y" ","))(""))
    ((("Y" "."))(""))
    ((("Y" "/"))(""))
    ((("Y" "\\"))(""))
    ((("Y" "!"))(""))
    ((("Y" "\""))(""))
    ((("Y" "#"))(""))
    ((("Y" "$"))(""))
    ((("Y" "%"))(""))
    ((("Y" "&"))(""))
    ((("Y" "'"))(""))
    ((("Y" "("))(""))
    ((("Y" ")"))(""))
    ((("Y" "|"))(""))
    ((("Y" "="))(""))
    ((("Y" "~"))(""))
    ((("Y" "Q"))(""))
    ((("Y" "W"))(""))
    ((("Y" "E"))(""))
    ((("Y" "R"))(""))
    ((("Y" "T"))(""))
    ((("Y" "Y"))(""))
    ((("Y" "U"))(""))
    ((("Y" "I"))(""))
    ((("Y" "O"))(""))
    ((("Y" "P"))(""))
    ((("Y" "`"))(""))
    ((("Y" "{"))(""))
    ((("Y" "A"))(""))
    ((("Y" "S"))(""))
    ((("Y" "D"))(""))
    ((("Y" "F"))(""))
    ((("Y" "G"))(""))
    ((("Y" "H"))(""))
    ((("Y" "J"))(""))
    ((("Y" "K"))(""))
    ((("Y" "L"))(""))
    ((("Y" "+"))(""))
    ((("Y" "*"))(""))
    ((("Y" "}"))(""))
    ((("Y" "Z"))(""))
    ((("Y" "X"))(""))
    ((("Y" "C"))(""))
    ((("Y" "V"))(""))
    ((("Y" "B"))(""))
    ((("Y" "N"))(""))
    ((("Y" "M"))(""))
    ((("Y" "<"))(""))
    ((("Y" ">"))(""))
    ((("Y" "?"))(""))
    ((("Y" "_"))(""))
    ((("Y" " "))(""))
    ((("U" "1"))(""))
    ((("U" "2"))(""))
    ((("U" "3"))(""))
    ((("U" "4"))(""))
    ((("U" "5"))(""))
    ((("U" "6"))(""))
    ((("U" "7"))(""))
    ((("U" "8"))(""))
    ((("U" "9"))(""))
    ((("U" "0"))(""))
    ((("U" "-"))(""))
    ((("U" "^"))(""))
    ((("U" "q"))(""))
    ((("U" "w"))(""))
    ((("U" "e"))(""))
    ((("U" "r"))(""))
    ((("U" "t"))(""))
    ((("U" "y"))(""))
    ((("U" "u"))(""))
    ((("U" "i"))(""))
    ((("U" "o"))(""))
    ((("U" "p"))(""))
    ((("U" "@"))(""))
    ((("U" "["))(""))
    ((("U" "a"))(""))
    ((("U" "s"))(""))
    ((("U" "d"))(""))
    ((("U" "f"))(""))
    ((("U" "g"))(""))
    ((("U" "h"))(""))
    ((("U" "j"))(""))
    ((("U" "k"))(""))
    ((("U" "l"))(""))
    ((("U" ";"))(""))
    ((("U" ":"))(""))
    ((("U" "]"))(""))
    ((("U" "z"))(""))
    ((("U" "x"))(""))
    ((("U" "c"))(""))
    ((("U" "v"))(""))
    ((("U" "b"))(""))
    ((("U" "n"))(""))
    ((("U" "m"))(""))
    ((("U" ","))(""))
    ((("U" "."))(""))
    ((("U" "/"))(""))
    ((("U" "\\"))(""))
    ((("U" "!"))(""))
    ((("U" "\""))(""))
    ((("U" "#"))(""))
    ((("U" "$"))(""))
    ((("U" "%"))(""))
    ((("U" "&"))(""))
    ((("U" "'"))(""))
    ((("U" "("))(""))
    ((("U" ")"))(""))
    ((("U" "|"))(""))
    ((("U" "="))(""))
    ((("U" "~"))(""))
    ((("U" "Q"))(""))
    ((("U" "W"))(""))
    ((("U" "E"))(""))
    ((("U" "R"))(""))
    ((("U" "T"))(""))
    ((("U" "Y"))(""))
    ((("U" "U"))(""))
    ((("U" "I"))(""))
    ((("U" "O"))(""))
    ((("U" "P"))(""))
    ((("U" "`"))(""))
    ((("U" "{"))(""))
    ((("U" "A"))(""))
    ((("U" "S"))(""))
    ((("U" "D"))(""))
    ((("U" "F"))(""))
    ((("U" "G"))(""))
    ((("U" "H"))(""))
    ((("U" "J"))(""))
    ((("U" "K"))(""))
    ((("U" "L"))(""))
    ((("U" "+"))(""))
    ((("U" "*"))(""))
    ((("U" "}"))(""))
    ((("U" "Z"))(""))
    ((("U" "X"))(""))
    ((("U" "C"))(""))
    ((("U" "V"))(""))
    ((("U" "B"))(""))
    ((("U" "N"))(""))
    ((("U" "M"))(""))
    ((("U" "<"))(""))
    ((("U" ">"))(""))
    ((("U" "?"))(""))
    ((("U" "_"))(""))
    ((("U" " "))(""))
    ((("I" "1"))(""))
    ((("I" "2"))(""))
    ((("I" "3"))(""))
    ((("I" "4"))(""))
    ((("I" "5"))(""))
    ((("I" "6"))(""))
    ((("I" "7"))(""))
    ((("I" "8"))(""))
    ((("I" "9"))(""))
    ((("I" "0"))(""))
    ((("I" "-"))(""))
    ((("I" "^"))(""))
    ((("I" "q"))(""))
    ((("I" "w"))(""))
    ((("I" "e"))(""))
    ((("I" "r"))(""))
    ((("I" "t"))(""))
    ((("I" "y"))(""))
    ((("I" "u"))(""))
    ((("I" "i"))(""))
    ((("I" "o"))(""))
    ((("I" "p"))(""))
    ((("I" "@"))(""))
    ((("I" "["))(""))
    ((("I" "a"))(""))
    ((("I" "s"))(""))
    ((("I" "d"))(""))
    ((("I" "f"))(""))
    ((("I" "g"))(""))
    ((("I" "h"))(""))
    ((("I" "j"))(""))
    ((("I" "k"))(""))
    ((("I" "l"))(""))
    ((("I" ";"))(""))
    ((("I" ":"))(""))
    ((("I" "]"))(""))
    ((("I" "z"))(""))
    ((("I" "x"))(""))
    ((("I" "c"))(""))
    ((("I" "v"))(""))
    ((("I" "b"))(""))
    ((("I" "n"))(""))
    ((("I" "m"))(""))
    ((("I" ","))(""))
    ((("I" "."))(""))
    ((("I" "/"))(""))
    ((("I" "\\"))(""))
    ((("I" "!"))(""))
    ((("I" "\""))(""))
    ((("I" "#"))(""))
    ((("I" "$"))(""))
    ((("I" "%"))(""))
    ((("I" "&"))(""))
    ((("I" "'"))(""))
    ((("I" "("))(""))
    ((("I" ")"))(""))
    ((("I" "|"))(""))
    ((("I" "="))(""))
    ((("I" "~"))(""))
    ((("I" "Q"))(""))
    ((("I" "W"))(""))
    ((("I" "E"))(""))
    ((("I" "R"))(""))
    ((("I" "T"))(""))
    ((("I" "Y"))(""))
    ((("I" "U"))(""))
    ((("I" "I"))(""))
    ((("I" "O"))(""))
    ((("I" "P"))(""))
    ((("I" "`"))(""))
    ((("I" "{"))(""))
    ((("I" "A"))(""))
    ((("I" "S"))(""))
    ((("I" "D"))(""))
    ((("I" "F"))(""))
    ((("I" "G"))(""))
    ((("I" "H"))(""))
    ((("I" "J"))(""))
    ((("I" "K"))(""))
    ((("I" "L"))(""))
    ((("I" "+"))(""))
    ((("I" "*"))(""))
    ((("I" "}"))(""))
    ((("I" "Z"))(""))
    ((("I" "X"))(""))
    ((("I" "C"))(""))
    ((("I" "V"))(""))
    ((("I" "B"))(""))
    ((("I" "N"))(""))
    ((("I" "M"))(""))
    ((("I" "<"))(""))
    ((("I" ">"))(""))
    ((("I" "?"))(""))
    ((("I" "_"))(""))
    ((("I" " "))(""))
    ((("O" "1"))(""))
    ((("O" "2"))(""))
    ((("O" "3"))(""))
    ((("O" "4"))(""))
    ((("O" "5"))(""))
    ((("O" "6"))(""))
    ((("O" "7"))(""))
    ((("O" "8"))(""))
    ((("O" "9"))(""))
    ((("O" "0"))(""))
    ((("O" "-"))(""))
    ((("O" "^"))(""))
    ((("O" "q"))(""))
    ((("O" "w"))(""))
    ((("O" "e"))(""))
    ((("O" "r"))(""))
    ((("O" "t"))(""))
    ((("O" "y"))(""))
    ((("O" "u"))(""))
    ((("O" "i"))(""))
    ((("O" "o"))(""))
    ((("O" "p"))(""))
    ((("O" "@"))(""))
    ((("O" "["))(""))
    ((("O" "a"))(""))
    ((("O" "s"))(""))
    ((("O" "d"))(""))
    ((("O" "f"))(""))
    ((("O" "g"))(""))
    ((("O" "h"))(""))
    ((("O" "j"))(""))
    ((("O" "k"))(""))
    ((("O" "l"))(""))
    ((("O" ";"))(""))
    ((("O" ":"))(""))
    ((("O" "]"))(""))
    ((("O" "z"))(""))
    ((("O" "x"))(""))
    ((("O" "c"))(""))
    ((("O" "v"))(""))
    ((("O" "b"))(""))
    ((("O" "n"))(""))
    ((("O" "m"))(""))
    ((("O" ","))(""))
    ((("O" "."))(""))
    ((("O" "/"))(""))
    ((("O" "\\"))(""))
    ((("O" "!"))(""))
    ((("O" "\""))(""))
    ((("O" "#"))(""))
    ((("O" "$"))(""))
    ((("O" "%"))(""))
    ((("O" "&"))(""))
    ((("O" "'"))(""))
    ((("O" "("))(""))
    ((("O" ")"))(""))
    ((("O" "|"))(""))
    ((("O" "="))(""))
    ((("O" "~"))(""))
    ((("O" "Q"))(""))
    ((("O" "W"))(""))
    ((("O" "E"))(""))
    ((("O" "R"))(""))
    ((("O" "T"))(""))
    ((("O" "Y"))(""))
    ((("O" "U"))(""))
    ((("O" "I"))(""))
    ((("O" "O"))(""))
    ((("O" "P"))(""))
    ((("O" "`"))(""))
    ((("O" "{"))(""))
    ((("O" "A"))(""))
    ((("O" "S"))(""))
    ((("O" "D"))(""))
    ((("O" "F"))(""))
    ((("O" "G"))(""))
    ((("O" "H"))(""))
    ((("O" "J"))(""))
    ((("O" "K"))(""))
    ((("O" "L"))(""))
    ((("O" "+"))(""))
    ((("O" "*"))(""))
    ((("O" "}"))(""))
    ((("O" "Z"))(""))
    ((("O" "X"))(""))
    ((("O" "C"))(""))
    ((("O" "V"))(""))
    ((("O" "B"))(""))
    ((("O" "N"))(""))
    ((("O" "M"))(""))
    ((("O" "<"))(""))
    ((("O" ">"))(""))
    ((("O" "?"))(""))
    ((("O" "_"))(""))
    ((("O" " "))(""))
    ((("P" "1"))(""))
    ((("P" "2"))(""))
    ((("P" "3"))(""))
    ((("P" "4"))(""))
    ((("P" "5"))(""))
    ((("P" "6"))(""))
    ((("P" "7"))(""))
    ((("P" "8"))(""))
    ((("P" "9"))(""))
    ((("P" "0"))(""))
    ((("P" "-"))(""))
    ((("P" "^"))(""))
    ((("P" "q"))(""))
    ((("P" "w"))(""))
    ((("P" "e"))(""))
    ((("P" "r"))(""))
    ((("P" "t"))(""))
    ((("P" "y"))(""))
    ((("P" "u"))(""))
    ((("P" "i"))(""))
    ((("P" "o"))(""))
    ((("P" "p"))(""))
    ((("P" "@"))(""))
    ((("P" "["))(""))
    ((("P" "a"))(""))
    ((("P" "s"))(""))
    ((("P" "d"))(""))
    ((("P" "f"))(""))
    ((("P" "g"))(""))
    ((("P" "h"))(""))
    ((("P" "j"))(""))
    ((("P" "k"))(""))
    ((("P" "l"))(""))
    ((("P" ";"))(""))
    ((("P" ":"))(""))
    ((("P" "]"))(""))
    ((("P" "z"))(""))
    ((("P" "x"))(""))
    ((("P" "c"))(""))
    ((("P" "v"))(""))
    ((("P" "b"))(""))
    ((("P" "n"))(""))
    ((("P" "m"))(""))
    ((("P" ","))(""))
    ((("P" "."))(""))
    ((("P" "/"))(""))
    ((("P" "\\"))(""))
    ((("P" "!"))(""))
    ((("P" "\""))(""))
    ((("P" "#"))(""))
    ((("P" "$"))(""))
    ((("P" "%"))(""))
    ((("P" "&"))(""))
    ((("P" "'"))(""))
    ((("P" "("))(""))
    ((("P" ")"))(""))
    ((("P" "|"))(""))
    ((("P" "="))(""))
    ((("P" "~"))(""))
    ((("P" "Q"))(""))
    ((("P" "W"))(""))
    ((("P" "E"))(""))
    ((("P" "R"))(""))
    ((("P" "T"))(""))
    ((("P" "Y"))(""))
    ((("P" "U"))(""))
    ((("P" "I"))(""))
    ((("P" "O"))(""))
    ((("P" "P"))(""))
    ((("P" "`"))(""))
    ((("P" "{"))(""))
    ((("P" "A"))(""))
    ((("P" "S"))(""))
    ((("P" "D"))(""))
    ((("P" "F"))(""))
    ((("P" "G"))(""))
    ((("P" "H"))(""))
    ((("P" "J"))(""))
    ((("P" "K"))(""))
    ((("P" "L"))(""))
    ((("P" "+"))(""))
    ((("P" "*"))(""))
    ((("P" "}"))(""))
    ((("P" "Z"))(""))
    ((("P" "X"))(""))
    ((("P" "C"))(""))
    ((("P" "V"))(""))
    ((("P" "B"))(""))
    ((("P" "N"))(""))
    ((("P" "M"))(""))
    ((("P" "<"))(""))
    ((("P" ">"))(""))
    ((("P" "?"))(""))
    ((("P" "_"))(""))
    ((("P" " "))(""))
    ((("`" "1"))(""))
    ((("`" "2"))(""))
    ((("`" "3"))(""))
    ((("`" "4"))(""))
    ((("`" "5"))(""))
    ((("`" "6"))(""))
    ((("`" "7"))(""))
    ((("`" "8"))(""))
    ((("`" "9"))(""))
    ((("`" "0"))(""))
    ((("`" "-"))(""))
    ((("`" "^"))(""))
    ((("`" "q"))(""))
    ((("`" "w"))(""))
    ((("`" "e"))(""))
    ((("`" "r"))(""))
    ((("`" "t"))(""))
    ((("`" "y"))(""))
    ((("`" "u"))(""))
    ((("`" "i"))(""))
    ((("`" "o"))(""))
    ((("`" "p"))(""))
    ((("`" "@"))(""))
    ((("`" "["))(""))
    ((("`" "a"))(""))
    ((("`" "s"))(""))
    ((("`" "d"))(""))
    ((("`" "f"))(""))
    ((("`" "g"))(""))
    ((("`" "h"))(""))
    ((("`" "j"))(""))
    ((("`" "k"))(""))
    ((("`" "l"))(""))
    ((("`" ";"))(""))
    ((("`" ":"))(""))
    ((("`" "]"))(""))
    ((("`" "z"))(""))
    ((("`" "x"))(""))
    ((("`" "c"))(""))
    ((("`" "v"))(""))
    ((("`" "b"))(""))
    ((("`" "n"))(""))
    ((("`" "m"))(""))
    ((("`" ","))(""))
    ((("`" "."))(""))
    ((("`" "/"))(""))
    ((("`" "\\"))(""))
    ((("`" "!"))(""))
    ((("`" "\""))(""))
    ((("`" "#"))(""))
    ((("`" "$"))(""))
    ((("`" "%"))(""))
    ((("`" "&"))(""))
    ((("`" "'"))(""))
    ((("`" "("))(""))
    ((("`" ")"))(""))
    ((("`" "|"))(""))
    ((("`" "="))(""))
    ((("`" "~"))(""))
    ((("`" "Q"))(""))
    ((("`" "W"))(""))
    ((("`" "E"))(""))
    ((("`" "R"))(""))
    ((("`" "T"))(""))
    ((("`" "Y"))(""))
    ((("`" "U"))(""))
    ((("`" "I"))(""))
    ((("`" "O"))(""))
    ((("`" "P"))(""))
    ((("`" "`"))(""))
    ((("`" "{"))(""))
    ((("`" "A"))(""))
    ((("`" "S"))(""))
    ((("`" "D"))(""))
    ((("`" "F"))(""))
    ((("`" "G"))(""))
    ((("`" "H"))(""))
    ((("`" "J"))(""))
    ((("`" "K"))(""))
    ((("`" "L"))(""))
    ((("`" "+"))(""))
    ((("`" "*"))(""))
    ((("`" "}"))(""))
    ((("`" "Z"))(""))
    ((("`" "X"))(""))
    ((("`" "C"))(""))
    ((("`" "V"))(""))
    ((("`" "B"))(""))
    ((("`" "N"))(""))
    ((("`" "M"))(""))
    ((("`" "<"))(""))
    ((("`" ">"))(""))
    ((("`" "?"))(""))
    ((("`" "_"))(""))
    ((("`" " "))(""))
    ((("{" "1"))(""))
    ((("{" "2"))(""))
    ((("{" "3"))(""))
    ((("{" "4"))(""))
    ((("{" "5"))(""))
    ((("{" "6"))(""))
    ((("{" "7"))(""))
    ((("{" "8"))(""))
    ((("{" "9"))(""))
    ((("{" "0"))(""))
    ((("{" "-"))(""))
    ((("{" "^"))(""))
    ((("{" "q"))(""))
    ((("{" "w"))(""))
    ((("{" "e"))(""))
    ((("{" "r"))(""))
    ((("{" "t"))(""))
    ((("{" "y"))(""))
    ((("{" "u"))(""))
    ((("{" "i"))(""))
    ((("{" "o"))(""))
    ((("{" "p"))(""))
    ((("{" "@"))(""))
    ((("{" "["))(""))
    ((("{" "a"))(""))
    ((("{" "s"))(""))
    ((("{" "d"))(""))
    ((("{" "f"))(""))
    ((("{" "g"))(""))
    ((("{" "h"))(""))
    ((("{" "j"))(""))
    ((("{" "k"))(""))
    ((("{" "l"))(""))
    ((("{" ";"))(""))
    ((("{" ":"))(""))
    ((("{" "]"))(""))
    ((("{" "z"))(""))
    ((("{" "x"))(""))
    ((("{" "c"))(""))
    ((("{" "v"))(""))
    ((("{" "b"))(""))
    ((("{" "n"))(""))
    ((("{" "m"))(""))
    ((("{" ","))(""))
    ((("{" "."))(""))
    ((("{" "/"))(""))
    ((("{" "\\"))(""))
    ((("{" "!"))(""))
    ((("{" "\""))(""))
    ((("{" "#"))(""))
    ((("{" "$"))(""))
    ((("{" "%"))(""))
    ((("{" "&"))(""))
    ((("{" "'"))(""))
    ((("{" "("))(""))
    ((("{" ")"))(""))
    ((("{" "|"))(""))
    ((("{" "="))(""))
    ((("{" "~"))(""))
    ((("{" "Q"))(""))
    ((("{" "W"))(""))
    ((("{" "E"))(""))
    ((("{" "R"))(""))
    ((("{" "T"))(""))
    ((("{" "Y"))(""))
    ((("{" "U"))(""))
    ((("{" "I"))(""))
    ((("{" "O"))(""))
    ((("{" "P"))(""))
    ((("{" "`"))(""))
    ((("{" "{"))(""))
    ((("{" "A"))(""))
    ((("{" "S"))(""))
    ((("{" "D"))(""))
    ((("{" "F"))(""))
    ((("{" "G"))(""))
    ((("{" "H"))(""))
    ((("{" "J"))(""))
    ((("{" "K"))(""))
    ((("{" "L"))(""))
    ((("{" "+"))(""))
    ((("{" "*"))(""))
    ((("{" "}"))(""))
    ((("{" "Z"))(""))
    ((("{" "X"))(""))
    ((("{" "C"))(""))
    ((("{" "V"))(""))
    ((("{" "B"))(""))
    ((("{" "N"))(""))
    ((("{" "M"))(""))
    ((("{" "<"))(""))
    ((("{" ">"))(""))
    ((("{" "?"))(""))
    ((("{" "_"))(""))
    ((("{" " "))(""))
    ((("A" "1"))(""))
    ((("A" "2"))(""))
    ((("A" "3"))(""))
    ((("A" "4"))(""))
    ((("A" "5"))(""))
    ((("A" "6"))(""))
    ((("A" "7"))(""))
    ((("A" "8"))(""))
    ((("A" "9"))(""))
    ((("A" "0"))(""))
    ((("A" "-"))(""))
    ((("A" "^"))(""))
    ((("A" "q"))(""))
    ((("A" "w"))(""))
    ((("A" "e"))(""))
    ((("A" "r"))(""))
    ((("A" "t"))(""))
    ((("A" "y"))(""))
    ((("A" "u"))(""))
    ((("A" "i"))(""))
    ((("A" "o"))(""))
    ((("A" "p"))(""))
    ((("A" "@"))(""))
    ((("A" "["))(""))
    ((("A" "a"))(""))
    ((("A" "s"))(""))
    ((("A" "d"))(""))
    ((("A" "f"))(""))
    ((("A" "g"))(""))
    ((("A" "h"))(""))
    ((("A" "j"))(""))
    ((("A" "k"))(""))
    ((("A" "l"))(""))
    ((("A" ";"))(""))
    ((("A" ":"))(""))
    ((("A" "]"))(""))
    ((("A" "z"))(""))
    ((("A" "x"))(""))
    ((("A" "c"))(""))
    ((("A" "v"))(""))
    ((("A" "b"))(""))
    ((("A" "n"))(""))
    ((("A" "m"))(""))
    ((("A" ","))(""))
    ((("A" "."))(""))
    ((("A" "/"))(""))
    ((("A" "\\"))(""))
    ((("A" "!"))(""))
    ((("A" "\""))(""))
    ((("A" "#"))(""))
    ((("A" "$"))(""))
    ((("A" "%"))(""))
    ((("A" "&"))(""))
    ((("A" "'"))(""))
    ((("A" "("))(""))
    ((("A" ")"))(""))
    ((("A" "|"))(""))
    ((("A" "="))(""))
    ((("A" "~"))(""))
    ((("A" "Q"))(""))
    ((("A" "W"))(""))
    ((("A" "E"))(""))
    ((("A" "R"))(""))
    ((("A" "T"))(""))
    ((("A" "Y"))(""))
    ((("A" "U"))(""))
    ((("A" "I"))(""))
    ((("A" "O"))(""))
    ((("A" "P"))(""))
    ((("A" "`"))(""))
    ((("A" "{"))(""))
    ((("A" "A"))(""))
    ((("A" "S"))(""))
    ((("A" "D"))(""))
    ((("A" "F"))(""))
    ((("A" "G"))(""))
    ((("A" "H"))(""))
    ((("A" "J"))(""))
    ((("A" "K"))(""))
    ((("A" "L"))(""))
    ((("A" "+"))(""))
    ((("A" "*"))(""))
    ((("A" "}"))(""))
    ((("A" "Z"))(""))
    ((("A" "X"))(""))
    ((("A" "C"))(""))
    ((("A" "V"))(""))
    ((("A" "B"))(""))
    ((("A" "N"))(""))
    ((("A" "M"))(""))
    ((("A" "<"))(""))
    ((("A" ">"))(""))
    ((("A" "?"))(""))
    ((("A" "_"))(""))
    ((("A" " "))(""))
    ((("S" "1"))(""))
    ((("S" "2"))(""))
    ((("S" "3"))(""))
    ((("S" "4"))(""))
    ((("S" "5"))(""))
    ((("S" "6"))(""))
    ((("S" "7"))(""))
    ((("S" "8"))(""))
    ((("S" "9"))(""))
    ((("S" "0"))(""))
    ((("S" "-"))(""))
    ((("S" "^"))(""))
    ((("S" "q"))(""))
    ((("S" "w"))(""))
    ((("S" "e"))(""))
    ((("S" "r"))(""))
    ((("S" "t"))(""))
    ((("S" "y"))(""))
    ((("S" "u"))(""))
    ((("S" "i"))(""))
    ((("S" "o"))(""))
    ((("S" "p"))(""))
    ((("S" "@"))(""))
    ((("S" "["))(""))
    ((("S" "a"))(""))
    ((("S" "s"))(""))
    ((("S" "d"))(""))
    ((("S" "f"))(""))
    ((("S" "g"))(""))
    ((("S" "h"))(""))
    ((("S" "j"))(""))
    ((("S" "k"))(""))
    ((("S" "l"))(""))
    ((("S" ";"))(""))
    ((("S" ":"))(""))
    ((("S" "]"))(""))
    ((("S" "z"))(""))
    ((("S" "x"))(""))
    ((("S" "c"))(""))
    ((("S" "v"))(""))
    ((("S" "b"))(""))
    ((("S" "n"))(""))
    ((("S" "m"))(""))
    ((("S" ","))(""))
    ((("S" "."))(""))
    ((("S" "/"))(""))
    ((("S" "\\"))(""))
    ((("S" "!"))(""))
    ((("S" "\""))(""))
    ((("S" "#"))(""))
    ((("S" "$"))(""))
    ((("S" "%"))(""))
    ((("S" "&"))(""))
    ((("S" "'"))(""))
    ((("S" "("))(""))
    ((("S" ")"))(""))
    ((("S" "|"))(""))
    ((("S" "="))(""))
    ((("S" "~"))(""))
    ((("S" "Q"))(""))
    ((("S" "W"))(""))
    ((("S" "E"))(""))
    ((("S" "R"))(""))
    ((("S" "T"))(""))
    ((("S" "Y"))(""))
    ((("S" "U"))(""))
    ((("S" "I"))(""))
    ((("S" "O"))(""))
    ((("S" "P"))(""))
    ((("S" "`"))(""))
    ((("S" "{"))(""))
    ((("S" "A"))(""))
    ((("S" "S"))(""))
    ((("S" "D"))(""))
    ((("S" "F"))(""))
    ((("S" "G"))(""))
    ((("S" "H"))(""))
    ((("S" "J"))(""))
    ((("S" "K"))(""))
    ((("S" "L"))(""))
    ((("S" "+"))(""))
    ((("S" "*"))(""))
    ((("S" "}"))(""))
    ((("S" "Z"))(""))
    ((("S" "X"))(""))
    ((("S" "C"))(""))
    ((("S" "V"))(""))
    ((("S" "B"))(""))
    ((("S" "N"))(""))
    ((("S" "M"))(""))
    ((("S" "<"))(""))
    ((("S" ">"))(""))
    ((("S" "?"))(""))
    ((("S" "_"))(""))
    ((("S" " "))(""))
    ((("D" "1"))(""))
    ((("D" "2"))(""))
    ((("D" "3"))(""))
    ((("D" "4"))(""))
    ((("D" "5"))(""))
    ((("D" "6"))(""))
    ((("D" "7"))(""))
    ((("D" "8"))(""))
    ((("D" "9"))(""))
    ((("D" "0"))(""))
    ((("D" "-"))(""))
    ((("D" "^"))(""))
    ((("D" "q"))(""))
    ((("D" "w"))(""))
    ((("D" "e"))(""))
    ((("D" "r"))(""))
    ((("D" "t"))(""))
    ((("D" "y"))(""))
    ((("D" "u"))(""))
    ((("D" "i"))(""))
    ((("D" "o"))(""))
    ((("D" "p"))(""))
    ((("D" "@"))(""))
    ((("D" "["))(""))
    ((("D" "a"))(""))
    ((("D" "s"))(""))
    ((("D" "d"))(""))
    ((("D" "f"))(""))
    ((("D" "g"))(""))
    ((("D" "h"))(""))
    ((("D" "j"))(""))
    ((("D" "k"))(""))
    ((("D" "l"))(""))
    ((("D" ";"))(""))
    ((("D" ":"))(""))
    ((("D" "]"))(""))
    ((("D" "z"))(""))
    ((("D" "x"))(""))
    ((("D" "c"))(""))
    ((("D" "v"))(""))
    ((("D" "b"))(""))
    ((("D" "n"))(""))
    ((("D" "m"))(""))
    ((("D" ","))(""))
    ((("D" "."))(""))
    ((("D" "/"))(""))
    ((("D" "\\"))(""))
    ((("D" "!"))(""))
    ((("D" "\""))(""))
    ((("D" "#"))(""))
    ((("D" "$"))(""))
    ((("D" "%"))(""))
    ((("D" "&"))(""))
    ((("D" "'"))(""))
    ((("D" "("))(""))
    ((("D" ")"))(""))
    ((("D" "|"))(""))
    ((("D" "="))(""))
    ((("D" "~"))(""))
    ((("D" "Q"))(""))
    ((("D" "W"))(""))
    ((("D" "E"))(""))
    ((("D" "R"))(""))
    ((("D" "T"))(""))
    ((("D" "Y"))(""))
    ((("D" "U"))(""))
    ((("D" "I"))(""))
    ((("D" "O"))(""))
    ((("D" "P"))(""))
    ((("D" "`"))(""))
    ((("D" "{"))(""))
    ((("D" "A"))(""))
    ((("D" "S"))(""))
    ((("D" "D"))(""))
    ((("D" "F"))(""))
    ((("D" "G"))(""))
    ((("D" "H"))(""))
    ((("D" "J"))(""))
    ((("D" "K"))(""))
    ((("D" "L"))(""))
    ((("D" "+"))(""))
    ((("D" "*"))(""))
    ((("D" "}"))(""))
    ((("D" "Z"))(""))
    ((("D" "X"))(""))
    ((("D" "C"))(""))
    ((("D" "V"))(""))
    ((("D" "B"))(""))
    ((("D" "N"))(""))
    ((("D" "M"))(""))
    ((("D" "<"))(""))
    ((("D" ">"))(""))
    ((("D" "?"))(""))
    ((("D" "_"))(""))
    ((("D" " "))(""))
    ((("F" "1"))(""))
    ((("F" "2"))(""))
    ((("F" "3"))(""))
    ((("F" "4"))(""))
    ((("F" "5"))(""))
    ((("F" "6"))(""))
    ((("F" "7"))(""))
    ((("F" "8"))(""))
    ((("F" "9"))(""))
    ((("F" "0"))(""))
    ((("F" "-"))(""))
    ((("F" "^"))(""))
    ((("F" "q"))(""))
    ((("F" "w"))(""))
    ((("F" "e"))(""))
    ((("F" "r"))(""))
    ((("F" "t"))(""))
    ((("F" "y"))(""))
    ((("F" "u"))(""))
    ((("F" "i"))(""))
    ((("F" "o"))(""))
    ((("F" "p"))(""))
    ((("F" "@"))(""))
    ((("F" "["))(""))
    ((("F" "a"))(""))
    ((("F" "s"))(""))
    ((("F" "d"))(""))
    ((("F" "f"))(""))
    ((("F" "g"))(""))
    ((("F" "h"))(""))
    ((("F" "j"))(""))
    ((("F" "k"))(""))
    ((("F" "l"))(""))
    ((("F" ";"))(""))
    ((("F" ":"))(""))
    ((("F" "]"))(""))
    ((("F" "z"))(""))
    ((("F" "x"))(""))
    ((("F" "c"))(""))
    ((("F" "v"))(""))
    ((("F" "b"))(""))
    ((("F" "n"))(""))
    ((("F" "m"))(""))
    ((("F" ","))(""))
    ((("F" "."))(""))
    ((("F" "/"))(""))
    ((("F" "\\"))(""))
    ((("F" "!"))(""))
    ((("F" "\""))(""))
    ((("F" "#"))(""))
    ((("F" "$"))(""))
    ((("F" "%"))(""))
    ((("F" "&"))(""))
    ((("F" "'"))(""))
    ((("F" "("))(""))
    ((("F" ")"))(""))
    ((("F" "|"))(""))
    ((("F" "="))(""))
    ((("F" "~"))(""))
    ((("F" "Q"))(""))
    ((("F" "W"))(""))
    ((("F" "E"))(""))
    ((("F" "R"))(""))
    ((("F" "T"))(""))
    ((("F" "Y"))(""))
    ((("F" "U"))(""))
    ((("F" "I"))(""))
    ((("F" "O"))(""))
    ((("F" "P"))(""))
    ((("F" "`"))(""))
    ((("F" "{"))(""))
    ((("F" "A"))(""))
    ((("F" "S"))(""))
    ((("F" "D"))(""))
    ((("F" "F"))(""))
    ((("F" "G"))(""))
    ((("F" "H"))(""))
    ((("F" "J"))(""))
    ((("F" "K"))(""))
    ((("F" "L"))(""))
    ((("F" "+"))(""))
    ((("F" "*"))(""))
    ((("F" "}"))(""))
    ((("F" "Z"))(""))
    ((("F" "X"))(""))
    ((("F" "C"))(""))
    ((("F" "V"))(""))
    ((("F" "B"))(""))
    ((("F" "N"))(""))
    ((("F" "M"))(""))
    ((("F" "<"))(""))
    ((("F" ">"))(""))
    ((("F" "?"))(""))
    ((("F" "_"))(""))
    ((("F" " "))(""))
    ((("G" "1"))(""))
    ((("G" "2"))(""))
    ((("G" "3"))(""))
    ((("G" "4"))(""))
    ((("G" "5"))(""))
    ((("G" "6"))(""))
    ((("G" "7"))(""))
    ((("G" "8"))(""))
    ((("G" "9"))(""))
    ((("G" "0"))(""))
    ((("G" "-"))(""))
    ((("G" "^"))(""))
    ((("G" "q"))(""))
    ((("G" "w"))(""))
    ((("G" "e"))(""))
    ((("G" "r"))(""))
    ((("G" "t"))(""))
    ((("G" "y"))(""))
    ((("G" "u"))(""))
    ((("G" "i"))(""))
    ((("G" "o"))(""))
    ((("G" "p"))(""))
    ((("G" "@"))(""))
    ((("G" "["))(""))
    ((("G" "a"))(""))
    ((("G" "s"))(""))
    ((("G" "d"))(""))
    ((("G" "f"))(""))
    ((("G" "g"))(""))
    ((("G" "h"))(""))
    ((("G" "j"))(""))
    ((("G" "k"))(""))
    ((("G" "l"))(""))
    ((("G" ";"))(""))
    ((("G" ":"))(""))
    ((("G" "]"))(""))
    ((("G" "z"))(""))
    ((("G" "x"))(""))
    ((("G" "c"))(""))
    ((("G" "v"))(""))
    ((("G" "b"))(""))
    ((("G" "n"))(""))
    ((("G" "m"))(""))
    ((("G" ","))(""))
    ((("G" "."))(""))
    ((("G" "/"))(""))
    ((("G" "\\"))(""))
    ((("G" "!"))(""))
    ((("G" "\""))(""))
    ((("G" "#"))(""))
    ((("G" "$"))(""))
    ((("G" "%"))(""))
    ((("G" "&"))(""))
    ((("G" "'"))(""))
    ((("G" "("))(""))
    ((("G" ")"))(""))
    ((("G" "|"))(""))
    ((("G" "="))(""))
    ((("G" "~"))(""))
    ((("G" "Q"))(""))
    ((("G" "W"))(""))
    ((("G" "E"))(""))
    ((("G" "R"))(""))
    ((("G" "T"))(""))
    ((("G" "Y"))(""))
    ((("G" "U"))(""))
    ((("G" "I"))(""))
    ((("G" "O"))(""))
    ((("G" "P"))(""))
    ((("G" "`"))(""))
    ((("G" "{"))(""))
    ((("G" "A"))(""))
    ((("G" "S"))(""))
    ((("G" "D"))(""))
    ((("G" "F"))(""))
    ((("G" "G"))(""))
    ((("G" "H"))(""))
    ((("G" "J"))(""))
    ((("G" "K"))(""))
    ((("G" "L"))(""))
    ((("G" "+"))(""))
    ((("G" "*"))(""))
    ((("G" "}"))(""))
    ((("G" "Z"))(""))
    ((("G" "X"))(""))
    ((("G" "C"))(""))
    ((("G" "V"))(""))
    ((("G" "B"))(""))
    ((("G" "N"))(""))
    ((("G" "M"))(""))
    ((("G" "<"))(""))
    ((("G" ">"))(""))
    ((("G" "?"))(""))
    ((("G" "_"))(""))
    ((("G" " "))(""))
    ((("H" "1"))(""))
    ((("H" "2"))(""))
    ((("H" "3"))(""))
    ((("H" "4"))(""))
    ((("H" "5"))(""))
    ((("H" "6"))(""))
    ((("H" "7"))(""))
    ((("H" "8"))(""))
    ((("H" "9"))(""))
    ((("H" "0"))(""))
    ((("H" "-"))(""))
    ((("H" "^"))(""))
    ((("H" "q"))(""))
    ((("H" "w"))(""))
    ((("H" "e"))(""))
    ((("H" "r"))(""))
    ((("H" "t"))(""))
    ((("H" "y"))(""))
    ((("H" "u"))(""))
    ((("H" "i"))(""))
    ((("H" "o"))(""))
    ((("H" "p"))(""))
    ((("H" "@"))(""))
    ((("H" "["))(""))
    ((("H" "a"))(""))
    ((("H" "s"))(""))
    ((("H" "d"))(""))
    ((("H" "f"))(""))
    ((("H" "g"))(""))
    ((("H" "h"))(""))
    ((("H" "j"))(""))
    ((("H" "k"))(""))
    ((("H" "l"))(""))
    ((("H" ";"))(""))
    ((("H" ":"))(""))
    ((("H" "]"))(""))
    ((("H" "z"))(""))
    ((("H" "x"))(""))
    ((("H" "c"))(""))
    ((("H" "v"))(""))
    ((("H" "b"))(""))
    ((("H" "n"))(""))
    ((("H" "m"))(""))
    ((("H" ","))(""))
    ((("H" "."))(""))
    ((("H" "/"))(""))
    ((("H" "\\"))(""))
    ((("H" "!"))(""))
    ((("H" "\""))(""))
    ((("H" "#"))(""))
    ((("H" "$"))(""))
    ((("H" "%"))(""))
    ((("H" "&"))(""))
    ((("H" "'"))(""))
    ((("H" "("))(""))
    ((("H" ")"))(""))
    ((("H" "|"))(""))
    ((("H" "="))(""))
    ((("H" "~"))(""))
    ((("H" "Q"))(""))
    ((("H" "W"))(""))
    ((("H" "E"))(""))
    ((("H" "R"))(""))
    ((("H" "T"))(""))
    ((("H" "Y"))(""))
    ((("H" "U"))(""))
    ((("H" "I"))(""))
    ((("H" "O"))(""))
    ((("H" "P"))(""))
    ((("H" "`"))(""))
    ((("H" "{"))(""))
    ((("H" "A"))(""))
    ((("H" "S"))(""))
    ((("H" "D"))(""))
    ((("H" "F"))(""))
    ((("H" "G"))(""))
    ((("H" "H"))(""))
    ((("H" "J"))(""))
    ((("H" "K"))(""))
    ((("H" "L"))(""))
    ((("H" "+"))(""))
    ((("H" "*"))(""))
    ((("H" "}"))(""))
    ((("H" "Z"))(""))
    ((("H" "X"))(""))
    ((("H" "C"))(""))
    ((("H" "V"))(""))
    ((("H" "B"))(""))
    ((("H" "N"))(""))
    ((("H" "M"))(""))
    ((("H" "<"))(""))
    ((("H" ">"))(""))
    ((("H" "?"))(""))
    ((("H" "_"))(""))
    ((("H" " "))(""))
    ((("J" "1"))(""))
    ((("J" "2"))(""))
    ((("J" "3"))(""))
    ((("J" "4"))(""))
    ((("J" "5"))(""))
    ((("J" "6"))(""))
    ((("J" "7"))(""))
    ((("J" "8"))(""))
    ((("J" "9"))(""))
    ((("J" "0"))(""))
    ((("J" "-"))(""))
    ((("J" "^"))(""))
    ((("J" "q"))(""))
    ((("J" "w"))(""))
    ((("J" "e"))(""))
    ((("J" "r"))(""))
    ((("J" "t"))(""))
    ((("J" "y"))(""))
    ((("J" "u"))(""))
    ((("J" "i"))(""))
    ((("J" "o"))(""))
    ((("J" "p"))(""))
    ((("J" "@"))(""))
    ((("J" "["))(""))
    ((("J" "a"))(""))
    ((("J" "s"))(""))
    ((("J" "d"))(""))
    ((("J" "f"))(""))
    ((("J" "g"))(""))
    ((("J" "h"))(""))
    ((("J" "j"))(""))
    ((("J" "k"))(""))
    ((("J" "l"))(""))
    ((("J" ";"))(""))
    ((("J" ":"))(""))
    ((("J" "]"))(""))
    ((("J" "z"))(""))
    ((("J" "x"))(""))
    ((("J" "c"))(""))
    ((("J" "v"))(""))
    ((("J" "b"))(""))
    ((("J" "n"))(""))
    ((("J" "m"))(""))
    ((("J" ","))(""))
    ((("J" "."))(""))
    ((("J" "/"))(""))
    ((("J" "\\"))(""))
    ((("J" "!"))(""))
    ((("J" "\""))(""))
    ((("J" "#"))(""))
    ((("J" "$"))(""))
    ((("J" "%"))(""))
    ((("J" "&"))(""))
    ((("J" "'"))(""))
    ((("J" "("))(""))
    ((("J" ")"))(""))
    ((("J" "|"))(""))
    ((("J" "="))(""))
    ((("J" "~"))(""))
    ((("J" "Q"))(""))
    ((("J" "W"))(""))
    ((("J" "E"))(""))
    ((("J" "R"))(""))
    ((("J" "T"))(""))
    ((("J" "Y"))(""))
    ((("J" "U"))(""))
    ((("J" "I"))(""))
    ((("J" "O"))(""))
    ((("J" "P"))(""))
    ((("J" "`"))(""))
    ((("J" "{"))(""))
    ((("J" "A"))(""))
    ((("J" "S"))(""))
    ((("J" "D"))(""))
    ((("J" "F"))(""))
    ((("J" "G"))(""))
    ((("J" "H"))(""))
    ((("J" "J"))(""))
    ((("J" "K"))(""))
    ((("J" "L"))(""))
    ((("J" "+"))(""))
    ((("J" "*"))(""))
    ((("J" "}"))(""))
    ((("J" "Z"))(""))
    ((("J" "X"))(""))
    ((("J" "C"))(""))
    ((("J" "V"))(""))
    ((("J" "B"))(""))
    ((("J" "N"))(""))
    ((("J" "M"))(""))
    ((("J" "<"))(""))
    ((("J" ">"))(""))
    ((("J" "?"))(""))
    ((("J" "_"))(""))
    ((("J" " "))(""))
    ((("K" "1"))(""))
    ((("K" "2"))(""))
    ((("K" "3"))(""))
    ((("K" "4"))(""))
    ((("K" "5"))(""))
    ((("K" "6"))(""))
    ((("K" "7"))(""))
    ((("K" "8"))(""))
    ((("K" "9"))(""))
    ((("K" "0"))(""))
    ((("K" "-"))(""))
    ((("K" "^"))(""))
    ((("K" "q"))(""))
    ((("K" "w"))(""))
    ((("K" "e"))(""))
    ((("K" "r"))(""))
    ((("K" "t"))(""))
    ((("K" "y"))(""))
    ((("K" "u"))(""))
    ((("K" "i"))(""))
    ((("K" "o"))(""))
    ((("K" "p"))(""))
    ((("K" "@"))(""))
    ((("K" "["))(""))
    ((("K" "a"))(""))
    ((("K" "s"))(""))
    ((("K" "d"))(""))
    ((("K" "f"))(""))
    ((("K" "g"))(""))
    ((("K" "h"))(""))
    ((("K" "j"))(""))
    ((("K" "k"))(""))
    ((("K" "l"))(""))
    ((("K" ";"))(""))
    ((("K" ":"))(""))
    ((("K" "]"))(""))
    ((("K" "z"))(""))
    ((("K" "x"))(""))
    ((("K" "c"))(""))
    ((("K" "v"))(""))
    ((("K" "b"))(""))
    ((("K" "n"))(""))
    ((("K" "m"))(""))
    ((("K" ","))(""))
    ((("K" "."))(""))
    ((("K" "/"))(""))
    ((("K" "\\"))(""))
    ((("K" "!"))(""))
    ((("K" "\""))(""))
    ((("K" "#"))(""))
    ((("K" "$"))(""))
    ((("K" "%"))(""))
    ((("K" "&"))(""))
    ((("K" "'"))(""))
    ((("K" "("))(""))
    ((("K" ")"))(""))
    ((("K" "|"))(""))
    ((("K" "="))(""))
    ((("K" "~"))(""))
    ((("K" "Q"))(""))
    ((("K" "W"))(""))
    ((("K" "E"))(""))
    ((("K" "R"))(""))
    ((("K" "T"))(""))
    ((("K" "Y"))(""))
    ((("K" "U"))(""))
    ((("K" "I"))(""))
    ((("K" "O"))(""))
    ((("K" "P"))(""))
    ((("K" "`"))(""))
    ((("K" "{"))(""))
    ((("K" "A"))(""))
    ((("K" "S"))(""))
    ((("K" "D"))(""))
    ((("K" "F"))(""))
    ((("K" "G"))(""))
    ((("K" "H"))(""))
    ((("K" "J"))(""))
    ((("K" "K"))(""))
    ((("K" "L"))(""))
    ((("K" "+"))(""))
    ((("K" "*"))(""))
    ((("K" "}"))(""))
    ((("K" "Z"))(""))
    ((("K" "X"))(""))
    ((("K" "C"))(""))
    ((("K" "V"))(""))
    ((("K" "B"))(""))
    ((("K" "N"))(""))
    ((("K" "M"))(""))
    ((("K" "<"))(""))
    ((("K" ">"))(""))
    ((("K" "?"))(""))
    ((("K" "_"))(""))
    ((("K" " "))(""))
    ((("L" "1"))(""))
    ((("L" "2"))(""))
    ((("L" "3"))(""))
    ((("L" "4"))(""))
    ((("L" "5"))(""))
    ((("L" "6"))(""))
    ((("L" "7"))(""))
    ((("L" "8"))(""))
    ((("L" "9"))(""))
    ((("L" "0"))(""))
    ((("L" "-"))(""))
    ((("L" "^"))(""))
    ((("L" "q"))(""))
    ((("L" "w"))(""))
    ((("L" "e"))(""))
    ((("L" "r"))(""))
    ((("L" "t"))(""))
    ((("L" "y"))(""))
    ((("L" "u"))(""))
    ((("L" "i"))(""))
    ((("L" "o"))(""))
    ((("L" "p"))(""))
    ((("L" "@"))(""))
    ((("L" "["))(""))
    ((("L" "a"))(""))
    ((("L" "s"))(""))
    ((("L" "d"))(""))
    ((("L" "f"))(""))
    ((("L" "g"))(""))
    ((("L" "h"))(""))
    ((("L" "j"))(""))
    ((("L" "k"))(""))
    ((("L" "l"))(""))
    ((("L" ";"))(""))
    ((("L" ":"))(""))
    ((("L" "]"))(""))
    ((("L" "z"))(""))
    ((("L" "x"))(""))
    ((("L" "c"))(""))
    ((("L" "v"))(""))
    ((("L" "b"))(""))
    ((("L" "n"))(""))
    ((("L" "m"))(""))
    ((("L" ","))(""))
    ((("L" "."))(""))
    ((("L" "/"))(""))
    ((("L" "\\"))(""))
    ((("L" "!"))(""))
    ((("L" "\""))(""))
    ((("L" "#"))(""))
    ((("L" "$"))(""))
    ((("L" "%"))(""))
    ((("L" "&"))(""))
    ((("L" "'"))(""))
    ((("L" "("))(""))
    ((("L" ")"))(""))
    ((("L" "|"))(""))
    ((("L" "="))(""))
    ((("L" "~"))(""))
    ((("L" "Q"))(""))
    ((("L" "W"))(""))
    ((("L" "E"))(""))
    ((("L" "R"))(""))
    ((("L" "T"))(""))
    ((("L" "Y"))(""))
    ((("L" "U"))(""))
    ((("L" "I"))(""))
    ((("L" "O"))(""))
    ((("L" "P"))(""))
    ((("L" "`"))(""))
    ((("L" "{"))(""))
    ((("L" "A"))(""))
    ((("L" "S"))(""))
    ((("L" "D"))(""))
    ((("L" "F"))(""))
    ((("L" "G"))(""))
    ((("L" "H"))(""))
    ((("L" "J"))(""))
    ((("L" "K"))(""))
    ((("L" "L"))(""))
    ((("L" "+"))(""))
    ((("L" "*"))(""))
    ((("L" "}"))(""))
    ((("L" "Z"))(""))
    ((("L" "X"))(""))
    ((("L" "C"))(""))
    ((("L" "V"))(""))
    ((("L" "B"))(""))
    ((("L" "N"))(""))
    ((("L" "M"))(""))
    ((("L" "<"))(""))
    ((("L" ">"))(""))
    ((("L" "?"))(""))
    ((("L" "_"))(""))
    ((("L" " "))(""))
    ((("+" "1"))(""))
    ((("+" "2"))(""))
    ((("+" "3"))(""))
    ((("+" "4"))(""))
    ((("+" "5"))(""))
    ((("+" "6"))(""))
    ((("+" "7"))(""))
    ((("+" "8"))(""))
    ((("+" "9"))(""))
    ((("+" "0"))(""))
    ((("+" "-"))(""))
    ((("+" "^"))(""))
    ((("+" "q"))(""))
    ((("+" "w"))(""))
    ((("+" "e"))(""))
    ((("+" "r"))(""))
    ((("+" "t"))(""))
    ((("+" "y"))(""))
    ((("+" "u"))(""))
    ((("+" "i"))(""))
    ((("+" "o"))(""))
    ((("+" "p"))(""))
    ((("+" "@"))(""))
    ((("+" "["))(""))
    ((("+" "a"))(""))
    ((("+" "s"))(""))
    ((("+" "d"))(""))
    ((("+" "f"))(""))
    ((("+" "g"))(""))
    ((("+" "h"))(""))
    ((("+" "j"))(""))
    ((("+" "k"))(""))
    ((("+" "l"))(""))
    ((("+" ";"))(""))
    ((("+" ":"))(""))
    ((("+" "]"))(""))
    ((("+" "z"))(""))
    ((("+" "x"))(""))
    ((("+" "c"))(""))
    ((("+" "v"))(""))
    ((("+" "b"))(""))
    ((("+" "n"))(""))
    ((("+" "m"))(""))
    ((("+" ","))(""))
    ((("+" "."))(""))
    ((("+" "/"))(""))
    ((("+" "\\"))(""))
    ((("+" "!"))(""))
    ((("+" "\""))(""))
    ((("+" "#"))(""))
    ((("+" "$"))(""))
    ((("+" "%"))(""))
    ((("+" "&"))(""))
    ((("+" "'"))(""))
    ((("+" "("))(""))
    ((("+" ")"))(""))
    ((("+" "|"))(""))
    ((("+" "="))(""))
    ((("+" "~"))(""))
    ((("+" "Q"))(""))
    ((("+" "W"))(""))
    ((("+" "E"))(""))
    ((("+" "R"))(""))
    ((("+" "T"))(""))
    ((("+" "Y"))(""))
    ((("+" "U"))(""))
    ((("+" "I"))(""))
    ((("+" "O"))(""))
    ((("+" "P"))(""))
    ((("+" "`"))(""))
    ((("+" "{"))(""))
    ((("+" "A"))(""))
    ((("+" "S"))(""))
    ((("+" "D"))(""))
    ((("+" "F"))(""))
    ((("+" "G"))(""))
    ((("+" "H"))(""))
    ((("+" "J"))(""))
    ((("+" "K"))(""))
    ((("+" "L"))(""))
    ((("+" "+"))(""))
    ((("+" "*"))(""))
    ((("+" "}"))(""))
    ((("+" "Z"))(""))
    ((("+" "X"))(""))
    ((("+" "C"))(""))
    ((("+" "V"))(""))
    ((("+" "B"))(""))
    ((("+" "N"))(""))
    ((("+" "M"))(""))
    ((("+" "<"))(""))
    ((("+" ">"))(""))
    ((("+" "?"))(""))
    ((("+" "_"))(""))
    ((("+" " "))(""))
    ((("*" "1"))(""))
    ((("*" "2"))(""))
    ((("*" "3"))(""))
    ((("*" "4"))(""))
    ((("*" "5"))(""))
    ((("*" "6"))(""))
    ((("*" "7"))(""))
    ((("*" "8"))(""))
    ((("*" "9"))(""))
    ((("*" "0"))(""))
    ((("*" "-"))(""))
    ((("*" "^"))(""))
    ((("*" "q"))(""))
    ((("*" "w"))(""))
    ((("*" "e"))(""))
    ((("*" "r"))(""))
    ((("*" "t"))(""))
    ((("*" "y"))(""))
    ((("*" "u"))(""))
    ((("*" "i"))(""))
    ((("*" "o"))(""))
    ((("*" "p"))(""))
    ((("*" "@"))(""))
    ((("*" "["))(""))
    ((("*" "a"))(""))
    ((("*" "s"))(""))
    ((("*" "d"))(""))
    ((("*" "f"))(""))
    ((("*" "g"))(""))
    ((("*" "h"))(""))
    ((("*" "j"))(""))
    ((("*" "k"))(""))
    ((("*" "l"))(""))
    ((("*" ";"))(""))
    ((("*" ":"))(""))
    ((("*" "]"))(""))
    ((("*" "z"))(""))
    ((("*" "x"))(""))
    ((("*" "c"))(""))
    ((("*" "v"))(""))
    ((("*" "b"))(""))
    ((("*" "n"))(""))
    ((("*" "m"))(""))
    ((("*" ","))(""))
    ((("*" "."))(""))
    ((("*" "/"))(""))
    ((("*" "\\"))(""))
    ((("*" "!"))(""))
    ((("*" "\""))(""))
    ((("*" "#"))(""))
    ((("*" "$"))(""))
    ((("*" "%"))(""))
    ((("*" "&"))(""))
    ((("*" "'"))(""))
    ((("*" "("))(""))
    ((("*" ")"))(""))
    ((("*" "|"))(""))
    ((("*" "="))(""))
    ((("*" "~"))(""))
    ((("*" "Q"))(""))
    ((("*" "W"))(""))
    ((("*" "E"))(""))
    ((("*" "R"))(""))
    ((("*" "T"))(""))
    ((("*" "Y"))(""))
    ((("*" "U"))(""))
    ((("*" "I"))(""))
    ((("*" "O"))(""))
    ((("*" "P"))(""))
    ((("*" "`"))(""))
    ((("*" "{"))(""))
    ((("*" "A"))(""))
    ((("*" "S"))(""))
    ((("*" "D"))(""))
    ((("*" "F"))(""))
    ((("*" "G"))(""))
    ((("*" "H"))(""))
    ((("*" "J"))(""))
    ((("*" "K"))(""))
    ((("*" "L"))(""))
    ((("*" "+"))(""))
    ((("*" "*"))(""))
    ((("*" "}"))(""))
    ((("*" "Z"))(""))
    ((("*" "X"))(""))
    ((("*" "C"))(""))
    ((("*" "V"))(""))
    ((("*" "B"))(""))
    ((("*" "N"))(""))
    ((("*" "M"))(""))
    ((("*" "<"))(""))
    ((("*" ">"))(""))
    ((("*" "?"))(""))
    ((("*" "_"))(""))
    ((("*" " "))(""))
    ((("}" "1"))(""))
    ((("}" "2"))(""))
    ((("}" "3"))(""))
    ((("}" "4"))(""))
    ((("}" "5"))(""))
    ((("}" "6"))(""))
    ((("}" "7"))(""))
    ((("}" "8"))(""))
    ((("}" "9"))(""))
    ((("}" "0"))(""))
    ((("}" "-"))(""))
    ((("}" "^"))(""))
    ((("}" "q"))(""))
    ((("}" "w"))(""))
    ((("}" "e"))(""))
    ((("}" "r"))(""))
    ((("}" "t"))(""))
    ((("}" "y"))(""))
    ((("}" "u"))(""))
    ((("}" "i"))(""))
    ((("}" "o"))(""))
    ((("}" "p"))(""))
    ((("}" "@"))(""))
    ((("}" "["))(""))
    ((("}" "a"))(""))
    ((("}" "s"))(""))
    ((("}" "d"))(""))
    ((("}" "f"))(""))
    ((("}" "g"))(""))
    ((("}" "h"))(""))
    ((("}" "j"))(""))
    ((("}" "k"))(""))
    ((("}" "l"))(""))
    ((("}" ";"))(""))
    ((("}" ":"))(""))
    ((("}" "]"))(""))
    ((("}" "z"))(""))
    ((("}" "x"))(""))
    ((("}" "c"))(""))
    ((("}" "v"))(""))
    ((("}" "b"))(""))
    ((("}" "n"))(""))
    ((("}" "m"))(""))
    ((("}" ","))(""))
    ((("}" "."))(""))
    ((("}" "/"))(""))
    ((("}" "\\"))(""))
    ((("}" "!"))(""))
    ((("}" "\""))(""))
    ((("}" "#"))(""))
    ((("}" "$"))(""))
    ((("}" "%"))(""))
    ((("}" "&"))(""))
    ((("}" "'"))(""))
    ((("}" "("))(""))
    ((("}" ")"))(""))
    ((("}" "|"))(""))
    ((("}" "="))(""))
    ((("}" "~"))(""))
    ((("}" "Q"))(""))
    ((("}" "W"))(""))
    ((("}" "E"))(""))
    ((("}" "R"))(""))
    ((("}" "T"))(""))
    ((("}" "Y"))(""))
    ((("}" "U"))(""))
    ((("}" "I"))(""))
    ((("}" "O"))(""))
    ((("}" "P"))(""))
    ((("}" "`"))(""))
    ((("}" "{"))(""))
    ((("}" "A"))(""))
    ((("}" "S"))(""))
    ((("}" "D"))(""))
    ((("}" "F"))(""))
    ((("}" "G"))(""))
    ((("}" "H"))(""))
    ((("}" "J"))(""))
    ((("}" "K"))(""))
    ((("}" "L"))(""))
    ((("}" "+"))(""))
    ((("}" "*"))(""))
    ((("}" "}"))(""))
    ((("}" "Z"))(""))
    ((("}" "X"))(""))
    ((("}" "C"))(""))
    ((("}" "V"))(""))
    ((("}" "B"))(""))
    ((("}" "N"))(""))
    ((("}" "M"))(""))
    ((("}" "<"))(""))
    ((("}" ">"))(""))
    ((("}" "?"))(""))
    ((("}" "_"))(""))
    ((("}" " "))(""))
    ((("Z" "1"))(""))
    ((("Z" "2"))(""))
    ((("Z" "3"))(""))
    ((("Z" "4"))(""))
    ((("Z" "5"))(""))
    ((("Z" "6"))(""))
    ((("Z" " "))(""))
    ((("X" " "))(""))
    ((("C" " "))(""))
    ((("V" " "))(""))
    ((("B" " "))(""))
    ((("N" "1"))(""))
    ((("N" "2"))(""))
    ((("N" "3"))(""))
    ((("N" "4"))(""))
    ((("N" "5"))(""))
    ((("N" "6"))(""))
    ((("N" "7"))(""))
    ((("N" "8"))(""))
    ((("N" "9"))(""))
    ((("N" "0"))(""))
    ((("N" "-"))(""))
    ((("N" "^"))(""))
    ((("N" "q"))(""))
    ((("N" "w"))(""))
    ((("N" "e"))(""))
    ((("N" "r"))(""))
    ((("N" "t"))(""))
    ((("N" "y"))(""))
    ((("N" "u"))(""))
    ((("N" "i"))(""))
    ((("N" "o"))(""))
    ((("N" "p"))(""))
    ((("N" "@"))(""))
    ((("N" "["))(""))
    ((("N" "a"))(""))
    ((("N" "s"))(""))
    ((("N" "d"))(""))
    ((("N" "f"))(""))
    ((("N" "g"))(""))
    ((("N" "h"))(""))
    ((("N" "j"))(""))
    ((("N" "k"))(""))
    ((("N" "l"))(""))
    ((("N" ";"))(""))
    ((("N" ":"))(""))
    ((("N" "]"))(""))
    ((("N" "z"))(""))
    ((("N" "x"))(""))
    ((("N" "c"))(""))
    ((("N" "v"))(""))
    ((("N" "b"))(""))
    ((("N" "n"))(""))
    ((("N" "m"))(""))
    ((("N" ","))(""))
    ((("N" "."))(""))
    ((("N" "/"))(""))
    ((("N" "\\"))(""))
    ((("N" "!"))(""))
    ((("N" "\""))(""))
    ((("N" "#"))(""))
    ((("N" "$"))(""))
    ((("N" "%"))(""))
    ((("N" "&"))(""))
    ((("N" "'"))(""))
    ((("N" "("))(""))
    ((("N" ")"))(""))
    ((("N" "|"))(""))
    ((("N" "="))(""))
    ((("N" "~"))(""))
    ((("N" "Q"))(""))
    ((("N" "W"))(""))
    ((("N" "E"))(""))
    ((("N" "R"))(""))
    ((("N" "T"))(""))
    ((("N" "Y"))(""))
    ((("N" "U"))(""))
    ((("N" "I"))(""))
    ((("N" "O"))(""))
    ((("N" "P"))(""))
    ((("N" "`"))(""))
    ((("N" "{"))(""))
    ((("N" "A"))(""))
    ((("N" "S"))(""))
    ((("N" "D"))(""))
    ((("N" "F"))(""))
    ((("N" "G"))(""))
    ((("N" "H"))(""))
    ((("N" "J"))(""))
    ((("N" "K"))(""))
    ((("N" "L"))(""))
    ((("N" "+"))(""))
    ((("N" "*"))(""))
    ((("N" "}"))(""))
    ((("N" "Z"))(""))
    ((("N" "X"))(""))
    ((("N" "C"))(""))
    ((("N" "V"))(""))
    ((("N" "B"))(""))
    ((("N" "N"))(""))
    ((("N" "M"))(""))
    ((("N" "<"))(""))
    ((("N" ">"))(""))
    ((("N" "?"))(""))
    ((("N" "_"))(""))
    ((("N" " "))(""))
    ((("M" "1"))(""))
    ((("M" "2"))(""))
    ((("M" "3"))(""))
    ((("M" "4"))(""))
    ((("M" "5"))(""))
    ((("M" "6"))(""))
    ((("M" "7"))(""))
    ((("M" "8"))(""))
    ((("M" "9"))(""))
    ((("M" "0"))(""))
    ((("M" "-"))(""))
    ((("M" "^"))(""))
    ((("M" "q"))(""))
    ((("M" "w"))(""))
    ((("M" "e"))(""))
    ((("M" "r"))(""))
    ((("M" "t"))(""))
    ((("M" "y"))(""))
    ((("M" "u"))(""))
    ((("M" "i"))(""))
    ((("M" "o"))(""))
    ((("M" "p"))(""))
    ((("M" "@"))(""))
    ((("M" "["))(""))
    ((("M" "a"))(""))
    ((("M" "s"))(""))
    ((("M" "d"))(""))
    ((("M" "f"))(""))
    ((("M" "g"))(""))
    ((("M" "h"))(""))
    ((("M" "j"))(""))
    ((("M" "k"))(""))
    ((("M" "l"))(""))
    ((("M" ";"))(""))
    ((("M" ":"))(""))
    ((("M" "]"))(""))
    ((("M" "z"))(""))
    ((("M" "x"))(""))
    ((("M" "c"))(""))
    ((("M" "v"))(""))
    ((("M" "b"))(""))
    ((("M" "n"))(""))
    ((("M" "m"))(""))
    ((("M" ","))(""))
    ((("M" "."))(""))
    ((("M" "/"))(""))
    ((("M" "\\"))(""))
    ((("M" "!"))(""))
    ((("M" "\""))(""))
    ((("M" "#"))(""))
    ((("M" "$"))(""))
    ((("M" "%"))(""))
    ((("M" "&"))(""))
    ((("M" "'"))(""))
    ((("M" "("))(""))
    ((("M" ")"))(""))
    ((("M" "|"))(""))
    ((("M" "="))(""))
    ((("M" "~"))(""))
    ((("M" "Q"))(""))
    ((("M" "W"))(""))
    ((("M" "E"))(""))
    ((("M" "R"))(""))
    ((("M" "T"))(""))
    ((("M" "Y"))(""))
    ((("M" "U"))(""))
    ((("M" "I"))(""))
    ((("M" "O"))(""))
    ((("M" "P"))(""))
    ((("M" "`"))(""))
    ((("M" "{"))(""))
    ((("M" "A"))(""))
    ((("M" "S"))(""))
    ((("M" "D"))(""))
    ((("M" "F"))(""))
    ((("M" "G"))(""))
    ((("M" "H"))(""))
    ((("M" "J"))(""))
    ((("M" "K"))(""))
    ((("M" "L"))(""))
    ((("M" "+"))(""))
    ((("M" "*"))(""))
    ((("M" "}"))(""))
    ((("M" "Z"))(""))
    ((("M" "X"))(""))
    ((("M" "C"))(""))
    ((("M" "V"))(""))
    ((("M" "B"))(""))
    ((("M" "N"))(""))
    ((("M" "M"))(""))
    ((("M" "<"))(""))
    ((("M" ">"))(""))
    ((("M" "?"))(""))
    ((("M" "_"))(""))
    ((("M" " "))(""))
    ((("<" "1"))(""))
    ((("<" "2"))(""))
    ((("<" "3"))(""))
    ((("<" "4"))(""))
    ((("<" "5"))(""))
    ((("<" "6"))(""))
    ((("<" "7"))(""))
    ((("<" "8"))(""))
    ((("<" "9"))(""))
    ((("<" "0"))(""))
    ((("<" "-"))(""))
    ((("<" "^"))(""))
    ((("<" "q"))(""))
    ((("<" "w"))(""))
    ((("<" "e"))(""))
    ((("<" "r"))(""))
    ((("<" "t"))(""))
    ((("<" "y"))(""))
    ((("<" "u"))(""))
    ((("<" "i"))(""))
    ((("<" "o"))(""))
    ((("<" "p"))(""))
    ((("<" "@"))(""))
    ((("<" "["))(""))
    ((("<" "a"))(""))
    ((("<" "s"))(""))
    ((("<" "d"))(""))
    ((("<" "f"))(""))
    ((("<" "g"))(""))
    ((("<" "h"))(""))
    ((("<" "j"))(""))
    ((("<" "k"))(""))
    ((("<" "l"))(""))
    ((("<" ";"))(""))
    ((("<" ":"))(""))
    ((("<" "]"))(""))
    ((("<" "z"))(""))
    ((("<" "x"))(""))
    ((("<" "c"))(""))
    ((("<" "v"))(""))
    ((("<" "b"))(""))
    ((("<" "n"))(""))
    ((("<" "m"))(""))
    ((("<" ","))(""))
    ((("<" "."))(""))
    ((("<" "/"))(""))
    ((("<" "\\"))(""))
    ((("<" "!"))(""))
    ((("<" "\""))(""))
    ((("<" "#"))(""))
    ((("<" "$"))(""))
    ((("<" "%"))(""))
    ((("<" "&"))(""))
    ((("<" "'"))(""))
    ((("<" "("))(""))
    ((("<" ")"))(""))
    ((("<" "|"))(""))
    ((("<" "="))(""))
    ((("<" "~"))(""))
    ((("<" "Q"))(""))
    ((("<" "W"))(""))
    ((("<" "E"))(""))
    ((("<" "R"))(""))
    ((("<" "T"))(""))
    ((("<" "Y"))(""))
    ((("<" "U"))(""))
    ((("<" "I"))(""))
    ((("<" "O"))(""))
    ((("<" "P"))(""))
    ((("<" "`"))(""))
    ((("<" "{"))(""))
    ((("<" "A"))(""))
    ((("<" "S"))(""))
    ((("<" "D"))(""))
    ((("<" "F"))(""))
    ((("<" "G"))(""))
    ((("<" "H"))(""))
    ((("<" "J"))(""))
    ((("<" "K"))(""))
    ((("<" "L"))(""))
    ((("<" "+"))(""))
    ((("<" "*"))(""))
    ((("<" "}"))(""))
    ((("<" "Z"))(""))
    ((("<" "X"))(""))
    ((("<" "C"))(""))
    ((("<" "V"))(""))
    ((("<" "B"))(""))
    ((("<" "N"))(""))
    ((("<" "M"))(""))
    ((("<" "<"))(""))
    ((("<" ">"))(""))
    ((("<" "?"))(""))
    ((("<" "_"))(""))
    ((("<" " "))(""))
    (((">" "1"))(""))
    (((">" "2"))(""))
    (((">" "3"))(""))
    (((">" "4"))(""))
    (((">" "5"))(""))
    (((">" "6"))(""))
    (((">" "7"))(""))
    (((">" "8"))(""))
    (((">" "9"))(""))
    (((">" "0"))(""))
    (((">" "-"))(""))
    (((">" "^"))(""))
    (((">" "q"))(""))
    (((">" "w"))(""))
    (((">" "e"))(""))
    (((">" "r"))(""))
    (((">" "t"))(""))
    (((">" "y"))(""))
    (((">" "u"))(""))
    (((">" "i"))(""))
    (((">" "o"))(""))
    (((">" "p"))(""))
    (((">" "@"))(""))
    (((">" "["))(""))
    (((">" "a"))(""))
    (((">" "s"))(""))
    (((">" "d"))(""))
    (((">" "f"))(""))
    (((">" "g"))(""))
    (((">" "h"))(""))
    (((">" "j"))(""))
    (((">" "k"))(""))
    (((">" "l"))(""))
    (((">" ";"))(""))
    (((">" ":"))(""))
    (((">" "]"))(""))
    (((">" "z"))(""))
    (((">" "x"))(""))
    (((">" "c"))(""))
    (((">" "v"))(""))
    (((">" "b"))(""))
    (((">" "n"))(""))
    (((">" "m"))(""))
    (((">" ","))(""))
    (((">" "."))(""))
    (((">" "/"))(""))
    (((">" "\\"))(""))
    (((">" "!"))(""))
    (((">" "\""))(""))
    (((">" "#"))(""))
    (((">" "$"))(""))
    (((">" "%"))(""))
    (((">" "&"))(""))
    (((">" "'"))(""))
    (((">" "("))(""))
    (((">" ")"))(""))
    (((">" "|"))(""))
    (((">" "="))(""))
    (((">" "~"))(""))
    (((">" "Q"))(""))
    (((">" "W"))(""))
    (((">" "E"))(""))
    (((">" "R"))(""))
    (((">" "T"))(""))
    (((">" "Y"))(""))
    (((">" "U"))(""))
    (((">" "I"))(""))
    (((">" "O"))(""))
    (((">" "P"))(""))
    (((">" "`"))(""))
    (((">" "{"))(""))
    (((">" "A"))(""))
    (((">" "S"))(""))
    (((">" "D"))(""))
    (((">" "F"))(""))
    (((">" "G"))(""))
    (((">" "H"))(""))
    (((">" "J"))(""))
    (((">" "+"))(""))
    (((">" "*"))(""))
    (((">" "}"))(""))
    (((">" "Z"))(""))
    (((">" "X"))(""))
    (((">" "C"))(""))
    (((">" "V"))(""))
    (((">" "B"))(""))
    (((">" "N"))(""))
    (((">" "M"))(""))
    (((">" "<"))(""))
    (((">" ">"))(""))
    (((">" "?"))(""))
    (((">" "_"))(""))
    (((">" " "))(""))
    ((("?" " "))(""))
    ((("_" " "))(""))))
