/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.awt.IconWithArrow;
import org.openide.util.Utilities;

class DropDownButton
extends JButton {
    private boolean mouseInButton = false;
    private boolean mouseInArrowArea = false;
    private Map<String, Icon> regIcons = new HashMap<String, Icon>(5);
    private Map<String, Icon> arrowIcons = new HashMap<String, Icon>(5);
    private static final String ICON_NORMAL = "normal";
    private static final String ICON_PRESSED = "pressed";
    private static final String ICON_ROLLOVER = "rollover";
    private static final String ICON_ROLLOVER_SELECTED = "rolloverSelected";
    private static final String ICON_SELECTED = "selected";
    private static final String ICON_DISABLED = "disabled";
    private static final String ICON_DISABLED_SELECTED = "disabledSelected";
    private static final String ICON_ROLLOVER_LINE = "rolloverLine";
    private static final String ICON_ROLLOVER_SELECTED_LINE = "rolloverSelectedLine";
    private PopupMenuListener menuListener;

    public DropDownButton(Icon icon, JPopupMenu jPopupMenu) {
        assert (null != icon);
        this.putClientProperty("dropDownMenu", jPopupMenu);
        this.setIcon(icon);
        this.resetIcons();
        this.addPropertyChangeListener("dropDownMenu", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DropDownButton.this.resetIcons();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (null != DropDownButton.this.getPopupMenu()) {
                    DropDownButton.this.mouseInArrowArea = DropDownButton.this.isInArrowArea(mouseEvent.getPoint());
                    DropDownButton.this.updateRollover(DropDownButton.this._getRolloverIcon(), DropDownButton.this._getRolloverSelectedIcon());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private boolean popupMenuOperation = false;

            public void mousePressed(MouseEvent mouseEvent) {
                this.popupMenuOperation = false;
                JPopupMenu jPopupMenu = DropDownButton.this.getPopupMenu();
                if (jPopupMenu != null && DropDownButton.this.getModel() instanceof Model) {
                    Model model = (Model)DropDownButton.this.getModel();
                    if (!model._isPressed()) {
                        if (DropDownButton.this.isInArrowArea(mouseEvent.getPoint()) && jPopupMenu.getComponentCount() > 0) {
                            model._press();
                            jPopupMenu.addPopupMenuListener(DropDownButton.this.getMenuListener());
                            jPopupMenu.show(DropDownButton.this, 0, DropDownButton.this.getHeight());
                            this.popupMenuOperation = true;
                        }
                    } else {
                        model._release();
                        jPopupMenu.removePopupMenuListener(DropDownButton.this.getMenuListener());
                        this.popupMenuOperation = true;
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.popupMenuOperation) {
                    this.popupMenuOperation = false;
                    mouseEvent.consume();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                DropDownButton.this.mouseInButton = true;
                if (DropDownButton.this.hasPopupMenu()) {
                    DropDownButton.this.mouseInArrowArea = DropDownButton.this.isInArrowArea(mouseEvent.getPoint());
                    DropDownButton.this.updateRollover(DropDownButton.this._getRolloverIcon(), DropDownButton.this._getRolloverSelectedIcon());
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                DropDownButton.this.mouseInButton = false;
                DropDownButton.this.mouseInArrowArea = false;
                if (DropDownButton.this.hasPopupMenu()) {
                    DropDownButton.this.updateRollover(DropDownButton.this._getRolloverIcon(), DropDownButton.this._getRolloverSelectedIcon());
                }
            }
        });
        this.setModel(new Model());
    }

    private PopupMenuListener getMenuListener() {
        if (null == this.menuListener) {
            this.menuListener = new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (!DropDownButton.this.mouseInButton) {
                        JPopupMenu jPopupMenu;
                        if (DropDownButton.this.getModel() instanceof Model) {
                            ((Model)DropDownButton.this.getModel())._release();
                        }
                        if (null != (jPopupMenu = DropDownButton.this.getPopupMenu())) {
                            jPopupMenu.removePopupMenuListener(this);
                        }
                    }
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            };
        }
        return this.menuListener;
    }

    private void updateRollover(Icon icon, Icon icon2) {
        super.setRolloverIcon(icon);
        super.setRolloverSelectedIcon(icon2);
    }

    private void resetIcons() {
        Icon icon = this.regIcons.get(ICON_NORMAL);
        if (null != icon) {
            this.setIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_PRESSED))) {
            this.setPressedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_ROLLOVER))) {
            this.setRolloverIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_ROLLOVER_SELECTED))) {
            this.setRolloverSelectedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_SELECTED))) {
            this.setSelectedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_DISABLED))) {
            this.setDisabledIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_DISABLED_SELECTED))) {
            this.setDisabledSelectedIcon(icon);
        }
    }

    private Icon _getRolloverIcon() {
        Icon icon = null;
        icon = this.arrowIcons.get(this.mouseInArrowArea ? ICON_ROLLOVER : ICON_ROLLOVER_LINE);
        if (null == icon) {
            Icon icon2 = this.regIcons.get(ICON_ROLLOVER);
            if (null == icon2) {
                icon2 = this.regIcons.get(ICON_NORMAL);
            }
            icon = new IconWithArrow(icon2, !this.mouseInArrowArea);
            this.arrowIcons.put(this.mouseInArrowArea ? ICON_ROLLOVER : ICON_ROLLOVER_LINE, icon);
        }
        return icon;
    }

    private Icon _getRolloverSelectedIcon() {
        Icon icon = null;
        icon = this.arrowIcons.get(this.mouseInArrowArea ? ICON_ROLLOVER_SELECTED : ICON_ROLLOVER_SELECTED_LINE);
        if (null == icon) {
            Icon icon2 = this.regIcons.get(ICON_ROLLOVER_SELECTED);
            if (null == icon2) {
                icon2 = this.regIcons.get(ICON_ROLLOVER);
            }
            if (null == icon2) {
                icon2 = this.regIcons.get(ICON_NORMAL);
            }
            icon = new IconWithArrow(icon2, !this.mouseInArrowArea);
            this.arrowIcons.put(this.mouseInArrowArea ? ICON_ROLLOVER_SELECTED : ICON_ROLLOVER_SELECTED_LINE, icon);
        }
        return icon;
    }

    JPopupMenu getPopupMenu() {
        Object object = this.getClientProperty("dropDownMenu");
        if (object instanceof JPopupMenu) {
            return (JPopupMenu)object;
        }
        return null;
    }

    boolean hasPopupMenu() {
        return null != this.getPopupMenu();
    }

    private boolean isInArrowArea(Point point) {
        return point.getLocation().x >= this.getWidth() - IconWithArrow.getArrowAreaWidth() - this.getInsets().right;
    }

    public void setIcon(Icon icon) {
        assert (null != icon);
        Icon icon2 = this.updateIcons(icon, ICON_NORMAL);
        this.arrowIcons.remove(ICON_ROLLOVER_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED);
        super.setIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    private Icon updateIcons(Icon icon, String string) {
        ImageIcon imageIcon = null;
        if (null == icon) {
            this.regIcons.remove(string);
            this.arrowIcons.remove(string);
        } else {
            this.regIcons.put(string, icon);
            imageIcon = new ImageIcon(Utilities.icon2Image((Icon)new IconWithArrow(icon, false)));
            this.arrowIcons.put(string, imageIcon);
        }
        return imageIcon;
    }

    public void setPressedIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_PRESSED);
        super.setPressedIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    public void setSelectedIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_SELECTED);
        super.setSelectedIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    public void setRolloverIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_ROLLOVER);
        this.arrowIcons.remove(ICON_ROLLOVER_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        super.setRolloverIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    public void setRolloverSelectedIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_ROLLOVER_SELECTED);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        super.setRolloverSelectedIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_DISABLED);
        super.setDisabledIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    public void setDisabledSelectedIcon(Icon icon) {
        Icon icon2 = this.updateIcons(icon, ICON_DISABLED_SELECTED);
        super.setDisabledSelectedIcon(this.hasPopupMenu() ? icon2 : icon);
    }

    private class Model
    extends DefaultButtonModel {
        private boolean _pressed = false;

        private Model() {
        }

        public void setPressed(boolean bl) {
            if (DropDownButton.this.mouseInArrowArea || this._pressed) {
                return;
            }
            super.setPressed(bl);
        }

        public void _press() {
            if (this.isPressed() || !this.isEnabled()) {
                return;
            }
            this.stateMask |= 5;
            this.fireStateChanged();
            this._pressed = true;
        }

        public void _release() {
            this._pressed = false;
            DropDownButton.this.mouseInArrowArea = false;
            this.setArmed(false);
            this.setPressed(false);
            this.setRollover(false);
            this.setSelected(false);
        }

        public boolean _isPressed() {
            return this._pressed;
        }

        protected void fireStateChanged() {
            if (this._pressed) {
                return;
            }
            super.fireStateChanged();
        }

        public void setArmed(boolean bl) {
            if (this._pressed) {
                return;
            }
            super.setArmed(bl);
        }

        public void setEnabled(boolean bl) {
            if (this._pressed) {
                return;
            }
            super.setEnabled(bl);
        }

        public void setSelected(boolean bl) {
            if (this._pressed) {
                return;
            }
            super.setSelected(bl);
        }

        public void setRollover(boolean bl) {
            if (this._pressed) {
                return;
            }
            super.setRollover(bl);
        }
    }
}

