/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class TypeCast
extends ASTNode {
    private ExecutableStatement statement;
    private boolean widen;

    public TypeCast(char[] expr, Class cast, int fields, ParserContext pCtx) {
        this.egressType = cast;
        this.name = expr;
        if ((fields & 0x10) != 0 && (this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.name, pCtx)).getKnownEgressType() != Object.class && !DataConversion.canConvert(cast, this.statement.getKnownEgressType())) {
            if (this.statement.getKnownEgressType().isAssignableFrom(cast)) {
                this.widen = true;
            } else {
                throw new CompileException("unable to cast type: " + this.statement.getKnownEgressType() + "; to: " + cast);
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.widen ? TypeCast.typeCheck(this.statement.getValue(ctx, thisValue, factory), this.egressType) : DataConversion.convert(this.statement.getValue(ctx, thisValue, factory), this.egressType);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.widen ? TypeCast.typeCheck(MVEL.eval(this.name, ctx, factory), this.egressType) : DataConversion.convert(MVEL.eval(this.name, ctx, factory), this.egressType);
    }

    private static Object typeCheck(Object inst, Class type) {
        if (inst == null) {
            return null;
        }
        if (type.isInstance(inst)) {
            return inst;
        }
        throw new ClassCastException(inst.getClass().getName() + " cannot be cast to: " + type.getClass().getName());
    }
}

