/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSFileChooserDialog;
import org.gjt.sp.jedit.gui.DynamicContextMenuService;
import org.gjt.sp.jedit.gui.EnhancedButton;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.SplashScreen;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedCheckBoxMenuItem;
import org.gjt.sp.jedit.menu.EnhancedMenu;
import org.gjt.sp.jedit.menu.EnhancedMenuItem;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SyntaxUtilities;
import org.jedit.keymap.Keymap;

public class GUIUtilities {
    private static SplashScreen splash;
    private static SoftReference<Map<String, Icon>> iconCache;
    private static String iconPath;
    private static final String defaultIconPath = "jeditresource:/org/gjt/sp/jedit/icons/themes/";
    private static final HashMap<String, String> deprecatedIcons;
    private static HashMap<String, String> macKeySymbols;

    public static void setIconPath(String string) {
        iconPath = string;
        iconCache = null;
    }

    public static Icon loadIcon(String string) {
        URL uRL;
        Icon icon;
        if (string == null) {
            return null;
        }
        if (deprecatedIcons != null && deprecatedIcons.containsKey(string)) {
            string = deprecatedIcons.get(string);
        }
        Map<String, Icon> map = null;
        if (iconCache != null) {
            map = iconCache.get();
        }
        if (map == null) {
            map = new Hashtable<String, Icon>();
            iconCache = new SoftReference<Map<String, Icon>>(map);
        }
        if ((icon = map.get(string)) != null) {
            return icon;
        }
        try {
            uRL = MiscUtilities.isURL(string) ? new URL(string) : new URL(iconPath + string);
        }
        catch (Exception exception) {
            try {
                uRL = new URL(defaultIconPath + string);
            }
            catch (Exception exception2) {
                Log.log(9, GUIUtilities.class, "Icon not found: " + string);
                Log.log(9, GUIUtilities.class, exception2);
                return null;
            }
        }
        icon = new ImageIcon(uRL);
        map.put(string, icon);
        return icon;
    }

    public static Image getEditorIcon() {
        return ((ImageIcon)GUIUtilities.loadIcon(jEdit.getProperty("logo.icon.medium"))).getImage();
    }

    public static Image getPluginIcon() {
        return GUIUtilities.getEditorIcon();
    }

    public static JMenuBar loadMenuBar(String string) {
        return GUIUtilities.loadMenuBar(jEdit.getActionContext(), string);
    }

    public static JMenuBar loadMenuBar(ActionContext actionContext, String string) {
        String string2 = jEdit.getProperty(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        JMenuBar jMenuBar = new JMenuBar();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            jMenuBar.add(GUIUtilities.loadMenu(actionContext, string3));
        }
        return jMenuBar;
    }

    public static JMenu loadMenu(String string) {
        return GUIUtilities.loadMenu(jEdit.getActionContext(), string);
    }

    public static JMenu loadMenu(ActionContext actionContext, String string) {
        return new EnhancedMenu(string, jEdit.getProperty(string.concat(".label")), actionContext);
    }

    public static JPopupMenu loadPopupMenu(String string, JEditTextArea jEditTextArea, MouseEvent mouseEvent) {
        return GUIUtilities.loadPopupMenu(jEdit.getActionContext(), string, jEditTextArea, mouseEvent);
    }

    public static JPopupMenu loadPopupMenu(String string) {
        return GUIUtilities.loadPopupMenu(jEdit.getActionContext(), string);
    }

    public static JPopupMenu loadPopupMenu(ActionContext actionContext, String string) {
        return GUIUtilities.loadPopupMenu(actionContext, string, null, null);
    }

    public static JPopupMenu loadPopupMenu(ActionContext actionContext, String string, JEditTextArea jEditTextArea, MouseEvent mouseEvent) {
        List<JMenuItem> list;
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string2 = jEdit.getProperty(string);
        if (string2 != null) {
            list = new StringTokenizer(string2);
            while (((StringTokenizer)((Object)list)).hasMoreTokens()) {
                String string3 = ((StringTokenizer)((Object)list)).nextToken();
                if ("-".equals(string3)) {
                    jPopupMenu.addSeparator();
                    continue;
                }
                jPopupMenu.add(GUIUtilities.loadMenuItem(actionContext, string3, false));
            }
        }
        if (jEditTextArea != null) {
            list = GUIUtilities.getServiceContextMenuItems(jEditTextArea, mouseEvent);
            if (!list.isEmpty()) {
                jPopupMenu.addSeparator();
            }
            for (JMenuItem jMenuItem : list) {
                jPopupMenu.add(jMenuItem);
            }
        }
        return jPopupMenu;
    }

    public static List<JMenuItem> getServiceContextMenuItems(JEditTextArea jEditTextArea, MouseEvent mouseEvent) {
        String[] stringArray;
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        String string = DynamicContextMenuService.class.getName();
        for (String string2 : stringArray = ServiceManager.getServiceNames(string)) {
            JMenuItem[] jMenuItemArray;
            DynamicContextMenuService dynamicContextMenuService;
            if (string2 == null || string2.trim().length() <= 0 || (dynamicContextMenuService = (DynamicContextMenuService)ServiceManager.getService(string, string2)) == null || (jMenuItemArray = dynamicContextMenuService.createMenu(jEditTextArea, mouseEvent)) == null) continue;
            arrayList.addAll(Arrays.asList(jMenuItemArray));
        }
        return arrayList;
    }

    public static JMenuItem loadMenuItem(String string) {
        return GUIUtilities.loadMenuItem(jEdit.getActionContext(), string, true);
    }

    public static JMenuItem loadMenuItem(String string, boolean bl) {
        return GUIUtilities.loadMenuItem(jEdit.getActionContext(), string, bl);
    }

    public static JMenuItem loadMenuItem(ActionContext actionContext, String string, boolean bl) {
        if (string.charAt(0) == '%') {
            return GUIUtilities.loadMenu(actionContext, string.substring(1));
        }
        return GUIUtilities._loadMenuItem(string, actionContext, bl);
    }

    public static JMenuItem loadMenuItem(EditAction editAction, boolean bl) {
        String string = editAction.getName();
        ActionContext actionContext = jEdit.getActionContext();
        return GUIUtilities._loadMenuItem(string, actionContext, bl);
    }

    public static Container loadToolBar(String string) {
        return GUIUtilities.loadToolBar(jEdit.getActionContext(), string);
    }

    public static Container loadToolBar(ActionContext actionContext, String string) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setName(string);
        jToolBar.setLayout(new FlowLayout(0, 0, 0));
        jToolBar.setFloatable(jEdit.getBooleanProperty("view.toolbar.floatable"));
        String string2 = jEdit.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if ("-".equals(string3)) {
                    jToolBar.addSeparator(new Dimension(12, 12));
                    continue;
                }
                EnhancedButton enhancedButton = GUIUtilities.loadToolButton(actionContext, string3);
                if (enhancedButton == null) continue;
                jToolBar.add(enhancedButton);
            }
        }
        jToolBar.addSeparator(new Dimension(12, 12));
        return jToolBar;
    }

    public static EnhancedButton loadToolButton(String string) {
        return GUIUtilities.loadToolButton(jEdit.getActionContext(), string);
    }

    public static EnhancedButton loadToolButton(ActionContext actionContext, String string) {
        Icon icon;
        String string2;
        String string3 = jEdit.getProperty(string + ".label");
        if (string3 == null) {
            string3 = string;
        }
        if ((string2 = jEdit.getProperty(string + ".icon")) == null) {
            icon = GUIUtilities.loadIcon(jEdit.getProperty("broken-image.icon"));
        } else {
            icon = GUIUtilities.loadIcon(string2);
            if (icon == null) {
                icon = GUIUtilities.loadIcon(jEdit.getProperty("broken-image.icon"));
            }
        }
        String string4 = GUIUtilities.prettifyMenuLabel(string3);
        String string5 = GUIUtilities.getShortcutLabel(string, true);
        if (string5 != null) {
            string4 = string4 + " (" + string5 + ')';
        }
        EnhancedButton enhancedButton = new EnhancedButton(icon, string4, string, actionContext);
        enhancedButton.setPreferredSize(new Dimension(32, 32));
        return enhancedButton;
    }

    public static String prettifyMenuLabel(String string) {
        int n = string.indexOf(36);
        if (n != -1) {
            string = string.substring(0, n).concat(string.substring(n + 1));
        }
        return string;
    }

    public static String getPlatformShortcutLabel(String string) {
        if (!OperatingSystem.isMacOSLF() || string == null || string.length() == 0) {
            return string;
        }
        String[] stringArray = string.split(" +");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(GUIUtilities.getMacShortcutLabel(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String getShortcutLabel(String string, Boolean bl) {
        if (string == null) {
            return null;
        }
        Keymap keymap = jEdit.getKeymapManager().getKeymap();
        String string2 = keymap.getShortcut(string + ".shortcut");
        String string3 = keymap.getShortcut(string + ".shortcut2");
        string2 = bl != false ? GUIUtilities.getPlatformShortcutLabel(string2) : string2;
        String string4 = string3 = bl != false ? GUIUtilities.getPlatformShortcutLabel(string3) : string3;
        if (string2 == null || string2.length() == 0) {
            if (string3 == null || string3.length() == 0) {
                return null;
            }
            return string3;
        }
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        return string2 + " or " + string3;
    }

    public static void setAutoMnemonic(AbstractButton abstractButton) {
        char c;
        String string = abstractButton.getText();
        int n = string.indexOf(36);
        if (n != -1 && string.length() - n > 1) {
            c = Character.toLowerCase(string.charAt(n + 1));
            string = string.substring(0, n).concat(string.substring(++n));
        } else {
            c = '\u0000';
        }
        if (c != '\u0000') {
            abstractButton.setMnemonic(c);
            abstractButton.setText(string);
        }
    }

    public static void message(final Component component, final String string, final Object[] objectArray) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            JOptionPane.showMessageDialog(component, jEdit.getProperty(string.concat(".message"), objectArray), jEdit.getProperty(string.concat(".title"), objectArray), 1);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GUIUtilities.message(component, string, objectArray);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void error(final Component component, final String string, final Object[] objectArray) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            JOptionPane.showMessageDialog(component, jEdit.getProperty(string.concat(".message"), objectArray), jEdit.getProperty(string.concat(".title"), objectArray), 0);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GUIUtilities.error(component, string, objectArray);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String input(Component component, String string, Object object) {
        return GUIUtilities.input(component, string, null, object);
    }

    public static String inputProperty(Component component, String string, String string2) {
        return GUIUtilities.inputProperty(component, string, null, string2);
    }

    public static String input(final Component component, final String string, final Object[] objectArray, final Object object) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return (String)JOptionPane.showInputDialog(component, jEdit.getProperty(string.concat(".message"), objectArray), jEdit.getProperty(string.concat(".title")), 3, null, null, object);
        }
        final String[] stringArray = new String[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    stringArray[0] = GUIUtilities.input(component, string, objectArray, object);
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
        return stringArray[0];
    }

    public static String inputProperty(final Component component, final String string, final Object[] objectArray, final String string2) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            String string3 = (String)JOptionPane.showInputDialog(component, jEdit.getProperty(string.concat(".message"), objectArray), jEdit.getProperty(string.concat(".title")), 3, null, null, jEdit.getProperty(string2));
            if (string3 != null) {
                jEdit.setProperty(string2, string3);
            }
            return string3;
        }
        final String[] stringArray = new String[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    stringArray[0] = GUIUtilities.inputProperty(component, string, objectArray, string2);
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
        return stringArray[0];
    }

    public static int confirm(final Component component, final String string, final Object[] objectArray, final int n, final int n2) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return JOptionPane.showConfirmDialog(component, jEdit.getProperty(string + ".message", objectArray), jEdit.getProperty(string + ".title"), n, n2);
        }
        final int[] nArray = new int[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nArray[0] = GUIUtilities.confirm(component, string, objectArray, n, n2);
                }
            });
        }
        catch (Exception exception) {
            return 2;
        }
        return nArray[0];
    }

    public static int option(final Component component, final String string, final Object[] objectArray, final int n, final Object[] objectArray2, final Object object) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return JOptionPane.showOptionDialog(component, jEdit.getProperty(string + ".message", objectArray), jEdit.getProperty(string + ".title"), -1, n, null, objectArray2, object);
        }
        final int[] nArray = new int[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nArray[0] = GUIUtilities.option(component, string, objectArray, n, objectArray2, object);
                }
            });
        }
        catch (Exception exception) {
            return 0;
        }
        return nArray[0];
    }

    public static int listConfirm(final Component component, final String string, final String[] stringArray, final Object[] objectArray) {
        if (EventQueue.isDispatchThread()) {
            JList<Object> jList = new JList<Object>(objectArray);
            jList.setVisibleRowCount(8);
            Object[] objectArray2 = new Object[]{jEdit.getProperty(string + ".message", stringArray), new JScrollPane(jList)};
            return JOptionPane.showConfirmDialog(component, objectArray2, jEdit.getProperty(string + ".title"), 0, 3);
        }
        final int[] nArray = new int[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nArray[0] = GUIUtilities.listConfirm(component, string, stringArray, objectArray);
                }
            });
        }
        catch (Exception exception) {
            return 2;
        }
        return nArray[0];
    }

    public static int listConfirm(final Component component, final String string, final String[] stringArray, final Object[] objectArray, final List list) {
        if (EventQueue.isDispatchThread()) {
            JList<Object> jList = new JList<Object>(objectArray);
            jList.setSelectionMode(2);
            jList.setVisibleRowCount(8);
            jList.addSelectionInterval(0, objectArray.length - 1);
            Object[] objectArray2 = new Object[]{jEdit.getProperty(string + ".message", stringArray), new JScrollPane(jList)};
            int n = JOptionPane.showConfirmDialog(component, objectArray2, jEdit.getProperty(string + ".title"), 0, 3);
            Object[] objectArray3 = jList.getSelectedValues();
            list.addAll(Arrays.asList(objectArray3));
            return n;
        }
        final int[] nArray = new int[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nArray[0] = GUIUtilities.listConfirm(component, string, stringArray, objectArray, list);
                }
            });
        }
        catch (Exception exception) {
            return 2;
        }
        return nArray[0];
    }

    public static String[] showVFSFileDialog(View view, String string, int n, boolean bl) {
        if (view == null) {
            Log.log(7, GUIUtilities.class, "showVFSFileDialog(): given null view, assuming jEdit.getActiveView()");
            view = jEdit.getActiveView();
        }
        GUIUtilities.hideSplashScreen();
        VFSFileChooserDialog vFSFileChooserDialog = new VFSFileChooserDialog(view, string, n, bl);
        return vFSFileChooserDialog.getSelectedFiles();
    }

    public static String[] showVFSFileDialog(Dialog dialog, View view, String string, int n, boolean bl) {
        GUIUtilities.hideSplashScreen();
        VFSFileChooserDialog vFSFileChooserDialog = new VFSFileChooserDialog(dialog, view, string, n, bl, true);
        return vFSFileChooserDialog.getSelectedFiles();
    }

    public static String[] showVFSFileDialog(Frame frame, View view, String string, int n, boolean bl) {
        GUIUtilities.hideSplashScreen();
        VFSFileChooserDialog vFSFileChooserDialog = new VFSFileChooserDialog(frame, view, string, n, bl, true);
        return vFSFileChooserDialog.getSelectedFiles();
    }

    public static Color parseColor(String string) {
        return SyntaxUtilities.parseColor(string, Color.black);
    }

    public static SyntaxStyle parseStyle(String string, String string2, int n) throws IllegalArgumentException {
        return SyntaxUtilities.parseStyle(string, string2, n, true);
    }

    public static String getStyleString(SyntaxStyle syntaxStyle) {
        Font font;
        StringBuilder stringBuilder = new StringBuilder();
        if (syntaxStyle.getForegroundColor() != null) {
            stringBuilder.append("color:").append(SyntaxUtilities.getColorHexString(syntaxStyle.getForegroundColor()));
        }
        if (syntaxStyle.getBackgroundColor() != null) {
            stringBuilder.append(" bgColor:").append(SyntaxUtilities.getColorHexString(syntaxStyle.getBackgroundColor()));
        }
        if (!(font = syntaxStyle.getFont()).isPlain()) {
            stringBuilder.append(" style:");
            if (font.isItalic()) {
                stringBuilder.append('i');
            }
            if (font.isBold()) {
                stringBuilder.append('b');
            }
        }
        return stringBuilder.toString();
    }

    public static void loadGeometry(Window window, Container container, String string) {
        Dimension dimension = window.getSize();
        int n = jEdit.getIntegerProperty(string + ".width", dimension.width);
        int n2 = jEdit.getIntegerProperty(string + ".height", dimension.height);
        int n3 = jEdit.getIntegerProperty(string + ".x", 50);
        int n4 = jEdit.getIntegerProperty(string + ".y", 50);
        if (container != null) {
            Point point = container.getLocation();
            n3 = point.x + n3;
            n4 = point.y + n4;
        }
        int n5 = jEdit.getIntegerProperty(string + ".extendedState", 0);
        Rectangle rectangle = new Rectangle(n3, n4, n, n2);
        try {
            if (!Debug.DISABLE_MULTIHEAD) {
                GUIUtilities.adjustForScreenBounds(rectangle);
            }
        }
        catch (Exception exception) {
            Log.log(9, GUIUtilities.class, exception);
        }
        if (OperatingSystem.isX11() && Debug.GEOMETRY_WORKAROUND) {
            new UnixWorkaround(window, string, rectangle, n5);
        } else {
            window.setBounds(rectangle);
            if (window instanceof Frame) {
                ((Frame)window).setExtendedState(n5);
            }
        }
    }

    public static void loadGeometry(Window window, String string) {
        GUIUtilities.loadGeometry(window, window.getParent(), string);
    }

    public static void adjustForScreenBounds(Rectangle rectangle) {
        Rectangle rectangle2 = OperatingSystem.getScreenBounds(rectangle);
        if (rectangle.width > rectangle2.width) {
            rectangle.width = rectangle2.width;
        }
        if (rectangle.x < rectangle2.x) {
            rectangle.x = rectangle2.x;
        }
        if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (rectangle.height > rectangle2.height) {
            rectangle.height = rectangle2.height;
        }
        if (rectangle.y < rectangle2.y) {
            rectangle.y = rectangle2.y;
        }
        if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
    }

    public static void saveGeometry(Window window, String string) {
        GUIUtilities.saveGeometry(window, window.getParent(), string);
    }

    public static void saveGeometry(Window window, Container container, String string) {
        if (window instanceof Frame) {
            jEdit.setIntegerProperty(string + ".extendedState", ((Frame)window).getExtendedState());
        }
        Rectangle rectangle = window.getBounds();
        int n = rectangle.x;
        int n2 = rectangle.y;
        if (container != null) {
            Rectangle rectangle2 = container.getBounds();
            n -= rectangle2.x;
            n2 -= rectangle2.y;
        }
        jEdit.setIntegerProperty(string + ".x", n);
        jEdit.setIntegerProperty(string + ".y", n2);
        jEdit.setIntegerProperty(string + ".width", rectangle.width);
        jEdit.setIntegerProperty(string + ".height", rectangle.height);
    }

    public static void hideSplashScreen() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    public static void applyTextAreaColors(Container container) {
        for (Component component : container.getComponents()) {
            component.setBackground(jEdit.getColorProperty("view.bgColor", Color.WHITE));
            component.setForeground(jEdit.getColorProperty("view.fgColor", Color.BLACK));
            if (component instanceof JTextPane) {
                ((JTextPane)component).setUI(new BasicEditorPaneUI());
            }
            if (!(component instanceof Container)) continue;
            GUIUtilities.applyTextAreaColors((Container)component);
        }
    }

    public static JComponent createMultilineLabel(String string) {
        int n;
        JPanel jPanel = new JPanel(new VariableGridLayout(2, 1, 1, 1));
        int n2 = 0;
        while ((n = string.indexOf(10, n2)) != -1) {
            jPanel.add(new JLabel(string.substring(n2, n)));
            n2 = n + 1;
        }
        if (n2 != string.length()) {
            jPanel.add(new JLabel(string.substring(n2)));
        }
        return jPanel;
    }

    public static void requestFocus(final Window window, final Component component) {
        window.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        component.requestFocusInWindow();
                    }
                });
                window.removeWindowFocusListener(this);
            }
        });
    }

    public static boolean isPopupTrigger(MouseEvent mouseEvent) {
        return TextAreaMouseHandler.isRightButton(mouseEvent.getModifiers());
    }

    public static boolean isMiddleButton(int n) {
        return TextAreaMouseHandler.isMiddleButton(n);
    }

    public static boolean isRightButton(int n) {
        return TextAreaMouseHandler.isRightButton(n);
    }

    public static Rectangle getScreenBounds() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (graphicsDeviceArray.length > 1) {
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    rectangle = rectangle.union(graphicsConfiguration.getBounds());
                }
            }
        }
        return rectangle;
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        GUIUtilities.showPopupMenu(jPopupMenu, component, n, n2, true);
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2, boolean bl) {
        Component component2;
        int n3 = 0;
        int n4 = 0;
        int n5 = bl ? 1 : 0;
        for (component2 = component; !(component2 instanceof Window) && component2 != null; component2 = component2.getParent()) {
            n3 += component2.getX();
            n4 += component2.getY();
        }
        if (component2 != null) {
            Dimension dimension = jPopupMenu.getPreferredSize();
            Rectangle rectangle = GUIUtilities.getScreenBounds();
            n = n + n3 + dimension.width + component2.getX() > rectangle.width && n + n3 + component2.getX() >= dimension.width ? (bl ? (n -= dimension.width + n5) : component2.getWidth() - dimension.width - n3 + n5) : (n += n5);
            n2 = n2 + n4 + dimension.height + component2.getY() > rectangle.height && n2 + n4 + component2.getY() >= dimension.height ? (bl ? component2.getHeight() - dimension.height - n4 + n5 : -dimension.height - 1) : (n2 += n5);
            jPopupMenu.show(component, n, n2);
        } else {
            jPopupMenu.show(component, n + n5, n2 + n5);
        }
    }

    public static boolean isAncestorOf(Component component, Component component2) {
        while (component2 != null) {
            if (component == component2) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    public static JDialog getParentDialog(Component component) {
        return (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, component);
    }

    public static Component getComponentParent(Component component, Class clazz) {
        while (component != null) {
            Component component2;
            if (component instanceof JComponent && (component2 = (Component)((JComponent)component).getClientProperty("KORTE_REAL_FRAME")) != null) {
                component = component2;
            }
            if (component.getClass().equals(clazz)) {
                return component;
            }
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            if (component instanceof FloatingWindowContainer) {
                component = ((FloatingWindowContainer)component).getDockableWindowManager();
                continue;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void setEnabledRecursively(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                GUIUtilities.setEnabledRecursively((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
        container.setEnabled(bl);
    }

    public static View getView(Component component) {
        return (View)GUIUtilities.getComponentParent(component, View.class);
    }

    public static void addSizeSaver(Frame frame, String string) {
        GUIUtilities.addSizeSaver(frame, frame.getParent(), string);
    }

    public static void addSizeSaver(Frame frame, Container container, String string) {
        SizeSaver sizeSaver = new SizeSaver(frame, container, string);
        frame.addWindowStateListener(sizeSaver);
        frame.addComponentListener(sizeSaver);
    }

    private static void initializeDeprecatedIcons() {
        deprecatedIcons.put("File.png", "16x16/mimetypes/text-x-generic.png");
        deprecatedIcons.put("Folder.png", "16x16/places/folder.png");
        deprecatedIcons.put("OpenFolder.png", "16x16/status/folder-open.png");
        deprecatedIcons.put("OpenFile.png", "16x16/actions/edit-select-all.png");
        deprecatedIcons.put("ReloadSmall.png", "16x16/actions/view-refresh.png");
        deprecatedIcons.put("DriveSmall.png", "16x16/devices/drive-harddisk.png");
        deprecatedIcons.put("New.png", "22x22/actions/document-new.png");
        deprecatedIcons.put("NewDir.png", "22x22/actions/folder-new.png");
        deprecatedIcons.put("Reload.png", "22x22/actions/view-refresh.png");
        deprecatedIcons.put("Load.png", "22x22/places/plugins.png");
        deprecatedIcons.put("Save.png", "22x22/actions/document-save.png");
        deprecatedIcons.put("SaveAs.png", "22x22/actions/document-save-as.png");
        deprecatedIcons.put("SaveAll.png", "22x22/actions/document-save-all.png");
        deprecatedIcons.put("Open.png", "22x22/actions/document-open.png");
        deprecatedIcons.put("Print.png", "22x22/actions/document-print.png");
        deprecatedIcons.put("Drive.png", "22x22/devices/drive-harddisk.png");
        deprecatedIcons.put("Clear.png", "22x22/actions/edit-clear.png");
        deprecatedIcons.put("Run.png", "22x22/actions/application-run.png");
        deprecatedIcons.put("RunAgain.png", "22x22/actions/application-run-again.png");
        deprecatedIcons.put("RunToBuffer.png", "22x22/actions/run-to-buffer.png");
        deprecatedIcons.put("CopyToBuffer.png", "22x22/actions/copy-to-buffer.png");
        deprecatedIcons.put("Plus.png", "22x22/actions/list-add.png");
        deprecatedIcons.put("Minus.png", "22x22/actions/list-remove.png");
        deprecatedIcons.put("Find.png", "22x22/actions/edit-find.png");
        deprecatedIcons.put("FindAgain.png", "22x22/actions/edit-find-next.png");
        deprecatedIcons.put("FindInDir.png", "22x22/actions/edit-find-in-folder.png");
        deprecatedIcons.put("Parse.png", "22x22/actions/document-reload2.png");
        deprecatedIcons.put("Delete.png", "22x22/actions/edit-delete.png");
        deprecatedIcons.put("Paste.png", "22x22/actions/edit-paste.png");
        deprecatedIcons.put("Cut.png", "22x22/actions/edit-cut.png");
        deprecatedIcons.put("Copy.png", "22x22/actions/edit-copy.png");
        deprecatedIcons.put("Undo.png", "22x22/actions/edit-undo.png");
        deprecatedIcons.put("Redo.png", "22x22/actions/edit-redo.png");
        deprecatedIcons.put("CurrentDir.png", "22x22/status/folder-visiting.png");
        deprecatedIcons.put("ParentDir.png", "22x22/actions/go-parent.png");
        deprecatedIcons.put("PageSetup.png", "22x22/actions/printer-setup.png");
        deprecatedIcons.put("Plugins.png", "22x22/apps/system-installer.png");
        deprecatedIcons.put("Floppy.png", "22x22/devices/media-floppy.png");
        deprecatedIcons.put("Stop.png", "22x22/actions/process-stop.png");
        deprecatedIcons.put("Cancel.png", "22x22/actions/process-stop.png");
        deprecatedIcons.put("Home.png", "22x22/actions/go-home.png");
        deprecatedIcons.put("Help.png", "22x22/apps/help-browser.png");
        deprecatedIcons.put("Properties.png", "22x22/actions/document-properties.png");
        deprecatedIcons.put("Preferences.png", "22x22/categories/preferences-system.png");
        deprecatedIcons.put("ZoomIn.png", "22x22/actions/zoom-in.png");
        deprecatedIcons.put("ZoomOut.png", "22x22/actions/zoom-out.png");
        deprecatedIcons.put("BrokenImage.png", "22x22/status/image-missing.png");
        deprecatedIcons.put("AdjustWidth.png", "22x22/actions/resize-horisontal.png");
        deprecatedIcons.put("ToolbarMenu.gif", "ToolbarMenu.gif");
        deprecatedIcons.put("Play.png", "22x22/actions/media-playback-start.png");
        deprecatedIcons.put("Pause.png", "22x22/actions/media-playback-pause.png");
        deprecatedIcons.put("MultipleResults.png", "22x22/actions/edit-find-multiple.png");
        deprecatedIcons.put("SingleResult.png", "22x22/actions/edit-find-single.png");
        deprecatedIcons.put("NextFile.png", "22x22/go-last.png");
        deprecatedIcons.put("PreviousFile.png", "22x22/go-first.png");
        deprecatedIcons.put("closebox.gif", "10x10/actions/close.png");
        deprecatedIcons.put("normal.gif", "10x10/status/document-unmodified.png");
        deprecatedIcons.put("readonly.gif", "10x10/emblem/emblem-readonly.png");
        deprecatedIcons.put("dirty.gif", "10x10/status/document-modified.png");
        deprecatedIcons.put("new.gif", "10x10/status/document-new.png");
        deprecatedIcons.put("ArrowU.png", "22x22/actions/go-up.png");
        deprecatedIcons.put("ArrowR.png", "22x22/actions/go-next.png");
        deprecatedIcons.put("ArrowD.png", "22x22/actions/go-down.png");
        deprecatedIcons.put("ArrowL.png", "22x22/actions/go-previous.png");
        deprecatedIcons.put("arrow1.png", "16x16/actions/group-expand.png");
        deprecatedIcons.put("arrow2.png", "16x16/actions/group-collapse.png");
        deprecatedIcons.put("NewView.png", "22x22/actions/window-new.png");
        deprecatedIcons.put("UnSplit.png", "22x22/actions/window-unsplit.png");
        deprecatedIcons.put("SplitVertical.png", "22x22/actions/window-split-vertical.png");
        deprecatedIcons.put("SplitHorizontal.png", "22x22/actions/window-split-horizontal.png");
        deprecatedIcons.put("ButtonProperties.png", "22x22/actions/document-properties.png");
    }

    static void init() {
        GUIUtilities.initializeDeprecatedIcons();
        String string = jEdit.getProperty("icon-theme", "tango");
        Log.log(1, GUIUtilities.class, "Icon theme set to: " + string);
        GUIUtilities.setIconPath(defaultIconPath + string + '/');
        Log.log(1, GUIUtilities.class, "Loading icon theme from: " + iconPath);
    }

    static void showSplashScreen() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    splash = new SplashScreen();
                }
            });
        }
        catch (Exception exception) {
            Log.log(9, GUIUtilities.class, "error displaying splash screen !", exception);
        }
    }

    static void advanceSplashProgress() {
        if (splash != null) {
            splash.advance();
        }
    }

    static void advanceSplashProgress(String string) {
        if (splash != null) {
            splash.advance(string);
        }
    }

    private static JMenuItem _loadMenuItem(String string, ActionContext actionContext, boolean bl) {
        Icon icon;
        char c;
        String string2 = jEdit.getProperty(string + ".label", string);
        int n = string2.indexOf(36);
        if (n != -1 && string2.length() - n > 1) {
            c = Character.toLowerCase(string2.charAt(n + 1));
            string2 = string2.substring(0, n).concat(string2.substring(++n));
        } else {
            c = '\u0000';
        }
        JMenuItem jMenuItem = jEdit.getBooleanProperty(string + ".toggle") ? new EnhancedCheckBoxMenuItem(string2, string, actionContext) : new EnhancedMenuItem(string2, string, actionContext);
        if (!OperatingSystem.isMacOS() && bl && c != '\u0000') {
            jMenuItem.setMnemonic(c);
        }
        if ((icon = GUIUtilities.loadIcon(jEdit.getProperty(string + ".icon.small"))) != null) {
            jMenuItem.setIcon(icon);
        }
        return jMenuItem;
    }

    private static String getMacShortcutLabel(String string) {
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(43);
        if (n != -1) {
            string3 = string.substring(0, n).toUpperCase();
            if (string3.indexOf(65) != -1) {
                stringBuilder.append('\u2303');
            }
            if (string3.indexOf(77) != -1) {
                stringBuilder.append('\u2325');
            }
            if (string3.indexOf(83) != -1) {
                stringBuilder.append('\u21e7');
            }
            if (string3.indexOf(67) != -1) {
                stringBuilder.append('\u2318');
            }
        }
        if ((string2 = macKeySymbols.get(string3 = string.substring(n + 1))) == null) {
            try {
                int n2 = KeyEvent.class.getField("VK_".concat(string3)).getInt(null);
                string2 = KeyEvent.getKeyText(n2).toUpperCase();
            }
            catch (Exception exception) {
                string2 = string3.toUpperCase();
            }
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private GUIUtilities() {
    }

    static {
        iconPath = defaultIconPath;
        deprecatedIcons = new HashMap();
        macKeySymbols = null;
        macKeySymbols = new HashMap();
        macKeySymbols.put("ENTER", "\u21a9");
        macKeySymbols.put("HOME", "\u2196");
        macKeySymbols.put("END", "\u2198");
        macKeySymbols.put("BACK_SPACE", "\u232b");
        macKeySymbols.put("DELETE", "\u2326");
        macKeySymbols.put("PAGE_UP", "\u21de");
        macKeySymbols.put("PAGE_DOWN", "\u21df");
        macKeySymbols.put("LEFT", "\u2190");
        macKeySymbols.put("UP", "\u2191");
        macKeySymbols.put("RIGHT", "\u2192");
        macKeySymbols.put("DOWN", "\u2193");
        macKeySymbols.put("ESCAPE", "\u238b");
        macKeySymbols.put("TAB", "\u21e5");
        macKeySymbols.put("SPACE", "\u2423");
    }

    private static class SizeSaver
    extends ComponentAdapter
    implements WindowStateListener {
        private final Frame frame;
        private final Container parent;
        private final String name;

        SizeSaver(Frame frame, Container container, String string) {
            if (frame == null || string == null) {
                throw new NullPointerException();
            }
            this.frame = frame;
            this.parent = container;
            this.name = string;
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            int n = windowEvent.getNewState();
            jEdit.setIntegerProperty(this.name + ".extendedState", n);
            Rectangle rectangle = this.frame.getBounds();
            this.save(n, rectangle);
        }

        private void save(int n, Rectangle rectangle) {
            switch (n) {
                case 4: {
                    jEdit.setIntegerProperty(this.name + ".x", rectangle.x);
                    jEdit.setIntegerProperty(this.name + ".width", rectangle.width);
                    break;
                }
                case 2: {
                    jEdit.setIntegerProperty(this.name + ".y", rectangle.y);
                    jEdit.setIntegerProperty(this.name + ".height", rectangle.height);
                    break;
                }
                case 0: {
                    GUIUtilities.saveGeometry(this.frame, this.parent, this.name);
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.componentMoved(componentEvent);
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            final Rectangle rectangle = this.frame.getBounds();
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n = SizeSaver.this.frame.getExtendedState();
                    SizeSaver.this.save(n, rectangle);
                }
            };
            new Thread("Sizesavingdelay"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    EventQueue.invokeLater(runnable);
                }
            }.start();
        }
    }

    public static class UnixWorkaround {
        Window win;
        String name;
        Rectangle desired;
        Rectangle required;
        long start;
        boolean windowOpened;

        public UnixWorkaround(Window window, String string, Rectangle rectangle, int n) {
            this.win = window;
            this.name = string;
            this.desired = rectangle;
            int n2 = jEdit.getIntegerProperty(string + ".dx", 0);
            int n3 = jEdit.getIntegerProperty(string + ".dy", 0);
            int n4 = jEdit.getIntegerProperty(string + ".d-width", 0);
            int n5 = jEdit.getIntegerProperty(string + ".d-height", 0);
            this.required = new Rectangle(rectangle.x - n2, rectangle.y - n3, rectangle.width - n4, rectangle.height - n5);
            Log.log(1, GUIUtilities.class, "Window " + string + ": desired geometry is " + rectangle);
            Log.log(1, GUIUtilities.class, "Window " + string + ": setting geometry to " + this.required);
            this.start = System.currentTimeMillis();
            window.setBounds(this.required);
            if (window instanceof Frame) {
                ((Frame)window).setExtendedState(n);
            }
            window.addComponentListener(new ComponentHandler());
            window.addWindowListener(new WindowHandler());
        }

        private class WindowHandler
        extends WindowAdapter {
            private WindowHandler() {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                UnixWorkaround.this.windowOpened = true;
                Rectangle rectangle = UnixWorkaround.this.win.getBounds();
                Log.log(1, GUIUtilities.class, "Window " + UnixWorkaround.this.name + ": bounds after opening: " + rectangle);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".dx", rectangle.x - UnixWorkaround.this.required.x);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".dy", rectangle.y - UnixWorkaround.this.required.y);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".d-width", rectangle.width - UnixWorkaround.this.required.width);
                jEdit.setIntegerProperty(UnixWorkaround.this.name + ".d-height", rectangle.height - UnixWorkaround.this.required.height);
                UnixWorkaround.this.win.removeWindowListener(this);
            }
        }

        private class ComponentHandler
        extends ComponentAdapter {
            private ComponentHandler() {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle rectangle = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && rectangle.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!rectangle.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, GUIUtilities.class, "Window resize blocked: " + UnixWorkaround.this.win.getBounds());
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (System.currentTimeMillis() - UnixWorkaround.this.start < 1000L) {
                    Rectangle rectangle = UnixWorkaround.this.win.getBounds();
                    if (!UnixWorkaround.this.windowOpened && rectangle.equals(UnixWorkaround.this.required)) {
                        return;
                    }
                    if (!rectangle.equals(UnixWorkaround.this.desired)) {
                        Log.log(1, GUIUtilities.class, "Window resize blocked: " + UnixWorkaround.this.win.getBounds());
                        UnixWorkaround.this.win.setBounds(UnixWorkaround.this.desired);
                    }
                }
                UnixWorkaround.this.win.removeComponentListener(this);
            }
        }
    }
}

