/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.HyperSearchNode;

public class HyperSearchFileNode
implements HyperSearchNode {
    public String path;
    public boolean showFullPath = true;
    private static String fileSep = System.getProperty("file.separator");
    private int count;

    public HyperSearchFileNode(String string) {
        this.path = string;
    }

    @Override
    public Buffer getBuffer(View view) {
        return jEdit.openFile(view, this.path);
    }

    @Override
    public void goTo(EditPane editPane) {
        Buffer buffer = this.getBuffer(editPane.getView());
        if (buffer == null) {
            return;
        }
        editPane.setBuffer(buffer);
    }

    public String toString() {
        if (this.showFullPath) {
            return this.path;
        }
        String[] stringArray = this.path.split(fileSep);
        return stringArray[stringArray.length - 1];
    }

    public boolean equals(Object object) {
        if (!(object instanceof HyperSearchFileNode)) {
            return false;
        }
        HyperSearchFileNode hyperSearchFileNode = (HyperSearchFileNode)object;
        return this.path.equals(MiscUtilities.resolveSymlinks(hyperSearchFileNode.path));
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    static {
        if (fileSep.equals("\\")) {
            fileSep = "\\\\";
        }
    }
}

