/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;

public final class HashtableOfPackage {
    public char[][] keyTable;
    public PackageBinding[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfPackage() {
        this(3);
    }

    public HashtableOfPackage(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new char[n2][];
        this.valueTable = new PackageBinding[n2];
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public PackageBinding get(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public PackageBinding put(char[] cArray, PackageBinding packageBinding) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n2] = packageBinding;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = cArray;
        this.valueTable[n2] = packageBinding;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return packageBinding;
    }

    private void rehash() {
        HashtableOfPackage hashtableOfPackage = new HashtableOfPackage(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            char[] cArray = this.keyTable[n];
            if (cArray == null) continue;
            hashtableOfPackage.put(cArray, this.valueTable[n]);
        }
        this.keyTable = hashtableOfPackage.keyTable;
        this.valueTable = hashtableOfPackage.valueTable;
        this.threshold = hashtableOfPackage.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        for (PackageBinding packageBinding : this.valueTable) {
            if (packageBinding == null) continue;
            string = string + packageBinding.toString() + "\n";
        }
        return string;
    }
}

