/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.charts.xy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYSelectionOverlay
extends ChartOverlay {
    private ChartComponent chart;
    private int selectionExtent;
    private final ConfigurationListener configurationListener = new ConfigurationListener();
    private final SelectionListener selectionListener = new SelectionListener();
    private final Set<Point> selectedValues = new HashSet<Point>();
    private Paint markPaint;
    private Paint oddPerfPaint;
    private Paint evenPerfPaint;
    private Stroke markStroke;
    private Stroke oddPerfStroke;
    private Stroke evenPerfStroke;

    public XYSelectionOverlay() {
        this.initDefaultValues();
    }

    public final void registerChart(ChartComponent chart) {
        this.unregisterListener();
        this.chart = chart;
        this.registerListener();
    }

    public final void unregisterChart(ChartComponent chart) {
        this.unregisterListener();
        this.chart = null;
    }

    private void registerListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.addConfigurationListener((ChartConfigurationListener)this.configurationListener);
        this.chart.getSelectionModel().addSelectionListener((ChartSelectionListener)this.selectionListener);
    }

    private void unregisterListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeConfigurationListener((ChartConfigurationListener)this.configurationListener);
        this.chart.getSelectionModel().removeSelectionListener((ChartSelectionListener)this.selectionListener);
    }

    private void initDefaultValues() {
        this.markPaint = new Color(80, 80, 80);
        this.oddPerfPaint = Color.BLACK;
        this.evenPerfPaint = Color.WHITE;
        this.markStroke = new BasicStroke(2.8f, 1, 1);
        this.oddPerfStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.0f, 3.0f}, 0.0f);
        this.evenPerfStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.0f, 3.0f}, 2.0f);
        this.selectionExtent = 3;
    }

    public void paint(Graphics g) {
        if (this.selectedValues.isEmpty()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.chart.getRenderingHints());
        Iterator<Point> it = this.selectedValues.iterator();
        boolean linePainted = false;
        while (it.hasNext()) {
            Point p = it.next();
            if (!linePainted) {
                g2.setPaint(this.evenPerfPaint);
                g2.setStroke(this.evenPerfStroke);
                g2.drawLine(p.x, 0, p.x, this.getHeight());
                g2.setPaint(this.oddPerfPaint);
                g2.setStroke(this.oddPerfStroke);
                g2.drawLine(p.x, 0, p.x, this.getHeight());
                g2.setPaint(this.markPaint);
                g2.setStroke(this.markStroke);
                linePainted = true;
            }
            g2.fillOval(p.x - this.selectionExtent + 1, p.y - this.selectionExtent + 1, this.selectionExtent * 2 - 1, this.selectionExtent * 2 - 1);
        }
    }

    private void vLineBoundsChanged(Set<Point> oldSelection, Set<Point> newSelection) {
        Point newSel;
        Point oldSel = oldSelection.isEmpty() ? null : oldSelection.iterator().next();
        Point point = newSel = newSelection.isEmpty() ? null : newSelection.iterator().next();
        if (oldSel != null) {
            this.repaint(oldSel.x - this.selectionExtent, 0, this.selectionExtent * 2, this.getHeight());
        }
        if (newSel != null) {
            this.repaint(newSel.x - this.selectionExtent, 0, this.selectionExtent * 2, this.getHeight());
        }
    }

    private static void updateSelectedValues(Set<Point> selectedValues, List<ItemSelection> selectedItems, ChartContext context) {
        selectedValues.clear();
        for (ItemSelection sel : selectedItems) {
            XYItemSelection xySel = (XYItemSelection)sel;
            long xValue = xySel.getItem().getXValue(xySel.getValueIndex());
            long yValue = xySel.getItem().getYValue(xySel.getValueIndex());
            selectedValues.add(new Point(Utils.checkedInt((double)Math.ceil(context.getViewX((double)xValue))), Utils.checkedInt((double)Math.ceil(context.getViewY((double)yValue)))));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionListener
    implements ChartSelectionListener {
        private SelectionListener() {
        }

        public void selectionModeChanged(int newMode, int oldMode) {
        }

        public void selectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
        }

        public void selectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        }

        public void highlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
            HashSet oldSelectedValues = new HashSet(XYSelectionOverlay.this.selectedValues);
            XYSelectionOverlay.updateSelectedValues(XYSelectionOverlay.this.selectedValues, currentItems, XYSelectionOverlay.this.chart.getChartContext());
            XYSelectionOverlay.this.vLineBoundsChanged(oldSelectedValues, XYSelectionOverlay.this.selectedValues);
        }
    }

    private class ConfigurationListener
    extends ChartConfigurationListener.Adapter {
        private ConfigurationListener() {
        }

        public void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HashSet oldSelectedValues = new HashSet(XYSelectionOverlay.this.selectedValues);
                    XYSelectionOverlay.updateSelectedValues(XYSelectionOverlay.this.selectedValues, XYSelectionOverlay.this.chart.getSelectionModel().getHighlightedItems(), XYSelectionOverlay.this.chart.getChartContext());
                    XYSelectionOverlay.this.vLineBoundsChanged(oldSelectedValues, XYSelectionOverlay.this.selectedValues);
                }
            });
        }
    }
}

