/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Font;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.ResourceManager;

public class FontLibrary {
    private static final Logger logger = Logger.getLogger(FontLibrary.class.getName());
    private static Font mainFont = null;
    private final float scaleFactor;

    public FontLibrary() {
        this.scaleFactor = 1.0f;
    }

    public FontLibrary(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    static Font createMainFont(String fontName, float scaleFactor) {
        float defaultSize = 12.0f * scaleFactor;
        mainFont = null;
        if (fontName != null) {
            Font font = Font.decode(fontName);
            if (font != null) {
                mainFont = font = font.deriveFont(defaultSize);
                return font;
            }
            logger.warning("Font not found: " + fontName);
        }
        return ResourceManager.getFont("font.normal").deriveFont(defaultSize);
    }

    public Font createScaledFont(FontType fontType, FontSize fontSize) {
        return FontLibrary.createFont(fontType, fontSize, 0, this.scaleFactor);
    }

    public Font createScaledFont(FontType fontType, FontSize fontSize, int style) {
        return FontLibrary.createFont(fontType, fontSize, style, this.scaleFactor);
    }

    public Font createCompatibleScaledFont(String string, FontType fontType, FontSize fontSize) {
        return FontLibrary.createCompatibleFont(string, fontType, fontSize, 0, this.scaleFactor);
    }

    public Font createCompatibleScaledFont(String string, FontType fontType, FontSize fontSize, int style) {
        return FontLibrary.createCompatibleFont(string, fontType, fontSize, style, this.scaleFactor);
    }

    public static Font createFont(FontType fontType, FontSize fontSize) {
        return FontLibrary.createFont(fontType, fontSize, 0, 1.0f);
    }

    public static Font createFont(FontType fontType, FontSize fontSize, int style) {
        return FontLibrary.createFont(fontType, fontSize, style, 1.0f);
    }

    public static Font createFont(FontType fontType, FontSize fontSize, float scaleFactor) {
        return FontLibrary.createFont(fontType, fontSize, 0, scaleFactor);
    }

    public static Font createCompatibleFont(String string, FontType fontType, FontSize fontSize) {
        return FontLibrary.createCompatibleFont(string, fontType, fontSize, 0, 1.0f);
    }

    public static Font createCompatibleFont(String string, FontType fontType, FontSize fontSize, int style) {
        return FontLibrary.createCompatibleFont(string, fontType, fontSize, style, 1.0f);
    }

    public static Font createCompatibleFont(String string, FontType fontType, FontSize fontSize, float scaleFactor) {
        return FontLibrary.createCompatibleFont(string, fontType, fontSize, 0, scaleFactor);
    }

    public static Font createFont(FontType fontType, FontSize fontSize, int style, float scaleFactor) {
        float scaledSize = FontLibrary.calcScaledSize(fontSize, scaleFactor);
        String fontKey = FontLibrary.getFontKey(fontType);
        Font font = fontKey == null ? mainFont : ResourceManager.getFont(fontKey);
        font = font.deriveFont(style, scaledSize);
        return font;
    }

    public static Font createCompatibleFont(String string, FontType fontType, FontSize fontSize, int style, float scaleFactor) {
        float scaledSize = FontLibrary.calcScaledSize(fontSize, scaleFactor);
        String fontKey = FontLibrary.getFontKey(fontType);
        Font font = null;
        if (fontType != FontType.NORMAL && (font = ResourceManager.getFont(fontKey)).canDisplayUpTo(string) != -1) {
            font = null;
        }
        if (font == null) {
            fontKey = FontLibrary.getFontKey(FontType.NORMAL);
            font = fontKey == null ? mainFont : ResourceManager.getFont(fontKey);
        }
        font = font.deriveFont(style, scaledSize);
        return font;
    }

    private static float calcScaledSize(FontSize fontSize, float scaleFactor) {
        float pixelSize;
        switch (fontSize) {
            default: {
                logger.warning("Unknown FontSize");
            }
            case TINY: {
                pixelSize = 12.0f;
                break;
            }
            case SMALLER: {
                pixelSize = 16.0f;
                break;
            }
            case SMALL: {
                pixelSize = 24.0f;
                break;
            }
            case MEDIUM: {
                pixelSize = 36.0f;
                break;
            }
            case BIG: {
                pixelSize = 48.0f;
            }
        }
        return pixelSize * scaleFactor;
    }

    private static String getFontKey(FontType fontType) {
        String fontName;
        switch (fontType) {
            default: {
                logger.warning("Unknown FontType");
            }
            case NORMAL: {
                fontName = mainFont != null ? null : "font.normal";
                break;
            }
            case SIMPLE: {
                fontName = "font.simple";
                break;
            }
            case HEADER: {
                fontName = "font.header";
            }
        }
        return fontName;
    }

    public static enum FontSize {
        TINY,
        SMALLER,
        SMALL,
        MEDIUM,
        BIG;

    }

    public static enum FontType {
        NORMAL,
        SIMPLE,
        HEADER;

    }
}

