/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.panel.Flag;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;

public class ConfirmDeclarationDialog
extends FreeColDialog<List<String>>
implements ActionListener,
ItemListener {
    private static final Logger logger = Logger.getLogger(ConfirmDeclarationDialog.class.getName());
    public static final Flag SPANISH_FLAG = new Flag(Flag.Background.FESSES, Flag.Decoration.NONE, Flag.UnionPosition.MIDDLE).setStripes(3).setUnionColor(null).setBackgroundColors(new Color(207, 20, 43), new Color(0, 36, 125), new Color(255, 204, 0));
    public static final Flag PORTUGUESE_FLAG = new Flag(Flag.Background.FESSES, Flag.Decoration.NONE, Flag.UnionPosition.CANTON).setUnionColor(new Color(62, 64, 149)).setBackgroundColors(new Color(0, 168, 89), new Color(255, 204, 41));
    public static final Flag ENGLISH_FLAG = new Flag(Flag.Background.FESSES, Flag.Decoration.NONE, Flag.UnionPosition.CANTON).setUnionColor(new Color(0.234f, 0.233f, 0.43f)).setBackgroundColors(new Color(0.698f, 0.132f, 0.203f), Color.WHITE);
    public static final Flag FRENCH_FLAG = new Flag(Flag.Background.PALES, Flag.Decoration.NONE, Flag.UnionPosition.LEFT).setStripes(3).setUnionColor(null).setBackgroundColors(new Color(0, 35, 149), Color.WHITE, new Color(237, 41, 57));
    public static final Flag DUTCH_FLAG = new Flag(Flag.Background.FESSES, Flag.Decoration.NONE, Flag.UnionPosition.TOP).setStripes(3).setUnionColor(null).setBackgroundColors(new Color(174, 28, 40), Color.WHITE, new Color(33, 70, 107));
    public static final Flag SWEDISH_FLAG = new Flag(Flag.Background.QUARTERLY, Flag.Decoration.SCANDINAVIAN_CROSS, Flag.UnionPosition.CANTON).setUnionColor(null).setDecorationColor(new Color(254, 203, 0)).setBackgroundColors(new Color(0, 82, 147));
    public static final Flag DANISH_FLAG = new Flag(Flag.Background.QUARTERLY, Flag.Decoration.SCANDINAVIAN_CROSS, Flag.UnionPosition.CANTON).setUnionColor(null).setDecorationColor(Color.WHITE).setBackgroundColors(new Color(198, 12, 48));
    public static final Flag RUSSIAN_FLAG = new Flag(Flag.Background.FESSES, Flag.Decoration.NONE, Flag.UnionPosition.MIDDLE).setStripes(3).setUnionColor(null).setBackgroundColors(Color.WHITE, new Color(0, 57, 166), new Color(213, 43, 30));
    private static final Map<String, Flag> defaultFlags = new HashMap<String, Flag>();
    private final JTextField countryField;
    private final JTextField nationField;
    private final JLabel label;
    private Flag flag;
    private final JComboBox<Flag.Background> background = new JComboBox<Flag.Background>(Flag.Background.values());
    private final JComboBox<Flag.Decoration> decoration = new JComboBox<Flag.Decoration>(Flag.Decoration.values());
    private final JComboBox<Flag.UnionPosition> unionPosition = new JComboBox<Flag.UnionPosition>(Flag.UnionPosition.values());
    private final JComboBox<Flag.UnionShape> unionShape = new JComboBox<Flag.UnionShape>(Flag.UnionShape.values());
    private final JComboBox<String> stars = new JComboBox<String>(this.getNumbers(50));
    private final JComboBox<String> stripes = new JComboBox<String>(this.getNumbers(13));
    private final ColorButton decorationColor = new ColorButton(Color.WHITE);
    private final ColorButton unionColor = new ColorButton(Color.BLUE);
    private final ColorButton starColor = new ColorButton(Color.WHITE);
    private final ColorButton[] backgroundColors = new ColorButton[]{new ColorButton(null), new ColorButton(null), new ColorButton(null), new ColorButton(null), new ColorButton(null), new ColorButton(null)};

    public ConfirmDeclarationDialog(FreeColClient freeColClient, JFrame frame) {
        super(freeColClient, frame);
        Player player = freeColClient.getMyPlayer();
        this.flag = defaultFlags.get(player.getNationId());
        if (this.flag == null) {
            this.flag = ENGLISH_FLAG;
        }
        StringTemplate sure = StringTemplate.template("confirmDeclarationDialog.areYouSure.text").addNamed("%monarch%", player.getMonarch());
        StringTemplate country = StringTemplate.template("confirmDeclarationDialog.defaultCountry").addName("%nation%", player.getNewLandName());
        this.countryField = new JTextField(Messages.message(country), 20);
        StringTemplate nation = StringTemplate.template("confirmDeclarationDialog.defaultNation").addStringTemplate("%nation%", player.getNationLabel());
        this.nationField = new JTextField(Messages.message(nation), 20);
        this.label = new JLabel();
        this.label.setIcon(new ImageIcon(this.flag.getImage()));
        MigPanel panel = new MigPanel(new MigLayout("wrap 2", "[][fill]", "[fill]"));
        panel.add((Component)Utility.localizedTextArea(sure), "span");
        panel.add((Component)Utility.localizedTextArea("confirmDeclarationDialog.enterCountry"), "span");
        panel.add((Component)this.countryField, "span");
        panel.add((Component)Utility.localizedTextArea("confirmDeclarationDialog.enterNation"), "span");
        panel.add((Component)this.nationField, "span");
        panel.add((Component)Utility.localizedTextArea("confirmDeclarationDialog.createFlag"), "span");
        panel.add((Component)this.label, "skip, width 200, height 100");
        this.addComboBox(panel, this.background, "flag.background.", this.flag.getBackground());
        this.addComboBox(panel, this.decoration, "flag.decoration.", this.flag.getDecoration());
        this.addComboBox(panel, this.unionPosition, "flag.unionPosition.", this.flag.getUnionPosition());
        this.addComboBox(panel, this.unionShape, "flag.unionShape.", this.flag.getUnionShape());
        this.stars.setSelectedIndex(this.flag.getStars() - 1);
        this.stars.addItemListener(this);
        panel.add(Utility.localizedLabel("flag.stars.label"));
        panel.add(this.stars);
        this.stripes.setSelectedIndex(this.flag.getStripes() - 1);
        this.stripes.addItemListener(this);
        panel.add(Utility.localizedLabel("flag.stripes.label"));
        panel.add(this.stripes);
        this.unionColor.setColor(this.flag.getUnionColor());
        this.unionColor.addActionListener(this);
        panel.add(Utility.localizedLabel("flag.unionColor.label"));
        panel.add((Component)this.unionColor, "sg colorButton");
        this.decorationColor.setColor(this.flag.getDecorationColor());
        this.decorationColor.addActionListener(this);
        panel.add(Utility.localizedLabel("flag.decorationColor.label"));
        panel.add(this.decorationColor);
        this.starColor.setColor(this.flag.getStarColor());
        this.starColor.addActionListener(this);
        panel.add(Utility.localizedLabel("flag.starColor.label"));
        panel.add(this.starColor);
        List<Color> flagColors = this.flag.getBackgroundColors();
        int colors = flagColors.size();
        panel.add(Utility.localizedLabel("flag.backgroundColors.label"));
        for (int index = 0; index < this.backgroundColors.length; ++index) {
            ColorButton button = this.backgroundColors[index];
            if (index < colors) {
                button.setColor(flagColors.get(index));
            }
            button.addActionListener(this);
            if (index == 0) {
                panel.add((Component)button, "split 3, sg colorButton");
                continue;
            }
            if (index % 3 == 0) {
                panel.add((Component)button, "skip, split 3, sg colorButton");
                continue;
            }
            panel.add((Component)button, "sg colorButton");
        }
        panel.setPreferredSize(panel.getPreferredSize());
        ImageIcon icon = new ImageIcon(this.getImageLibrary().getSmallMiscIconImage(player.getNation()));
        Object fake = null;
        List c = ConfirmDeclarationDialog.choices();
        c.add(new ChoiceItem<Object>(Messages.message("confirmDeclarationDialog.areYouSure.yes"), fake).okOption());
        c.add(new ChoiceItem<Object>(Messages.message("confirmDeclarationDialog.areYouSure.no"), fake).cancelOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, panel, icon, c);
    }

    private <T> void addComboBox(JPanel panel, JComboBox<T> box, String prefix, T value) {
        box.setRenderer(new EnumRenderer(prefix));
        box.setSelectedItem(value);
        box.addItemListener(this);
        panel.add(Utility.localizedLabel(prefix + "label"));
        panel.add(box);
    }

    private void setColors() {
        this.flag.setUnionColor(this.unionColor.getColor());
        this.flag.setStarColor(this.starColor.getColor());
        this.flag.setDecorationColor(this.decorationColor.getColor());
        ArrayList<Color> colors = new ArrayList<Color>();
        for (ColorButton button : this.backgroundColors) {
            Color color = button.getColor();
            if (color != null) {
                colors.add(color);
            }
            this.flag.setBackgroundColors(colors);
        }
    }

    private String[] getNumbers(int count) {
        String[] result = new String[count];
        for (int index = 0; index < count; ++index) {
            result[index] = Integer.toString(index + 1);
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        ColorButton button = (ColorButton)ae.getSource();
        Color color = JColorChooser.showDialog(this, this.label.getText(), button.getBackground());
        button.setColor(color);
        this.setColors();
        this.label.setIcon(new ImageIcon(this.flag.getImage()));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Flag.Background newBackground = (Flag.Background)((Object)this.background.getSelectedItem());
        Flag.Decoration newDecoration = (Flag.Decoration)((Object)this.decoration.getSelectedItem());
        Flag.UnionPosition newPosition = (Flag.UnionPosition)((Object)this.unionPosition.getSelectedItem());
        Flag.UnionShape newShape = (Flag.UnionShape)((Object)this.unionShape.getSelectedItem());
        this.flag = new Flag(newBackground, newDecoration, newPosition, newShape);
        this.flag.setStars(this.stars.getSelectedIndex() + 1);
        this.flag.setStripes(this.stripes.getSelectedIndex() + 1);
        this.setColors();
        this.label.setIcon(new ImageIcon(this.flag.getImage()));
    }

    @Override
    public List<String> getResponse() {
        Object value = this.getValue();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.nationField.getText().replaceAll("[^\\s\\w]", ""));
            result.add(this.countryField.getText());
            return result;
        }
        return null;
    }

    static {
        defaultFlags.put("model.nation.dutch", DUTCH_FLAG);
        defaultFlags.put("model.nation.english", ENGLISH_FLAG);
        defaultFlags.put("model.nation.french", FRENCH_FLAG);
        defaultFlags.put("model.nation.spanish", SPANISH_FLAG);
        defaultFlags.put("model.nation.danish", DANISH_FLAG);
        defaultFlags.put("model.nation.portuguese", PORTUGUESE_FLAG);
        defaultFlags.put("model.nation.russian", RUSSIAN_FLAG);
        defaultFlags.put("model.nation.swedish", SWEDISH_FLAG);
    }

    private static class EnumRenderer<T>
    extends FreeColComboBoxRenderer<T> {
        private final String prefix;

        public EnumRenderer(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void setLabelValues(JLabel c, T value) {
            c.setText(Messages.message(this.prefix + value.toString()));
        }
    }

    public static class ColorButton
    extends JButton {
        private Color color = null;

        public ColorButton(Color color) {
            this.setColor(color);
        }

        public final Color getColor() {
            return this.color;
        }

        public final void setColor(Color color) {
            this.color = color;
            this.setBackground(color);
            this.setText(color == null ? "X" : null);
        }

        @Override
        public String getUIClassID() {
            return "ColorButtonUI";
        }
    }
}

