/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.client.gui.panel.Draggable;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class GoodsLabel
extends AbstractGoodsLabel
implements Draggable {
    GUI gui;

    public GoodsLabel(GUI gui, Goods goods) {
        super(gui.getImageLibrary(), goods);
        this.gui = gui;
        this.initialize();
    }

    public static Color getColor(GoodsType goodsType, int amount, Location location) {
        String key = !goodsType.limitIgnored() && location instanceof Colony && ((Colony)location).getWarehouseCapacity() < amount ? "color.foreground.GoodsLabel.capacityExceeded" : (location instanceof Colony && goodsType.isStorable() && ((Colony)location).getExportData(goodsType).getExported() ? "color.foreground.GoodsLabel.exported" : (amount == 0 ? "color.foreground.GoodsLabel.zeroAmount" : (amount < 0 ? "color.foreground.GoodsLabel.negativeAmount" : "color.foreground.GoodsLabel.positiveAmount")));
        return ResourceManager.getColor(key);
    }

    private void initialize() {
        Goods goods = this.getGoods();
        Location location = goods.getLocation();
        Player player = location instanceof Ownable ? ((Ownable)((Object)location)).getOwner() : null;
        GoodsType type = goods.getType();
        Specification spec = goods.getGame().getSpecification();
        if (this.getAmount() < 100) {
            this.setPartialChosen(true);
        }
        if (player == null || !type.isStorable() || player.canTrade(type) || location instanceof Colony && spec.getBoolean("model.option.customIgnoreBoycott") && ((Colony)location).hasAbility("model.ability.export")) {
            Utility.localizeToolTip((JComponent)this, goods.getLabel(true));
        } else {
            Utility.localizeToolTip((JComponent)this, goods.getLabel(false));
            this.setIcon(this.getDisabledIcon());
        }
        this.setForeground(GoodsLabel.getColor(type, goods.getAmount(), location));
        super.setText(String.valueOf(goods.getAmount()));
    }

    public Goods getGoods() {
        return (Goods)this.getAbstractGoods();
    }

    @Override
    public void setPartialChosen(boolean partialChosen) {
        super.setPartialChosen(partialChosen);
        ImageLibrary lib = this.gui.getImageLibrary();
        BufferedImage image = partialChosen ? lib.getSmallIconImage(this.getType()) : lib.getIconImage(this.getType());
        this.setIcon(new ImageIcon(image));
    }

    @Override
    public boolean isOnCarrier() {
        Goods goods = this.getGoods();
        return goods != null && goods.getLocation() instanceof Unit;
    }
}

