/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;

public final class TradeRoutePanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(TradeRoutePanel.class.getName());
    private static final String DEASSIGN = "deassign";
    private static final Comparator<TradeRoute> tradeRouteComparator = Comparator.comparing(TradeRoute::getName);
    private final Unit unit;
    private final DefaultListModel<TradeRoute> listModel = new DefaultListModel();
    private JList<TradeRoute> tradeRoutes;
    private final Map<TradeRoute, Integer> counts = new HashMap<TradeRoute, Integer>();
    private JButton newRouteButton;
    private JButton editRouteButton;
    private JButton deleteRouteButton;
    private JButton deassignRouteButton;

    public TradeRoutePanel(FreeColClient freeColClient, Unit unit) {
        super(freeColClient, new MigLayout("wrap 2", "[fill][fill]"));
        Player player = this.getMyPlayer();
        this.unit = unit;
        this.tradeRoutes = new JList<TradeRoute>(this.listModel);
        this.tradeRoutes.addListSelectionListener(e -> this.updateButtons());
        this.tradeRoutes.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
                Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, selected, focus);
                TradeRoute tradeRoute = (TradeRoute)value;
                String name = tradeRoute.getName();
                Integer n = (Integer)TradeRoutePanel.this.counts.get(tradeRoute);
                if (n == null || n <= 0) {
                    this.setText(name);
                } else {
                    this.setText(name + "  (" + n + ")");
                }
                return ret;
            }
        });
        JScrollPane tradeRouteView = new JScrollPane(this.tradeRoutes);
        this.newRouteButton = Utility.localizedButton("tradeRoutePanel.newRoute");
        Utility.localizeToolTip((JComponent)this.newRouteButton, "tradeRoutePanel.new.tooltip");
        this.newRouteButton.addActionListener(ae -> this.newRoute());
        this.editRouteButton = Utility.localizedButton("tradeRoutePanel.editRoute");
        Utility.localizeToolTip((JComponent)this.editRouteButton, "tradeRoutePanel.edit.tooltip");
        this.editRouteButton.addActionListener(ae -> {
            TradeRoute selected = this.tradeRoutes.getSelectedValue();
            String name = selected.getName();
            this.getGUI().showTradeRouteInputPanel(selected, () -> {
                StringTemplate template = null;
                if (selected.getName() == null) {
                    selected.setName(name);
                } else {
                    template = selected.verify();
                    if (template == null) {
                        this.igc().updateTradeRoute(selected);
                        this.updateList(selected);
                    } else {
                        this.getGUI().showInformationMessage(template);
                    }
                }
            });
        });
        this.deleteRouteButton = Utility.localizedButton("tradeRoutePanel.deleteRoute");
        Utility.localizeToolTip((JComponent)this.deleteRouteButton, "tradeRoutePanel.delete.tooltip");
        this.deleteRouteButton.addActionListener(ae -> {
            TradeRoute route = this.getRoute();
            if (route != null) {
                for (Unit u : route.getAssignedUnits()) {
                    this.igc().assignTradeRoute(u, null);
                }
                this.deleteTradeRoute(route);
                this.updateList(null);
            }
        });
        this.deassignRouteButton = Utility.localizedButton("tradeRoutePanel.deassignRoute");
        Utility.localizeToolTip((JComponent)this.deassignRouteButton, "tradeRoutePanel.deassign.tooltip");
        this.deassignRouteButton.setActionCommand(DEASSIGN);
        this.deassignRouteButton.addActionListener(this);
        JButton cancelButton = Utility.localizedButton("cancel");
        cancelButton.setActionCommand("CANCEL");
        cancelButton.addActionListener(this);
        this.setCancelComponent(cancelButton);
        this.updateButtons();
        this.updateList(unit == null || unit.getTradeRoute() == null ? null : unit.getTradeRoute());
        this.add((Component)Utility.localizedHeader(Messages.nameKey("tradeRoutePanel"), false), "span, align center");
        if (this.unit != null && this.unit.getLocation() != null) {
            JLabel unitLabel = new JLabel(unit.getDescription(Unit.UnitLabelType.NATIONAL));
            unitLabel.setIcon(new ImageIcon(this.getImageLibrary().getSmallerUnitImage(this.unit)));
            this.add(unitLabel);
            Location loc = this.unit.getLocation();
            JLabel locLabel = Utility.localizedLabel(loc.getLocationLabelFor(player));
            this.add(locLabel);
        }
        this.add((Component)tradeRouteView, "height 360:400, width 250:");
        this.add((Component)this.newRouteButton, "split 4, flowy, growx");
        this.add((Component)this.editRouteButton, "growx");
        this.add((Component)this.deleteRouteButton, "growx");
        this.add(this.deassignRouteButton);
        this.add((Component)this.okButton, "newline 20, span, split 2, tag ok");
        this.add((Component)cancelButton, "tag cancel");
        this.getGUI().restoreSavedSize(this, this.getPreferredSize());
    }

    private TradeRoute getRoute() {
        return this.tradeRoutes.getSelectedValue();
    }

    private void newRoute() {
        Player player = this.getMyPlayer();
        Unit u = this.unit;
        TradeRoute newRoute = this.igc().getNewTradeRoute(player);
        this.getGUI().showTradeRouteInputPanel(newRoute, () -> {
            StringTemplate template = null;
            if (newRoute.getName() == null) {
                this.deleteTradeRoute(newRoute);
                this.updateList(null);
            } else {
                template = newRoute.verify();
                if (template == null) {
                    this.igc().updateTradeRoute(newRoute);
                    if (u != null) {
                        this.igc().assignTradeRoute(u, newRoute);
                    }
                    this.updateList(newRoute);
                } else {
                    this.updateList(null);
                    this.getGUI().showInformationMessage(template);
                }
            }
        });
    }

    private void updateButtons() {
        this.newRouteButton.setEnabled(true);
        if (this.tradeRoutes.getSelectedIndex() < 0) {
            this.editRouteButton.setEnabled(false);
            this.deleteRouteButton.setEnabled(false);
            this.deassignRouteButton.setEnabled(false);
        } else {
            this.editRouteButton.setEnabled(true);
            this.deleteRouteButton.setEnabled(true);
            this.deassignRouteButton.setEnabled(this.unit != null && this.unit.getTradeRoute() != null);
        }
    }

    private void updateList(TradeRoute selectRoute) {
        Player player = this.getMyPlayer();
        this.counts.clear();
        for (Unit u : player.getUnits()) {
            TradeRoute tradeRoute = u.getTradeRoute();
            if (tradeRoute == null) continue;
            Integer i = this.counts.get(tradeRoute);
            int value = i == null ? 0 : i;
            this.counts.put(tradeRoute, value + 1);
        }
        ArrayList<TradeRoute> routes = new ArrayList<TradeRoute>(player.getTradeRoutes());
        Collections.sort(routes, tradeRouteComparator);
        this.listModel.clear();
        for (TradeRoute route : routes) {
            this.listModel.addElement(route);
        }
        if (selectRoute != null && this.tradeRoutes != null) {
            this.tradeRoutes.setSelectedValue(selectRoute, true);
        }
    }

    private void deleteTradeRoute(TradeRoute route) {
        List<TradeRoute> routes = this.getMyPlayer().getTradeRoutes();
        routes.remove(route);
        this.igc().setTradeRoutes(routes);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (null == command) {
            return;
        }
        TradeRoute route = this.getRoute();
        switch (command) {
            case "deassign": {
                if (this.unit != null && route == this.unit.getTradeRoute()) {
                    this.igc().clearOrders(this.unit);
                }
                this.getGUI().removeFromCanvas(this);
                break;
            }
            case "OK": {
                ArrayList<TradeRoute> routes = new ArrayList<TradeRoute>();
                for (int index = 0; index < this.listModel.getSize(); ++index) {
                    routes.add(this.listModel.getElementAt(index));
                }
                this.igc().setTradeRoutes(routes);
                if (this.unit != null && route != null) {
                    this.igc().assignTradeRoute(this.unit, route);
                }
                super.actionPerformed(ae);
                break;
            }
            case "CANCEL": {
                this.getGUI().removeTradeRoutePanel(this);
                break;
            }
            default: {
                super.actionPerformed(ae);
            }
        }
    }

    @Override
    public void removeNotify() {
        this.listModel.clear();
        this.tradeRoutes = null;
        this.counts.clear();
        this.newRouteButton = null;
        this.editRouteButton = null;
        this.deleteRouteButton = null;
        this.deassignRouteButton = null;
        super.removeNotify();
    }
}

