/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.StreamReaderDelegate;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;

public class FreeColXMLReader
extends StreamReaderDelegate
implements Closeable {
    private static final Logger logger = Logger.getLogger(FreeColXMLReader.class.getName());
    private InputStream inputStream = null;
    private ReadScope readScope;
    private Map<String, FreeColObject> uninterned = null;

    public FreeColXMLReader(InputStream inputStream) throws IOException {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            this.setParent(xif.createXMLStreamReader(inputStream, "UTF-8"));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        this.inputStream = inputStream;
        this.readScope = ReadScope.NORMAL;
    }

    public FreeColXMLReader(Reader reader) throws IOException {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            this.setParent(xif.createXMLStreamReader(reader));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        this.inputStream = null;
        this.readScope = ReadScope.NORMAL;
    }

    public boolean shouldIntern() {
        return this.readScope != ReadScope.NOINTERN;
    }

    public ReadScope getReadScope() {
        return this.readScope;
    }

    public void setReadScope(ReadScope readScope) {
        this.readScope = readScope;
        this.uninterned = this.shouldIntern() ? null : new HashMap();
    }

    private FreeColObject lookup(Game game, String id) {
        FreeColObject fco = this.shouldIntern() ? null : this.uninterned.get(id);
        return fco != null ? fco : game.getFreeColGameObject(id);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "Error closing stream.", xse);
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Error closing stream.", ioe);
            }
            this.inputStream = null;
        }
    }

    public String readId() {
        String id = this.getAttribute("id", null);
        if (id == null) {
            id = this.getAttribute("ID", null);
        }
        return id;
    }

    public boolean atTag(String tag) {
        return this.getLocalName().equals(tag);
    }

    public void expectTag(String tag) throws XMLStreamException {
        String endTag = this.getLocalName();
        if (!endTag.equals(tag)) {
            throw new XMLStreamException("Parse error, " + tag + " expected, not: " + endTag);
        }
    }

    public void closeTag(String tag) throws XMLStreamException {
        if (this.nextTag() != 2) {
            throw new XMLStreamException("Parse error, END_ELEMENT expected, not: " + this.getLocalName());
        }
        this.expectTag(tag);
    }

    public String currentTag() {
        StringBuilder sb = new StringBuilder(this.getLocalName());
        sb.append(", attributes:");
        int n = this.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            sb.append(" ").append(this.getAttributeLocalName(i)).append("=\"").append(this.getAttributeValue(i)).append("\"");
        }
        return sb.toString();
    }

    public boolean hasAttribute(String attributeName) {
        return this.getParent().getAttributeValue(null, attributeName) != null;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        return attrib == null ? defaultValue : Boolean.parseBoolean(attrib);
    }

    public float getAttribute(String attributeName, float defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        float result = defaultValue;
        if (attrib != null) {
            try {
                result = Float.parseFloat(attrib);
            }
            catch (NumberFormatException e) {
                logger.warning(attributeName + " is not a float: " + attrib);
            }
        }
        return result;
    }

    public int getAttribute(String attributeName, int defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        int result = defaultValue;
        if (attrib != null) {
            try {
                result = Integer.decode(attrib);
            }
            catch (NumberFormatException e) {
                logger.warning(attributeName + " is not an integer: " + attrib);
            }
        }
        return result;
    }

    public long getAttribute(String attributeName, long defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        long result = defaultValue;
        if (attrib != null) {
            try {
                result = Long.decode(attrib);
            }
            catch (NumberFormatException e) {
                logger.warning(attributeName + " is not a long: " + attrib);
            }
        }
        return result;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        return attrib == null ? defaultValue : attrib;
    }

    public <T extends Enum<T>> T getAttribute(String attributeName, Class<T> returnClass, T defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        T result = defaultValue;
        if (attrib != null) {
            try {
                result = Enum.valueOf(returnClass, attrib.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                logger.warning(attributeName + " is not a " + defaultValue.getClass().getName() + ": " + attrib);
            }
        }
        return result;
    }

    public <T extends FreeColObject> T getAttribute(Game game, String attributeName, Class<T> returnClass, T defaultValue) throws XMLStreamException {
        String attrib;
        String string = attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        if (attrib == null) {
            return defaultValue;
        }
        FreeColObject fco = this.lookup(game, attrib);
        try {
            return (T)((FreeColObject)returnClass.cast(fco));
        }
        catch (ClassCastException cce) {
            throw new XMLStreamException(cce);
        }
    }

    public <T extends AIObject> T getAttribute(AIMain aiMain, String attributeName, Class<T> returnClass, T defaultValue) {
        String attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        return attrib == null ? defaultValue : aiMain.getAIObject(attrib, returnClass);
    }

    public Location getLocationAttribute(Game game, String attributeName, boolean make) throws XMLStreamException {
        String attrib;
        if (attributeName == null) {
            return null;
        }
        String string = attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        if (attrib != null) {
            FreeColObject fco = this.lookup(game, attrib);
            if (fco == null && make) {
                Class<? extends FreeColGameObject> c = Game.getLocationClass(attrib);
                if (c != null) {
                    fco = this.makeFreeColGameObject(game, attributeName, c, this.getReadScope() == ReadScope.SERVER);
                }
            }
            if (fco instanceof Location) {
                return (Location)((Object)fco);
            }
            logger.warning("Not a location: " + attrib);
        }
        return null;
    }

    public <T> List<T> readList(String tag, Class<T> type) throws XMLStreamException {
        this.expectTag(tag);
        int length = this.getAttribute("xLength", -1);
        if (length < 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int x = 0; x < length; ++x) {
            try {
                String value = this.getAttribute("x" + x, null);
                Object object = null;
                if (value != null) {
                    Constructor<T> c = type.getConstructor(type);
                    object = c.newInstance(value);
                }
                list.add(object);
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.closeTag(tag);
        return list;
    }

    public <T extends FreeColGameObjectType> List<T> readList(Specification spec, String tag, Class<T> type) throws XMLStreamException {
        this.expectTag(tag);
        int length = this.getAttribute("xLength", -1);
        if (length < 0) {
            return Collections.emptyList();
        }
        ArrayList<FreeColGameObjectType> list = new ArrayList<FreeColGameObjectType>(length);
        for (int x = 0; x < length; ++x) {
            FreeColGameObjectType value = this.getType(spec, "x" + x, type, null);
            if (value == null) {
                logger.warning("Null list value(" + x + ")");
            }
            list.add(value);
        }
        this.closeTag(tag);
        return list;
    }

    public <T extends FreeColGameObject> T findFreeColGameObject(Game game, String attributeName, Class<T> returnClass, T defaultValue, boolean required) throws XMLStreamException {
        FreeColGameObject ret = this.getAttribute(game, attributeName, returnClass, (FreeColGameObject)null);
        if (ret == (FreeColGameObject)null) {
            if (required) {
                throw new XMLStreamException("Missing " + attributeName + " for " + returnClass.getName() + ": " + this.currentTag());
            }
            ret = defaultValue;
        }
        return (T)ret;
    }

    public <T extends FreeColGameObject> T makeFreeColGameObject(Game game, String attributeName, Class<T> returnClass, boolean required) throws XMLStreamException {
        String id;
        String string = id = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        if (id == null) {
            if (required) {
                throw new XMLStreamException("Missing " + attributeName + " for " + returnClass.getName() + ": " + this.currentTag());
            }
        } else {
            FreeColObject fco = this.lookup(game, id);
            if (fco == null) {
                try {
                    FreeColGameObject ret = (FreeColGameObject)game.newInstance(returnClass, this.getReadScope() == ReadScope.SERVER);
                    if (this.shouldIntern()) {
                        ret.internId(id);
                    } else {
                        this.uninterned.put(id, ret);
                    }
                    return (T)ret;
                }
                catch (IOException e) {
                    if (required) {
                        throw new XMLStreamException(e);
                    }
                    logger.log(Level.WARNING, "Failed to create FCGO: " + id, e);
                }
            } else {
                try {
                    return (T)((FreeColGameObject)returnClass.cast(fco));
                }
                catch (ClassCastException cce) {
                    throw new XMLStreamException(cce);
                }
            }
        }
        return null;
    }

    private <T extends FreeColGameObject> T internedRead(Game game, Class<T> returnClass) throws XMLStreamException {
        T ret = this.makeFreeColGameObject(game, "id", returnClass, false);
        if (ret != null) {
            ((FreeColGameObject)ret).readFromXML(this);
        }
        return ret;
    }

    private <T extends FreeColObject> T uninternedRead(Game game, Class<T> returnClass) throws XMLStreamException {
        T ret;
        try {
            ret = game.newInstance(returnClass, false);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        String id = this.readId();
        if (id == null) {
            throw new XMLStreamException("Object identifier not found.");
        }
        this.uninterned.put(id, (FreeColObject)ret);
        ((FreeColObject)ret).readFromXML(this);
        return ret;
    }

    public <T extends FreeColGameObject> T readFreeColGameObject(Game game, Class<T> returnClass) throws XMLStreamException {
        return (T)(this.shouldIntern() ? this.internedRead(game, returnClass) : (FreeColGameObject)this.uninternedRead(game, returnClass));
    }

    public <T extends AIObject> T findAIObject(AIMain aiMain, String attributeName, Class<T> returnClass, T defaultValue, boolean required) throws XMLStreamException {
        AIObject ret = this.getAttribute(aiMain, attributeName, returnClass, (AIObject)null);
        if (ret == (AIObject)null) {
            if (required) {
                throw new XMLStreamException("Missing " + attributeName + " for " + returnClass.getName() + ": " + this.currentTag());
            }
            ret = defaultValue;
        }
        return (T)ret;
    }

    public <T extends AIObject> T makeAIObject(AIMain aiMain, String attributeName, Class<T> returnClass, T defaultValue, boolean required) throws XMLStreamException {
        String id = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        AIObject ret = null;
        if (id == null) {
            if (required) {
                throw new XMLStreamException("Missing " + attributeName + " for " + returnClass.getName() + ": " + this.currentTag());
            }
        } else {
            ret = (AIObject)aiMain.getAIObject(id, returnClass);
            if (ret == null) {
                try {
                    Constructor<T> c = returnClass.getConstructor(AIMain.class, String.class);
                    ret = (AIObject)returnClass.cast(c.newInstance(aiMain, id));
                    if (required && ret == null) {
                        throw new XMLStreamException("Constructed null " + returnClass.getName() + " for " + id + ": " + this.currentTag());
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | XMLStreamException e) {
                    if (required) {
                        throw new XMLStreamException(e);
                    }
                    logger.log(Level.WARNING, "Failed to create AIObject: " + id, e);
                }
            }
        }
        return (T)ret;
    }

    public boolean shouldClearContainers() {
        return !this.hasAttribute("extends") && !this.hasAttribute("preserve");
    }

    public <T extends FreeColGameObjectType> T getType(Specification spec, String attributeName, Class<T> returnClass, T defaultValue) {
        String attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        return attrib == null ? defaultValue : spec.getType(attrib, returnClass);
    }

    public <T extends FreeColGameObjectType> T getRole(Specification spec, String attributeName, Class<T> returnClass, T defaultValue) {
        String attrib;
        String string = attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        if (attrib == null) {
            return defaultValue;
        }
        attrib = Role.fixRoleId(attrib);
        return spec.getType(attrib, returnClass);
    }

    public <T extends FreeColObject> T copy(Game game, Class<T> returnClass) throws XMLStreamException {
        this.setReadScope(ReadScope.NOINTERN);
        this.nextTag();
        return this.uninternedRead(game, returnClass);
    }

    public static enum ReadScope {
        SERVER,
        NORMAL,
        NOINTERN;

    }
}

