/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

public class IndianNationType
extends NationType {
    private List<RandomChoice<UnitType>> skills = null;
    private List<String> regions = null;
    private static final String PROBABILITY_TAG = "probability";
    private static final String SKILL_TAG = "skill";

    public IndianNationType(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public boolean isEuropean() {
        return false;
    }

    @Override
    public boolean isIndian() {
        return true;
    }

    @Override
    public boolean isREF() {
        return false;
    }

    public final String getSettlementTypeKey(boolean plural) {
        return this.getSettlementType(false).getId() + (plural ? ".plural" : "");
    }

    public List<String> getRegionNames() {
        return this.regions == null ? Collections.emptyList() : this.regions;
    }

    private void addRegion(String id) {
        if (this.regions == null) {
            this.regions = new ArrayList<String>();
        }
        this.regions.add(id);
    }

    public List<RandomChoice<UnitType>> getSkills() {
        return this.skills == null ? Collections.emptyList() : this.skills;
    }

    private void addSkill(UnitType unitType, int probability) {
        if (this.skills == null) {
            this.skills = new ArrayList<RandomChoice<UnitType>>();
        }
        this.skills.add(new RandomChoice<UnitType>(unitType, probability));
    }

    public List<RandomChoice<UnitType>> generateSkillsForTile(Tile tile) {
        List<RandomChoice<UnitType>> skills = this.getSkills();
        HashMap<GoodsType, Integer> scale = new HashMap<GoodsType, Integer>();
        for (RandomChoice<UnitType> skill : skills) {
            scale.put(skill.getObject().getExpertProduction(), 1);
        }
        for (Tile t : tile.getSurroundingTiles(1)) {
            for (Map.Entry entry : scale.entrySet()) {
                GoodsType goodsType = (GoodsType)entry.getKey();
                scale.put(goodsType, (Integer)entry.getValue() + t.getPotentialProduction(goodsType, null));
            }
        }
        ArrayList<RandomChoice<UnitType>> scaledSkills = new ArrayList<RandomChoice<UnitType>>();
        for (RandomChoice<UnitType> skill : skills) {
            UnitType unitType = skill.getObject();
            int scaleValue = (Integer)scale.get(unitType.getExpertProduction());
            scaledSkills.add(new RandomChoice<UnitType>(unitType, skill.getProbability() * scaleValue));
        }
        return scaledSkills;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (RandomChoice<UnitType> choice : this.getSkills()) {
            xw.writeStartElement(SKILL_TAG);
            xw.writeAttribute("id", choice.getObject());
            xw.writeAttribute(PROBABILITY_TAG, choice.getProbability());
            xw.writeEndElement();
        }
        for (String region : this.getRegionNames()) {
            xw.writeStartElement(Region.getXMLElementTagName());
            xw.writeAttribute("id", region);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec;
        IndianNationType parent;
        if (xr.shouldClearContainers()) {
            this.skills = null;
            this.regions = null;
        }
        if ((parent = xr.getType(spec = this.getSpecification(), "extends", IndianNationType.class, this)) != this) {
            if (parent.skills != null && !parent.skills.isEmpty()) {
                if (this.skills == null) {
                    this.skills = new ArrayList<RandomChoice<UnitType>>();
                }
                this.skills.addAll(parent.skills);
            }
            if (parent.regions != null && !parent.regions.isEmpty()) {
                if (this.regions == null) {
                    this.regions = new ArrayList<String>();
                }
                this.regions.addAll(parent.regions);
            }
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (SKILL_TAG.equals(tag)) {
            this.addSkill(xr.getType(spec, "id", UnitType.class, null), xr.getAttribute(PROBABILITY_TAG, 0));
            xr.closeTag(SKILL_TAG);
        } else if (Region.getXMLElementTagName().equals(tag)) {
            this.addRegion(xr.readId());
            xr.closeTag(Region.getXMLElementTagName());
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return IndianNationType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "indian-nation-type";
    }
}

