/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.util.Utils;

public class StringTemplate
extends FreeColObject {
    private TemplateType templateType = TemplateType.KEY;
    private String defaultId = null;
    private List<String> keys = null;
    private List<StringTemplate> replacements = null;
    private static final String DEFAULT_ID_TAG = "defaultId";
    private static final String KEY_TAG = "key";
    private static final String TEMPLATE_TYPE_TAG = "templateType";

    protected StringTemplate() {
    }

    protected StringTemplate(String id, StringTemplate template) {
        this.setId(id);
        this.templateType = template.templateType;
        this.defaultId = template.defaultId;
        this.keys = template.keys;
        this.replacements = template.replacements;
    }

    protected StringTemplate(String id, String defaultId, TemplateType templateType) {
        this.setId(id);
        this.defaultId = defaultId;
        this.templateType = templateType;
        this.keys = null;
        this.replacements = null;
    }

    public StringTemplate(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public static StringTemplate copy(String id, StringTemplate template) {
        return new StringTemplate(id, template);
    }

    public static StringTemplate name(String value) {
        if (value == null) {
            logger.warning("NULL NAME TEMPLATE\n" + FreeColDebugger.stackTraceToString());
        }
        return new StringTemplate(value, null, TemplateType.NAME);
    }

    public static StringTemplate key(Named named) {
        return StringTemplate.key(named.getNameKey());
    }

    public static StringTemplate key(String value) {
        return new StringTemplate(value, null, TemplateType.KEY);
    }

    public static StringTemplate template(Named named) {
        return StringTemplate.template(named.getNameKey());
    }

    public static StringTemplate template(String value) {
        return new StringTemplate(value, null, TemplateType.TEMPLATE);
    }

    public static StringTemplate label(String value) {
        return new StringTemplate(value, null, TemplateType.LABEL);
    }

    public final TemplateType getTemplateType() {
        return this.templateType;
    }

    public final String getDefaultId() {
        return this.defaultId;
    }

    public final void setDefaultId(String newDefaultId) {
        this.defaultId = newDefaultId;
    }

    public final List<String> getKeys() {
        return this.keys == null ? Collections.emptyList() : this.keys;
    }

    private void addKey(String key) {
        if (this.keys == null) {
            this.keys = new ArrayList<String>();
        }
        this.keys.add(key);
    }

    public final List<StringTemplate> getReplacements() {
        return this.replacements == null ? Collections.emptyList() : this.replacements;
    }

    private void addReplacement(StringTemplate replacement) {
        if (this.replacements == null) {
            this.replacements = new ArrayList<StringTemplate>();
        }
        this.replacements.add(replacement);
    }

    public final StringTemplate getReplacement(String key) {
        if (this.keys != null && this.replacements != null) {
            for (int index = 0; index < this.keys.size(); ++index) {
                if (!key.equals(this.keys.get(index))) continue;
                return this.replacements.size() <= index ? null : this.replacements.get(index);
            }
        }
        return null;
    }

    public StringTemplate add(String key, String value) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-value pair to StringTemplate." + (Object)((Object)this.templateType));
        }
        this.addKey(key);
        this.addReplacement(StringTemplate.key(value));
        return this;
    }

    public StringTemplate add(String value) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a single string to StringTemplate." + (Object)((Object)this.templateType));
        }
        this.addReplacement(StringTemplate.key(value));
        return this;
    }

    public StringTemplate addName(String key, String value) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-name pair to StringTemplate." + (Object)((Object)this.templateType));
        }
        this.addKey(key);
        this.addReplacement(StringTemplate.name(value));
        return this;
    }

    public StringTemplate addName(String key, FreeColObject object) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-object pair to StringTemplate." + (Object)((Object)this.templateType));
        }
        this.addKey(key);
        this.addReplacement(StringTemplate.key(Messages.nameKey(object.getId())));
        return this;
    }

    public StringTemplate addName(String value) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a single string to StringTemplate." + (Object)((Object)this.templateType));
        }
        this.addReplacement(StringTemplate.name(value));
        return this;
    }

    public StringTemplate addNamed(String key, Named named) {
        return this.add(key, named.getNameKey());
    }

    public StringTemplate addNamed(Named named) {
        return this.add(named.getNameKey());
    }

    public StringTemplate addAmount(String key, Number amount) {
        return this.addName(key, amount.toString());
    }

    public StringTemplate addStringTemplate(String key, StringTemplate template) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new IllegalArgumentException("Cannot add key-template pair to StringTemplate." + (Object)((Object)this.templateType));
        }
        this.addKey(key);
        this.addReplacement(template);
        return this;
    }

    public StringTemplate addStringTemplate(StringTemplate template) {
        if (this.templateType != TemplateType.LABEL) {
            throw new IllegalArgumentException("Cannot add a template to StringTemplate." + (Object)((Object)this.templateType));
        }
        this.addReplacement(template);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StringTemplate) {
            StringTemplate t = (StringTemplate)o;
            if (!super.equals(o) || this.templateType != t.templateType || !Utils.equals(this.defaultId, t.defaultId)) {
                return false;
            }
            switch (this.templateType) {
                case TEMPLATE: {
                    int i;
                    if (this.keys == null != (t.keys == null)) {
                        return false;
                    }
                    if (this.keys != null) {
                        if (this.keys.size() != t.keys.size() || this.keys.size() != this.replacements.size()) {
                            return false;
                        }
                        for (i = 0; i < this.keys.size(); ++i) {
                            if (this.keys.get(i).equals(t.keys.get(i))) continue;
                            return false;
                        }
                    }
                }
                case LABEL: {
                    int i;
                    if (this.replacements == null != (t.replacements == null)) {
                        return false;
                    }
                    if (this.replacements == null) break;
                    if (this.replacements.size() != t.replacements.size()) {
                        return false;
                    }
                    for (i = 0; i < this.replacements.size(); ++i) {
                        if (this.replacements.get(i).equals(t.replacements.get(i))) continue;
                        return false;
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.templateType.ordinal();
        hash = 31 * hash + Utils.hashCode(this.defaultId);
        switch (this.templateType) {
            case TEMPLATE: {
                for (String key : this.getKeys()) {
                    hash = 31 * hash + Utils.hashCode(key);
                }
            }
            case LABEL: {
                for (StringTemplate replacement : this.getReplacements()) {
                    hash = 31 * hash + Utils.hashCode(replacement);
                }
                break;
            }
        }
        return hash;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TEMPLATE_TYPE_TAG, this.templateType);
        if (this.defaultId != null) {
            xw.writeAttribute(DEFAULT_ID_TAG, this.defaultId);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.keys != null) {
            for (String key : this.keys) {
                xw.writeStartElement(KEY_TAG);
                xw.writeAttribute("value", key);
                xw.writeEndElement();
            }
        }
        if (this.replacements != null) {
            for (StringTemplate replacement : this.replacements) {
                replacement.toXML(xw);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.templateType = xr.getAttribute(TEMPLATE_TYPE_TAG, TemplateType.class, TemplateType.TEMPLATE);
        this.defaultId = xr.getAttribute(DEFAULT_ID_TAG, null);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.keys != null) {
            this.keys.clear();
        }
        if (this.replacements != null) {
            this.replacements.clear();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (KEY_TAG.equals(tag)) {
            this.addKey(xr.getAttribute("value", null));
            xr.closeTag(KEY_TAG);
        } else if (StringTemplate.getXMLElementTagName().equals(tag)) {
            this.addReplacement(new StringTemplate(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append((Object)this.templateType).append(": ");
        switch (this.templateType) {
            case LABEL: {
                if (this.replacements == null) {
                    sb.append(this.getId());
                    break;
                }
                for (StringTemplate object : this.replacements) {
                    sb.append(object).append(this.getId());
                }
                break;
            }
            case TEMPLATE: {
                sb.append(this.getId());
                if (this.defaultId != null) {
                    sb.append(" (").append(this.defaultId).append(")");
                }
                sb.append(" [");
                if (this.keys != null) {
                    for (int index = 0; index < this.keys.size(); ++index) {
                        sb.append("[").append(this.keys.get(index)).append(": ").append(this.replacements.get(index)).append("]");
                    }
                }
                sb.append("]");
                break;
            }
            case KEY: {
                sb.append(this.getId());
                if (this.defaultId == null) break;
                sb.append(" (").append(this.defaultId).append(")");
                break;
            }
            default: {
                sb.append(this.getId());
            }
        }
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return StringTemplate.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "stringTemplate";
    }

    public static enum TemplateType {
        NAME,
        KEY,
        TEMPLATE,
        LABEL;

    }
}

