/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class AssignTradeRouteMessage
extends DOMMessage {
    private final String unitId;
    private final String tradeRouteId;

    public AssignTradeRouteMessage(Unit unit, TradeRoute tradeRoute) {
        super(AssignTradeRouteMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.tradeRouteId = tradeRoute == null ? null : tradeRoute.getId();
    }

    public AssignTradeRouteMessage(Game game, Element element) {
        super(AssignTradeRouteMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.tradeRouteId = element.hasAttribute("tradeRoute") ? element.getAttribute("tradeRoute") : null;
    }

    public Element handle(FreeColServer server, Connection connection) {
        TradeRoute tradeRoute;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = serverPlayer.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.tradeRouteId == null) {
            tradeRoute = null;
        } else {
            try {
                tradeRoute = serverPlayer.getOurFreeColGameObject(this.tradeRouteId, TradeRoute.class);
            }
            catch (Exception e) {
                return DOMMessage.clientError(e.getMessage());
            }
        }
        return server.getInGameController().assignTradeRoute(serverPlayer, unit, tradeRoute);
    }

    @Override
    public Element toXMLElement() {
        Element result = AssignTradeRouteMessage.createMessage(AssignTradeRouteMessage.getXMLElementTagName(), "unit", this.unitId);
        if (this.tradeRouteId != null) {
            result.setAttribute("tradeRoute", this.tradeRouteId);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "assignTradeRoute";
    }
}

