#ifndef R2_CONFIGURE_H
#define R2_CONFIGURE_H

#include "r_version.h"

#ifdef LIL_ENDIAN
#undef LIL_ENDIAN
#endif
#define LIL_ENDIAN 1
#define CPU_ENDIAN 0

#define DEBUGGER 1

#if __WIN32__ || __CYGWIN__ || MINGW32
#define R2_PREFIX "."
#define R2_LIBDIR "./lib"
#define R2_INCDIR "./include/libr"
#define R2_DATDIR "./share"
#else
#define R2_PREFIX "/usr"
#define R2_LIBDIR "/usr/lib"
#define R2_INCDIR "/usr/include/libr"
#define R2_DATDIR "/usr/share"
#endif

#define R2_VERSION "0.10.2"
#define HAVE_LIB_MAGIC 1
#define USE_LIB_MAGIC 0
#ifndef HAVE_LIB_SSL
#define HAVE_LIB_SSL 1
#endif
#ifndef HAVE_LIB_EWF
#define HAVE_LIB_EWF @HAVE_LIB_EWF@
#endif

#define HAVE_FORK 1

#define WITH_GPL 1

#define R2_WWWROOT R2_DATDIR "/radare2/" R2_VERSION "/www"

#endif
