/* libide-1.0.vapi generated by vapigen-0.32, do not modify. */

[CCode (cprefix = "Ide", gir_namespace = "Ide", gir_version = "1.0", lower_case_cprefix = "ide_")]
namespace Ide {
	[CCode (cheader_filename = "ide.h", type_id = "ide_application_get_type ()")]
	public class Application : Gtk.Application, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		public Application ();
		public unowned string get_keybindings_mode ();
		public unowned GLib.Menu get_menu_by_id (string id);
		public Ide.ApplicationMode get_mode ();
		public unowned Ide.RecentProjects get_recent_projects ();
		public unowned GLib.DateTime get_started_at ();
		public async GLib.DBusProxy get_worker_async (string plugin_name, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool open_project (GLib.File file);
		public void show_projects_window ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_back_forward_item_get_type ()")]
	public class BackForwardItem : Ide.Object {
		[CCode (has_construct_function = false)]
		public BackForwardItem (Ide.Context context, Ide.Uri uri);
		public bool chain (Ide.BackForwardItem other);
		public Ide.Uri get_uri ();
		public Ide.Uri uri { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_back_forward_list_get_type ()")]
	public class BackForwardList : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BackForwardList ();
		public Ide.BackForwardList branch ();
		public bool get_can_go_backward ();
		public bool get_can_go_forward ();
		public unowned Ide.BackForwardItem? get_current_item ();
		public void go_backward ();
		public void go_forward ();
		public void merge (Ide.BackForwardList branch);
		public void push (Ide.BackForwardItem item);
		public bool can_go_backward { get; }
		public bool can_go_forward { get; }
		public Ide.BackForwardItem current_item { get; }
		public signal void navigate_to (Ide.BackForwardItem object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_get_type ()")]
	public class Buffer : Gtk.SourceBuffer {
		[CCode (has_construct_function = false)]
		protected Buffer ();
		public void check_for_volume_change ();
		public bool get_busy ();
		public size_t get_change_count ();
		public bool get_changed_on_volume ();
		public GLib.Bytes get_content ();
		public unowned Ide.Context get_context ();
		public unowned Ide.Diagnostic? get_diagnostic_at_iter (Gtk.TextIter iter);
		public unowned Ide.File get_file ();
		public bool get_highlight_diagnostics ();
		public void get_iter_at_source_location (out Gtk.TextIter iter, Ide.SourceLocation location);
		public Ide.BufferLineFlags get_line_flags (uint line);
		public bool get_read_only ();
		public void get_selection_bounds (out Gtk.TextIter insert, out Gtk.TextIter selection);
		public unowned string get_style_scheme_name ();
		public async Ide.Symbol get_symbol_at_location_async (Gtk.TextIter location, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Ide.SymbolResolver? get_symbol_resolver ();
		public unowned string get_title ();
		public string get_word_at_iter (Gtk.TextIter iter);
		public void hold ();
		public void rehighlight ();
		public void release ();
		public void set_file (Ide.File file);
		public void set_highlight_diagnostics (bool highlight_diagnostics);
		public void set_style_scheme_name (string style_scheme_name);
		public void sync_to_unsaved_files ();
		public void trim_trailing_whitespace ();
		public bool busy { get; }
		public bool changed_on_volume { get; }
		public Ide.Context context { get; construct; }
		public Ide.File file { get; set; }
		[NoAccessorMethod]
		public bool has_diagnostics { get; }
		public bool highlight_diagnostics { get; set; }
		public bool read_only { get; }
		public string style_scheme_name { get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		public virtual signal void cursor_moved (Gtk.TextIter location);
		public signal void line_flags_changed ();
		public signal void loaded ();
		public signal void saved ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_change_monitor_get_type ()")]
	public class BufferChangeMonitor : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BufferChangeMonitor ();
		public void emit_changed ();
		public virtual Ide.BufferLineChange get_change (Gtk.TextIter iter);
		[NoWrapper]
		public virtual void set_buffer (Ide.Buffer buffer);
		public Ide.Buffer buffer { construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_manager_get_type ()")]
	public class BufferManager : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected BufferManager ();
		public Ide.Buffer create_temporary_buffer ();
		public unowned Ide.Buffer? find_buffer (GLib.File file);
		public GLib.GenericArray<weak Ide.Buffer> get_buffers ();
		public unowned Ide.Buffer get_focus_buffer ();
		public size_t get_max_file_size ();
		public uint get_n_buffers ();
		public unowned Gtk.SourceCompletionWords get_word_completion ();
		public bool has_file (GLib.File file);
		public async Ide.Buffer load_file_async (Ide.File file, bool force_reload, out Ide.Progress? progress, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_file_async (Ide.Buffer buffer, Ide.File file, Ide.Progress progress, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_focus_buffer (Ide.Buffer buffer);
		public void set_max_file_size (size_t max_file_size);
		[NoAccessorMethod]
		public bool auto_save { get; set; }
		[NoAccessorMethod]
		public uint auto_save_timeout { get; set; }
		public Ide.Buffer focus_buffer { get; set; }
		public signal void buffer_focus_enter (Ide.Buffer buffer);
		public signal void buffer_focus_leave (Ide.Buffer buffer);
		public signal void buffer_loaded (Ide.Buffer buffer);
		public signal void buffer_saved (Ide.Buffer buffer);
		public signal Ide.Buffer? create_buffer (Ide.File file);
		public signal void load_buffer (Ide.Buffer buffer, bool reloading);
		public signal void save_buffer (Ide.Buffer buffer);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_build_result_get_type ()")]
	public class BuildResult : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BuildResult ();
		public void emit_diagnostic (Ide.Diagnostic diagnostic);
		public string get_mode ();
		public bool get_running ();
		public GLib.TimeSpan get_running_time ();
		public unowned GLib.InputStream get_stderr_stream ();
		public unowned GLib.InputStream? get_stdout_stream ();
		public void log_subprocess (GLib.Subprocess subprocess);
		public void set_mode (string mode);
		public void set_running (bool running);
		public string mode { owned get; set; }
		public bool running { get; set; }
		public virtual signal void diagnostic (Ide.Diagnostic diagnostic);
		public virtual signal void log (Ide.BuildResultLog log, string message);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_builder_get_type ()")]
	public abstract class Builder : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Builder ();
		public virtual async Ide.BuildResult build_async (Ide.BuilderBuildFlags flags, out unowned Ide.BuildResult result, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Ide.Configuration get_configuration ();
		public Ide.Configuration configuration { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_item_get_type ()")]
	public abstract class CompletionItem : GLib.Object {
		[CCode (has_construct_function = false)]
		public CompletionItem ();
		public static string fuzzy_highlight (string haystack, string casefold_query);
		public static bool fuzzy_match (string haystack, string casefold_needle, out uint priority);
		public virtual bool match (string query, string casefold);
		public void set_priority (uint priority);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_results_get_type ()")]
	public class CompletionResults : GLib.Object {
		[CCode (has_construct_function = false)]
		public CompletionResults (string query);
		[NoWrapper]
		public virtual int compare (Ide.CompletionItem left, Ide.CompletionItem right);
		public unowned string get_query ();
		public void invalidate_sort ();
		public void present (Gtk.SourceCompletionProvider provider, Gtk.SourceCompletionContext context);
		public bool replay (string query);
		public void take_proposal (owned Ide.CompletionItem proposal);
		public string query { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_configuration_get_type ()")]
	public class Configuration : Ide.Object {
		[CCode (has_construct_function = false)]
		public Configuration (Ide.Context context, string id, string device_id, string runtime_id);
		public Ide.Configuration duplicate ();
		public unowned string get_config_opts ();
		public bool get_debug ();
		public unowned Ide.Device? get_device ();
		public unowned string get_device_id ();
		public bool get_dirty ();
		public unowned string get_display_name ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_environ ();
		public unowned Ide.Environment get_environment ();
		public unowned string get_id ();
		public int get_parallelism ();
		public unowned string get_prefix ();
		public unowned Ide.Runtime? get_runtime ();
		public unowned string get_runtime_id ();
		public uint get_sequence ();
		public unowned string getenv (string key);
		public void set_config_opts (string config_opts);
		public void set_debug (bool debug);
		public void set_device (Ide.Device device);
		public void set_device_id (string device_id);
		public void set_dirty (bool dirty);
		public void set_display_name (string display_name);
		public void set_parallelism (int parallelism);
		public void set_prefix (string prefix);
		public void set_runtime (Ide.Runtime runtime);
		public void set_runtime_id (string runtime_id);
		public void setenv (string key, string value);
		public string config_opts { get; set; }
		public bool debug { get; set; }
		public Ide.Device device { get; set; }
		public string device_id { get; set; }
		public bool dirty { get; set; }
		public string display_name { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] environ { owned get; }
		public string id { get; construct; }
		public int parallelism { get; set; }
		public string prefix { get; set; }
		public Ide.Runtime runtime { get; set; }
		public string runtime_id { get; set; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_configuration_manager_get_type ()")]
	public class ConfigurationManager : Ide.Object, GLib.AsyncInitable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected ConfigurationManager ();
		public void add (Ide.Configuration configuration);
		public unowned Ide.Configuration? get_configuration (string id);
		public unowned Ide.Configuration get_current ();
		public void remove (Ide.Configuration configuration);
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_current (Ide.Configuration configuration);
		public Ide.Configuration current { get; set; }
		[NoAccessorMethod]
		public string current_display_name { owned get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_context_get_type ()")]
	public class Context : GLib.Object, GLib.AsyncInitable {
		[CCode (cname = "ide_context_new_async", has_construct_function = false)]
		public async Context (GLib.File project_file, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Ide.BackForwardList get_back_forward_list ();
		public unowned Ide.BufferManager get_buffer_manager ();
		public unowned Ide.BuildSystem get_build_system ();
		public unowned Ide.ConfigurationManager get_configuration_manager ();
		public unowned Ide.DeviceManager get_device_manager ();
		public unowned Ide.Project get_project ();
		public unowned GLib.File get_project_file ();
		public unowned Gtk.RecentManager get_recent_manager ();
		public unowned string get_root_build_dir ();
		public unowned Ide.RuntimeManager get_runtime_manager ();
		public unowned Ide.ScriptManager get_script_manager ();
		public unowned Ide.SearchEngine get_search_engine ();
		public void* get_service_typed (GLib.Type service_type);
		public Ide.Settings get_settings (string schema_id, string relative_path);
		public unowned Ide.SourceSnippetsManager get_snippets_manager ();
		public unowned Ide.UnsavedFiles get_unsaved_files ();
		public unowned Ide.Vcs get_vcs ();
		public void hold ();
		public void hold_for_object (GLib.Object instance);
		public void release ();
		public async bool restore_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_root_build_dir (string root_build_dir);
		public async bool unload_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public Ide.BackForwardList back_forward_list { get; }
		public Ide.BufferManager buffer_manager { get; }
		public Ide.BuildSystem build_system { get; }
		public Ide.ConfigurationManager configuration_manager { get; }
		public Ide.DeviceManager device_manager { get; }
		public Ide.Project project { get; }
		public GLib.File project_file { get; construct; }
		public string root_build_dir { get; set; }
		public Ide.RuntimeManager runtime_manager { get; }
		public Ide.ScriptManager script_manager { get; }
		public Ide.SearchEngine search_engine { get; }
		[NoAccessorMethod]
		public Ide.SourceSnippetsManager snippets_manager { owned get; set; }
		public Ide.UnsavedFiles unsaved_files { get; }
		public Ide.Vcs vcs { get; }
		public signal void loaded ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_deployer_get_type ()")]
	public abstract class Deployer : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Deployer ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_device_get_type ()")]
	public abstract class Device : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Device ();
		public unowned string? get_display_name ();
		public unowned string get_id ();
		public virtual unowned string get_system_type ();
		public virtual void prepare_configuration (Ide.Configuration configuration);
		public void set_display_name (string display_name);
		public void set_id (string id);
		public string display_name { get; set; }
		public string id { get; set; }
		public string system_type { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_device_manager_get_type ()")]
	public class DeviceManager : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected DeviceManager ();
		public void add_provider (Ide.DeviceProvider provider);
		public unowned Ide.Device get_device (string device_id);
		public GLib.GenericArray<weak Ide.Device> get_devices ();
		public bool get_settled ();
		public void remove_provider (Ide.DeviceProvider provider);
		public bool settled { get; }
		public signal void device_added (Ide.DeviceProvider object, Ide.Device p0);
		public signal void device_removed (Ide.DeviceProvider object, Ide.Device p0);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_diagnostic_ref", type_id = "ide_diagnostic_get_type ()", unref_function = "ide_diagnostic_unref")]
	[Compact]
	public class Diagnostic {
		[CCode (has_construct_function = false)]
		public Diagnostic (Ide.DiagnosticSeverity severity, string text, Ide.SourceLocation location);
		public void add_range (Ide.SourceRange range);
		public unowned Ide.Fixit get_fixit (uint index);
		public unowned Ide.SourceLocation get_location ();
		public uint get_num_fixits ();
		public uint get_num_ranges ();
		public unowned Ide.SourceRange? get_range (uint index);
		public Ide.DiagnosticSeverity get_severity ();
		public unowned string get_text ();
		public string get_text_for_display ();
		public Ide.Diagnostic @ref ();
		public void take_fixit (owned Ide.Fixit fixit);
		public void take_range (owned Ide.SourceRange range);
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_diagnostician_get_type ()")]
	public class Diagnostician : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Diagnostician ();
		public async Ide.Diagnostics diagnose_async (Ide.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Gtk.SourceLanguage get_language ();
		public void set_language (Gtk.SourceLanguage language);
		public Gtk.SourceLanguage language { get; set; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_diagnostics_ref", type_id = "ide_diagnostics_get_type ()", unref_function = "ide_diagnostics_unref")]
	[Compact]
	public class Diagnostics {
		[CCode (has_construct_function = false)]
		public Diagnostics (owned GLib.GenericArray<Ide.Diagnostic>? ar);
		public size_t get_size ();
		public unowned Ide.Diagnostic index (size_t index);
		public void merge (Ide.Diagnostics other);
		public Ide.Diagnostics @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_directory_build_system_get_type ()")]
	public class DirectoryBuildSystem : Ide.Object, GLib.AsyncInitable, Ide.BuildSystem {
		[CCode (has_construct_function = false)]
		protected DirectoryBuildSystem ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_directory_genesis_addin_get_type ()")]
	public class DirectoryGenesisAddin : GLib.Object, Ide.GenesisAddin {
		[CCode (has_construct_function = false)]
		protected DirectoryGenesisAddin ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_directory_vcs_get_type ()")]
	public class DirectoryVcs : Ide.Object, GLib.AsyncInitable, Ide.Vcs {
		[CCode (has_construct_function = false)]
		protected DirectoryVcs ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_doap_get_type ()")]
	public class Doap : GLib.Object {
		[CCode (has_construct_function = false)]
		public Doap ();
		public unowned string get_bug_database ();
		public unowned string get_category ();
		public unowned string get_description ();
		public unowned string get_download_page ();
		public unowned string get_homepage ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_languages ();
		public unowned GLib.List<Ide.DoapPerson> get_maintainers ();
		public unowned string get_name ();
		public unowned string get_shortdesc ();
		public bool load_from_data (string data, size_t length) throws GLib.Error;
		public bool load_from_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public string bug_database { owned get; set; }
		[NoAccessorMethod]
		public string category { owned get; set; }
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public string download_page { owned get; set; }
		[NoAccessorMethod]
		public string homepage { owned get; set; }
		[NoAccessorMethod]
		public string languages { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string shortdesc { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_doap_person_get_type ()")]
	public class DoapPerson : GLib.Object {
		[CCode (has_construct_function = false)]
		public DoapPerson ();
		public unowned string get_email ();
		public unowned string get_name ();
		public void set_email (string email);
		public void set_name (string name);
		public string email { get; set; }
		public string name { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_editor_perspective_get_type ()")]
	public class EditorPerspective : Ide.Layout, Atk.Implementor, Gtk.Buildable, Ide.Perspective, Pnl.Dock, Pnl.DockItem {
		[CCode (has_construct_function = false)]
		protected EditorPerspective ();
		public void focus_buffer_in_current_stack (Ide.Buffer buffer);
		public void focus_location (Ide.SourceLocation location);
		public signal void view_added (Gtk.Widget object);
		public signal void view_removed (Gtk.Widget object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_editor_view_get_type ()")]
	public class EditorView : Ide.LayoutView, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected EditorView ();
		public unowned Ide.SourceView get_active_source_view ();
		public unowned Ide.Buffer get_document ();
		public Ide.Buffer document { get; construct; }
		public signal void request_documentation (string object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_environment_get_type ()")]
	public class Environment : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public Environment ();
		public void append (Ide.EnvironmentVariable variable);
		public Ide.Environment copy ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_environ ();
		public unowned string getenv (string key);
		public void remove (Ide.EnvironmentVariable variable);
		public void setenv (string key, string value);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_environment_editor_get_type ()")]
	public class EnvironmentEditor : Gtk.ListBox, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public EnvironmentEditor ();
		public unowned Ide.Environment? get_environment ();
		public void set_environment (Ide.Environment environment);
		public Ide.Environment environment { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_environment_editor_row_get_type ()")]
	public class EnvironmentEditorRow : Gtk.ListBoxRow, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected EnvironmentEditorRow ();
		public unowned Ide.EnvironmentVariable? get_variable ();
		public void set_variable (Ide.EnvironmentVariable variable);
		public void start_editing ();
		public Ide.EnvironmentVariable variable { get; set; }
		public signal void @delete ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_environment_variable_get_type ()")]
	public class EnvironmentVariable : GLib.Object {
		[CCode (has_construct_function = false)]
		public EnvironmentVariable (string key, string value);
		public unowned string get_key ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public string key { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_extension_adapter_get_type ()")]
	public class ExtensionAdapter : Ide.Object {
		[CCode (has_construct_function = false)]
		public ExtensionAdapter (Ide.Context context, Peas.Engine? engine, GLib.Type interface_type, string key, string? value);
		public unowned Peas.Engine get_engine ();
		public unowned GLib.Object get_extension ();
		public GLib.Type get_interface_type ();
		public unowned string get_key ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public Peas.Engine engine { get; construct; }
		public GLib.Object extension { get; }
		public GLib.Type interface_type { get; construct; }
		public string key { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_extension_set_adapter_get_type ()")]
	public class ExtensionSetAdapter : Ide.Object {
		[CCode (has_construct_function = false)]
		public ExtensionSetAdapter (Ide.Context context, Peas.Engine engine, GLib.Type interface_type, string key, string value);
		public void @foreach (Ide.ExtensionSetAdapterForeachFunc foreach_func);
		public unowned Peas.Engine get_engine ();
		public GLib.Type get_interface_type ();
		public unowned string get_key ();
		public uint get_n_extensions ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public Peas.Engine engine { get; construct; }
		public GLib.Type interface_type { get; construct; }
		public string key { get; set; }
		public string value { get; set; }
		public signal void extension_added (Peas.PluginInfo object, GLib.Object p0);
		public signal void extension_removed (Peas.PluginInfo object, GLib.Object p0);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_file_get_type ()")]
	public class File : Ide.Object {
		[CCode (has_construct_function = false)]
		public File (Ide.Context? context, GLib.File file);
		public bool equal (Ide.File other);
		public async Ide.File? find_other_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public File.for_path (Ide.Context context, string path);
		public unowned GLib.File get_file ();
		public bool get_is_temporary ();
		public unowned Gtk.SourceLanguage? get_language ();
		public unowned string get_path ();
		public uint get_temporary_id ();
		public uint hash ();
		public async Ide.FileSettings load_settings_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public static bool manager_show (GLib.File file) throws GLib.Error;
		public GLib.File file { get; construct; }
		public bool is_temporary { get; }
		public Gtk.SourceLanguage language { get; }
		public string path { get; construct; }
		public uint temporary_id { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_file_settings_get_type ()")]
	public class FileSettings : Ide.Object {
		[CCode (has_construct_function = false)]
		public FileSettings (Ide.File file);
		public unowned Ide.File get_file ();
		public bool get_settled ();
		[NoAccessorMethod]
		public string encoding { owned get; set; }
		[NoAccessorMethod]
		public bool encoding_set { get; set; }
		public Ide.File file { get; construct; }
		[NoAccessorMethod]
		public Ide.IndentStyle indent_style { get; set; }
		[NoAccessorMethod]
		public bool indent_style_set { get; set; }
		[NoAccessorMethod]
		public int indent_width { get; set; }
		[NoAccessorMethod]
		public bool indent_width_set { get; set; }
		[NoAccessorMethod]
		public bool insert_trailing_newline { get; set; }
		[NoAccessorMethod]
		public bool insert_trailing_newline_set { get; set; }
		[NoAccessorMethod]
		public Gtk.SourceNewlineType newline_type { get; set; }
		[NoAccessorMethod]
		public bool newline_type_set { get; set; }
		[NoAccessorMethod]
		public bool overwrite_braces { get; set; }
		[NoAccessorMethod]
		public bool overwrite_braces_set { get; set; }
		[NoAccessorMethod]
		public uint right_margin_position { get; set; }
		[NoAccessorMethod]
		public bool right_margin_position_set { get; set; }
		[NoAccessorMethod]
		public bool settled { get; set; }
		[NoAccessorMethod]
		public bool show_right_margin { get; set; }
		[NoAccessorMethod]
		public bool show_right_margin_set { get; set; }
		[NoAccessorMethod]
		public uint tab_width { get; set; }
		[NoAccessorMethod]
		public bool tab_width_set { get; set; }
		[NoAccessorMethod]
		public bool trim_trailing_whitespace { get; set; }
		[NoAccessorMethod]
		public bool trim_trailing_whitespace_set { get; set; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_fixit_ref", type_id = "ide_fixit_get_type ()", unref_function = "ide_fixit_unref")]
	[Compact]
	public class Fixit {
		public void apply ();
		public unowned Ide.SourceRange get_range ();
		public unowned string get_text ();
		public Ide.Fixit @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_genesis_perspective_get_type ()")]
	public class GenesisPerspective : Gtk.Bin, Atk.Implementor, Gtk.Buildable, Ide.Perspective {
		[CCode (has_construct_function = false)]
		protected GenesisPerspective ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_highlight_engine_get_type ()")]
	public class HighlightEngine : Ide.Object {
		[CCode (has_construct_function = false)]
		public HighlightEngine (Ide.Buffer buffer);
		public void clear ();
		public unowned Ide.Buffer get_buffer ();
		public unowned Ide.Highlighter get_highlighter ();
		public unowned Gtk.TextTag get_style (string style_name);
		public void invalidate (Gtk.TextIter begin, Gtk.TextIter end);
		public void rebuild ();
		public Ide.Buffer buffer { get; construct; }
		public Ide.Highlighter highlighter { get; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_highlight_index_ref", type_id = "ide_highlight_index_get_type ()", unref_function = "ide_highlight_index_unref")]
	[Compact]
	public class HighlightIndex {
		[CCode (has_construct_function = false)]
		public HighlightIndex ();
		public void dump ();
		public void insert (string word, void* tag);
		public void* lookup (string word);
		public Ide.HighlightIndex @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h")]
	[Compact]
	public class Language {
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_get_type ()")]
	public class Layout : Pnl.DockBin, Atk.Implementor, Gtk.Buildable, Pnl.Dock, Pnl.DockItem {
		[CCode (has_construct_function = false)]
		protected Layout ();
		public unowned Gtk.Widget? get_active_view ();
		public Gtk.Widget active_view { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_grid_get_type ()")]
	public class LayoutGrid : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public LayoutGrid ();
		public unowned Ide.LayoutStack add_stack_after (Ide.LayoutStack stack);
		public unowned Ide.LayoutStack add_stack_before (Ide.LayoutStack stack);
		public void foreach_view (Gtk.Callback callback);
		public unowned Gtk.Widget? get_last_focus ();
		public unowned Ide.LayoutStack? get_stack_after (Ide.LayoutStack stack);
		public unowned Ide.LayoutStack? get_stack_before (Ide.LayoutStack stack);
		public GLib.List<weak Ide.LayoutStack> get_stacks ();
		public signal void empty ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_pane_get_type ()")]
	public class LayoutPane : Pnl.DockBinEdge, Atk.Implementor, Gtk.Buildable, Pnl.DockItem {
		[CCode (has_construct_function = false)]
		protected LayoutPane ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_stack_get_type ()")]
	public class LayoutStack : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public LayoutStack ();
		public void foreach_view (Gtk.Callback callback);
		public unowned Gtk.Widget? get_active_view ();
		public void remove (Gtk.Widget view);
		public void set_active_view (Gtk.Widget active_view);
		public Ide.LayoutView active_view { get; set; }
		public signal void empty ();
		public signal void split (Ide.LayoutView view, int split_type);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_view_get_type ()")]
	public class LayoutView : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected LayoutView ();
		public virtual Ide.LayoutView create_split ();
		public virtual bool get_can_preview ();
		public virtual bool get_can_split ();
		public unowned Gtk.Widget? get_controls ();
		public virtual bool get_modified ();
		public virtual unowned string get_special_title ();
		public virtual unowned string get_title ();
		public virtual void navigate_to (Ide.SourceLocation location);
		public virtual void set_back_forward_list (Ide.BackForwardList back_forward_list);
		public virtual void set_split_view (bool split_view);
		public bool can_split { get; }
		public bool modified { get; }
		public string special_title { get; }
		public string title { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_local_device_get_type ()")]
	public class LocalDevice : Ide.Device {
		[CCode (has_construct_function = false)]
		protected LocalDevice ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_object_get_type ()")]
	public class Object : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Object ();
		[CCode (has_construct_function = false)]
		public Object.finish (GLib.AsyncResult result) throws GLib.Error;
		public unowned Ide.Context get_context ();
		public bool hold ();
		public static void notify_in_main (void* instance, GLib.ParamSpec pspec);
		public void release ();
		public virtual void set_context (Ide.Context context);
		public Ide.Context context { get; construct; }
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_omni_search_display_get_type ()")]
	public class OmniSearchDisplay : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected OmniSearchDisplay ();
		public unowned Ide.SearchContext get_context ();
		public uint64 get_count ();
		public void move_next_result ();
		public void move_previous_result ();
		public void set_context (Ide.SearchContext context);
		public Ide.SearchContext context { get; set; }
		public signal void activate ();
		public signal void result_activated (Ide.SearchResult object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_omni_search_entry_get_type ()")]
	public class OmniSearchEntry : Gtk.Entry, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.Editable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public OmniSearchEntry ();
		public unowned Ide.SearchEngine get_search_engine ();
		public void set_search_engine (Ide.SearchEngine search_engine);
		public signal void clear_search ();
		public signal void move_next_result ();
		public signal void move_previous_result ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_omni_search_group_get_type ()")]
	public class OmniSearchGroup : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected OmniSearchGroup ();
		public bool activate ();
		public void add_result (Ide.SearchResult result);
		public void clear ();
		public uint64 get_count ();
		public unowned Ide.SearchResult? get_first ();
		public unowned Ide.SearchProvider get_provider ();
		public bool has_selection ();
		public bool move_next ();
		public bool move_previous ();
		public void remove_result (Ide.SearchResult result);
		public void select_first ();
		public void select_last ();
		public void unselect ();
		public Ide.SearchProvider provider { get; construct; }
		public signal void result_activated (Gtk.Widget object, Ide.SearchResult p0);
		public signal void result_selected (Ide.SearchResult object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_omni_search_row_get_type ()")]
	public class OmniSearchRow : Gtk.ListBoxRow, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected OmniSearchRow ();
		public unowned Ide.SearchResult get_result ();
		public void set_result (Ide.SearchResult result);
		[NoAccessorMethod]
		public string icon_name { set; }
		public Ide.SearchResult result { get; set; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_pattern_spec_ref", type_id = "ide_pattern_spec_get_type ()", unref_function = "ide_pattern_spec_unref")]
	[Compact]
	public class PatternSpec {
		[CCode (has_construct_function = false)]
		public PatternSpec (string keywords);
		public unowned string get_text ();
		public bool match (string haystack);
		public Ide.PatternSpec @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_bin_get_type ()")]
	public class PreferencesBin : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesBin ();
		[NoWrapper]
		public virtual void connect (GLib.Settings settings);
		[NoWrapper]
		public virtual void disconnect (GLib.Settings settings);
		[NoWrapper]
		public virtual bool matches (Ide.PatternSpec spec);
		[NoAccessorMethod]
		public string keywords { owned get; construct; }
		[NoAccessorMethod]
		public string path { owned get; construct; }
		[NoAccessorMethod]
		public int priority { get; construct; }
		[NoAccessorMethod]
		public string schema_id { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_entry_get_type ()")]
	public class PreferencesEntry : Ide.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesEntry ();
		public unowned Gtk.Widget get_title_widget ();
		[NoAccessorMethod]
		public string text { owned get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		public signal void activate ();
		public signal void changed (string object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_file_chooser_button_get_type ()")]
	public class PreferencesFileChooserButton : Ide.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesFileChooserButton ();
		[NoAccessorMethod]
		public Gtk.FileChooserAction action { get; construct; }
		[NoAccessorMethod]
		public string key { owned get; construct; }
		[NoAccessorMethod]
		public string subtitle { owned get; construct; }
		[NoAccessorMethod]
		public string title { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_flow_box_get_type ()")]
	public class PreferencesFlowBox : Egg.ColumnLayout, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PreferencesFlowBox ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_font_button_get_type ()")]
	public class PreferencesFontButton : Ide.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesFontButton ();
		[NoAccessorMethod]
		public string key { owned get; construct; }
		[NoAccessorMethod]
		public string title { owned get; construct; }
		public signal void activate ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_group_get_type ()")]
	public class PreferencesGroup : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesGroup ();
		public void add (Gtk.Widget widget);
		public int get_priority ();
		public unowned string get_title ();
		[NoAccessorMethod]
		public bool is_list { get; construct; }
		public int priority { get; construct; }
		public string title { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_page_get_type ()")]
	public class PreferencesPage : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesPage ();
		public void add_group (Ide.PreferencesGroup group);
		public unowned Ide.PreferencesGroup? get_group (string group_name);
		[NoAccessorMethod]
		public int priority { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_spin_button_get_type ()")]
	public class PreferencesSpinButton : Ide.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesSpinButton ();
		[NoAccessorMethod]
		public string key { owned get; construct; }
		[NoAccessorMethod]
		public string subtitle { owned get; construct; }
		[NoAccessorMethod]
		public string title { owned get; construct; }
		public signal void activate ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_switch_get_type ()")]
	public class PreferencesSwitch : Ide.PreferencesBin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesSwitch ();
		[NoAccessorMethod]
		public bool is_radio { get; construct; }
		[NoAccessorMethod]
		public string key { owned get; construct; }
		[NoAccessorMethod]
		public string subtitle { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant target { owned get; construct; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		public signal void activated ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_progress_get_type ()")]
	public class Progress : GLib.Object {
		[CCode (has_construct_function = false)]
		public Progress ();
		public static void file_progress_callback (int64 current_num_bytes, int64 total_num_bytes, void* user_data);
		public double get_fraction ();
		public unowned string get_message ();
		public void set_fraction (double fraction);
		public void set_message (string message);
		[NoAccessorMethod]
		public bool completed { get; }
		public double fraction { get; set; }
		public string message { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_get_type ()")]
	public class Project : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Project ();
		public void add_file (Ide.ProjectFile file);
		public Ide.File? get_file_for_path (string path);
		public unowned Ide.ProjectFiles? get_files ();
		public unowned string get_id ();
		public unowned string get_name ();
		public Ide.File get_project_file (GLib.File gfile);
		public unowned Ide.ProjectItem get_root ();
		public void reader_lock ();
		public void reader_unlock ();
		public async bool rename_file_async (GLib.File orig_file, GLib.File new_file, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool trash_file_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public void writer_lock ();
		public void writer_unlock ();
		public string id { get; }
		public string name { get; }
		public Ide.ProjectItem root { get; construct; }
		public signal void file_renamed (GLib.File object, GLib.File p0);
		public signal void file_trashed (GLib.File object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_file_get_type ()")]
	public class ProjectFile : Ide.ProjectItem {
		[CCode (has_construct_function = false)]
		protected ProjectFile ();
		public unowned GLib.File get_file ();
		public unowned GLib.FileInfo get_file_info ();
		public bool get_is_directory ();
		public unowned string get_name ();
		public unowned string get_path ();
		[NoAccessorMethod]
		public GLib.File file { owned get; set; }
		[NoAccessorMethod]
		public GLib.FileInfo file_info { owned get; set; }
		public bool is_directory { get; }
		public string name { get; }
		[NoAccessorMethod]
		public string path { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_files_get_type ()")]
	public class ProjectFiles : Ide.ProjectItem {
		[CCode (has_construct_function = false)]
		protected ProjectFiles ();
		public void add_file (Ide.ProjectFile file);
		public unowned Ide.ProjectItem? find_file (GLib.File file);
		public Ide.File? get_file_for_path (string path);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_info_get_type ()")]
	public class ProjectInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ProjectInfo ();
		public int compare (Ide.ProjectInfo info2);
		public unowned string get_description ();
		public unowned GLib.File? get_directory ();
		public unowned Ide.Doap? get_doap ();
		public unowned GLib.File? get_file ();
		public bool get_is_recent ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_languages ();
		public unowned GLib.DateTime? get_last_modified_at ();
		public unowned string get_name ();
		public int get_priority ();
		public void set_description (string description);
		public void set_directory (GLib.File directory);
		public void set_file (GLib.File file);
		public void set_is_recent (bool is_recent);
		public void set_languages (string languages);
		public void set_name (string name);
		public void set_priority (int priority);
		public string description { get; set; }
		public GLib.File directory { get; set; }
		[NoAccessorMethod]
		public Ide.Doap doap { owned get; set; }
		public GLib.File file { get; set; }
		public bool is_recent { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] languages { get; set; }
		[NoAccessorMethod]
		public GLib.DateTime last_modified_at { owned get; set; }
		public string name { get; set; }
		public int priority { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_item_get_type ()")]
	public class ProjectItem : Ide.Object {
		[CCode (has_construct_function = false)]
		protected ProjectItem ();
		public void append (Ide.ProjectItem child);
		public unowned GLib.Sequence get_children ();
		public unowned Ide.ProjectItem? get_parent ();
		public void remove (Ide.ProjectItem child);
		[NoAccessorMethod]
		public Ide.ProjectItem parent { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_recent_projects_get_type ()")]
	public class RecentProjects : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public RecentProjects ();
		public async bool discover_async (bool recent_only, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_busy ();
		public GLib.GenericArray<weak Ide.ProjectInfo> get_projects ();
		public void remove (GLib.List<Ide.ProjectInfo> project_infos);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_refactory_get_type ()")]
	public abstract class Refactory : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Refactory ();
	}
	[CCode (cheader_filename = "ide.h")]
	[Compact]
	public class RefactoryInterface {
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_runtime_get_type ()")]
	public class Runtime : Ide.Object {
		[CCode (has_construct_function = false)]
		public Runtime (Ide.Context context, string id, string title);
		public virtual bool contains_program_in_path (string program, GLib.Cancellable? cancellable = null);
		public virtual Ide.SubprocessLauncher create_launcher () throws GLib.Error;
		public unowned string get_display_name ();
		public unowned string get_id ();
		public virtual async bool postbuild_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool prebuild_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void prepare_configuration (Ide.Configuration configuration);
		public void set_display_name (string display_name);
		public void set_id (string id);
		public string display_name { get; set construct; }
		public string id { get; set construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_runtime_manager_get_type ()")]
	public class RuntimeManager : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected RuntimeManager ();
		public void add (Ide.Runtime runtime);
		public unowned Ide.Runtime get_runtime (string id);
		public void remove (Ide.Runtime runtime);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_script_get_type ()")]
	public abstract class Script : Ide.Object, GLib.AsyncInitable {
		[CCode (has_construct_function = false)]
		protected Script ();
		public unowned GLib.File get_file ();
		public GLib.File file { get; construct; }
		[HasEmitter]
		public virtual signal void load ();
		[HasEmitter]
		public virtual signal void unload ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_script_manager_get_type ()")]
	public class ScriptManager : Ide.Object {
		[CCode (has_construct_function = false)]
		protected ScriptManager ();
		public unowned string get_scripts_directory ();
		public async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public string scripts_directory { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_context_get_type ()")]
	public class SearchContext : Ide.Object {
		[CCode (has_construct_function = false)]
		protected SearchContext ();
		public void add_result (Ide.SearchProvider provider, Ide.SearchResult result);
		public void cancel ();
		public void execute (string search_terms, size_t max_results);
		public size_t get_max_results ();
		public unowned GLib.List<Ide.SearchProvider> get_providers ();
		public void provider_completed (Ide.SearchProvider provider);
		public void remove_result (Ide.SearchProvider provider, Ide.SearchResult result);
		public void set_provider_count (Ide.SearchProvider provider, uint64 count);
		public signal void completed ();
		public signal void count_set (Ide.SearchProvider object, uint64 p0);
		public signal void result_added (Ide.SearchProvider object, Ide.SearchResult p0);
		public signal void result_removed (Ide.SearchProvider object, Ide.SearchResult p0);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_engine_get_type ()")]
	public class SearchEngine : Ide.Object {
		[CCode (has_construct_function = false)]
		protected SearchEngine ();
		public Ide.SearchContext? search (string search_terms);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_result_get_type ()")]
	public class SearchResult : Ide.Object {
		[CCode (has_construct_function = false)]
		public SearchResult (Ide.SearchProvider provider, string title, string subtitle, float score);
		public virtual void activate ();
		public int compare (Ide.SearchResult b);
		public unowned Ide.SearchProvider get_provider ();
		public float get_score ();
		public unowned string get_subtitle ();
		public unowned string get_title ();
		[NoAccessorMethod]
		public Ide.SearchProvider provider { owned get; set; }
		public float score { get; construct; }
		public string subtitle { get; construct; }
		public string title { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_settings_get_type ()")]
	public class Settings : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Settings ();
		public void bind (string key, void* object, string property, GLib.SettingsBindFlags flags);
		public void bind_with_mapping (string key, void* object, string property, GLib.SettingsBindFlags flags, GLib.SettingsBindGetMapping? get_mapping, owned GLib.SettingsBindSetMapping? set_mapping);
		public bool get_boolean (string key);
		public GLib.Variant get_default_value (string key);
		public double get_double (string key);
		public bool get_ignore_project_settings ();
		public int get_int (string key);
		public unowned string get_relative_path ();
		public unowned string get_schema_id ();
		public string get_string (string key);
		public uint get_uint (string key);
		public GLib.Variant get_user_value (string key);
		public GLib.Variant get_value (string key);
		public void set_boolean (string key, bool val);
		public void set_double (string key, double val);
		public void set_int (string key, int val);
		public void set_string (string key, string val);
		public void set_uint (string key, uint val);
		public void set_value (string key, GLib.Variant value);
		public void unbind (string property);
		public bool ignore_project_settings { get; construct; }
		public string relative_path { get; construct; }
		public string schema_id { get; construct; }
		public signal void changed (string object);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_source_location_ref", type_id = "ide_source_location_get_type ()", unref_function = "ide_source_location_unref")]
	[Compact]
	public class SourceLocation {
		[CCode (has_construct_function = false)]
		public SourceLocation (Ide.File file, uint line, uint line_offset, uint offset);
		public unowned Ide.File get_file ();
		public uint get_line ();
		public uint get_line_offset ();
		public uint get_offset ();
		public Ide.Uri get_uri ();
		public Ide.SourceLocation @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_map_get_type ()")]
	public class SourceMap : Gtk.SourceMap, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected SourceMap ();
		public signal void hide_map ();
		public signal void show_map ();
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_source_range_ref", type_id = "ide_source_range_get_type ()", unref_function = "ide_source_range_unref")]
	[Compact]
	public class SourceRange {
		[CCode (has_construct_function = false)]
		public SourceRange (Ide.SourceLocation begin, Ide.SourceLocation end);
		public unowned Ide.SourceLocation get_begin ();
		public unowned Ide.SourceLocation get_end ();
		public Ide.SourceRange @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippet_get_type ()")]
	public class SourceSnippet : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceSnippet (string trigger, string language);
		public void add_chunk (Ide.SourceSnippetChunk chunk);
		public Ide.SourceSnippet copy ();
		public void get_chunk_range (Ide.SourceSnippetChunk chunk, Gtk.TextIter begin, Gtk.TextIter end);
		public unowned Ide.SourceSnippetContext get_context ();
		public unowned string get_description ();
		public unowned string get_language ();
		public unowned Gtk.TextMark get_mark_begin ();
		public unowned Gtk.TextMark get_mark_end ();
		public uint get_n_chunks ();
		public unowned Ide.SourceSnippetChunk get_nth_chunk (uint n);
		public unowned string get_snippet_text ();
		public int get_tab_stop ();
		public unowned string get_trigger ();
		public void set_description (string description);
		public void set_language (string language);
		public void set_snippet_text (string snippet_text);
		public void set_trigger (string trigger);
		[NoAccessorMethod]
		public Gtk.TextBuffer buffer { owned get; }
		public string description { get; set; }
		public string language { get; set; }
		public Gtk.TextMark mark_begin { get; }
		public Gtk.TextMark mark_end { get; }
		public string snippet_text { get; set; }
		public int tab_stop { get; }
		public string trigger { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippet_chunk_get_type ()")]
	public class SourceSnippetChunk : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceSnippetChunk ();
		public Ide.SourceSnippetChunk copy ();
		public unowned Ide.SourceSnippetContext get_context ();
		public unowned string get_spec ();
		public int get_tab_stop ();
		public unowned string get_text ();
		public bool get_text_set ();
		public void set_context (Ide.SourceSnippetContext context);
		public void set_spec (string spec);
		public void set_tab_stop (int tab_stop);
		public void set_text (string text);
		public void set_text_set (bool text_set);
		public Ide.SourceSnippetContext context { get; set; }
		public string spec { get; set; }
		public int tab_stop { get; set; }
		public string text { get; set; }
		public bool text_set { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippet_context_get_type ()")]
	public class SourceSnippetContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceSnippetContext ();
		public void add_variable (string key, string value);
		public void clear_variables ();
		public void dump ();
		public void emit_changed ();
		public string expand (string input);
		public unowned string get_variable (string key);
		public void set_line_prefix (string line_prefix);
		public void set_tab_width (int tab_size);
		public void set_use_spaces (bool use_spaces);
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippets_get_type ()")]
	public class SourceSnippets : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceSnippets ();
		public void add (Ide.SourceSnippet snippet);
		public void clear ();
		public uint count ();
		public void @foreach (string prefix, GLib.Func foreach_func);
		public void merge (Ide.SourceSnippets other);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_snippets_manager_get_type ()")]
	public class SourceSnippetsManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceSnippetsManager ();
		public unowned Ide.SourceSnippets? get_for_language (Gtk.SourceLanguage language);
		public unowned Ide.SourceSnippets? get_for_language_id (string language_id);
		public async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_view_get_type ()")]
	public class SourceView : Gtk.SourceView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected SourceView ();
		[NoWrapper]
		public virtual void auto_indent ();
		public unowned Ide.BackForwardList? get_back_forward_list ();
		public int get_count ();
		public unowned Ide.SourceSnippet? get_current_snippet ();
		public bool get_enable_word_completion ();
		public unowned Ide.FileSettings? get_file_settings ();
		public unowned Pango.FontDescription get_font_desc ();
		public bool get_highlight_current_line ();
		public bool get_insert_matching_brace ();
		public unowned string get_mode_display_name ();
		public unowned string get_mode_name ();
		public bool get_overwrite ();
		public bool get_overwrite_braces ();
		public bool get_rubberband_search ();
		public uint get_scroll_offset ();
		public unowned Gtk.SourceSearchContext? get_search_context ();
		public Gtk.DirectionType get_search_direction ();
		public bool get_show_grid_lines ();
		public bool get_show_line_changes ();
		public bool get_show_line_diagnostics ();
		public bool get_show_search_bubbles ();
		public bool get_show_search_shadow ();
		public bool get_snippet_completion ();
		public Gdk.Rectangle get_visible_rect ();
		public void get_visual_position (uint line, uint line_offset);
		[NoWrapper]
		public virtual void insert_at_cursor_and_indent (string str);
		public bool move_mark_onscreen (Gtk.TextMark mark);
		public bool place_cursor_onscreen ();
		public void rollback_search ();
		public void scroll_mark_onscreen (Gtk.TextMark mark, bool use_align, double alignx, double aligny);
		public void scroll_to_iter (Gtk.TextIter iter, double within_margin, bool use_align, double xalign, double yalign, bool animate_scroll);
		public void scroll_to_mark (Gtk.TextMark mark, double within_margin, bool use_align, double xalign, double yalign, bool animate_scroll);
		public void set_back_forward_list (Ide.BackForwardList back_forward_list);
		public void set_count (int count);
		public void set_enable_word_completion (bool enable_word_copletion);
		public void set_font_desc (Pango.FontDescription font_desc);
		public void set_font_name (string font_name);
		public void set_highlight_current_line (bool highlight_current_line);
		public void set_insert_matching_brace (bool insert_matching_brace);
		public void set_overwrite_braces (bool overwrite_braces);
		public void set_rubberband_search (bool rubberband_search);
		public void set_scroll_offset (uint scroll_offset);
		public void set_search_direction (Gtk.DirectionType direction);
		public void set_show_grid_lines (bool show_grid_lines);
		public void set_show_line_changes (bool show_line_changes);
		public void set_show_line_diagnostics (bool show_line_changes);
		public void set_show_search_bubbles (bool show_search_bubbles);
		public void set_show_search_shadow (bool show_search_bubbles);
		public void set_snippet_completion (bool snippet_completion);
		public Ide.BackForwardList back_forward_list { get; set; }
		public int count { get; set; }
		public bool enable_word_completion { get; set; }
		public Ide.FileSettings file_settings { get; }
		public Pango.FontDescription font_desc { get; set; }
		public string font_name { set construct; }
		[NoAccessorMethod]
		public Ide.IndentStyle indent_style { set; }
		[NoAccessorMethod]
		public Ide.Indenter indenter { owned get; }
		public bool insert_matching_brace { get; set; }
		public string mode_display_name { get; }
		[NoAccessorMethod]
		public int overscroll { get; set; }
		public bool overwrite_braces { get; set; }
		public bool rubberband_search { get; set; }
		public uint scroll_offset { get; set; }
		public Gtk.SourceSearchContext search_context { get; }
		public Gtk.DirectionType search_direction { get; set; }
		public bool show_grid_lines { get; set; }
		public bool show_line_changes { get; set; }
		public bool show_line_diagnostics { get; set; }
		public bool show_search_bubbles { get; set; }
		public bool show_search_shadow { get; set; }
		public bool snippet_completion { get; set; }
		public signal void action (string object, string p0, string p1);
		public virtual signal void append_to_count (int digit);
		public virtual signal void begin_macro ();
		public signal void begin_user_action ();
		public virtual signal void capture_modifier ();
		public virtual signal void clear_count ();
		public virtual signal void clear_modifier ();
		[HasEmitter]
		public virtual signal void clear_search ();
		public virtual signal void clear_selection ();
		[HasEmitter]
		public virtual signal void clear_snippets ();
		public virtual signal void cycle_completion (Gtk.DirectionType direction);
		public virtual signal void decrease_font_size ();
		public virtual signal void delete_selection ();
		public virtual signal void end_macro ();
		public signal void end_user_action ();
		public virtual signal void focus_location (Ide.SourceLocation location);
		public virtual signal void goto_definition ();
		public virtual signal void hide_completion ();
		public virtual signal void increase_font_size ();
		public virtual signal void indent_selection (int level);
		public virtual signal void insert_modifier (bool use_count);
		[HasEmitter]
		public virtual signal void jump (Gtk.TextIter location);
		public virtual signal void move_error (Gtk.DirectionType dir);
		public virtual signal void move_search (Gtk.DirectionType dir, bool extend_selection, bool select_match, bool exclusive, bool apply_count, bool at_word_boundaries);
		public virtual signal void movement (Ide.SourceViewMovement movement, bool extend_selection, bool exclusive, bool apply_count);
		public virtual signal void paste_clipboard_extended (bool smart_lines, bool after_cursor, bool place_cursor_at_original);
		public virtual signal void pop_selection ();
		[HasEmitter]
		public signal void pop_snippet ();
		public virtual signal void push_selection ();
		[HasEmitter]
		public signal void push_snippet (Ide.SourceSnippet snippet, Gtk.TextIter? location);
		public virtual signal void rebuild_highlight ();
		public signal void reindent ();
		public virtual signal void replay_macro (bool use_count);
		public virtual signal void request_documentation ();
		public virtual signal void reset_font_size ();
		public virtual signal void restore_insert_mark ();
		public virtual signal void save_command ();
		public virtual signal void save_insert_mark ();
		public virtual signal void save_search_char ();
		public virtual signal void select_inner (string inner_left, string inner_right, bool exclusive, bool string_mode);
		public virtual signal void select_tag (bool exclusive);
		public virtual signal void selection_theatric (Ide.SourceViewTheatric theatric);
		public virtual signal void set_mode (string mode, Ide.SourceViewModeType type);
		public virtual signal void set_overwrite (bool overwrite);
		public virtual signal void set_search_text (string search_text, bool from_selection);
		public virtual signal void sort (bool ignore_case, bool reverse);
		public virtual signal void swap_selection_bounds ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_view_mode_get_type ()")]
	public class SourceViewMode : Gtk.Widget, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected SourceViewMode ();
		public bool get_block_cursor ();
		public unowned string get_default_mode ();
		public unowned string get_display_name ();
		public bool get_keep_mark_on_char ();
		public Ide.SourceViewModeType get_mode_type ();
		public bool get_repeat_insert_with_count ();
		public bool get_suppress_unbound ();
		public void set_has_indenter (bool has_indenter);
		public string name { get; }
		public signal void action (string object, string p0, string p1);
		public signal void append_to_count (int object);
		public signal void backspace ();
		public signal void begin_macro ();
		public signal void begin_user_action ();
		public signal void capture_modifier ();
		public signal void change_case (Gtk.SourceChangeCaseType object);
		public signal void change_number (int object);
		public signal void clear_count ();
		public signal void clear_modifier ();
		public signal void clear_search ();
		public signal void clear_selection ();
		public signal void clear_snippets ();
		public signal void copy_clipboard ();
		public signal void cut_clipboard ();
		public signal void cycle_completion (Gtk.DirectionType object);
		public signal void decrease_font_size ();
		public signal void delete_from_cursor (Gtk.DeleteType object, int p0);
		public signal void delete_selection ();
		public signal void end_macro ();
		public signal void end_user_action ();
		public signal void goto_definition ();
		public signal void hide_completion ();
		public signal void increase_font_size ();
		public signal void indent_selection (int object);
		public signal void insert_at_cursor (string object);
		public signal void insert_modifier (bool object);
		public signal void join_lines ();
		public signal void move_cursor (Gtk.MovementStep object, int p0, bool p1);
		public signal void move_error (Gtk.DirectionType object);
		public signal void move_lines (bool object, int p0);
		public signal void move_search (Gtk.DirectionType object, bool p0, bool p1, bool p2, bool p3, bool p4);
		public signal void move_to_matching_bracket (bool object);
		public signal void move_viewport (Gtk.ScrollStep object, int p0);
		public signal void move_words (int object);
		public signal void movement (Ide.SourceViewMovement object, bool p0, bool p1, bool p2);
		public signal void paste_clipboard ();
		public signal void paste_clipboard_extended (bool object, bool p0, bool p1);
		public signal void pop_selection ();
		public signal void preedit_changed (string object);
		public signal void push_selection ();
		public signal void rebuild_highlight ();
		public signal void redo ();
		public signal void reindent ();
		public signal void replay_macro (bool object);
		public signal void request_documentation ();
		public signal void reset_font_size ();
		public signal void restore_insert_mark ();
		public signal void save_command ();
		public signal void save_insert_mark ();
		public signal void save_search_char ();
		public signal void select_all (bool object);
		public signal void select_inner (string object, string p0, bool p1, bool p2);
		public signal void select_tag (bool object);
		public signal void selection_theatric (Ide.SourceViewTheatric object);
		public signal void set_anchor ();
		public signal void set_mode (string object, Ide.SourceViewModeType p0);
		public signal void set_overwrite (bool object);
		public signal void set_search_text (string object, bool p0);
		public signal void show_completion ();
		public signal void sort (bool object, bool p0);
		public signal void swap_selection_bounds ();
		public signal void toggle_cursor_visible ();
		public signal void toggle_overwrite ();
		public signal void undo ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_subprocess_launcher_get_type ()")]
	public class SubprocessLauncher : GLib.Object {
		[CCode (has_construct_function = false)]
		public SubprocessLauncher (GLib.SubprocessFlags flags);
		public unowned string get_cwd ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_environ ();
		public GLib.SubprocessFlags get_flags ();
		public void overlay_environment (Ide.Environment environment);
		public void push_args ([CCode (array_length = false, array_null_terminated = true)] string[] args);
		public void push_argv (string argv);
		public void set_cwd (string cwd);
		public void set_environ (string environ_);
		public void set_flags (GLib.SubprocessFlags flags);
		public void setenv (string key, string value, bool replace);
		public virtual async GLib.Subprocess spawn_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual GLib.Subprocess spawn_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public string cwd { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] environ { get; set; }
		public GLib.SubprocessFlags flags { get; set construct; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_symbol_ref", type_id = "ide_symbol_get_type ()", unref_function = "ide_symbol_unref")]
	[Compact]
	public class Symbol {
		[CCode (has_construct_function = false)]
		public Symbol (string name, Ide.SymbolKind kind, Ide.SymbolFlags flags, Ide.SourceLocation? declaration_location, Ide.SourceLocation? definition_location, Ide.SourceLocation? canonical_location);
		public unowned Ide.SourceLocation? get_canonical_location ();
		public unowned Ide.SourceLocation? get_declaration_location ();
		public unowned Ide.SourceLocation? get_definition_location ();
		public Ide.SymbolFlags get_flags ();
		public Ide.SymbolKind get_kind ();
		public unowned string get_name ();
		public Ide.Symbol @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_symbol_node_get_type ()")]
	public class SymbolNode : Ide.Object {
		[CCode (has_construct_function = false)]
		protected SymbolNode ();
		public Ide.SymbolFlags get_flags ();
		public Ide.SymbolKind get_kind ();
		public virtual Ide.SourceLocation? get_location ();
		public unowned string get_name ();
		[NoAccessorMethod]
		public Ide.SymbolFlags flags { get; set; }
		[NoAccessorMethod]
		public Ide.SymbolKind kind { get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_template_base_get_type ()")]
	public abstract class TemplateBase : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TemplateBase ();
		public void add_path (string path, GLib.File destination, Template.Scope scope, int mode);
		public void add_resource (string resource_path, GLib.File destination, Template.Scope scope, int mode);
		public async bool expand_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Template.TemplateLocator? get_locator ();
		public void set_locator (Template.TemplateLocator locator);
		public Template.TemplateLocator locator { get; set; }
	}
	[CCode (cheader_filename = "ide.h")]
	[Compact]
	public class ThreadPool {
		public static void push (Ide.ThreadPoolKind kind, [CCode (scope = "async")] Ide.ThreadFunc func);
		public static void push_task (Ide.ThreadPoolKind kind, GLib.Task task, [CCode (scope = "async")] GLib.TaskThreadFunc func);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_tree_get_type ()")]
	public class Tree : Gtk.TreeView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected Tree ();
		public void add_builder (Ide.TreeBuilder builder);
		public void expand_to_node (Ide.TreeNode node);
		public unowned Ide.TreeNode? find_child_node (Ide.TreeNode node, Ide.TreeFindFunc find_func);
		public unowned Ide.TreeNode? find_custom (GLib.EqualFunc equal_func, void* key);
		public unowned Ide.TreeNode? find_item (GLib.Object? item);
		public unowned GLib.MenuModel? get_context_menu ();
		public unowned Ide.TreeNode? get_root ();
		public unowned Ide.TreeNode get_selected ();
		public bool get_show_icons ();
		public void rebuild ();
		public void remove_builder (Ide.TreeBuilder builder);
		public void scroll_to_node (Ide.TreeNode node);
		public void set_context_menu (GLib.MenuModel context_menu);
		public void set_filter (owned Ide.TreeFilterFunc filter_func);
		public void set_root (Ide.TreeNode node);
		public void set_show_icons (bool show_icons);
		public GLib.MenuModel context_menu { get; set; }
		public Ide.TreeNode root { get; set; }
		[NoAccessorMethod]
		public Ide.TreeNode selection { owned get; set; }
		public bool show_icons { get; set; }
		public virtual signal void action (string action_group, string action_name, string param);
		public virtual signal void populate_popup (Gtk.Widget widget);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_tree_builder_get_type ()")]
	public class TreeBuilder : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		protected TreeBuilder ();
		public unowned Ide.Tree? get_tree ();
		public Ide.Tree tree { get; }
		public virtual signal void added (Ide.Tree tree);
		public virtual signal void build_node (Ide.TreeNode node);
		public virtual signal bool node_activated (Ide.TreeNode node);
		public virtual signal void node_popup (Ide.TreeNode node, GLib.Menu menu);
		public virtual signal void node_selected (Ide.TreeNode node);
		public virtual signal void node_unselected (Ide.TreeNode node);
		public virtual signal void removed (Ide.Tree tree);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_tree_node_get_type ()")]
	public class TreeNode : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public TreeNode ();
		public void append (Ide.TreeNode child);
		public void collapse ();
		public bool expand (bool expand_ancestors);
		public void get_area (Gdk.Rectangle area);
		public bool get_children_possible ();
		public bool get_expanded ();
		public unowned string get_icon_name ();
		public unowned GLib.Object get_item ();
		public bool get_iter (Gtk.TreeIter iter);
		public unowned Ide.TreeNode get_parent ();
		public Gtk.TreePath? get_path ();
		public unowned string get_text ();
		public unowned Ide.Tree get_tree ();
		public bool get_use_dim_label ();
		public bool get_use_markup ();
		public void insert_sorted (Ide.TreeNode child, Ide.TreeNodeCompareFunc compare_func);
		public void invalidate ();
		public void prepend (Ide.TreeNode child);
		public void remove (Ide.TreeNode child);
		public void select ();
		public void set_children_possible (bool children_possible);
		public void set_icon_name (string? icon_name);
		public void set_item (GLib.Object item);
		public void set_text (string? text);
		public void set_use_dim_label (bool use_dim_label);
		public void set_use_markup (bool use_markup);
		public void show_popover (Gtk.Popover popover);
		public bool children_possible { get; set; }
		public string icon_name { get; set; }
		public GLib.Object item { get; set; }
		public Ide.TreeNode parent { get; }
		public string text { get; set; }
		[NoAccessorMethod]
		public Ide.Tree tree { owned get; set; }
		public bool use_dim_label { get; set; }
		public bool use_markup { get; set; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_unsaved_file_ref", type_id = "ide_unsaved_file_get_type ()", unref_function = "ide_unsaved_file_unref")]
	[Compact]
	public class UnsavedFile {
		public unowned GLib.Bytes get_content ();
		public unowned GLib.File get_file ();
		public int64 get_sequence ();
		public unowned string get_temp_path ();
		public bool persist (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public Ide.UnsavedFile @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_unsaved_files_get_type ()")]
	public class UnsavedFiles : Ide.Object {
		[CCode (has_construct_function = false)]
		protected UnsavedFiles ();
		public void clear ();
		public bool contains (GLib.File file);
		public int64 get_sequence ();
		public Ide.UnsavedFile? get_unsaved_file (GLib.File file);
		public void remove (GLib.File file);
		public async bool restore_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<weak Ide.UnsavedFile> to_array ();
		public void update (GLib.File file, GLib.Bytes content);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_uri_ref", type_id = "ide_uri_get_type ()", unref_function = "ide_uri_unref")]
	[Compact]
	public class Uri {
		[CCode (has_construct_function = false)]
		public Uri (string uri_string, Ide.UriParseFlags flags) throws GLib.Error;
		public static string build (string scheme, string userinfo, string host, string port, string path, string query, string fragment);
		public Ide.Uri copy ();
		[CCode (has_construct_function = false)]
		public Uri.from_file (GLib.File file);
		public unowned string get_auth_params ();
		public unowned string get_fragment ();
		public unowned string get_host ();
		public unowned string get_password ();
		public unowned string get_path ();
		public ushort get_port ();
		public unowned string get_query ();
		public unowned string get_scheme ();
		public unowned string get_user ();
		public bool is_file (GLib.File file);
		public Ide.Uri new_relative (string uri_string, Ide.UriParseFlags flags) throws GLib.Error;
		public static bool parse_host (string uri_string, Ide.UriParseFlags flags, out string scheme, out string host, out ushort port) throws GLib.Error;
		public static GLib.HashTable<weak string,weak string> parse_params (string @params, ssize_t length, char separator, bool case_insensitive);
		public Ide.Uri @ref ();
		public void set_auth_params (string auth_params);
		public void set_fragment (string fragment);
		public void set_host (string host);
		public void set_password (string password);
		public void set_path (string path);
		public void set_port (ushort port);
		public void set_query (string query);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public static void split (string uri_string, bool strict, out string? scheme, out string? userinfo, out string? host, out string? port, out string? path, out string? query, out string? fragment);
		public GLib.File? to_file ();
		public string to_string (Ide.UriToStringFlags flags);
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_vcs_uri_ref", type_id = "ide_vcs_uri_get_type ()", unref_function = "ide_vcs_uri_unref")]
	[Compact]
	public class VcsUri {
		[CCode (has_construct_function = false)]
		public VcsUri (string uri);
		public unowned string get_host ();
		public unowned string get_path ();
		public uint get_port ();
		public unowned string get_scheme ();
		public unowned string get_user ();
		public static bool is_valid (string uri_string);
		public Ide.VcsUri @ref ();
		public void set_host (string host);
		public void set_path (string path);
		public void set_port (uint port);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public string to_string ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_workbench_get_type ()")]
	public class Workbench : Gtk.ApplicationWindow, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected Workbench ();
		public void add_perspective (Ide.Perspective perspective);
		public void close ();
		public void focus (Gtk.Widget widget);
		public unowned Ide.Context? get_context ();
		public bool get_fullscreen ();
		public unowned Ide.Perspective? get_perspective_by_name (string name);
		public unowned Ide.Perspective get_visible_perspective ();
		public unowned string get_visible_perspective_name ();
		public async bool open_files_async (GLib.File files, uint n_files, string hint, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool open_project_async (GLib.File file_or_directory, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool open_uri_async (Ide.Uri uri, string hint, GLib.Cancellable? cancellable) throws GLib.Error;
		public void remove_perspective (Ide.Perspective perspective);
		public async bool save_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_fullscreen (bool fullscreen);
		public void set_visible_perspective (Ide.Perspective perspective);
		public void set_visible_perspective_name (string name);
		public void views_foreach (Gtk.Callback callback);
		public Ide.Context context { get; }
		public Ide.Perspective visible_perspective { get; set; }
		public string visible_perspective_name { get; set; }
		public signal void action (string object, string p0, string p1);
		public signal void set_perspective (string name);
		public signal void unload (Ide.Context object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_workbench_header_bar_get_type ()")]
	public class WorkbenchHeaderBar : Gtk.HeaderBar, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public WorkbenchHeaderBar ();
		public void focus_search ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeApplicationAddinInterface", type_id = "ide_application_addin_get_type ()")]
	public interface ApplicationAddin : GLib.Object {
		public abstract void load (Ide.Application application);
		public abstract void unload (Ide.Application application);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeApplicationToolInterface", type_id = "ide_application_tool_get_type ()")]
	public interface ApplicationTool : GLib.Object {
		public abstract async int run_async ([CCode (array_length = false, array_null_terminated = true)] string[] arguments, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBuildResultAddinInterface", type_id = "ide_build_result_addin_get_type ()")]
	public interface BuildResultAddin : GLib.Object {
		public abstract void load (Ide.BuildResult result);
		public abstract void unload (Ide.BuildResult result);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBuildSystemInterface", type_id = "ide_build_system_get_type ()")]
	public interface BuildSystem : Ide.Object {
		[CCode (array_length = false, array_null_terminated = true)]
		public abstract async string[] get_build_flags_async (Ide.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract Ide.Builder get_builder (Ide.Configuration configuration) throws GLib.Error;
		public abstract int get_priority ();
		public static async Ide.BuildSystem new_async (Ide.Context context, GLib.File project_file, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public abstract Ide.Context context { owned get; construct; }
		[NoAccessorMethod]
		public abstract GLib.File project_file { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeCompletionProviderInterface", type_id = "ide_completion_provider_get_type ()")]
	public interface CompletionProvider : Gtk.SourceCompletionProvider, GLib.Object {
		public static string context_current_word (Gtk.SourceCompletionContext context);
		public static bool context_in_comment (Gtk.SourceCompletionContext context);
		public static bool context_in_comment_or_string (Gtk.SourceCompletionContext context);
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeDebuggerInterface", type_id = "ide_debugger_get_type ()")]
	public interface Debugger : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeDeviceProviderInterface", type_id = "ide_device_provider_get_type ()")]
	public interface DeviceProvider : Ide.Object {
		public void emit_device_added (Ide.Device device);
		public void emit_device_removed (Ide.Device device);
		public abstract GLib.GenericArray<weak Ide.Device> get_devices ();
		public abstract bool get_settled ();
		public abstract Ide.Context context { construct; }
		public abstract bool settled { get; }
		public signal void device_added (Ide.Device object);
		public signal void device_removed (Ide.Device object);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeDiagnosticProviderInterface", type_id = "ide_diagnostic_provider_get_type ()")]
	public interface DiagnosticProvider : Ide.Object {
		public abstract async Ide.Diagnostics? diagnose_async (Ide.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeEditorViewAddinInterface", type_id = "ide_editor_view_addin_get_type ()")]
	public interface EditorViewAddin : GLib.Object {
		[NoWrapper]
		public abstract void language_changed (string language_id);
		[NoWrapper]
		public abstract void load (Ide.EditorView view);
		[NoWrapper]
		public abstract void unload (Ide.EditorView view);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeExecutableInterface", type_id = "ide_executable_get_type ()")]
	public interface Executable : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeExecuterInterface", type_id = "ide_executer_get_type ()")]
	public interface Executer : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeGenesisAddinInterface", type_id = "ide_genesis_addin_get_type ()")]
	public interface GenesisAddin : GLib.Object {
		public abstract string get_icon_name ();
		public abstract string get_title ();
		public abstract unowned Gtk.Widget get_widget ();
		public abstract async bool run_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public abstract bool is_ready { get; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeHighlighterInterface", type_id = "ide_highlighter_get_type ()")]
	public interface Highlighter : Ide.Object {
		[NoWrapper]
		public abstract void set_engine (Ide.HighlightEngine engine);
		public abstract Gtk.TextIter update (Ide.HighlightCallback callback, Gtk.TextIter range_begin, Gtk.TextIter range_end);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeIndenterInterface", type_id = "ide_indenter_get_type ()")]
	public interface Indenter : GLib.Object {
		public abstract string? format (Gtk.TextView text_view, Gtk.TextIter begin, Gtk.TextIter end, out int cursor_offset, Gdk.EventKey event);
		public abstract bool is_trigger (Gdk.EventKey event);
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdePerspectiveInterface", type_id = "ide_perspective_get_type ()")]
	public interface Perspective : GLib.Object {
		public abstract bool agree_to_shutdown ();
		public abstract GLib.ActionGroup? get_actions ();
		public abstract string? get_icon_name ();
		public abstract string? get_id ();
		public abstract bool get_needs_attention ();
		public abstract int get_priority ();
		public abstract string get_title ();
		public abstract unowned Gtk.Widget? get_titlebar ();
		public abstract bool is_early ();
		public abstract void set_fullscreen (bool fullscreen);
		public abstract void views_foreach (Gtk.Callback callback);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdePreferencesInterface", type_id = "ide_preferences_get_type ()")]
	public interface Preferences : GLib.Object {
		public abstract uint add_custom (string page_name, string group_name, Gtk.Widget widget, string keywords, int priority);
		public abstract uint add_file_chooser (string page_name, string group_name, string schema_id, string key, string path, string title, string subtitle, Gtk.FileChooserAction action, string keywords, int priority);
		public abstract uint add_font_button (string page_name, string group_name, string schema_id, string key, string title, string keywords, int priority);
		public abstract void add_group (string page_name, string group_name, string title, int priority);
		public abstract void add_list_group (string page_name, string group_name, string title, int priority);
		public abstract void add_page (string page_name, string title, int priority);
		public abstract uint add_radio (string page_name, string group_name, string schema_id, string key, string path, string variant_string, string title, string subtitle, string keywords, int priority);
		public abstract uint add_spin_button (string page_name, string group_name, string schema_id, string key, string path, string title, string subtitle, string keywords, int priority);
		public abstract uint add_switch (string page_name, string group_name, string schema_id, string key, string? path, string? variant_string, string? title, string? subtitle, string? keywords, int priority);
		public abstract bool remove_id (uint widget_id);
		public abstract void set_page (string page_name, GLib.HashTable<void*,void*> map);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdePreferencesAddinInterface", type_id = "ide_preferences_addin_get_type ()")]
	public interface PreferencesAddin : GLib.Object {
		public abstract void load (Ide.Preferences preferences);
		public abstract void unload (Ide.Preferences preferences);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeProcessInterface", type_id = "ide_process_get_type ()")]
	public interface Process : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeProjectMinerInterface", type_id = "ide_project_miner_get_type ()")]
	public interface ProjectMiner : GLib.Object {
		public void emit_discovered (Ide.ProjectInfo project_info);
		public abstract async bool mine_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual signal void discovered (Ide.ProjectInfo project_info);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeProjectTemplateInterface", type_id = "ide_project_template_get_type ()")]
	public interface ProjectTemplate : GLib.Object {
		public abstract async bool expand_async (GLib.HashTable<string,GLib.Variant> @params, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract string get_description ();
		public abstract string get_icon_name ();
		public abstract string get_id ();
		[CCode (array_length = false, array_null_terminated = true)]
		public abstract string[] get_languages ();
		public abstract string get_name ();
		public abstract unowned Gtk.Widget get_widget ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeRuntimeProviderInterface", type_id = "ide_runtime_provider_get_type ()")]
	public interface RuntimeProvider : GLib.Object {
		public abstract void load (Ide.RuntimeManager manager);
		public abstract void unload (Ide.RuntimeManager manager);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSearchProviderInterface", type_id = "ide_search_provider_get_type ()")]
	public interface SearchProvider : Ide.Object {
		public abstract void activate (Gtk.Widget row, Ide.SearchResult result);
		public abstract Gtk.Widget create_row (Ide.SearchResult result);
		public abstract unichar get_prefix ();
		public abstract int get_priority ();
		public abstract unowned string get_verb ();
		public abstract void populate (Ide.SearchContext context, string search_terms, size_t max_results, GLib.Cancellable? cancellable = null);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeServiceInterface", type_id = "ide_service_get_type ()")]
	public interface Service : GLib.Object {
		public abstract unowned string get_name ();
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract void start ();
		public abstract void stop ();
		public abstract Ide.Context context { construct; }
		public virtual signal void context_loaded ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSymbolResolverInterface", type_id = "ide_symbol_resolver_get_type ()")]
	public interface SymbolResolver : Ide.Object {
		public abstract async Ide.SymbolTree? get_symbol_tree_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Ide.Symbol? lookup_symbol_async (Ide.SourceLocation location, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public abstract void set_context (Ide.Context context);
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSymbolTreeInterface", type_id = "ide_symbol_tree_get_type ()")]
	public interface SymbolTree : GLib.Object {
		public abstract uint get_n_children (Ide.SymbolNode? node);
		public abstract Ide.SymbolNode? get_nth_child (Ide.SymbolNode? node, uint nth);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTagsBuilderInterface", type_id = "ide_tags_builder_get_type ()")]
	public interface TagsBuilder : GLib.Object {
		public abstract async bool build_async (GLib.File directory_or_flie, bool asynchronous, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTargetInterface", type_id = "ide_target_get_type ()")]
	public interface Target : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTemplateProviderInterface", type_id = "ide_template_provider_get_type ()")]
	public interface TemplateProvider : GLib.Object {
		public abstract GLib.List<Ide.ProjectTemplate> get_project_templates ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTestCaseInterface", type_id = "ide_test_case_get_type ()")]
	public interface TestCase : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTestSuiteInterface", type_id = "ide_test_suite_get_type ()")]
	public interface TestSuite : Ide.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeVcsInterface", type_id = "ide_vcs_get_type ()")]
	public interface Vcs : Ide.Object {
		public abstract Ide.BufferChangeMonitor? get_buffer_change_monitor (Ide.Buffer buffer);
		public abstract int get_priority ();
		public abstract unowned GLib.File get_working_directory ();
		public abstract bool is_ignored (GLib.File file) throws GLib.Error;
		public static async Ide.Vcs new_async (Ide.Context context, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract Ide.Context context { construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeWorkbenchAddinInterface", type_id = "ide_workbench_addin_get_type ()")]
	public interface WorkbenchAddin : GLib.Object {
		public abstract bool can_open (Ide.Uri uri, string? content_type, out int priority);
		public abstract string get_id ();
		public abstract void load (Ide.Workbench workbench);
		public abstract async bool open_async (Ide.Uri uri, string content_type, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload (Ide.Workbench workbench);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeWorkerInterface", type_id = "ide_worker_get_type ()")]
	public interface Worker : GLib.Object {
		public abstract GLib.DBusProxy create_proxy (GLib.DBusConnection connection) throws GLib.Error;
		public abstract void register_service (GLib.DBusConnection connection);
	}
	[CCode (cheader_filename = "ide.h", has_type_id = false)]
	public struct LineReader {
		public weak string contents;
		public size_t length;
		public ssize_t pos;
		public void init (string contents, ssize_t length);
		public unowned string next (size_t length);
	}
	[CCode (cheader_filename = "ide.h", has_type_id = false)]
	public struct SearchReducer {
		public weak Ide.SearchContext context;
		public weak Ide.SearchProvider provider;
		public weak GLib.Sequence sequence;
		public size_t max_results;
		public size_t count;
		public bool accepts (float score);
		public void destroy ();
		public void init (Ide.SearchContext context, Ide.SearchProvider provider, size_t max_results);
		public void push (Ide.SearchResult result);
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_APPLICATION_MODE_", has_type_id = false)]
	public enum ApplicationMode {
		PRIMARY,
		WORKER,
		TOOL,
		TESTS
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUFFER_LINE_CHANGE_", has_type_id = false)]
	public enum BufferLineChange {
		NONE,
		ADDED,
		CHANGED,
		DELETED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUFFER_LINE_FLAGS_", type_id = "ide_buffer_line_flags_get_type ()")]
	[Flags]
	public enum BufferLineFlags {
		NONE,
		ADDED,
		CHANGED,
		DELETED,
		ERROR,
		WARNING,
		NOTE
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUILD_RESULT_LOG_", type_id = "ide_build_result_log_get_type ()")]
	public enum BuildResultLog {
		STDOUT,
		STDERR
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUILDER_BUILD_FLAGS_", has_type_id = false)]
	[Flags]
	public enum BuilderBuildFlags {
		NONE,
		FORCE_BOOTSTRAP,
		FORCE_CLEAN,
		NO_BUILD,
		NO_CONFIGURE
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DIAGNOSTIC_", type_id = "ide_diagnostic_severity_get_type ()")]
	public enum DiagnosticSeverity {
		IGNORED,
		NOTE,
		DEPRECATED,
		WARNING,
		ERROR,
		FATAL;
		public static unowned string to_string (Ide.DiagnosticSeverity severity);
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_HIGHLIGHT_", type_id = "ide_highlight_result_get_type ()")]
	public enum HighlightResult {
		STOP,
		CONTINUE
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_INDENT_STYLE_", type_id = "ide_indent_style_get_type ()")]
	public enum IndentStyle {
		SPACES,
		TABS
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_LAYOUT_GRID_SPLIT_", type_id = "ide_layout_grid_split_get_type ()")]
	public enum LayoutGridSplit {
		LEFT,
		RIGHT,
		MOVE_LEFT,
		MOVE_RIGHT
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_MODE_TYPE_", type_id = "ide_source_view_mode_type_get_type ()")]
	public enum SourceViewModeType {
		TRANSIENT,
		PERMANENT,
		MODAL
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_MOVEMENT_", type_id = "ide_source_view_movement_get_type ()")]
	public enum SourceViewMovement {
		PREVIOUS_OFFSET,
		NEXT_OFFSET,
		NTH_CHAR,
		PREVIOUS_CHAR,
		NEXT_CHAR,
		FIRST_CHAR,
		FIRST_NONSPACE_CHAR,
		MIDDLE_CHAR,
		LAST_CHAR,
		NEXT_WORD_START,
		NEXT_FULL_WORD_START,
		NEXT_SUB_WORD_START,
		PREVIOUS_SUB_WORD_START,
		PREVIOUS_WORD_START,
		PREVIOUS_FULL_WORD_START,
		PREVIOUS_WORD_END,
		PREVIOUS_FULL_WORD_END,
		NEXT_WORD_END,
		NEXT_FULL_WORD_END,
		SENTENCE_START,
		SENTENCE_END,
		PARAGRAPH_START,
		PARAGRAPH_END,
		PREVIOUS_LINE,
		NEXT_LINE,
		FIRST_LINE,
		NTH_LINE,
		LAST_LINE,
		LINE_PERCENTAGE,
		LINE_CHARS,
		LINE_END,
		HALF_PAGE_UP,
		HALF_PAGE_DOWN,
		HALF_PAGE_LEFT,
		HALF_PAGE_RIGHT,
		PAGE_UP,
		PAGE_DOWN,
		SCREEN_UP,
		SCREEN_DOWN,
		SCREEN_LEFT,
		SCREEN_RIGHT,
		SCREEN_TOP,
		SCREEN_MIDDLE,
		SCREEN_BOTTOM,
		MATCH_SPECIAL,
		SCROLL_SCREEN_TOP,
		SCROLL_SCREEN_CENTER,
		SCROLL_SCREEN_BOTTOM,
		SCROLL_SCREEN_LEFT,
		SCROLL_SCREEN_RIGHT,
		PREVIOUS_UNMATCHED_BRACE,
		NEXT_UNMATCHED_BRACE,
		PREVIOUS_UNMATCHED_PAREN,
		NEXT_UNMATCHED_PAREN,
		NEXT_MATCH_MODIFIER,
		PREVIOUS_MATCH_MODIFIER,
		NEXT_MATCH_SEARCH_CHAR,
		PREVIOUS_MATCH_SEARCH_CHAR
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_THEATRIC_", type_id = "ide_source_view_theatric_get_type ()")]
	public enum SourceViewTheatric {
		EXPAND,
		SHRINK
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SYMBOL_FLAGS_", type_id = "ide_symbol_flags_get_type ()")]
	[Flags]
	public enum SymbolFlags {
		NONE,
		IS_STATIC,
		IS_MEMBER,
		IS_DEPRECATED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SYMBOL_", type_id = "ide_symbol_kind_get_type ()")]
	public enum SymbolKind {
		NONE,
		SCALAR,
		CLASS,
		FUNCTION,
		METHOD,
		STRUCT,
		UNION,
		FIELD,
		ENUM,
		ENUM_VALUE,
		VARIABLE,
		HEADER
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_THREAD_POOL_", type_id = "ide_thread_pool_kind_get_type ()")]
	public enum ThreadPoolKind {
		COMPILER,
		INDEXER,
		LAST
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_URI_PARSE_", has_type_id = false)]
	[Flags]
	public enum UriParseFlags {
		STRICT,
		HTML5,
		NO_IRI,
		PASSWORD,
		AUTH_PARAMS,
		NON_DNS,
		DECODED,
		UTF8_ONLY
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_URI_HIDE_", has_type_id = false)]
	[Flags]
	public enum UriToStringFlags {
		AUTH_PARAMS,
		FRAGMENT
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DOAP_ERROR_INVALID_")]
	public errordomain DoapError {
		FORMAT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_URI_ERROR_")]
	public errordomain UriError {
		MISC,
		BAD_SCHEME,
		BAD_USER,
		BAD_PASSWORD,
		BAD_AUTH_PARAMS,
		BAD_HOST,
		BAD_PORT,
		BAD_PATH,
		BAD_QUERY,
		BAD_FRAGMENT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "ide.h", instance_pos = 3.9)]
	public delegate void ExtensionSetAdapterForeachFunc (Ide.ExtensionSetAdapter @set, Peas.PluginInfo plugin_info, Peas.Extension extension);
	[CCode (cheader_filename = "ide.h", has_target = false)]
	public delegate Ide.HighlightResult HighlightCallback (Gtk.TextIter begin, Gtk.TextIter end, string style_name);
	[CCode (cheader_filename = "ide.h", instance_pos = 0.9)]
	public delegate void ThreadFunc ();
	[CCode (cheader_filename = "ide.h", instance_pos = 2.9)]
	public delegate bool TreeFilterFunc (Ide.Tree tree, Ide.TreeNode node);
	[CCode (cheader_filename = "ide.h", instance_pos = 3.9)]
	public delegate bool TreeFindFunc (Ide.Tree tree, Ide.TreeNode node, Ide.TreeNode child);
	[CCode (cheader_filename = "ide.h", instance_pos = 2.9)]
	public delegate int TreeNodeCompareFunc (Ide.TreeNode a, Ide.TreeNode b);
	[CCode (cheader_filename = "ide.h", has_target = false)]
	public delegate void WidgetContextHandler (Gtk.Widget widget, Ide.Context context);
	[CCode (cheader_filename = "ide.h", cname = "IDE_BUFFER_LINE_FLAGS_DIAGNOSTICS_MASK")]
	public const int BUFFER_LINE_FLAGS_DIAGNOSTICS_MASK;
	[CCode (cheader_filename = "ide.h", cname = "IDE_ENABLE_TRACE")]
	public const int ENABLE_TRACE;
	[CCode (cheader_filename = "ide.h", cname = "IDE_FILE_SETTINGS_EXTENSION_POINT")]
	public const string FILE_SETTINGS_EXTENSION_POINT;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_BOOKMARK_FILENAME")]
	public const string RECENT_PROJECTS_BOOKMARK_FILENAME;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_GROUP")]
	public const string RECENT_PROJECTS_GROUP;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_LANGUAGE_GROUP_PREFIX")]
	public const string RECENT_PROJECTS_LANGUAGE_GROUP_PREFIX;
	[CCode (cheader_filename = "ide.h", cname = "IDE_SCRIPT_EXTENSION_POINT")]
	public const string SCRIPT_EXTENSION_POINT;
	[CCode (cheader_filename = "ide.h")]
	public static async Ide.BuildSystem build_system_new_async (Ide.Context context, GLib.File project_file, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	public static Cairo.Region cairo_region_create_from_clip_extents (Cairo.Context cr);
	[CCode (cheader_filename = "ide.h")]
	public static void cairo_rounded_rectangle (Cairo.Context cr, Gdk.Rectangle rect, int x_radius, int y_radius);
	[CCode (cheader_filename = "ide.h")]
	public static string completion_provider_context_current_word (Gtk.SourceCompletionContext context);
	[CCode (cheader_filename = "ide.h")]
	public static bool completion_provider_context_in_comment (Gtk.SourceCompletionContext context);
	[CCode (cheader_filename = "ide.h")]
	public static bool completion_provider_context_in_comment_or_string (Gtk.SourceCompletionContext context);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "ide.h")]
	public static string[] dnd_get_uri_list (Gtk.SelectionData selection_data);
	[CCode (cheader_filename = "ide.h")]
	public static unowned string get_program_name ();
	[CCode (cheader_filename = "ide.h")]
	public static string get_system_arch ();
	[CCode (cheader_filename = "ide.h")]
	public static size_t get_system_page_size ();
	[CCode (cheader_filename = "ide.h")]
	public static void gtk_text_buffer_remove_tag (Gtk.TextBuffer buffer, Gtk.TextTag tag, Gtk.TextIter start, Gtk.TextIter end, bool minimal_damage);
	[CCode (cheader_filename = "ide.h")]
	public static int log_get_verbosity ();
	[CCode (cheader_filename = "ide.h")]
	public static void log_increase_verbosity ();
	[CCode (cheader_filename = "ide.h")]
	public static void log_init (bool stdout_, string filename);
	[CCode (cheader_filename = "ide.h")]
	public static void log_set_verbosity (int level);
	[CCode (cheader_filename = "ide.h")]
	public static void log_shutdown ();
	[CCode (cheader_filename = "ide.h")]
	public static string pango_font_description_to_css (Pango.FontDescription font_desc);
	[CCode (cheader_filename = "ide.h")]
	public static void rgba_shade (Gdk.RGBA rgba, Gdk.RGBA dst, double k);
	[CCode (cheader_filename = "ide.h")]
	public static void set_program_name (string program_name);
	[CCode (cheader_filename = "ide.h")]
	public static bool source_style_scheme_apply_style (Gtk.SourceStyleScheme style_scheme, string style, Gtk.TextTag tag);
	[CCode (cheader_filename = "ide.h")]
	public static async Ide.Vcs vcs_new_async (Ide.Context context, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	public static bool widget_action (Gtk.Widget widget, string group, string name, GLib.Variant param);
	[CCode (cheader_filename = "ide.h")]
	public static bool widget_action_with_string (Gtk.Widget widget, string group, string name, string param);
	[CCode (cheader_filename = "ide.h")]
	public static void* widget_find_child_typed (Gtk.Widget widget, GLib.Type type);
	[CCode (cheader_filename = "ide.h")]
	public static unowned Ide.Workbench? widget_get_workbench (Gtk.Widget widget);
	[CCode (cheader_filename = "ide.h")]
	public static void widget_hide_with_fade (Gtk.Widget widget);
	[CCode (cheader_filename = "ide.h")]
	public static void widget_set_context_handler (Gtk.Widget widget, [CCode (scope = "async")] Ide.WidgetContextHandler handler);
	[CCode (cheader_filename = "ide.h")]
	public static void widget_show_with_fade (Gtk.Widget widget);
}
