var readDir = require("fs").readdirSync;
var readFile = require("fs").readFileSync;
var test = require("./driver").test;
var testFail = require("./driver").testFail;

var dir = __dirname + "/flow";

readDir(dir).forEach(function (suiteName) {
  if (suiteName[0] === "." || suiteName === "options.json") return;
  suiteName = dir + "/" + suiteName;
  readDir(suiteName).forEach(function (testName) {
    if (testName[0] === ".") return;
    var isValid = testName !== "invalid";
    testName = suiteName + "/" + testName;
    var testSrc = readFile(testName + "/actual.js", "utf-8");
    if (isValid) {
      test(testSrc, require(testName + "/expected.json").program, {
        ecmaVersion: 7,
        locations: true,
        ranges: true,
        sourceType: "module"
      });
    } else {
      test(testSrc, require(testName + "/options.json").throws, { ecmaVersion: 6 });
    }
  });
});