/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.membership;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class MembershipAction
extends AbstractComponent {
    public static final String DISCOVERY_JOIN_ACTION_NAME = "internal:discovery/zen/join";
    public static final String DISCOVERY_JOIN_VALIDATE_ACTION_NAME = "internal:discovery/zen/join/validate";
    public static final String DISCOVERY_LEAVE_ACTION_NAME = "internal:discovery/zen/leave";
    private final TransportService transportService;
    private final DiscoveryNodesProvider nodesProvider;
    private final MembershipListener listener;
    private final ClusterService clusterService;

    public MembershipAction(Settings settings, ClusterService clusterService, TransportService transportService, DiscoveryNodesProvider nodesProvider, MembershipListener listener) {
        super(settings);
        this.transportService = transportService;
        this.nodesProvider = nodesProvider;
        this.listener = listener;
        this.clusterService = clusterService;
        transportService.registerRequestHandler(DISCOVERY_JOIN_ACTION_NAME, JoinRequest.class, "generic", new JoinRequestRequestHandler());
        transportService.registerRequestHandler(DISCOVERY_JOIN_VALIDATE_ACTION_NAME, ValidateJoinRequest.class, "generic", new ValidateJoinRequestRequestHandler());
        transportService.registerRequestHandler(DISCOVERY_LEAVE_ACTION_NAME, LeaveRequest.class, "generic", new LeaveRequestRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler(DISCOVERY_JOIN_ACTION_NAME);
        this.transportService.removeHandler(DISCOVERY_JOIN_VALIDATE_ACTION_NAME);
        this.transportService.removeHandler(DISCOVERY_LEAVE_ACTION_NAME);
    }

    public void sendLeaveRequest(DiscoveryNode masterNode, DiscoveryNode node) {
        this.transportService.sendRequest(node, DISCOVERY_LEAVE_ACTION_NAME, new LeaveRequest(masterNode), EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    public void sendLeaveRequestBlocking(DiscoveryNode masterNode, DiscoveryNode node, TimeValue timeout) {
        this.transportService.submitRequest(masterNode, DISCOVERY_LEAVE_ACTION_NAME, new LeaveRequest(node), EmptyTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    public void sendJoinRequest(DiscoveryNode masterNode, DiscoveryNode node) {
        this.transportService.sendRequest(masterNode, DISCOVERY_JOIN_ACTION_NAME, new JoinRequest(node), EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    public void sendJoinRequestBlocking(DiscoveryNode masterNode, DiscoveryNode node, TimeValue timeout) {
        this.transportService.submitRequest(masterNode, DISCOVERY_JOIN_ACTION_NAME, new JoinRequest(node), EmptyTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    public void sendValidateJoinRequestBlocking(DiscoveryNode node, ClusterState state, TimeValue timeout) {
        this.transportService.submitRequest(node, DISCOVERY_JOIN_VALIDATE_ACTION_NAME, new ValidateJoinRequest(state), EmptyTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    private class LeaveRequestRequestHandler
    extends TransportRequestHandler<LeaveRequest> {
        private LeaveRequestRequestHandler() {
        }

        @Override
        public void messageReceived(LeaveRequest request, TransportChannel channel) throws Exception {
            MembershipAction.this.listener.onLeave(request.node);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class LeaveRequest
    extends TransportRequest {
        private DiscoveryNode node;

        public LeaveRequest() {
        }

        private LeaveRequest(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.node = DiscoveryNode.readNode(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.node.writeTo(out);
        }
    }

    class ValidateJoinRequestRequestHandler
    extends TransportRequestHandler<ValidateJoinRequest> {
        ValidateJoinRequestRequestHandler() {
        }

        @Override
        public void messageReceived(ValidateJoinRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class ValidateJoinRequest
    extends TransportRequest {
        private ClusterState state;

        public ValidateJoinRequest() {
        }

        public ValidateJoinRequest(ClusterState state) {
            this.state = state;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
                this.state = ClusterState.Builder.readFrom(in, null);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
                this.state.writeTo(out);
            }
        }
    }

    private class JoinRequestRequestHandler
    extends TransportRequestHandler<JoinRequest> {
        private JoinRequestRequestHandler() {
        }

        @Override
        public void messageReceived(JoinRequest request, final TransportChannel channel) throws Exception {
            MembershipAction.this.listener.onJoin(request.node, new JoinCallback(){

                @Override
                public void onSuccess() {
                    try {
                        channel.sendResponse(TransportResponse.Empty.INSTANCE);
                    }
                    catch (Throwable t) {
                        this.onFailure(t);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    try {
                        channel.sendResponse(t);
                    }
                    catch (Throwable e) {
                        MembershipAction.this.logger.warn("failed to send back failure on join request", e, new Object[0]);
                    }
                }
            });
        }
    }

    public static class JoinRequest
    extends TransportRequest {
        DiscoveryNode node;

        public JoinRequest() {
        }

        private JoinRequest(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.node = DiscoveryNode.readNode(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.node.writeTo(out);
        }
    }

    public static interface MembershipListener {
        public void onJoin(DiscoveryNode var1, JoinCallback var2);

        public void onLeave(DiscoveryNode var1);
    }

    public static interface JoinCallback {
        public void onSuccess();

        public void onFailure(Throwable var1);
    }
}

